#ifndef	__STRINGS_H__
#define	__STRINGS_H__

#include <stdlib.h>
#ifdef	COHERENT
#define	__STRING_H__
#define	__ENV__
#endif

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__BOOL_H__
#include <bool.h>
#endif

#ifndef	__SPACES
#define	__SPACES	" \r\t\n"
#endif

#ifdef	LINUX
#define	__ADD_STRING__
#define	__NO_STRDUP__
#endif

#ifdef	SCO
#define	__ENV__
#define	__ADD_STRING__
#endif

#ifdef	__ANSI__
#include <string.h>
#ifdef	__ADD_STRING__
IMPORT	int	stricmp PROTO((char *s1, char *s2));
IMPORT	int	strnicmp PROTO((char *s1, char *s2, int n));
IMPORT	char	*strlwr PROTO((char *s1));
IMPORT	char	*strupr PROTO((char *s2));
#endif
#else

#ifndef	__ENV__
#include <env.h>
#endif

#ifndef	__ANSI_STRINGS__
IMPORT	int	strlen PROTO((char *str));
IMPORT	char *strupr PROTO((char *str));
IMPORT	char *strlwr PROTO((char *str));
IMPORT	int	strcmp PROTO((char *str1, char *str2));
IMPORT	int	stricmp PROTO((char *str1, char *str2));
IMPORT	int	strncmp PROTO((char *str1, char *str2, int len));
IMPORT	int	strnicmp PROTO((char *str1, char *str2, int len));
IMPORT	char *strtok PROTO((char *str, char *str));
IMPORT	char *strchr PROTO((char *str, char code));
IMPORT	char *strcat PROTO((char *dest, char *src));
IMPORT	char *strcpy PROTO((char *dest, char *src));
IMPORT	int strcspn PROTO((char *string, char *set));
IMPORT	char *strncat PROTO((char *dest, char *src, int length));
IMPORT	char *strncpy PROTO((char *dest, char *src, int length));
IMPORT	char *strnset PROTO((char *string, char cc, int length));
IMPORT	char *strpbrk PROTO((char *string, char *set));
IMPORT	char *strrchr PROTO((char *string, char cc));
IMPORT	char *strset PROTO((char *string, char cc));
IMPORT	char *strstr PROTO((char *s1, char *s2));
#endif
#endif
#ifndef	__NO_STRDUP__
IMPORT	char *strdup PROTO((char *s));
#endif
IMPORT	char	*stristr PROTO((char *s1, char *s2));
IMPORT	int	isstrblank PROTO((char *s));
IMPORT	char *strtrim PROTO((char *s, char *trim));
IMPORT	char *strrtrim PROTO((char *s, char *trim));
IMPORT	char *strltrim PROTO((char *s, char *trim));
IMPORT	void fatal PROTO((char *format, ...));
IMPORT	int	getargs PROTO((int argc, char **argv, char *options));
IMPORT	BOOL atob PROTO((char *str));
IMPORT	char *strint PROTO((int i, int z));
IMPORT	char *picture PROTO((char *buf, char *pict, long value));
IMPORT	char *expand PROTO((char *str));
IMPORT	char *right PROTO((char *str, int len));
#endif
