#include <sys_socket.h>

#ifndef	MAX_CONNECTIONS
#define	MAX_CONNECTIONS	16
#endif

#ifdef	LINUX
#define	__SERVER_SELECT
#endif

#ifdef	__SERVER_SELECT
#include <select.h>
#else
#include <poll.h>
#endif

typedef	struct
{
	int		server_cnt;
	int		server_limit;
	int		server_event;
	int		server_events;
	int		server_connection[MAX_CONNECTIONS];
#ifdef	__SERVER_SELECT
	int		server_hiwater;
	fd_set	server_input, server_output, server_other;
#else
	struct	pollfd	server_poll[MAX_CONNECTIONS];
#endif	
}	SERVER;

#define	get_connection(server, client)	(server->server_connection[client])
#define	detach_server(server, id)		(server->server_connection[i] = -1)

IMPORT	SERVER	*create_server PROTO((int port, int maxclient));
IMPORT	void	destroy_server PROTO((SERVER *dev));
IMPORT	int		attach_server PROTO((SERVER *dev, int fd));
IMPORT	int		accept_server PROTO((SERVER *dev));
IMPORT	int		wait_server PROTO((SERVER *dev, int timeout));
 

