#ifndef	__MBASE_H__
#define	__MBASE_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__STREAM_H__
#include <sys_stream.h>
#endif

#ifndef	TOPICS
#define	TOPICS	".topic"
#endif

typedef	struct
{
	char	mb_topic[77];
	long	mb_position;
	char	mb_userid[17];
	long	mb_seqid;
	time_t	mb_create;
	time_t	mb_since;
	long	mb_count;
}	TOPIC;

#define	lock_topics()			lock_file(TOPICS)
#define	ulock_topics(lck)		ulock_file(lck)
#define	open_topics()			_open_topics(TOPICS, "r+")
#define	close_topics(sp)		close_stream(sp)

IMPORT	STREAM		*_open_topics PROTO((char *name, char *mode));
IMPORT	TOPIC		*read_topics PROTO((STREAM *sp));
IMPORT	TOPIC		*write_topics PROTO((STREAM *sp, TOPIC *a));
IMPORT	TOPIC		*create_topics PROTO((STREAM *sp, TOPIC *a));
IMPORT	void		remove_topics PROTO((STREAM *sp, TOPIC *a));
IMPORT	void		update_topics PROTO((STREAM *sp, TOPIC *a));
IMPORT	char		*fname_topic PROTO((TOPIC *a));
#endif

