#ifndef	__BITS_H__
#define	__BITS_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

typedef	unsigned char	*bits;

#define	bitarray(a, s)	unsigned char a[s / 8]
#define	tstbit(a, b)	(*((bits)(a) + b / 8) & (0x01 << (b % 8)))
#define	setbit(a, b)	(*((bits)(a) + b / 8) |= (0x01 << (b % 8)))
#define	clrbit(a, b)	(*((bits)(a) + b / 8) &= ~(0x01 << (b % 8)))	

IMPORT	void	bitsand PROTO((bits a, bits b, int size));
IMPORT	void	bitsor PROTO((bits a, bits b, int size));
IMPORT	void	bitsxor PROTO((bits a, bits b, int size));
IMPORT	void	bitsset PROTO((bits a, int size));
IMPORT	void	bitsclr PROTO((bits a, int size));

#endif
