/*	$Header$
	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

Created by:

	David Sugar, Tycho Softworks
   	E-Mail: dyfet@aol.com, BBS: 201-858-3429

Synopsis:

	Provides a portable system interface to common file operations.

History:

	$Log$
*/

#ifndef	__FILES_H__
#define	__FILES_H__

#include <stdio.h>

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__BOOL_H__
#include <bool.h>
#endif

#ifndef	__CONFIG_H__
#include <sys_config.h>
#endif

#ifdef	__OS2__
#define	ETC_PATH	getenv("ETC")
#define	LIB_PATH	os2libpath()
IMPORT	char	*os2libpath PROTO((void));
#endif

#ifdef	QNX
#define	ETC_PATH	"/config"
#define	LIB_PATH	"/config"
typedef	FILE	LOCK;
#else
typedef	struct
{
	int		l_fd;
	char	l_name[0];
}	LOCK;
#endif

#ifdef	SCO
#define	ETC_PATH	"/vubbs/files:/etc:/usr/lib:/usr/local/lib"
#define	LIB_PATH	ETC_PATH
#endif

#ifndef	ETC_PATH
#define	ETC_PATH	"/etc:/usr/lib:/usr/local/lib"
#endif

#ifndef	LIB_PATH
#define	LIB_PATH	"/usr/local/lib:/usr/lib:/etc:/lib"
#endif

IMPORT	BOOL	canread PROTO((char *path));
IMPORT	BOOL	canwrite PROTO((char *path));
IMPORT	BOOL	isnewfile PROTO((char *from, char *to));
IMPORT	BOOL	isfile PROTO((char *fpath));
IMPORT	BOOL	isdir PROTO((char *fpath));
IMPORT	char	*search_path PROTO((char *path, char *fname));
IMPORT	void	dup_fstamp PROTO((char *file1, char *file2));
IMPORT	int		compress_file PROTO((CONFIG *cfg, char *fname, char *outpath));
IMPORT	int		expand_file PROTO((CONFIG *cfg, char *input, char *output)); 
IMPORT	int		send_file PROTO((CONFIG *cfg, char *protocol, char **flist));
IMPORT	int		recv_file PROTO((CONFIG *cfg, char *protocol, char **flist));
IMPORT	char	*name_temp PROTO((void));
IMPORT	FILE	*open_temp PROTO((void));
IMPORT	void	close_temp PROTO((FILE *fp));
#ifdef	QNX
#define	lock_file(fname)	fopen(fname, "w")
#define	ulock_file(lock)	fclose(lock)
#else
IMPORT	BOOL	islock_file PROTO((char *fname));
IMPORT	LOCK	*lock_file PROTO((char *fname));
IMPORT	void	ulock_file PROTO((LOCK *lock));
#endif

#endif
