#ifndef	__SOFTWARE_H__
#define	__SOFTWARE_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__STREAM_H__
#include <sys_stream.h>
#endif

#ifndef	INDEX
#define	INDEX	".index"
#endif

#ifndef	UPDATE
#define	UPDATE	".update"
#endif

typedef	struct
{
	char	a_fname[33];
	char	a_title[65];
	char	a_text[65 * 13];
}	ABSTRACT;

#define	lock_softidx()			lock_file(INDEX)
#define	ulock_softidx(lck)		ulock_file(lck)
#define	open_softidx()			_open_softidx(INDEX, "r")
#define	append_softidx()		_open_softidx(INDEX, "a")
#define	update_softidx()		_open_softidx(UPDATE, "w")
#define	close_softidx(sp)		close_stream(sp)

IMPORT	STREAM		*_open_softidx PROTO((char *name, char *mode));
IMPORT	ABSTRACT	*read_softidx PROTO((STREAM *sp));
IMPORT	ABSTRACT	*write_softidx PROTO((STREAM *sp, ABSTRACT *a));
IMPORT	void	replace_softidx PROTO((STREAM *sp));

#endif
