/*	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

	Defines functions and constants asssociated with national
	replacement when localizing VU.
*/

#ifndef __VU_H__
#include <vu.h>
#endif

#ifdef	__LL_EN
#define	__LL
#endif

#ifdef	__LF_NA
#define	__LF
#endif

#ifndef	__LF
#define	__LF_NA
#endif

#ifndef	__LL
#define	__LL_EN
#endif

#ifdef	QNX
#define	sprintf	tsprintf
#endif

#ifdef	__LF_NA

#define	LOCATION	"North American"
#define	DATE_FIELD_MARK	'/'
#define	NUMBER_COLUMN_MARK ','
#define	CURRENCY_MARK '$'

/*	some data conversion macros */

#define	num2time(buf,val)	sprintf(buf,"%2d:%02d",val / 60,val % 60)
#define	time2num(buf)		(atoi(buf) * 60 + atoi(buf + 3))

#define	num2date(buf,val)	sprintf(buf,"%2u/%02u/%02u",((unsigned)val / 32) % 12+1, (unsigned)val % 32,(((unsigned)val / 384) + 90) % 100)   	
#define	tm2date(buf,val)	sprintf(buf,"%2u/%02u/%02u",buf->tm_mon + 1, buf->tm_mday, buf->tm_year % 100)
#define	date2num(buf)		(unsigned)(((atoi(buf+6) + 10) % 100) *  384 + (atoi(buf) - 1) * 32) + atoi(buf+3)) 

#endif

#ifndef	START_OF_WEEK
#define	START_OF_WEEK	0
#endif

#ifndef	START_OF_YEAR
#define	START_OF_YEAR	0
#endif

CONTROL(VUEditDateControl);

IMPORT	char *PASCAL VUCvtDate P(( struct tm *now ));
IMPORT	struct tm *PASCAL VUScanDate P(( struct tm *mask , char *buf ));


