/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <signal.h>
#include <pwd.h>
#include <unistd.h>
#include "yabbslib.h"

/*
 * thanks to jban@data.fls.dk for patches to make this work properly
 * and for variable shutdown times.
 */

extern int bbs_s;

void cli_page(char *name) {}
void cli_msgline(char *line, int type, void *d) {}
void cli_msghdrline(int x, char *to, char *from, char *del, char *subject, 
    void *d) {}
void cli_talkline(char *channel, char *name, char *msg, int type) {}
void cli_textline(char *line, void *d) {}
void cli_planline(char *line, void *d) {}
void cli_gfileline(char *line, void *d) {}
void cli_gfileindexline(char *name, char *path, char *type, void *d) {}
void cli_msgbasename(int baseid, char *basename, void *d) {}
void cli_useroptions(char *name, int slen, unsigned long o, char *s, void *d) {}
void cli_founduser(char *name, void *d) {}
void cli_announce(int type, char *arg1, char *arg2) {}

char *cli_yabbsrcname(void) {
    static char *yabbsrc = "yabbsrc";
    return yabbsrc;
}

char *cli_hiddenyabbsrcname(void) {
    static char *yabbsrc = ".yabbsrc";
    return yabbsrc;
}

void cli_fatalerror(char *msg) {
    printf("FATAL: %s\n", msg);
    exit(1);
}

void cli_error(char *msg) {
    printf("warning: %s\n", msg);
}

void cli_wholine(char *name, char *onfrom, char *onsince, int idle, void *d) { }

void cli_channelline(char *channel, char *users, void *d) { }

void sigint() {
    printf("yshutdown: shutdown canceled\n");
    bbs_shutdown(SD_ENABLE, "shutdown canceled");
    exit(1);
}

void main(int argc, char **argv) {
    char userid[10], passwd[10], *server;
    int ul, sleeptime;
    signal(SIGINT, sigint);

    sleeptime = (argc < 2) ? 60 : atoi(argv[1]);
    if (sleeptime < 0) sleeptime = -sleeptime;

    if (argc >= 3) server = argv[2]; else server = NULL;

    printf("yabbs login: "); fgets(userid, 9, stdin);
    userid[ul = strlen(userid)] = 0;
    if (ul) userid[--ul] = 0;
    strcpy(passwd, getpass("password: "));
    bbs_connect(server);
    bbs_login(userid, passwd);

    while (sleeptime > 4) {
        char warnmsg[80];

        sprintf(warnmsg, "system going down in %d seconds", sleeptime);
        printf("yshutdown: sending %d seconds warning\n", sleeptime);
        bbs_shutdown(SD_DISABLE, warnmsg);
        if (argc == 4) bbs_shutdown(SD_DISABLE, argv[3]);
        sleep(sleeptime /= 2);
    }
    sleep(sleeptime);
    printf("yshutdown: shutting down now\n");
    bbs_shutdown((argc == 4) ? SD_DISABLE : SD_NOW, "system going down NOW");
    if (argc == 4) bbs_shutdown(SD_NOW, argv[3]);
    bbs_logout();
}
