// Filename:   userupdate.c
// Contents:   a program to update the userlog for the new format
// Author: Greg Shaw
// Created:    12/6/94

#include "bbshdr.h"

int update(int version)
{
	FILE   *ufile = NULL;       // old userlog
	FILE   *nfile= NULL;        // new userlog
	char   *bbsdir;
	char   finame[255];         // filename
	char   line[255];           // one line in file (255 max)
	char   linenum;             // used to look for appropriate line
	char   c;                   // input char
	unsigned char  of;          // offset into line
	int    has_color;           // has color?
	char    editor[15];         // favorite editor
	int    lines;               // lines on screen
	int    cols;                // columns on screen
	int        credited;        // credited time
	int        priv_msgs;       // private messages
	int     pub_msgs;           // private messages
	int    acl, timelimit, timeused, kused;
	long   flags;
	time_t anniversary;



	if (bbsdir = getenv("BBSDIR"), bbsdir == NULL)
	{
		fprintf(stderr,"BBSDIR environment variable not set\n");
		return(-1);
	}
	sprintf(finame,"%s/admin/userlog",bbsdir);

	if (version == 1)
	{
		linenum = 0;            // look for first line first
		if (ufile = fopen(finame,"r"), ufile != NULL)
		{
			strcat(finame,".new");
			if (nfile = fopen(finame,"w"), nfile == NULL)
			{
				fprintf(stderr,"Unable to open new userlog.\n");
				return(-1);
			}
			while (!feof(ufile))
			{
				of = 0;
				while (c = fgetc(ufile), c != '\r' && c != '\n' && !feof(ufile))
					// skip trailing left bracket
					if (c != ']')
						line[of++] = c;
				line[of] = 0;   // add null
				switch(linenum)
				{
					case 0:     // first line
						// got line 1?
						if (line[0] == '[' && line[1] == 'A')
						{
							sscanf(&line[2],"%s %*s %*s %*s %*s %*s",finame);
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 1:     // second line
						// got line 2?
						if (line[0] == '[' && line[1] == 'B')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 2:     // third line
						// got line 3?
						if (line[0] == '[' && line[1] == 'C')
						{
							if (sscanf(&line[2],"%d %d %d %d %s %d %d ",&priv_msgs,&pub_msgs,&credited, &has_color, editor, &lines, &cols)
								!= 7)
							{
								fprintf(stderr,"bad read from user  file.  (%s)(line C) Corrupted?",finame);
								return(-1);
							}
							fprintf(nfile,"[C %d %d %d %d %s %d %d english ]\n",priv_msgs,pub_msgs,credited, has_color, editor, lines, cols);
							// get next line
							linenum++;
						}
						break;
					case 3:     // fourth line
						// got line 4?
						printf("line d\n");
						if (line[0] == '[' && line[1] == 'D')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum=0;
						}
						break;
					default:
						printf("Unknown switch value: %d",linenum);
						linenum = 0;
				}
			}
		}
		else
		{
			fprintf(stderr,"Unable to open userlog.\n");
		}
	}
	else if (version == 2)      // 0.86 to 0.89
	{
		linenum = 0;            // look for first line first
		if (ufile = fopen(finame,"r"), ufile != NULL)
		{
			strcat(finame,".new");
			if (nfile = fopen(finame,"w"), nfile == NULL)
			{
				fprintf(stderr,"Unable to open new userlog.\n");
				return(-1);
			}
			while (!feof(ufile))
			{
				of = 0;
				while (c = fgetc(ufile), c != '\r' && c != '\n' && !feof(ufile))
					// skip trailing left bracket
					if (c != ']')
						line[of++] = c;
				line[of] = 0;   // add null
				switch(linenum)
				{
					case 0:     // first line
						// got line 1?
						if (line[0] == '[' && line[1] == 'A')
						{
							sscanf(&line[2],"%s %*s %*s %*s %*s %*s",finame);
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 1:     // second line
						// got line 2?
						if (line[0] == '[' && line[1] == 'B')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 2:     // third line
						// got line 3?
						if (line[0] == '[' && line[1] == 'C')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 3:     // fourth line
						// got line 4?
						if (line[0] == '[' && line[1] == 'D')
						{
							if (sscanf(&line[2],"%lx %d %d %d %ld %d",&flags, &acl, &timelimit, &timeused, &anniversary, &kused ) != 6)
							{
								fprintf(stderr,"bad read from user  file.  (%s)(line D) Corrupted?",finame);
								return(-1);
							}
							fprintf(nfile,"[D %lx %d %d %d %ld %d 0 ]\n",flags, acl, timelimit, timeused, anniversary, kused );
							// get next line
							linenum=0;
						}
						break;
				}
			}
		}
		else
		{
			fprintf(stderr,"Unable to open userlog.\n");
		}
	}
	fclose(ufile);              // close file
	fclose(nfile);              // close file
	return(0);
}


void usage(void)
{
	printf("Usage: userupdate -v current_revision\n");
	printf("Example:\n");
	printf("\tTo update userlog from 0.85 to 0.86\n");
	printf("\tuserupdate -v 0.85\n");
	printf("\nSupported versions:\n");
	printf("\t0.85 to 0.86\n");
	printf("\t0.86 to 0.89\n");
}


main(int argc,char *argv[])
{
	char   c;                   // character sent back by getopt



	c = getopt(argc,argv,"v:");
	if (c == -1)
		usage();
	else
	{
		switch (c)
		{
			case 'v':           // version
				// 0.85 to 0.86
				if (!strcmp(optarg,"0.85"))
					return(update(1));
				// 0.86 to 0.89
				else if (!strcmp(optarg,"0.86"))
					return(update(2));
			default:
				usage();
		}
	}
	return(0);
}


