// Filename:   filesupdate
// Contents:   the conversion program to update the files sections to the
//     new format.
// Created:    6/17/94
// Author: Greg Shaw

#ifndef _FILESUPDATE_C_
#define  _FILESUPDATE_C_

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

// Function:   convert
// Purpose:    convert a files section
// Input:  path - the name of the bbs section to read
// Output: none.  setup function only.
// Author: Greg Shaw
// Created:    6/17/94

int convert(char *sname)
{
	FILE   *infile,*outfile;
	char   name[100];
	char   uploader[100];
	int    numdls;
	char   tmpstr[255];
	char   tmpstr2[255];
	int    off;
	int    line;
	char   *bbsdir;             // used for bbsdir environment var
	char   c;

	if (bbsdir = getenv("BBSDIR"), bbsdir == NULL)
	{
		printf("Unable to get BBSDIR\r\n");
		exit(1);
	}
	// tack on files header
	sprintf(tmpstr,"%s/filehdr/%s",bbsdir,sname);
	if (infile = fopen(tmpstr,"r"), infile == NULL)
	{
		printf("Unable to open files section %s\r\n",sname);
		return(0);              // empty files section
	}
	// tack on files header
	sprintf(tmpstr,"%s/filehdr/%s.new",bbsdir,sname);
	if (outfile = fopen(tmpstr,"w"), infile == NULL)
	{
		printf("Unable to open new files header.\r\n");
		return(0);
	}
	// ok.  now read everything into dllist object
	line = 0;
	while (!feof(infile))
	{
		while (c=fgetc(infile), c != '[' && !feof(infile));
		if (feof(infile))
			continue;
		switch(line)
		{
			case 0:             // line 1
				if (c = fgetc(infile), c == 'A')
				{
					if (fscanf(infile,"%s %*ld %*ld %d %s", name, &numdls,uploader) != 3)
					{
						printf("%s: Error on line A\r\n",sname);
						return(0);
					}
					line++;
					fprintf(outfile,"[A %s %d %s ]\n",uploader, numdls, name);
				}
				break;
			case 1:             // line 2
				if (c = fgetc(infile), c == 'B')
				{
					off = 0;
					while (c = fgetc(infile), c != '\r' && c != '\n' && !feof(infile))
						tmpstr[off++] = c;
					tmpstr[off] = 0;
					fprintf(outfile,"[B %s\n",tmpstr);
					line++;
				}
				break;
			case 2:             // line 3
				if (c = fgetc(infile), c == 'C')
				{
					off = 0;
					while (c = fgetc(infile), c != '\r' && c != '\n' && !feof(infile))
						tmpstr[off++] = c;
					tmpstr[off] = 0;
					fprintf(outfile,"[C %s\n",tmpstr);
					line++;
				}
				break;
			case 3:             // line 4
				if (c = fgetc(infile), c == 'D')
				{
					off = 0;
					while (c = fgetc(infile), c != '\r' && c != '\n' && !feof(infile))
						tmpstr[off++] = c;
					tmpstr[off] = 0;
					fprintf(outfile,"[D %s\n",tmpstr);
					line++;
				}
				break;
			case 4:             // line 5
				if (c = fgetc(infile), c == 'E')
				{
					off = 0;
					while (c = fgetc(infile), c != '\r' && c != '\n' && !feof(infile))
						tmpstr[off++] = c;
					tmpstr[off] = 0;
					fprintf(outfile,"[E %s\n",tmpstr);
					line++;
				}
				break;
			case 5:             // line 6
				if (c = fgetc(infile), c == 'F')
				{
					off = 0;
					while (c = fgetc(infile), c != '\r' && c != '\n' && !feof(infile))
						tmpstr[off++] = c;
					tmpstr[off] = 0;
					fprintf(outfile,"[F %s\n",tmpstr);
					line = 0;
				}
				break;
		}
	}
	fclose(infile);
	fclose(outfile);
	sprintf(tmpstr,"%s/filehdr/%s",getenv("BBSDIR"),sname);
	sprintf(tmpstr2,"%s/filehdr/%s.old",getenv("BBSDIR"),sname);
	rename(tmpstr,tmpstr2);     // rename file
	sprintf(tmpstr,"%s/filehdr/%s.new",getenv("BBSDIR"),sname);
	sprintf(tmpstr2,"%s/filehdr/%s",getenv("BBSDIR"),sname);
	rename(tmpstr,tmpstr2);     // rename file
	return(0);
};


main()
{
	char   *bbsdir;             // used for bbsdir environment var
	char   c;
	FILE *hdrfile;
	char   tmpstr[120];

	if (bbsdir = getenv("BBSDIR"), bbsdir == NULL)
	{
		printf("Unable to get BBSDIR\r\n");
		exit(1);
	}
	sprintf(tmpstr,"%s/filehdr/bbs_files_hdr",bbsdir);
	if (hdrfile = fopen(tmpstr,"r"), hdrfile == NULL)
	{
		printf("Unable to open main files header.\r\n");
		exit(1);
	}
	while (!feof(hdrfile))
	{
		while(c = fgetc(hdrfile), c != '[' && !feof(hdrfile));
		if (fscanf(hdrfile,"%s",tmpstr) == 1)
		{
			printf("Converting %s\r\n",tmpstr);
			convert(tmpstr);
		}
	}
	fclose(hdrfile);
}


#endif                          // _FILESUPDATE_C_






