// Filename:   dllist.h
// Contents:   the object definition for the doubly linked list object
// Author: Greg Shaw
// Created:    8/2/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _DLLIST_H_
#define _DLLIST_H_

#include "bbshdr.h"


// Structure:  finfo
// Contents:   the record for a file in a files section
// Author: Greg Shaw
// Created:    8/1/93

typedef struct finfo
{
	// name of file
	char name[MAX_FILENAMELENGTH+1];
	char sdesc[SDESC_LEN];      // short description
	char uploader[41];          // name of uploader
	char avail;                 // is file online and available?
	time_t date;                // date of upload
	int    numdls;              // number of times downloaded
	unsigned long filepos;      // position in file of description
	unsigned long size;         // size of file
	struct finfo *next;         // next record
	struct finfo *previous;     // previous record
};


typedef struct finfo FInfo;

// Object: dllist
// Purpose:    encapsulate a dynamically linked list object with
//     self-sorting capabilities.
// Attributes: numrec - number of records in list
//     head - head of list
//         tail - tail of list
//     sortstate - the current sorted state:
//         0 - unsorted (just loaded)
//         1 - ascending by date
//         2 - ascending by alphabetic
// Methods:    add - add to list
//     open - read in files section
//         clear - nuke list
//         sort - sort list (by key)
//     previous - return 'previous' record
//     next - return 'next' record
// Author: Greg Shaw
// Created:    8/2/93

class dllist : public errlog
{
	int    numrec;              // number of records in list
	FInfo  *head;               // head of list
	FInfo  *tail;               // tail (end) of list
	FInfo  *here;               // current list record pointer
	int    sortstate;           // current sorted state
	// sort records by type
	sel_sort(int srtype, FInfo *head);
	public:
		dllist();               // constructor
		~dllist();              // destructor
		add(FInfo *rec);        // add to list
		clear_list(void);       // nuke list
		sort(int type);         // sort list
		top(void);              // go to head of list
		bottom(void);           // go to tail of list
		numrecs(void)           // return number of records
		{
			return(numrec);
		};
		FInfo *previous(void);  // previous record
		FInfo *next(void);      // next record
		FInfo *find(char *str); // search record for string
};


#endif                          // _DLLIST_H_







