// Filename:   bbsinfo.h
// Contents:   the bbs information object
// Author:     Greg Shaw
// Created:        7/11/93

/*

This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSINFO_H_
#define _BBSINFO_H_

// Structure:  card_color
// Contents:   the information that defines a card 'level'
// Author:     Greg Shaw
// Created:        7/27/93

typedef struct
{
	char   colr[10];            // card color
	int        acl;             // minimum acl for that level
	int        tl;              // minimume tl for level
	int        flags;           // additional flags for level (or'd into user flags)
	int        kbytes;          // how many kbytes per period user may download
	int    timelimit_days;      // days timelimit is valid
	int    timelimit_period;    // timelimit for period
	int    account_valid_months;// timeperiod (months) that an
	// account is valid
} CardRec;


// Object:     bbsinfo
// Purpose:        return some information that is setup-specific (and could
//             change, so hard-coding isn't an option)
// Attributes: none
// Methods:
//             loghost - return the name of the loghost
//             watchost - return the name of the sysop watcher daemon
//                 ratio - return the required upload/download ratio
//             def_acl - return the default BBS access level
//             def_termtype - return the default terminal type
// Author:     Greg Shaw
// Created:        7/11/93

class bbsinfo
{
	// find line with keyword
	int    findline(char *line, char *word);
	public:
		// return card info for card type passed in
		CardRec    *cardinfo(int   type);
		int creditchat(void);   // is chat time credited?
		int credituploads(void);// is upload time credited?
		// is sysop available for chat?
		int    chat_avail(int tim);
		char *loghost(void);    // error logging daemon
		char *chathost(void);   // chat daemon
		int    def_card(void);  // default card color
		// default terminal type
		char *def_termtype(void);
		float  ratio(void);     // upload to download ratio
		char *sysop(void);      // return sysop's name
		int    sys_msg_once(int num);
		// display (num) system msg once?
		char *sys_pager(void);  // default system pager
		int waittime(void);     // time between logons allowed for users
		char *watchhost(void);  // sysop watcher daemon
		char *userprompt(void); //  the prompt for at the end of a menu
		char *mailspool(void);  // system mail spool file
		int showtime(void);     // show user timeleft
		int showcoms(void);     // show user valid command keys
		int showfortune(void);  // show user fortune upon logon?
		// time before user booted
		int inactivity_timeout(void);
		int maxk(void);         // max # of K user can download at one time
		int mailchecktime(void);// minimum # of seconds between new mail checks
		char *talkprog(void);   // return the system 'talk' program
		uid_t bbs_uid(void);    // return bbs uid
		gid_t bbs_gid(void);    // return bbs uid
		char *username(void);   // return name of current user
		int checkmail(void);    // check for mail?
		// fudge timelimit?
		int timelimit_fudge(void);
		// log menu accesses?
		int log_menu_accesses(void);
		int log_externals(void);// log externals?
		// default foreground
		int def_foreground(void);
		// default background
		int def_background(void);
		int def_attribute(void);// default color attribute
		// fudge factor for logging out user when time expired in download
};


#endif                          // _BBSINFO_H_







