#include "bbshdr.h"	// BBS headers

// Function:	usage
// Purpose:	print out usage information
// Author:	Greg Shaw
// Created:	5/12/95

void usage(void)
{
	fprintf(stderr,"Usage: anu login full_name login_dir bbs_group_num uid\n");
	exit(1);
}



main(int argc,char *argv[])
{
        FILE *infile;
	struct passwd *pwd;
	char tmpstr[255];
	errlog error_logger; 	// BBS error logger
	uid_t uid;		// uid and gid (for chown)
	gid_t gid;

        if (argc != 6)
		usage();
        else if (pwd = getpwuid(getuid()), strcmp(pwd->pw_name,"new"))
	{
		fprintf(stderr,"anu is part of the rocat BBS System.\n");
		fprintf(stderr,"anu may be run only by the 'new' user.\n");
		printf("user: %s\n",pwd->pw_name);
		usage();
		sprintf(tmpstr,"anu: %s tried to create new account",pwd->pw_name);
		error_logger.ap_log(tmpstr);
	}
	// Ok.  We're reasonably certain that this guy is the real thing
	// let's create a new user record
 	if (infile = fopen("/etc/passwd","a"), infile == NULL)
	{
		perror("anu: Unable to open /etc/passwd");
		exit(1);
	}
	fprintf(infile,"%s::%s:%s:%s:%s:/bbs/bbs\n",argv[1],argv[5],argv[4],argv[2],argv[3]);
	sprintf(tmpstr,"anu: created new user %s",argv[1]);
	error_logger.ap_log(tmpstr);
	fclose(infile);
	// now create his home directory
	if (mkdir(argv[3],0755))
	{
		perror("anu: Unable to create home directory");
	}
	// change ownership to new user
	sscanf(argv[5],"%hd",&uid);
	sscanf(argv[4],"%hd",&gid);
	chown(argv[3],uid,gid);
	exit(0);
}

