/* ix/MBox (xmd.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #ET elapsed_time()    calculate the delivering time
   #BR brief()           mail a letter to a BBS user
   #IS is_external()     old gateway stuff (forget about it)
   #MI mailing()         find users BBS username
   #ML massiv_lock	 lock completely!
   #MU massiv_unlock	 undo complete lock!
   #MA main()            XMD main function

   Contact <volkers@unnet.wupper.de> for help! */






#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>

#include "mbox.h"


UNSIGNED char tmp[STRING];
UNSIGNED char alias[MAX_XMD_ALIAS][2][STRING];
UNSIGNED char x400[STRING];
UNSIGNED char PIPE_RECEIVER[STRING];
int INTERACT;

int KOPIE;


/* #ET - Calculates the delivering time out of a "Date:" header line [hd].

   This function returns a "X-Delivering-Time:" header line. */

UNSIGNED char *elapsed_time( hd )
UNSIGNED char hd[];
{
  UNSIGNED char tag[STRING];
  UNSIGNED char monat[STRING];
  UNSIGNED char jahr[STRING];
  UNSIGNED char zeit[STRING];
  UNSIGNED char zone[STRING];

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
 
  UNSIGNED char mon[12][4];

  UNSIGNED char tzcode[STRING];
  UNSIGNED char tzfact[STRING];
  UNSIGNED char tzname[STRING];

  int i = 0, a = 0;

  long ljahr, lzeit;
  long njahr, nzeit;

  FILE *fp;


  strcpy(mon[ 1], "Jan");
  strcpy(mon[ 2], "Feb");
  strcpy(mon[ 3], "Mar");
  strcpy(mon[ 4], "Apr");
  strcpy(mon[ 5], "May");
  strcpy(mon[ 6], "Jun");
  strcpy(mon[ 7], "Jul");
  strcpy(mon[ 8], "Aug");
  strcpy(mon[ 9], "Sep");
  strcpy(mon[10], "Oct");
  strcpy(mon[11], "Nov");
  strcpy(mon[12], "Dec");

  while((a == 0) && (hd[i] != '\0')){
	if((hd[i] >= '0') && (hd[i] <= '9')) a = i;
	i++;
  }

  strcpy(s, (UNSIGNED char *) strcopy(hd, a, (strlen(hd))));

  sscanf(s, "%s %s %s %s %s", tag, monat, jahr, zeit, zone);
 
  for(i = 1; i <= 12; i++){
	if(strcomp(mon[i], monat) == 0) a = i;
  }

  sprintf(s, "%02.2d.%02.2d.%02.2d", atoi(tag), a, atoi(jahr));
  ljahr = dateconv( (UNSIGNED char *) s );

  lzeit = (long) (atol( strcopy(zeit, 0, 1) ) * 60) + (atol(strcopy(zeit, 3, 4)));
  
  strcpy(s, (UNSIGNED char *) mydate( 0 ));
  njahr = dateconv( (UNSIGNED char *) s );

  strcpy(s, (UNSIGNED char *) mytime( 0 ));
  nzeit = (long) (atol( strcopy(s, 0, 1) ) * 60) + (atol(strcopy(s, 3, 4)));

  if((zone[1] >= '0') && (zone[1] <= '9')){     /* +0500, -0100, ...  */
	strcpy(tzfact, (UNSIGNED char *) zone);
	tzname[0] = '\0';
  }
  else{						/* GMT, CET, EET, ... */
	fp = fopen( TIMEZONES, "r" );
	if(fp == NULL){
		sprintf(t, "XMD-FILE-NOT-FOUND: %s\n", (UNSIGNED char *) TIMEZONES);
		return (UNSIGNED char *) t;
	}
	while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));
	while(fgets(s, STRING, fp) != NULL){
		sscanf(s, "%s", t);
		if(strcomp(zone, t) == 0){
			sscanf(s, "%s %s", tzcode, tzfact);	
			strcpy(tzname, (UNSIGNED char *) stripped(strcopy(s, 19, strlen(s))));
		}
	}
	fclose(fp);
  }

  strcpy(s, (UNSIGNED char *) GMT_DIFF);	
  if(s[0] == '-'){
	s[0] = ' ';
	nzeit += (long) (atol(s) * 60 / 100); 
  }
  else{
	s[0] = ' ';
	nzeit -= (long) (atol(s) * 60 / 100); 
  }
  
  if(tzfact[0] == '-'){
  	tzfact[0] = ' ';
	lzeit += (long) (atol(tzfact) * 60 / 100); 
  }
  else{
	tzfact[0] = ' ';
	lzeit -= (long) (atol(tzfact) * 60 / 100); 
  }
  
  njahr -= ljahr; 

  if(njahr > 30){
	njahr -= 70;	
  }
  if(njahr > 30){
	return( (UNSIGNED char *) "X-Delivering-Time: Not able to calculate!\n" );
  }

  nzeit -= lzeit;
  
  if(nzeit < 0){
	nzeit += (24 * 60);
	njahr -= 1;
  }

  if(njahr > 0){
	sprintf(s, "X-Delivering-Time: %ld day(s), %ld hour(s) and %ld minute(s)",
		  (long) njahr, 
		  (long) (nzeit / 60), 
		  (long) (nzeit - ((nzeit / 60) * 60)));
  }
  else{
	sprintf(s, "X-Delivering-Time: %ld hour(s) and %ld minute(s)",
		  (long) (nzeit / 60), 
		  (long) (nzeit - ((nzeit / 60) * 60)));	
  }

  if(tzname[0] != '\0'){
	sprintf(t, "; %s", tzname);
	strcat(s, t);
  }

  strcat(s, "\n");


  return (UNSIGNED char *) s;
}



void log_it( s1, s2, s3 )
UNSIGNED char s1[], s2[], s3[];
{
  FILE *ff;


  ff = fopen( XMDLOG, "a" );
  if(ff == NULL){
	printf("\nCan't open %s\n", XMDLOG);
	return;
  }
  fprintf(ff, "%5.5s  %5.5s > %-29.29s   [%s %s]\n",
	(UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
        (UNSIGNED char *) s1, s2, s3);
  fclose(ff);
}



/* #BR - Mail to a BBS user [arg]. */

brief(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;
  int fd;
  int i, a, b;
  int ok;
  struct userdaten LOOSER;

  struct tm *timeptr;
  time_t timer;

  int receiver;
  static int mail_id;
  int lines   = 0;
  int local   = 0;
  int arrived = 1;

  int yet_new = 0;


  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char subject[STRING];
  UNSIGNED char autor[STRING];
  UNSIGNED char rec_char[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char user[STRING];
  UNSIGNED char destination[STRING];
  UNSIGNED char receipt[STRING];

  i = 0;
  ok = 0;


  strcpy(user, (UNSIGNED char *) stripped(arg));
  strcpy(subject, XMD01_MSG);

  JUNK:	receiver = 0;

  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	log_it( "Can't read:", UDBASE, "!" );
	printf("\nCan't read %s\n", UDBASE);
	exit(-1);
  }
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (receiver == 0)) {
	if ((strcomp(user, LOOSER.name) == 0) ||
	    (strcomp(LOOSER.name, user) == 0) ||
	    (strcomp(user, LOOSER.nick) == 0) ||
	    (strcomp(user, LOOSER.sh_name) == 0)) {
		receiver = LOOSER.id;
		strcpy(rec_char, LOOSER.name);
	}
  }
  close(fd);

  if (receiver == 0) {
	sprintf(subject, "[xmd:] '%s' ???   ", user);
	strcpy(user, POSTMASTER);
	arrived = 0;
	goto JUNK;
  }

  massiv_lock( receiver );

  sprintf(t, "%s/usr/%d/seq", HOME, receiver);
  maybe_locked(t, "r"); mblock( t );
  fp = fopen(t, "r");
  if(fp == NULL){
	yet_new = 1;
	sprintf(t, "%s/usr/%c/%d/seq", HOME, rec_char[0], receiver);
	fp = fopen(t, "r");
	if(fp == NULL){
		log_it( "Can't read:", t, "!" );
		printf("\nCan't read %s\n", t);
		massiv_unlock( receiver );
		exit(-1);
	}
  }
  fgets(s, STRING, fp);
  mail_id = atoi( s );
  fclose(fp);

  fp = fopen(t, "w");
  if(fp == NULL){
	log_it( "Can't write to:", t, "!" );
	printf("\nCan't write to %s\n", t);
  }
  fprintf(fp, "%d\n", (int) (mail_id + 1));
  fclose(fp);

  if(INTERACT == 0) printf("%s\n", arg);


  if(yet_new == 0)
	sprintf(destination, "%s/usr/%d/%d", HOME, receiver, mail_id);
  else
	sprintf(destination, "%s/usr/%c/%d/%d", HOME, rec_char[0], receiver, mail_id);

  fp = fopen(destination, "w");
  if(fp == NULL){
	log_it( "Can't write to:", destination, "!" );
	printf("\nCan't write to %s\n", destination);
  }
  lines = 7;

  autor[0] = '\0';
  subject[0] = '\0';

  ff = fopen(tmp, "r");
  if (ff == NULL) {
	massiv_unlock( receiver );
	return;
  }
  while (fgets(s, STRING, ff) != NULL) {
	i = 0;

	if(strcomp("*From ", s) == 0){
		strcpy(s, (UNSIGNED char *) stripped(strcopy(s, 1, STRING)));
		strcat(s, "\n");
	}
	if(strcomp("Date: ", s) == 0){
		fputs(elapsed_time( s ), fp);
	}
	fputs(s, fp);
	lines++;
	if((strcomp("Subject: ", s) == 0) && (subject[0] == '\0')){
		strcpy(subject, (UNSIGNED char *) stripped(strcopy(s, 9, STRING)));
	}
	if((strcomp("From: ", s) == 0) && ((autor[0] == '\0') || (local = 1))){
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 6, STRING)));
		local = 0;
	}
	if(strcomp("From ", s) == 0){
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 5, STRING)));
		local = 1;
	}
	if(strcomp("*From ", s) == 0){
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 6, STRING)));
		local = 1;
	}
	if(strcomp("Return-Receipt-To: ", s) == 0){
		strcpy(receipt, (UNSIGNED char *) stripped(strcopy(s, 19, STRING)));
	}
	if(strcomp("X-Return-Receipt-To: ", s) == 0){
		strcpy(receipt, (UNSIGNED char *) stripped(strcopy(s, 19, STRING)));
	}
  }
  fclose(ff);
  fclose(fp);


  if((strcomp("Joerg Guettel", rec_char) == 0) || (strcomp("Joerg.Guettel", rec_char) == 0)){
	fp = fopen( destination, "r" );
	ff = fopen( tmp, "w" );
	while(fgets(s, STRING, fp) != 0){
		fprintf(ff, "%s", s);
		if(strcomp("MIME-Version:", s) == 0){
			fprintf(ff, "Content-Type: text/plain;\n");			
		}
	}
	fclose(fp);
	fclose(ff);
	sprintf(s, "/bin/sh %s/etc/rmail.sh %s noergel!joergg", HOME, tmp);
	system(s);
  }

  i = 0; 
  while(autor[i] != '\0'){
	if(autor[i] == '(') autor[(i-1)] = '\0';
	i++;
  }

  if(autor[0] == '"'){
	i = 1;
	while((autor[i] != '"') && (autor[i] != '\0')){
		i++;
	}
	i--;
	strcpy(autor, (UNSIGNED char *) strcopy(autor, 1, i));
  }

  if((local == 1) && (strcomp("postmaster", autor) == 0)){
	fclose(fp);
	unlink(destination);
	if(INTERACT == 0) printf("[%s]\n", arg);
	fp = fopen( XMDLOG, "a" );
	if(fp == NULL){
		printf("\nCan't append to %s\n", XMDLOG);
		massiv_unlock( receiver );
		return;
	}
	fprintf(fp, "%-29.29s   %33.33s\n", (UNSIGNED char *) stripped(arg), subject);
	fclose(fp);
	massiv_unlock( receiver );
	return;
  }

  if(yet_new == 0)
	sprintf(s, "%s/usr/%d/INDEX", HOME, receiver);
  else
	sprintf(s, "%s/usr/%c/%d/INDEX", HOME, rec_char[0], receiver);

  fp = fopen(s, "a");
  if(fp == NULL){
	log_it( "Can't append to:", s, "!" );
	printf("\nCan't append to %s\n", s);
	massiv_unlock( receiver );
	return;
  }

  sprintf(s, "%d              ", mail_id);
  s[6] = '\0';
  fputs(s, fp);

  sprintf(ex, "%s                                  ", subject);
  ex[26] = '\0';
  fputs(ex, fp);

  sprintf(ex, "  %s                                        ", autor);
  ex[22] = '\0';
  fputs(ex, fp);


  strcpy(s, (UNSIGNED char *) mydate(1));
  strcpy(t, (UNSIGNED char *) mytime(1));
  sprintf(ex, "  %s  %s         ", s, t);
  ex[19] = '\0';
  fputs(ex, fp);
  sprintf(s, "%s\n", LE215_MSG);
  fputs(s, fp);

  fclose(fp);

  mbunlock(s);

  if(INTERACT == 0) printf("%s\n", arg);

  ff = fopen( XMDLOG, "a" );
  if(ff == NULL){
	printf("\nCan't append to %s\n", XMDLOG);
	massiv_unlock( receiver );
	return;
  }
  fprintf(ff, "%5.5s  %5.5s   %-29.29s   %-31.31s\n", 
	  (UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
	  (UNSIGNED char *) stripped(arg), subject);
  fclose(ff);

  if(receipt[0] != '\0'){
	i = 0; b = 0;
	while(receipt[i] != '\0'){
		if(receipt[i] == '!') b = i;
		if(receipt[i] == '@') b = i;
		i++;
	}
	if(b == 0) return;
 	i = b; a = 0;
	while((i > 0) && (a == 0)){
		if((receipt[i] == ' ') ||
		   (receipt[i] == '<') ||
		   (receipt[i] == '(')) a = i + 1;
		i--;
	}
  	i = b; b = 0;
 	while((receipt[i] != '\0') && (b == 0)){
		if((receipt[i] == ' ') ||
		   (receipt[i] == '>') ||
		   (receipt[i] == ')')) b = i -1;
		i++;
	}
	if(b == 0) b = i -1;
 	strcpy(receipt, (UNSIGNED char *) strcopy(receipt, a, b));

	sprintf(t, "%s/%d.REC", TMP, getpid());
	ff = fopen( t, "w" );	
	if(ff == NULL){
		log_it( "Can't write to:", t, "!" );
		printf("\nCan't write to %s\n", t);
  	}

	time(&timer);

	fprintf(ff, "From: XMD@%s\n", UUCPID2); 
	fprintf(ff, "Sender: postmaster@%s (Die Postmeisterei)\n", UUCPID2);
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	fprintf(ff, "To: %s\n", receipt);
	fprintf(ff, "Subject: Delivering Report\n");
	fprintf(ff, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
	fprintf(ff, "Message-Id: <%x.xmd@%s>\n", timer, UUCPID2);
	fputs("\n", ff);

	fprintf(ff, "%s, %s at %s\n\n", LOCATION, mydate( 1 ), mytime( 1 ));

	fprintf(ff, "Your mail \"%s\" ...\n", subject);
	if(arrived == 1){
		fprintf(ff, "... reached %s.\n\nBye for now!\n", (UNSIGNED char *) stripped(arg));
	}
	else{
		fprintf(ff, "... couldn't be delivered to %s.\n\n", (UNSIGNED char *) stripped(arg));
		fprintf(ff, "The local postmaster got a copy of your mail! Maybe he is able to forward it\nto the correct receipient!\n\n");
	}
	fclose(ff);

	sprintf(s, "/bin/sh %s/etc/rmail.sh %s %s", HOME, t, receipt);
	system(s);
	unlink( t );
  }

  if(KOPIE == 0){
	KOPIE++;
	sprintf(s, "%s/usr/%c/%d/.deputy", HOME, rec_char[0], receiver);
	fp = fopen( s, "r");
	if(fp != NULL){
		while(fgets(s, STRING, fp) != 0){
			/*
			i = 0;
			while(s[i] != '\0'){
				if(s[i] == ' ') s[i] = '.';
				i++;
			}
			sprintf(t, "/bin/sh %s/etc/rmail.sh %s %s", HOME, tmp, s);
			system(t);
			*/
			if(strlen( (UNSIGNED char *) stripped(s)) > 3) brief( stripped(s) );
		}
		fclose(fp);
	}
  }
  massiv_unlock( receiver );
}




/* #IS - Old gateway stuff. */

int is_external( s )
UNSIGNED char s[];
{
  int i = 0, j = 0, p = 0;

  if(strcomp("To: Empty Address", s) == 0) return (int) -1;

  while(s[i] != '\0'){
	if(s[i] == '%') j++;
	if((s[i] == '@') && (j > 0)) p = i;
	i++;
  }
  return (int) p;
}



/* #MI - Finding a BBS username in a UUCP address and calling "brief()"
   with this address. */

mailing()
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[LONGSTRING];
  UNSIGNED char t[STRING];
  int i, j;
  int toggle = 0;


  if(PIPE_RECEIVER[0] != '\0'){
	i = 0;
	while(PIPE_RECEIVER[i] != '\0'){
		if(PIPE_RECEIVER[i] == '.') PIPE_RECEIVER[i] = ' ';
		i++;
	}
	KOPIE = 0;
	brief(PIPE_RECEIVER);
	return; 	
  } 

  fp = fopen(tmp, "r");
  if (fp == NULL) {
	log_it( "Can't read:", tmp, "!" );
	printf("\nCan't read %s\n", tmp);
	exit(-1);
  }
  while (fgets(s, STRING, fp) != NULL) {
	if ((strcomp("X400-Recipients:", s) == 0) && (toggle == 0)){
		i = 16;
		j = 0;
		while(s[i] != '\0'){
			if(s[i] == '<') j = i+1;
			if(s[i] == '@'){
				strcpy(x400, (UNSIGNED char *) strcopy(s, j, (i-1)));
			}
			i++;
		}
	}
	if ((strcomp("To:", s) == 0) && (toggle == 0)){
		i = 1;
		toggle++;
		while(strcomp("EOL", alias[i][1]) != 0){	
			if(strcomp(alias[i][1], s) == 0) strcpy(s, alias[i][2]);
			i++;
		}

		i = 0;
		j = 0;
		while ((s[i] != '\0') && (s[i] != '@')) {
			if (s[i] == '!') j = i;
			if (s[i] == '.') s[i] = ' ';
			i++;
		}
		i--;
		if (j == 0) {
			strcpy(t, (UNSIGNED char *) strcopy(s, 4, i));
		} else {
			strcpy(t, (UNSIGNED char *) strcopy(s, (j + 1), strlen(s)));
		}

		if(t[0] == '"'){
			j = 1;
			while((t[j] != '\0') && (t[j] != '"')){
				j++;
			}
			j--;
			strcpy(t, (UNSIGNED char *) strcopy(t, 1, j));
		}

		if(is_external(s) == 0){
			KOPIE = 0;
			brief(t);
		}
		else{	
			if(strcomp("Empty Address", t) == 0){
				strcpy(t, (UNSIGNED char *) x400);
			}
			sprintf(s, "rmail -v -d -i %s %s@amnet.UUCP", tmp, t);
			if(INTERACT == 0) printf("%s\n", t);
			system( s );
			ff = fopen( XMDLOG, "a" );
			if(ff == NULL){
				printf("\nCan't open %s\n", XMDLOG);
				return;
			}
			fprintf(ff, "%5.5s  %5.5s > %-29.29s   [Gateway]\n", 
				(UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
			        (UNSIGNED char *) t);
			fclose(ff);
		}
	}
  }

  fclose(fp);
}


/* #ML - Do a HARD (!) locking on all XMDs actions. */

massiv_lock(id)
int id;
{
  UNSIGNED char s[STRING];

  FILE *fp;

  int tries = 0;
  int pid = getpid();

  long tn, ts;
  

  time(&ts);

  srand( pid );
  sleep( rand() % 20 );	

  do{
  	sprintf(s, "%s/xmd.%d.LCK", TMP, id);
	fp = fopen( s, "r" );
	if(fp == NULL){
		fp = fopen(s, "w" );
		fprintf(fp, "%d\n", pid);
		fclose(fp);
		tries = -1;
	}else{
		fgets(s, 80, fp);
		fclose(fp);
		if(atoi(s) == pid) 
			tries = -1;
		else
			sleep( rand() % 20 );	
	}
	time(&tn);
	if((tn-ts) > 1800){
		log_it( "Locking failed. Stalled lock", "brocken!", "" );
		sprintf(s, "%s/xmd.%d.LCK", TMP, id);
		unlink(s);
	}
  }while(tries >= 0);
}


/* #MU - Unlock XMD */ 

massiv_unlock(id)
int id;
{
  UNSIGNED char s[STRING];

  sprintf(s, "%s/xmd.%d.LCK", TMP, id);
  unlink(s);
}




/* #MA - XMD main function. 

   This is able to forward mails to addresses such as "Real.Name@UUCPID". 

   It also understands "Real.Name -" command lines. This is used by smail
   in the "aliases" file. The mailing text has to come from stdin than. */

main(argc, argv)
int argc;
UNSIGNED char *argv[];
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[LONGSTRING];
  UNSIGNED char t[LONGSTRING];
  UNSIGNED char dump[STRING];
  UNSIGNED char maildrop[STRING];
  int toggle = 0;
  int l;
  int c;
  int p;
  int i;
  int j;


  setuid(0);
  setgid(0);
  umask(0000);

  chdir(HOME);


  PIPE_RECEIVER[0] = '\0';


  strcpy(ORGANIZATION, _ORGANIZATION);
  strcpy(SYSTEM,       _SYSTEM);
  strcpy(UUCPSITE,     _UUCPSITE);
  strcpy(UUCPID2,      _UUCPID2);
  strcpy(UUCPID1,      _UUCPID1);
  strcpy(NAT_DOMAIN1,  _NAT_DOMAIN1);
  strcpy(NAT_DOMAIN2,  _NAT_DOMAIN2);
  strcpy(NAT_DOMAIN3,  _NAT_DOMAIN3);
  strcpy(UUCPBANG,     _UUCPBANG);
  strcpy(PHONE,        _PHONE);
  strcpy(LOCATION,     _LOCATION);
  strcpy(SMARTHOST,    _SMARTHOST);
  strcpy(NEWS_MINIMUM, _NEWS_MINIMUM);
  strcpy(PMS_TTY,      _PMS_TTY);
  strcpy(GREP,         _GREP);
  strcpy(UUX,          _UUX); 
  strcpy(TAR,          _TAR);
  strcpy(SORTEDCUT,    _SORTEDCUT);
  strcpy(SECONDCUT,    _SECONDCUT);
  strcpy(THIRDCUT,     _THIRDCUT);
  TARIF = (int) _TARIF;
  NZNT  = (int) _NZNT;
  NZBT  = (int) _NZBT;
  RZNT  = (int) _RZNT;
  RZBT  = (int) _RZBT;
  WZNT  = (int) _WZNT;
  WZBT  = (int) _WZBT;
  strcpy(REFLECT_NG,   _REFLECT_NG);

  if(get_cfg() == -1)
	write_cfg();




  if(argc < 2){
	maybe_locked(ERRMBOX, "r"); mblock(ERRMBOX);
	fp = fopen(ERRMBOX, "r");
	INTERACT = 0;
  }
  else{
	if(argv[2][0] == '-'){
		strcpy(PIPE_RECEIVER, (UNSIGNED char *) argv[1]);
		sprintf(maildrop, "%s/%dPIP", TMP, getpid());
		fp = fopen(maildrop, "w");
		if(fp == NULL){
			log_it( "Can't write to:", maildrop, "!" );
			log_it( "Mail LOST! No SETUID for XMD!!!", "CHMOD ug+s xmd", "IMMEDIATLY!!!" );
			printf("\nCan't write to %s\n", maildrop);
			return;
		}
		c = 0;
		do{
			c = fgetc(stdin);
			if((c != EOF) && (c != 4)){
				fputc(c, fp);
			}
		}while((c != EOF) && (c != 4));
		fclose(fp);
		fp = fopen(maildrop, "r");
		INTERACT = 1;	
	}
	else{
		maybe_locked(maildrop, "r"); mblock(maildrop);
		sprintf(maildrop, "%s/%s", MAILDROP, argv[1]);
		fp = fopen(maildrop, "r");
		INTERACT = 1;
	}
  }
  if(INTERACT == 0) printf("\n");

  if (fp == NULL) {
	if(INTERACT == 0) printf("\nNo mail.\n");
	return;
  }

  l = 1; 
  ff = fopen( XMD_ALIAS, "r" );
  if(ff != 0){
	while(fgets(s, STRING, ff) != 0){
		if((s[0] > 64) && (l < MAX_XMD_ALIAS)){
			strcpy(alias[l][1], (UNSIGNED char *) stripped(s));
			fgets(s, STRING, ff);
			strcpy(alias[l][2], (UNSIGNED char *) stripped(s));
			l++;
		}
	}
	fclose(ff);
  }
  strcpy(alias[l][1], "EOL");

  sprintf(dump, "%s/%d.DUMP", TMP, getpid());
  ff = fopen(dump, "w");
  if(ff == NULL){
	log_it( "Can't write to:", dump, "!" );
	printf("\nCan't write to %s\n", dump);
	return;
  }

  toggle = 0;

  while (fgets(s, STRING, fp) != NULL) {
	l = 2;
	if (s[0] == '>') {
		if(PIPE_RECEIVER[0] == '\0'){
			if(s[1] != ' ') l = 1;
			strcpy(t, (UNSIGNED char *) strcopy(s, l, strlen(s)));
			strcpy(s, t);
		}
		if (strcomp("OOPS", s) != 0) {
			fputs(s, ff);
		}
	}
	else{
		if(strcomp("From ", s) == 0){
			fprintf(ff, "*%s", s);
			if(strcomp(RETURNED_MAIL, s) == 0){
				while(strcomp("> ", s) != 0){
					fgets(s, STRING, fp);
				}
			}
		}
		else{
			fputs(s, ff);
		}
	}

  }
  fclose(ff);
  fclose(fp);

  fp = fopen(dump, "r");
  if(fp == NULL){
	log_it( "Can't read:", dump, "!" );
	printf("\nCan't read %s\n", dump);
	return;
  }

  sprintf(tmp, "%s/%d.XMD", TMP, getpid());

  ff = fopen(tmp, "w");
  if(ff == NULL){
	log_it( "Can't write to:", tmp, "!" );
	printf("\nCan't write to %s\n", tmp);
	return;
  }

  toggle = 0;

  while (fgets(s, STRING, fp) != NULL) {
	if (strcomp("*From ", s) == 0){
		if (toggle == 1) {
			if (ff != 0) fclose(ff);
			mailing();
			ff = fopen(tmp, "w");
			if(ff == NULL){
				log_it( "Can't write to:", tmp, "!" );
				printf("\nCan't write to %s\n", tmp);
				return;
			}
		}
		toggle = 1;
		fputs(s, ff);
	}
	if ((toggle == 1) && (strcomp("*From ", s) != 0)){

		if (strcomp("X400-Recipients:", s) == 0){
			i = 16;
			j = 0;
			while(s[i] != '\0'){
				if(s[i] == '<') j = i+1;
				if(s[i] == '@'){
					strcpy(x400, (UNSIGNED char *) strcopy(s, j, (i-1)));
				}
				i++;
			}
		}		
		
		if(strcomp("To: ", s) == 0){
			p = is_external(s);

			if(p > 0){
				s[p] = '\0';
				strcat(s, (UNSIGNED char *) "@amnet.UUCP\n");
			}
			if(p == -1){
				sprintf(s, "To: %s@amnet.UUCP\n", x400);
			}
		}
		fputs(s, ff);
	}
  }
  if (ff != 0) fclose(ff);
  if (toggle == 1) mailing();
  fclose(fp);

  unlink(tmp);
  unlink(dump);

  if(INTERACT == 0){
 	sprintf(s, "> %s", ERRMBOX);
	mbunlock(ERRMBOX);
  }
  else{
	if(getgid() == GUEST_GID){
	 	sprintf(s, "> %s", maildrop);
		mbunlock(maildrop);
	}
  }
  system(s);

  sprintf(maildrop, "%s/%dPIP", TMP, getpid()); /* 9.4.94 - Bugfree ??? */
  unlink(maildrop);
}
