/* ix/MBox (show.c) by Volker Schuermann, 11.06.1994

   This C source code contains the following functions:

   #SW show()                display a file 
   #MR more()                display further, repeat, ... request
   #RT richtext()            convert RTF (MIME)
   #QP quoted_printable()    convert quoted printable (MIME)
   #IC iso_convert()         convert ISO 8859-1
   #IL iso_line()            convert ISO 8859-1, linewise
   #RO rot13()               encrypt a file using rot13         
   #UR unrot13()             decrypt a file using rot13
   #SR show_raw()	     display an (ANSI) file w/o converting
   #HT handle_html()	     take care of the WWW/html format

   Contact <volkers@unnet.wupper.de> for help! */







#include <stdio.h>
#include <string.h>

#include "mbox.h"


static int show_more;
static FILE *page;
static UNSIGNED char show_tmp[STRING];
static int seite;
extern UNSIGNED char headinfo[STRING];

static int morechen;


/* Globals for RTF (Richtext Format): */

static int RTFcomment; 
static int RTFcenter;
static int RTFrightflush;
static int RTFheading;

static UNSIGNED char ENCODING[STRING];

static int QPkeys;

UNSIGNED char *richtext();
UNSIGNED char *quoted_printable();
unsigned char *iso_convert();
unsigned char *iso_line();
UNSIGNED char *rot13();
UNSIGNED char *unrot13();

static int tog;

void show_toggle();

static int posit;

static int html;
static int html_ref;

UNSIGNED char *handle_html();


/* #SW - Display a file [fname].

   It's not allowed to show more than [maxlines].

   [mode]   ->  > 999  =  room for a headline 
		 > 99  =  ANSI graphics as first headline
                   99  =  reset global variables (of "show()")
                    0  =  don't stop, don't use "more()"

   This functions returns -1 if the file doesn't exist or can't be
   read and -9 if "show()" is ordered to skip the file. */

#define LLL 80

int show(fname, maxlines, mode)
UNSIGNED char fname[];
int maxlines;
int mode;
{
  FILE *fp;

  UNSIGNED char s[LONGSTRING];
  UNSIGNED char o[LONGSTRING];
  UNSIGNED char t[STRING];
  UNSIGNED char CONTENT[STRING];
  int ml;
  int ret_status = 0;
  int maxi = MAX_SCR_LINES;
  int swing = 0;
  int sl, ok;
  int i;
 
  int HEADER_done = 0;
  int HEADER_path = 0;
  int HEADER_double = 0;

  int FACE = 0;
  int tog_mode = 0;

  html = 0;
  html_ref = 1;

  posit = 0; 


  if (mode > 9999) {
	mode -= 10000;
	tog_mode++;
	tog = 1;
  }
  if (mode > 999) {		/* ANSI Headline */
	mode -= 1000;
	maxi -= 8;
	swing = 2;
	morechen = 1;
	seite = 1;
  }  
  if (mode > 99) {		/* HEADLINE */
	mode -= 100;
	maxi -= 2;
	swing = 2;
	morechen = 1;
	seite = 1;

	if(USER.terminal == ISO6429) maxi++;
  }
  if (mode == 99) {		/* RESET */
	show_more = 0;
	seite = 1;
	return 0;
  }

  fp = fopen(fname, "r");
  if (fp == NULL) {
	return -1;
  }
  ml = 0;
  morechen = 0;

  CONTENT[0]  = '\0';
  ENCODING[0] = '\0';
 
  RTFcomment    = 0;
  RTFcenter     = 0;
  RTFrightflush = 0; 
  RTFheading    = 0;

  QPkeys 	= 0;



  strcpy(VAR_NAME, (UNSIGNED char *) fetch_reciepy( fname ));

  /* Temporary checking Usage */

#ifdef _UNNET
  if((strcomp("PM", BRETT) != 0) && (USER.level < 10)){
	page = fopen( "/local/mbox/etc/usage", "a" );
	if(strcomp("CDROM", NG) != 0) 
		fprintf(page, "%s\n", NG); 
	else
		fprintf(page, "cdrom\n");
	fclose(page);
  }
#endif

  sprintf(show_tmp, "%s/show%d", TMP, getpid());
  page = fopen(show_tmp, "w");

  if (mode != 2)
	show_more = 0;
  else
	morechen = show_more;

  if (show_more > maxi) show_more = 0;


  if(DISKUSSION){
	while((fgets(t, STRING, fp) != NULL) && (strcomp("Subject: ", t) != 0));

	if(strcomp("Subject: ", t) != 0) return -9;

	if(sgrep( t, DIS_subject ) != 0){

		sprintf(t, " %s: %s ", SHO01_MSG, (UNSIGNED char *) stripped(DIS_subject) );
		headline( t );
		rewind(fp);
	}		
	else{
		fclose(fp);
		fclose(page);
		return -9;
	}
  }


  while ((ml < maxlines) && (fgets(s, LONGSTRING, fp) != NULL)) {

	posit++;

	if(SHORT_HEADER){

		if(strcomp("Content-Type:", s) == 0){
			strcpy(CONTENT, (UNSIGNED char *) strcopy(s, 14, 80));
			if(strcomp("text/richtext", CONTENT) != 0) /* RTF etc. */
				 CONTENT[0] = '\0';
		}
		if(strcomp("Content-Transfer-Encoding:", s) == 0){
			strcpy(ENCODING, (UNSIGNED char *) strcopy(s, 27, 80));
		}

		if((strcomp("Path: ", s) == 0) || (strcomp("Newsgroups: ", s) == 0)){
			HEADER_path++;
			continue;
		}

		if((HEADER_path != 0) && (HEADER_done == 0)){

			if(strcomp("From: ", s) == 0){
				printf("%s %s", GBL01_MSG, strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s", GBL01_MSG, strcopy(s, 6, strlen(s)));
				morechen++;
			}
			if(strcomp("Subject: ", s) == 0){
				printf("%s %s", GBL03_MSG, strcopy(s, 9, strlen(s)));
				fprintf(fp, "%s %s", GBL03_MSG, strcopy(s, 9, strlen(s)));
				morechen++;
			}		
			if(strcomp("Date: ", s) == 0){
				printf("%s %s\n", GBL02_MSG, strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s\n", GBL02_MSG, strcopy(s, 6, strlen(s)));
				morechen++;
			}
			if(strlen(s) < 3){
				HEADER_done++;
				morechen++;
			}
			continue;
 		}	
	}
	else{
		if(HEADER_done == 0){
			sprintf(t, "%s %s", GBL01_MSG, X_MAIL_DEMON);
			if(strcomp(t, s) == 0){
				do{
					fgets(s, LONGSTRING, fp);
				}while(strcomp("From", s) != 0);
				HEADER_double++;
				ansi2("md", 0, 0);
			}
			if((strcomp("Path:", s)        == 0) || 
			   (strcomp("From", s)	       == 0) ||
			   (strcomp("Newsgroups:", s)  == 0) || 
                           (strcomp(GBL01_MSG, s)      == 0) ||
			   (strcomp("Date:", s)        == 0) ||
			   (strcomp("Return-Path:", s) == 0)){
				ansi2("md", 0, 0);
				HEADER_double++;
			}	
			if(strlen(s) < 3){
				HEADER_done++;
				HEADER_double = 0;
				ansi2("me", 0, 0);
			}			
		}
	}

	if(strcomp("Content-Type:", s) == 0){
		strcpy(CONTENT, (UNSIGNED char *) strcopy(s, 14, 80));
		if(strcomp("text/richtext", CONTENT) != 0) /* RTF etc. */
			 CONTENT[0] = '\0';
	}
	if(strcomp("Content-Transfer-Encoding:", s) == 0){
		strcpy(ENCODING, (UNSIGNED char *) strcopy(s, 27, 80));
				
	}
	if(strcomp("Content-", s) == 0){
		if((HEADER_done != 0) || (ml < 2)){
			HEADER_done++;
			continue; 
		}
	}
	if(strcomp("Xref:", s) == 0){
		continue;
	}
        if(strcomp("X-Face:", s) == 0){
		if(FACE == 0){
			FACE++;
		}
	}
	if((strcomp("<html>", s) == 0) || (strcomp("<!doctype", s) == 0) ||
	   (strcomp("<Head>", s) == 0) || (strcomp("<Title>", s) == 0)){
		html = 1;
		morechen = 0;
		ansi2( "cl", 0, 0 );
	}

	if(html != 0){
		if(strcomp("-------------------------------------------------------------", s) == 0) return 0;
		strcpy(s, (UNSIGNED char *) handle_html(s));
	}	

#ifdef _MULTIMEDIA
	if(strcomp("Quoted-Printable", ENCODING) == 0){
		strcpy(s, (UNSIGNED char *) quoted_printable(s));
	}
	if(CONTENT[0] != '\0'){
		strcpy(s, (UNSIGNED char *) richtext(s));
	}
#endif	

	if(UMLAUT_MODUS != 4) 
		strcpy(s, (UNSIGNED char *) iso_line(s));

	if(ROT13_MODUS && HEADER_done) 
		strcpy(s, (UNSIGNED char *) unrot13( s ));


	sl = strlen(s);
	while(sl > LLL){
		strcpy(o, (UNSIGNED char *) s);
		sl = LLL; ok = 0;
		i = 0;
		while((s[i] != '\0') && (i <= sl)){
			if(s[i] == ESC){
				i++;
				while((s[i] < 65) || (s[i] == '[')){
					i++;
					sl++;
				}
				sl += 2;
			}			
			i++;
		}

		while((sl > 0) && (ok == 0)){
			if(s[sl] < 48){
				ok = sl;
			}
			sl--;
		}
		s[ok] = '\0';

		if(sl < (strlen(o)-1)){
			morechen++;	
		
			if(tog_mode) show_toggle();
			printf("%s", s);
			if(tog_mode) ansi2( "me", 0, 0 );
			printf("\n");
			fprintf(page, "%s\n", s);
		
			strcpy(s, (UNSIGNED char *)bigcopy(o, ok, strlen(o)));
			sl = strlen(s);
		}
		else{
			sl = 0;
		}	

		if(ok == 0){
			sl = LLL;
		}
		if(s[0] == '\n') s[0] = '\0';
	}
	i = strlen(s) -1;
	if(s[i] == '\n') s[i] = '\0'; 
	
	if(tog_mode) show_toggle();
	printf("%s", s);
	if(tog_mode) ansi2( "me", 0, 0 );
	printf("\n");
	fprintf(page, "%s\n", s);

	ml++;
	morechen++;
	if ((morechen >= maxi) && (mode > 0)) {
		morechen = 0;
		maxi += swing;
		swing = 0;
		fclose(page);
		if(html == 0)
			ret_status = more();
		else
			(void) getint();

		maxi = MAX_SCR_LINES;	
		if ((ret_status != 0) && (ret_status != 2)) {
			ml = maxlines + 9999;
		}
		else {
			if(ret_status == 2){
				rewind(fp);
				posit -= (maxi * 2);
				if(posit < 0) posit = 0;
				for(i = 0; i < posit; i++)
  					fgets(s, LONGSTRING, fp); 
			}
			else{
				page = fopen(show_tmp, "w");
				if(HEADER_double != 0){
					ansi2( "md", 0, 0 );
				}
			}
		}
		if((USER.terminal == ISO6429) && (seite == 2)) maxi--;
	}
  }
  fclose(fp);

  show_more = morechen;

  if (page != NULL) fclose(page);
  unlink(show_tmp);

  /* Experimental use only ! */

  if(FACE != 0){
	faces( fname );
  }


  return (int) ret_status;
}




/* #MR - Ask user whether he/she likes to see more.

   This functions returns 0 for continue and -1 for stop. 
   And 1 to completly break the action or 2, to go to a
   previous page */

int more()
{
  UNSIGNED char s[LONGSTRING];
  UNSIGNED char c;
  int ok = 0;

FIRST_TRY:

  ansi2("mr", 0, 0);
  printf("                                                                               ");
  if (ROT13_MODUS)
	printf("%c[ROT13!] [%s] (?) > ", CR, SHO04_MSG);
  else
	printf("%c[%s] (?) > ", CR, SHO04_MSG);
  ansi2("me", 0, 0);

SECOND_TRY:

  c = getint();

  if (c == '?') {
	ansi2("mr", 0, 0);
	clearline();
	printf("%c%s > ", CR, SHO05_MSG);
	ansi2("me", 0, 0);
	goto SECOND_TRY;
  }
  if (c > 96) c -= 32;

  if ((c == DEL) ||
      (c == CTRL_D) ||
      (c == CTRL_X) ||
      (c == SHO06_MSG) ||
      (c == SHO07_MSG))
	ok = -1;

  if ((c == SHO08_MSG) || (c == SHO09_MSG)) ok = 1;

  if ((c == SHO10aMSG) || (c == SHO10bMSG)) ok = 2;

  if (c == SHO10_MSG) {
	ansi2("cl", 0, 0);
	ansi2("mr", 0, 0);
	printf("                                                                               ");
	printf("%c%s\n", CR, SHO11_MSG);
	ansi2("me", 0, 0);	
	page = fopen(show_tmp, "r");
	if (page != NULL) {
		while (fgets(s, LONGSTRING, page) != NULL) {
			printf("%s", s);
		}
		fclose(page);
	}
	goto FIRST_TRY;
  }
 
  if(ok != 1){	
  	  if(ok == 2){
		ansi2("cl", 0, 0);
		seite--;
		if(seite < 1) seite = 1;
		sprintf(s, "%s^-  [%s %d]", headinfo, SHO12_MSG, seite);
		headline(s);
	  }
          else{
	  	seite++;
	  }
	
	  if (USER.more == 3) {
		clearline();
	  }
	  else {
		if(USER.more != 0){
			ansi2("cl", 0, 0);
			sprintf(s, "%s^-  [%s %d]", headinfo, SHO12_MSG, seite);
			headline(s);
		}
		else printf("\n\n");
	  }
  }
  else{	
	clearline();
  }

  return (int) ok;
}



/* #RT - Converting a RTF (MIME Richtext) line [s] to a line containing
   ANSI (or any other terminal) codes.

   This function returns the converted line. */

UNSIGNED char *richtext( s )
UNSIGNED char s[];
{
  UNSIGNED char rt[LONGSTRING];
  UNSIGNED char line[LONGSTRING];
  UNSIGNED char space[LONGSTRING];
  int i = 0, j;
  int l = 0;
  int not;
  int keys = 0;

  while(s[i] != '\0'){
	if(s[i] != '<'){
		if(RTFcomment == 0){
			/* RTF-Konform:
			if(s[i] == '\n')
				line[l] = ' ';
			else
				line[l] = s[i];
			NICHT RTF-Konform: */

			line[l] = s[i];
			l++;
			keys++;
		}
	}
	else{
		line[l] = '\0';
		not = 0;
		i++;
		j = i;
		while((s[j] != '>') && (s[j] != '\0')){
			if(s[j] == '/'){
				i++;
				not++;
			}
			j++;
		}
		strcpy(rt, (UNSIGNED char *) bigcopy(s, i, (j-1)));

		if(not == 0){
			if(strcomp("Bold",       rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "md" ));
			if(strcomp("Italic",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "mr" ));
			if(strcomp("Bigger",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "mb" ));
			if(strcomp("Flash",      rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "mb" ));
			if(strcomp("Underline",  rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "us" ));
			if(strcomp("Paragraph",  rt) == 0){
				strcat( line, "\n\n");
				morechen += 2;
			}
			if(strcomp("Comment",    rt) == 0)
				RTFcomment++;
			if(strcomp("Center",     rt) == 0)
				RTFcenter++;
			if(strcomp("FlushRight", rt) == 0)
				RTFrightflush++;
			if(strcomp("Heading",   rt) == 0){
				RTFheading++;
				strcat( line, (UNSIGNED char *) termansi( "md" ));
			}
		}
		else{
			if(strcomp("Bold",       rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Italic",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Bigger",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Flash",      rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Underline",  rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Paragraph",  rt) == 0){
				strcat( line, "\n\n");
				morechen += 2;
			}
			if(strcomp("Comment",    rt) == 0)
				RTFcomment = 0;
			if(strcomp("Center",     rt) == 0)
				RTFcenter = 9999;
			if(strcomp("FlushRight", rt) == 0)
				RTFrightflush = 9999;
			if(strcomp("Heading",   rt) == 0){
				RTFheading = 9999;
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			}
		}

		if(strcomp("LT", rt) == 0) 
			strcat( line, (UNSIGNED char *) "<" );

		/* NICHT RTF-Konform:
		if(strcomp("NL", rt) == 0){ 
			strcat( line, (UNSIGNED char *)  "\n" );
			morechen++;
		}
		*/

		if(strcomp("NP", rt) == 0) 
			strcat( line, (UNSIGNED char *) "\f" );
		if(RTFcomment == 0){
			l = strlen(line);
		}
		i = j;
	}
	i++;
  }
  line[l] = '\0';
  strcpy(space, (UNSIGNED char *) "                                                                              ");	

  if((RTFcenter != 0) || (RTFheading != 0)){
	i = (79 - keys) / 2; 
	if(i <  0) i = 0;
	if(i > 79) i = 0;
	space[i] = '\0';
	strcat(space, (UNSIGNED char *) line);
	strcpy(line, (UNSIGNED char *) space);
  }
  if(RTFrightflush != 0){
	i = 79 - keys;
	space[i] = '\0';
	strcat(space, (UNSIGNED char *) line);
	strcpy(line, (UNSIGNED char *) space);
  }

  if(RTFcenter     == 9999) RTFcenter = 0;
  if(RTFrightflush == 9999) RTFrightflush = 0;
  if(RTFheading    == 9999) RTFheading = 0;

  return (UNSIGNED char *) line;
}





/* #QP - Converting a line [s] regarding QP rules #1 to #5.

   This function returns the converted line. */

UNSIGNED char *quoted_printable( s )
UNSIGNED char s[];
{
  UNSIGNED char line[LONGSTRING];
  int i = 0, l = 0, p = 0;

  while(s[i] != '\0'){
	if(s[i] == '='){
		if(s[(i+1)] == '\n'){
			i++;
		}
		else{
			if(s[(i+1)] < 65)
				p = 16 * (s[(i+1)] - 48);
			else
				p = 16 * (s[(i+1)] - 55);
			if(s[(i+2)] < 65)
				p = p  + (s[(i+2)] - 48); 
			else
				p = p  + (s[(i+2)] - 55); 
			line[l] = p;
			l++;
			i += 2;
		}
	}
	else{
		line[l] = s[i];
		l++;
		QPkeys++;
		if(s[i] == '\n') QPkeys = 0;
	}

	if(QPkeys >= 75){
		p = l;
		while((line[p] != ' ') && (p > 0)){
			p--;
		}
		line[p] = '\n';
		QPkeys = 0;
	}
	i++;
  }
  line[l] = '\0';

  return (UNSIGNED char *) line;
}




/* #IC - Converting a character [c] from ISO 8859-1 to another standard.

   This function returns the converted (group of) char(s). */

 
unsigned char *iso_convert( c )		/* !!! unsigned, NOT UNSIGNED !!! */
int c;
{
  int ok = 0;

  unsigned char t[STRING];

  t[0] = '\0'; 
  t[1] = '\0';

  if(c > 127){

	if(UMLAUT_MODUS == 1){
		switch(c){
			case 142 :
			case 196 : t[0] = 196; 
				   break;
			case 153 :
			case 214 : t[0] = 214; 
				   break;
			case 154 :
			case 220 : t[0] = 220; 
				   break;
			case 225 : 
			case 223 : t[0] = 223; 
				   break;
			case 132 :
			case 228 : t[0] = 228; 
				   break;
			case 148 :
			case 246 : t[0] = 246;
				   break;
			case 129 :
			case 252 : t[0] = 252; 
				   break;
		}
	}
	if(UMLAUT_MODUS == INTEL_INSIDE){
		switch(c){
			case 142 :
			case 196 : t[0] = 142; 
				   break;
			case 153 :
			case 214 : t[0] = 153; 
				   break;
			case 154 :
			case 220 : t[0] = 154; 
				   break;
			case 225 : 
			case 223 : t[0] = 225; 
				   break;
			case 132 :
			case 228 : t[0] = 132; 
				   break;
			case 148 :
			case 246 : t[0] = 148;
				   break;
			case 129 :
			case 252 : t[0] = 129; 
				   break;
		}
	}
	if(UMLAUT_MODUS == 3){
		switch(c){
			case 142 :
			case 196 : t[0] = 'A'; ok++;
				   break;
			case 153 :
			case 214 : t[0] = 'O'; ok++;
				   break;
			case 154 :
			case 220 : t[0] = 'U'; ok++;
				   break;
			case 225 : 
			case 223 : t[0] = 's'; 
				   t[1] = 's';
				   break;
			case 132 :
			case 228 : t[0] = 'a'; ok++;
				   break;
			case 148 :
			case 246 : t[0] = 'o'; ok++;
				   break;
			case 129 :
			case 252 : t[0] = 'u'; ok++;
				   break;
		}
		if(ok != 0){
			t[1] = 'e';
		}
		t[2] = '\0';
	}
	if(t[0] == '\0') t[0] = c;
  }
  else{
	t[0] = c;
  }

  return (UNSIGNED char *) t;
}



/* #IL - Converting a line [s] from ISO 8859-1 to another standard.

   This function returns the converted line. */

unsigned char *iso_line( s )
unsigned char s[];		/* !!! unsigned, NOT UNSIGNED !!! */
{
  unsigned char t[LONGSTRING];
  unsigned char z[LONGSTRING];

  int i = 0;

  t[0] = '\0';

  while(s[i] != '\0'){
	strcat(t, (unsigned char *) iso_convert( s[i] ));
	i++;
  }

  strcpy(z, (UNSIGNED char *) t);
 
  return (unsigned char *) z;
}



/* THANX (!) to Iain Lea (TIN) for the following ... */


/* #RO - Encrypting a line [s] using ROT13 algorythm.

   This function returns the converted line. */

UNSIGNED char *rot13( s )
UNSIGNED char s[];
{
  UNSIGNED char t[LONGSTRING];

  int i = 0;

  t[0] = '\0';

  while(s[i] != '\0'){
	if((s[i] >= 'A') && (s[i] <= 'Z')){
		t[i] = 'A' + (s[i] + 'A' + 13) % 26;
	}
	else{
		if((s[i] >= 'a') && (s[i] <= 'z')){
		s[i] -= 32;
		t[i] = 'A' + (s[i] + 'A' + 13) % 26;
		t[i] += 32;
	}
		else{
			t[i] = s[i];
		}
	}
	i++;
  }

  t[i] = '\0';

  return (UNSIGNED char *) t;
}



/* THANX (!) to Iain Lea (TIN) for the following ... */


/* #UR - Decrypting a line [s] using ROT13 algorythm.

   This function returns the converted line. */

UNSIGNED char *unrot13( s )
UNSIGNED char s[];
{
  UNSIGNED char t[LONGSTRING];
  int i = 0;

  t[0] = '\0';

 
  while(s[i] != '\0'){
	if((s[i] >= 'A') && (s[i] <= 'Z')){
		t[i] = 'A' + (s[i] - 'A' + 13) % 26;
	}
	else{
		if((s[i] >= 'a') && (s[i] <= 'z')){
		t[i] = 'a' + (s[i] - 'a' + 13) % 26;
	}
		else{
			t[i] = s[i];
		}
	}
	i++;
  }

  t[i] = '\0';

  return (UNSIGNED char *) t;
}



/* #SR - Display a file without converting (esp. for ANSI files) */

void show_raw( path, ypos )
UNSIGNED char path[];
int ypos;
{
  UNSIGNED char s[LONGSTRING];

  FILE *fp;

  if(ypos != 0) ansi2( "cl", 0, 0 );

  fp = fopen( path, "r" );
  if(fp == NULL){
	/*
	nerror( "show.c", 873, "show_raw()", "Can't open", path );	
	*/
	return;
  }
  while(fgets(s, LONGSTRING, fp) != 0){
	printf("%s", s);
  }
  fclose(fp);

  if(ypos != 0) ansi2( "cm", 1, ypos );
}


void show_toggle()
{
  if(tog == 1){
	tog = 0;
 	
	if(USER.terminal != ISO6429)
		ansi2( "md", 0, 0 );
	else
		ansi2( "X7", 0, 0 );
  }
  else{
	tog = 1;
	
	if(USER.terminal != ISO6429)
		ansi2( "me", 0, 0 );
	else
		ansi2( "X8", 0, 0 );
  }
}



/* #HT - WWW/html format handler ... don't expect too much ;-) */

UNSIGNED char *handle_html( s )
UNSIGNED char s[];
{
  UNSIGNED char line[LONGSTRING];
  UNSIGNED char t[STRING];
  UNSIGNED char u[STRING];

  int i = 0, a = -1, b = -1, l = 0;
  int not = 0;

  int headline = 0;

  FILE *fp;
 
  /*
  fp = fopen( "log", "a" );
  fprintf(fp, "1 %s", s);
  */

  line[0] = '\0';
  
  while(s[i] != '\0'){
	if(s[i] == '<'){
		a = i + 1;
		while((s[i] != '\0') && (s[i] != '>')) i++;
		b = i -1;
		not = 0;
		if(s[a] == '/'){
			not++;
			a++;
		}
		strcpy(t, (UNSIGNED char *) strcopy(s, a, b));	

		if(not == 0){
			if(strcomp("!DOC",      t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X2" ));
			if(strcomp("Body",      t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X2" ));
			if(strcomp("Head",      t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X2" ));
			if(strcomp("Title",     t) == 0){
				strcat( line, (UNSIGNED char *) termansi( "X4" ));
				headline = 1;
			}
			if(strcomp("Address",   t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X6" ));
			if(strcomp("Pre",       t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X0" ));
			if(strcomp("I",         t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X1" ));
			/*
			if(strcomp("P",         t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "md" ));
			*/
			if(strcomp("Tt",        t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "us" ));
			if(strcomp("H1",        t) == 0){
				strcat( line, (UNSIGNED char *) termansi( "X9" ));
				headline = 2;
			}
		}
		else{
			/*
			if(strcomp("A",         t) == 0){
				sprintf(u, "[%d] ", html_ref); html_ref++;
				strcat(line, (UNSIGNED char *) u);				
			}
			else{
				strcat(line, (UNSIGNED char *) termansi( "me" ));
				strcat(line, (UNSIGNED char *) termansi( "X2" ));
			}	
			*/
			strcat(line, (UNSIGNED char *) termansi( "me" ));
			strcat(line, (UNSIGNED char *) termansi( "X2" ));
		}
		l = strlen( line );
	}
	else{
		line[l] = s[i];
		l++; line[l] = '\0';
	}
	i++;
  }

  if(headline != 0){
	strcpy(t, (UNSIGNED char *) line );
	strcpy(line, (UNSIGNED char *) "                                                                            ");
	a = 0; i = 0;
	while(t[i] != '\0'){
		if((t[i] > 64) && (t[i] != '[') && (t[i] != ';')) a++;
		i++;
	}
	a = 40 - (a/2);
	line[a] = '\0';
	strcat(line, (UNSIGNED char *) t ); 

	if(headline == 1){
		ansi2( "X4", 0, 0 );
		clearline(); 
	}
  }

  /*
  fprintf(fp, "2 %s", line);
  fclose(fp);
  */ 
  
  return (UNSIGNED char *) line; 
}
