/* ix/MBox (nerror.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #NE nerror()           catching bugs

   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>
#include <setjmp.h>

#include "mbox.h"


extern jmp_buf jmpenv;



/* #NR - Catching bugs and doing the reporting.

   [file] tells in which file the error occured,
   [line] specifies the code line,
   [function] names the C function,
   [descr] contains a description and
   [er] gives further information. */


void nerror(file, line, function, descr, er)
UNSIGNED char file[];
int line;
UNSIGNED char function[], descr[], er[];
{
  UNSIGNED char s[STRING];

  chdir( HOME );

  ansi2("md", 0, 0);
  printf("%c%s ", CR, NER01_MSG);
  ansi2("me", 0, 0);

  printf("%s (%s) - %s \"%s\"\n", function, file, descr, er);

  sprintf(s, "[%s] %s, %d\n***** %s, %s, %s ... %s !!!",
	NER02_MSG, file, line, function, descr, er, NER03_MSG);

  control(s, 99);
  control(s, 3);

  longjmp(jmpenv, 1);
}



