/* ix/MBox (main.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #HB headblock()	 display ANSI or normal headline
   #CB cut_bef()         isolate the command from an input line
   #CA cut_arg()         isolate the argument(s) from an input line
   #RA rates()           show telecom rates/charges
   #LG logout()          update userdate on logout
   #IT init()            setup commands, check user levels
   #FO fixoutput()       where to dump log output?
   #CI checkit()	 check ix/MBox installation
   #MA main()            the main function itself

   Contact <volkers@unnet.wupper.de> for help! */







#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "mbox.h"

extern time_t time_start, time_now;



/* #HB - Make a headline ;-) */

void headblock( hl, le )
UNSIGNED char hl[], le[];
{
  UNSIGNED char ex[LONGSTRING];

  strcpy(ex, (UNSIGNED char *) le);
  strcat(ex, (UNSIGNED char *) "                                                                              ");
  ex[79] = '\0';

  headline( hl );

  if(USER.terminal == ISO6429){
	if(ansi2( "X1", 0, 0 ) == 0){
		printf( "%s\n", ex);
		ansi2( "me", 0, 0 );
		return;
	}
  }
  printf("%s\n", le);
  printf("===============================================================================\n");
}




/* #CB - Isolate the command from an input line [s]. */

UNSIGNED char *cut_bef(s)
UNSIGNED char s[];
{
  static UNSIGNED char bef[STRING];
  int i = 0;

#ifdef _PROFILE
  profile( "cut_bef()" );
#endif

  while (s[i] > 32) {
	bef[i] = s[i];
	i++;
  }
  bef[i] = '\0';
  return (UNSIGNED char *) bef;
}



/* #CA - Isolate the argument(s) from an input line [s]. */

UNSIGNED char *cut_arg(s)
UNSIGNED char s[];
{
  static UNSIGNED char arg[STRING];
  int i = 0, a = 0;

#ifdef _PROFILE
  profile( "cut_arg()" );
#endif

  while (s[i] > 32) i++;
  if (s[i] == '\0') return (UNSIGNED char *) "";

  while (s[i] == 32) i++;

  while (s[i] != '\0') {
	arg[a] = s[i];
	i++;
	a++;
  }
  arg[a] = '\0';

  while((arg[(a-1)] < 33) && (a > 1)){
	a--;
	arg[a] = '\0';
  }

  return (UNSIGNED char *) arg;
}




/* #RA - Calculate the telecom rates and build up a prompt.

   This function returns the prompt line. */

UNSIGNED char *rates()
{
  static UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int dif;
  int n1, n2, r1, r2, w1, w2;
  struct tm *timeptr;

  time(&time_now);
  dif = time_now - time_start;

  n1 = dif / NZNT;
  n1++;
  n1 *= TARIF;
  n2 = dif / NZBT;
  n2++;
  n2 *= TARIF;
  r1 = dif / RZNT;
  r1++;
  r1 *= TARIF;
  r2 = dif / RZBT;
  r2++;
  r2 *= TARIF;
  w1 = dif / WZNT;
  w1++;
  w1 *= TARIF;
  w2 = dif / WZBT;
  w2++;
  w2 *= TARIF;

  timeptr = localtime(&time_now);
  sprintf(t, "%s", asctime(timeptr));

  if ((t[0] == 'S') || (timeptr->tm_hour > 18) || (timeptr->tm_hour < 8)) {
	sprintf(s, "(%ds) NZ %d.%02.2d, RZ %d.%02.2d, WZ %d.%02.2d",
	 dif, fix(n2), flt(n2), fix(r2), flt(r2), fix(w2), flt(w2));
  }
  else {
	sprintf(s, "(%ds) NZ %d.%02.2d, RZ %d.%02.2d, WZ %d.%02.2d",
	 dif, fix(n1), flt(n1), fix(r1), flt(r1), fix(w1), flt(w1));
  }

  return (UNSIGNED char *) s;
}




/* #LG - Updates users database after user has left the BBS. */

void logout()
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int a;

  printf("\n");


  time(&time_now);
  USER.elapsed += (long) (time_now - time_start);

  sprintf(s, "%s/etc/whatdoes.%s", HOME, (UNSIGNED char *) ttyna());
  unlink( s );

  sprintf(USER.abused, "%ld", IDX_SIZE);

  sprintf(s, "%s/%s/CDIDX.%d", HOME, TMP, getpid());
  unlink( s );
  sprintf(s, "%s/%s/CDDIR.%d", HOME, TMP, getpid());
  unlink( s );
  sprintf(s, "%s/%s/CDJNK.%d", HOME, TMP, getpid());
  unlink( s );


  USER.seq--;		
  printf("\n");
  init_user( MAI01_MSG, 0 );

#ifdef _NOINDEX
  sprintf(s, "%s/inhalt.%d", TMP, getpid());
  unlink(s);
#endif

  sprintf(s, "%s/surf.%d", TMP, getpid());
  unlink(s);

  control(MAI02_MSG, 3);

  chdir( HOME );

  if(USER.level <= ADMIN_LEV){ 
		
	sprintf(t, "%s/mbstat.%d", TMP, getpid());
	ff = fopen(t, "w" );
	if(ff == NULL){
		nerror("main.c", 257, "logout", "Can't write to", t);
	}
	time(&time_now);
	fprintf(ff, "%s %-8.8s %ld\n", (UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) ttyna(), (time_now - time_start));

	a = 0;

	fp = fopen( MBSTAT, "r" );
	if(fp == NULL){
		nerror("main.c", 266, "logout", "Can't read", MBSTAT);
	}
	while((fgets(s, STRING, fp) != NULL) && (a < (PRO_ENTRIES * 3))){
		fputs(s, ff);
		a++;
	}
	fclose(fp);
	fclose(ff);
	
	mbrename( t, MBSTAT );
  }

#ifdef _UNNET

  if(frwd_host[0] != '\0'){
	printf("\n\nNEWS-Artikel werden \"gepackt\" fuer [%s] ...\n", frwd_host);
	sprintf(s, "/usr/local/lib/news/bin/batch/sendbatches %s", frwd_host);
	system( s );
  }
#endif
}





/* #IT - Gets and sorts commands in and sets user levels. */

void init()
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char udcc[STRING];
  int udcl;
  UNSIGNED char udcp[STRING];
  int b = 0;
  int ok = 0;

  ff = fopen(UDCS, "r");
  if (ff == NULL) {
	nerror("main.c", 115, "init", "Can't read", UDCS);
	exit(0);
  }  
  while((fgets(s, STRING, ff) != NULL) && (s[0] != '='));
  if(fgets(s, STRING, ff) != NULL) ok = 1;
  t[0] = '\0';
  sscanf(s, "%s %d %s %s", udcc, &udcl, udcp, t);
  if(udcc[0] > 96) udcc[0] -= 32;
  if(t[0] != '\0'){
 	strcat(udcp, " "); strcat(udcp, t);
  }

  fp = fopen(BEFEHLE, "r");
  if (fp == NULL) {
	printf("\n%s\n\n", MAI02aMSG);
	exit( 0 );
  }
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%d %d %d %d %s", &BEF[b].id, &BEF[b].in, &BEF[b].ex, &BEF[b].prototyp, BEF[b].befehl) > 0) {

	if (BEF[b].id == 160) MAILOUT_LEV = BEF[b].ex;	  /* MAIL/BRIEF		 */
	if (BEF[b].id == 125) ADMIN_LEV = BEF[b].ex;	  /* ADMIN		 */
	if (BEF[b].id == 230) WRITE_EX_LEV = BEF[b].ex;   /* WRITE/SCHREIBEN */
	if (BEF[b].id == 230) WRITE_IN_LEV = BEF[b].in;	  /* WRITE/SCHREIBEN	*/
	if (BEF[b].id == 998) WRITE_INTERNAT = BEF[b].in; /* ~MAIL_DUMMY	*/
	if (BEF[b].id == 195) PD_D_LEV = BEF[b].in;       /* ~PD		*/
	if (BEF[b].id == 195) PD_U_LEV = BEF[b].ex;	  /* ~PD		*/
	if (BEF[b].id == 240) EXE_LEV = BEF[b].ex;	  /* EXEC/SHELL		*/
	if (BEF[b].id == 320) GUEST_LEV = BEF[b].in;	  /* VERSION		*/
	if (BEF[b].id == 130) BB1 = b;
	if (BEF[b].id == 150) BB2 = b;
	if (BEF[b].id == 160) BB3 = b;
	if (BEF[b].id == 170) BB4 = b;
	if (BEF[b].id == 210) BB5 = b;
	if (BEF[b].id == 180) BB6 = b;
	if (BEF[b].id == 190) BB7 = b;
	if (BEF[b].id == 200) BB8 = b;
	if (BEF[b].id == 270) BB9 = b;
	/*
	printf("[%s < %s]\n", udcc, BEF[b].befehl); sleep( 1 );
	*/
	if((ok == 1) && (BEF[b].prototyp == 1) && (udcc[0] < BEF[b].befehl[0])){
		BEF[(b+1)].id = BEF[b].id;
		BEF[(b+1)].in = BEF[b].in;
		BEF[(b+1)].ex = BEF[b].ex;
		BEF[(b+1)].prototyp = BEF[b].prototyp;
		strcpy(BEF[(b+1)].befehl, (UNSIGNED char *) BEF[b].befehl);
		BEF[b].id = 1000;
		BEF[b].in = udcl;
		BEF[b].ex = udcl;
		BEF[b].prototyp = 1;
		strcpy(BEF[b].befehl, (UNSIGNED char *) udcc);
		strcpy(BEF[b].pfad, (UNSIGNED char *) udcp);
		b++;
		if(fgets(s, STRING, ff) == NULL) ok = 0;
		sscanf(s, "%s %d %s %s", udcc, &udcl, udcp, t);
		if(udcc[0] > 96) udcc[0] -= 32;
		strcat(udcp, " "); strcat(udcp, t);
	}

	b++;
	if (b >= MAX_BEF) {
		nerror("main.c", 85, "init", "Definition MAX_BEF", "to small");
	}
  }

  if(ok != 0){
	BEF[b].id = 1000;
	BEF[b].in = udcl;
	BEF[b].ex = udcl;
	BEF[b].prototyp = 1;
	strcpy(BEF[b].befehl, (UNSIGNED char *) udcc);
	strcpy(BEF[b].pfad, (UNSIGNED char *) udcp);
	b++;
  }	

  BEF[b].id = -1;

  fclose(fp);
  fclose(ff);
}






/* #FO - Where to store/display log information. */

void fixoutput()
{
  UNSIGNED char s[STRING];

  FILE *fp;

  strcpy(s, CONSOLE); 

  if(strcomp("REDIRECT", CONSOLE) == 0){
	fp = fopen( CDIRECTFL, "r" );
	if(fp != NULL){
		fgets(s, STRING, fp);
		fclose(fp);
		
	}
   }
   strcpy(CONSOLE_REDIRECT, (UNSIGNED char *) stripped(s));
}




/* #CI - Check the ix/MBox installation */

void do_checkit( s, t )
UNSIGNED char s[], t[];
{
  UNSIGNED char l[LONGSTRING];

  struct stat fst;

  if(t[0] == '\0')
	sprintf(l, "%s .............................................", s);
  else
	sprintf(l, "%s [%s] ........................................", s, t);
  l[40] = '\0';
  printf("%c%s check", TAB, l);
  if(stat(s, &fst) != 0)
	printf(" - not found!\n");
  else
	printf("ed.\n");
}


void do_chperm( s )
UNSIGNED char s[];
{
  UNSIGNED char l[LONGSTRING];
  UNSIGNED char t[STRING];

  struct stat fst;

  sprintf(t, "%s/%s", (UNSIGNED char *) BIN, s);

  sprintf(l, "%s .............................................", t);
  l[28] = '\0';
  printf("%c%s check", TAB, l);

  if(stat(s, &fst) != 0){
	printf(" - not found!\n");
  }
  else{
	printf(" UID %d, GID %d, SETUID %d", fst.st_uid, fst.st_gid, fst.st_mode & S_ISUID);  

	if((fst.st_uid == 0) && (fst.st_gid == 0) && (fst.st_mode & S_ISUID))
		printf(" - OK.\n");
	else
		printf(" - WRONG!!!\n");
  }
}

void do_chrange( s, min, max, val )
UNSIGNED char s[];
int min, max;
{
  UNSIGNED char l[LONGSTRING];

  sprintf(l, "%s .............................................", s);
  l[30] = '\0';
  printf("%c%s check", TAB, l);
  if((val > min) && (val < max))
	printf("ed.\n");
  else
	printf(" - out of range (%d < %d > %d)\n", min, val, max);
}


void checkit()
{  
  UNSIGNED char s[STRING];
  UNSIGNED char l[LONGSTRING];
  UNSIGNED char t[STRING];
 
  int i;

  FILE *fp;



  headline( " CHECKIT " );

  printf("\n1. Terminals\n\n");


  for(i = 1; i < 6; i++){

	switch(i){
		case 1:	strcpy(l, "ansi");
			strcpy(TERMINAL, "ansi");
			break;
		case 2:	strcpy(l, "vt100");
			strcpy(TERMINAL, "vt100");
			break;
		case 3: strcpy(l, "vt52");
			strcpy(TERMINAL, "vt52");
			break;
		case 4: strcpy(l, "unknown");
			strcpy(TERMINAL, "un");
			break;
		case 5:	strcpy(l, "ansi-color");
			strcpy(TERMINAL, "ansi-color");
			break;
	}

	strcat(l, " .....................................................");
	l[40]  = '\0'; 
        printf("%c%s check", TAB, l);

	if(ansi2( "INIT", 0, 0 ) == -1)
		printf(" - not known!\n");
	else
		printf("ed.\n");
  }

  fp = fopen(TERMIS, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", TERMIS);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while(fgets(s, STRING, fp) != NULL){ 

	if(s[0] < 65) continue;
	sscanf(s, "%s", &t);
	sprintf(l, "%s ...................................................", t);
	l[40]  = '\0'; 
        printf("%c%s check", TAB, l);

	if(ansi2( "INIT", 0, 0 ) == -1)
		printf(" - not known!\n");
	else
		printf("ed.\n");
  }

  fclose(fp);


  printf("\n");
  more();

  printf("\n\n2. Directories\n\n");

  do_checkit( "./lib", "" );
  do_checkit( "./etc", "" );
  do_checkit( "./usr", "" );
  do_checkit( TMP, "TMP" );
  do_checkit( GLOBAL_TMP, "GLOBAL_TMP" );
  do_checkit( NEWS, "NEWS" );
  do_checkit( MAILDROP, "MAILDROP" );

  printf("\n");
  more();

  printf("\n\n3. Vital Files\n\n");

  do_checkit( NEWSGROUPS, "NEWSGROUPS" );
  do_checkit( NGROUPS, "NGROUPS" );
  do_checkit( BEFEHLE, "BEFEHLE" );
  do_checkit( HILFE, "HILFE" );
  do_checkit( KURZHILFE, "KURZHILFE" );
  do_checkit( SEQ, "SEQ" );
  do_checkit( CALLS, "CALLS" );
  do_checkit( UDBASE, "UDBASE" );
  do_checkit( UDSEQ, "UDSEQ" );

  printf("\n");
  more();
  
  printf("\n\n4. Supporting Tools\n\n");

  do_checkit( RSH, "RSH" );
  do_checkit( MB_DAEMON, "MB_DAEMON" );
  do_checkit( FAVORITE_EDITOR, "FAVORITE_EDITORS" );
  do_checkit( PRINTER, "PRINTER" );
  do_checkit( UUDECODE, "UUDECODE" );
  do_checkit( SX, "SX" );
  do_checkit( RX, "RX" );

  strcpy(s, TAR);
  i = 0; 
  while((s[i] != ' ') && (s[i] != '\0')) i++;
  s[i] = '\0';
  do_checkit( s, "TAR" );

  printf("\n\n5. Permissions\n\n");

  do_chperm( "mbox" );
  do_chperm( "xmd" );
  do_chperm( "mb-daemon" );

  printf("\n");
  more();

  printf("\n\n6. Editors [%s]\n\n", EDITORS);
  
  fp = fopen(EDITORS, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", EDITORS);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%s %s", t, s) > 0){
	do_checkit( s, "" );
  }
  fclose(fp);


  printf("\n");
  more();

  printf("\n7. Games [%s]\n\n", GAMES);
  
  fp = fopen(GAMES, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", GAMES);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%s %s", t, s) > 0){
	do_checkit( s, "" );
  }
  fclose(fp);


  printf("\n");
  more();

  printf("\n8. Packers [%s]\n\n", PACKERS);
  
  fp = fopen(PACKERS, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", PACKERS);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%s %s %s %s %s", t, s, t, t, t) > 0){
	do_checkit( s, "" );
  }
  fclose(fp);


  printf("\n");
  more();

  printf("\n9. Dimensions\n\n");
  
  do_chrange( "MAX_PER_NG", 10, 32000, (int) MAX_PER_NG);
  do_chrange( "PRO_ENTRIES", 10, 32000, (int) PRO_ENTRIES);
  do_chrange( "MAX_TERMINALS", 1, 32000, (int) MAX_TERMINALS);
  do_chrange( "MAX_BEF", 99, 200, (int) MAX_BEF);
  do_chrange( "MAX_MAK", 49, 200, (int) MAX_MAK);
  do_chrange( "MAX_NEWSGRPS", 19, 500, (int) MAX_NEWSGRPS);

  printf("\n\n");
  init_user( "Returning", 0 );

  printf("\n\n");
}



/* #MA - The mother of all that mess ... */

int main(argc, argv)
int argc;
UNSIGNED char *argv[];
{
  UNSIGNED char s[STRING];
  FILE *fp;
  int i;

  struct stat fst;


#if defined(_ESTDIO) || !defined(_SYS7)
  setbuf(stdout, NULL);
#endif


#ifdef _PROFILE
  profile( "+" );
#endif

  ROT13_MODUS   = 0;
  IP_CAUSED_HUP = 0;

  chdir(HOME);

  OLDUID = getuid();
  OLDGID = getgid();

  strcpy(MYNAME, (UNSIGNED char *) "J. Random Loser");

  sprintf(BEFEHLE,   "./src/languages/%s.cmd", (UNSIGNED char *) LANGUAGE);
  sprintf(HILFE,     "./src/languages/%s.hlp", (UNSIGNED char *) LANGUAGE);
  sprintf(KURZHILFE, "./src/languages/%s.shh", (UNSIGNED char *) LANGUAGE);


  strcpy(ORGANIZATION, _ORGANIZATION);
  strcpy(SYSTEM,       _SYSTEM);
  strcpy(UUCPSITE,     _UUCPSITE);
  strcpy(UUCPID2,      _UUCPID2);
  strcpy(UUCPID1,      _UUCPID1);
  strcpy(NAT_DOMAIN1,  _NAT_DOMAIN1);
  strcpy(NAT_DOMAIN2,  _NAT_DOMAIN2);
  strcpy(NAT_DOMAIN3,  _NAT_DOMAIN3);
  strcpy(UUCPBANG,     _UUCPBANG);
  strcpy(PHONE,        _PHONE);
  strcpy(LOCATION,     _LOCATION);
  strcpy(SMARTHOST,    _SMARTHOST);
  strcpy(NEWS_MINIMUM, _NEWS_MINIMUM);
  strcpy(NEWS_LEVEL1,  _NEWS_LEVEL1);
  strcpy(PMS_TTY,      _PMS_TTY);
  strcpy(GREP,         _GREP);
  strcpy(UUX,          _UUX); 
  strcpy(TAR,          _TAR);
  strcpy(SORTEDCUT,    _SORTEDCUT);
  strcpy(SECONDCUT,    _SECONDCUT);
  strcpy(THIRDCUT,     _THIRDCUT);
  strcpy(FOURTHCUT,    _FOURTHCUT);
  TARIF = (int) _TARIF;
  NZNT  = (int) _NZNT;
  NZBT  = (int) _NZBT;
  RZNT  = (int) _RZNT;
  RZBT  = (int) _RZBT;
  WZNT  = (int) _WZNT;
  WZBT  = (int) _WZBT;
  strcpy(REFLECT_NG,   _REFLECT_NG);


  if(get_cfg() == -1)
	write_cfg();


  if(chdir( TMP ) == -1){
	printf("\nYou have to \"make inst\" first!\n\n");
	return -1;
  }
  chdir( HOME );

  i = stat("mbox", &fst);

  if(((fst.st_mode & S_ISUID) != S_ISUID) || ((fst.st_mode & S_ISGID) != S_ISGID)){
	printf("\nSerious problem!\n");
	printf("\nThe [%s/mbox] does not have SETUID/SETGID!\n", HOME);
	printf("\nDo \"chmod ug+s %s/mbox\" right now to fix this problem!!!\n\n", HOME);
	return -1;	
  }
 
  if((i != 0) || (fst.st_uid != 0) || ((fst.st_gid != 0) && (fst.st_gid != 1))){
	printf("\nSerious problem!\n");
	printf("\nThe [mbox] is not owned by \"root.root\" but by (%d.%d)!", fst.st_uid, fst.st_gid);
	printf("\nYou have to fix this NOW! RTFM: READ THE README!!!\n\n");
	return -1;
  }

  if((OLDGID != GUEST_GID) && (OLDGID != USERS_GID) && (OLDGID != ROOT_GID)){
        printf("\nCongratulations to your sysop! He has managed to screw up the definitions");
  	printf("\nfor this bbs package completely. If you can, please tell him to overthink");
  	printf("\nhis ideas of \"GIDs\" - he in fact hasn't even a clou about it! Let him have");
        printf("\na look at the FAQ and especially the [./src/mbox.h] file ...\n\n");
	return -1;
  }

  if((int) GUEST_GID == (int) USERS_GID){
	printf("\nIn [mbox.h], around line 368, I told you that GUEST_GID *must* be different");
     	printf("\nfrom USERS_GID ... why do you set both definitions equals??\n");
        printf("\n\nCheck [/etc/passwd]. If \"users\" and \"guests\" have the same GID, you");
        printf("\nhave to make up a new group for \"guests\". Afterwards you must update");
        printf("\nthe definitions in [mbox.h]!\n"); 
        printf("\nRTFM: START READING README FILES!!!\n\n");
	return -1;
  }

  if(((int) ROOT_UID != 0) || (((int) ROOT_GID != 0) && ((int) ROOT_GID != 1))){
	printf("\nIn [mbox.h], around line 365, I told you that the ix/MBox will need");
	printf("\n\"root.root\" permissions to work properly.\n");
     	printf("\nYou set ROOT_UID (%d) and ROOT_GID (%d). Is this really, really correct??\n", ROOT_UID, ROOT_GID);
	printf("\nIf so, find *these* lines in \"main.c\" and comment them out ...");
	printf("\nIf not, fix it! RTFM: READ THE README!\n\n");
	return -1; 
  }

  if(chdir( "/cdrom" ) == -1){
	printf("\nOops. Your \"mount point\" for the CDROM device isn't \"/cdrom\"!?!?\n");
	printf("Why not? It'll cause problems if you want to make use of the CDROM from\n");
	printf("within the ix/MBox BBS!!! For \"/cdrom2\", the same thing applies!\n\n");
	printf("Just create a directory \"/cdrom\" or find these lines in \"main.c\"\n");
	printf("and comment them out. That'll stop this message!\n\n");
	return -1;
  }
  chdir( HOME );

  fp = fopen( "/bin/sh", "r" );
  if(fp == NULL){
	printf("\nCan't reach \"/bin/sh\"! That's quite a problem in many respects ...\n\n");
	return -1;
  }
  fclose(fp);


  fp = fopen( UDBASE, "r" );
  if(fp == NULL){
	strcpy(TERMINAL, "ansi");
	ansi2("INIT", 0, 0);

	headline( MAI03_MSG );
	ansi2("md", 0, 0);
	printf("\n%s", MAI04_MSG);
	printf("\n%s", MAI05_MSG);
	printf("\n%s", MAI06_MSG);
	printf("\n");
	printf("\n%s", MAI07_MSG);
	printf("\n%s", MAI08_MSG);
	printf("\n%s\n\n", MAI09_MSG);
	ansi2("me", 0, 0);

	postfach( "#1" );
	postfach( "#2" );
  }
  else{
	fclose(fp);
  }


  frwd_host[0] = '\0';

  fixoutput();
  area( " " );
  init();  
  intro( 0 );
  get_makros();
  ctrlx();

  loop();

  logout();
  noctrlx();
  ansi2("md", 0, 0);
  printf("\n\n%s\n\n", MAI11_MSG);
  ansi2("me", 0, 0);

#ifdef _PROFILE
  profile( "-" );
#endif

  return 0;
}
