/*
   This C source code contains the following functions:

   #SC sigcatch()        catch signals to handle them within the BBS
   #LP loop()            main loop of the BBS

   Contact <volkers@unnet.wupper.de> for help! */



 



   
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <setjmp.h>
#include <signal.h>
#include <sys/stat.h>

#include "mbox.h"

extern time_t time_start, time_now;

jmp_buf jmpenv;

int AFTER_DARK;


/* #SC - Catch signals and react.

   [sig] tells the number of the signal which leads to this call. */

void sigcatch(sig)
int sig;
{
  UNSIGNED char tmp[STRING];  


  signal(sig, SIG_IGN);

  chdir( HOME );
 
  sprintf(tmp, "[SIGNAL] %d", sig);
  control( tmp, 3 );

  switch (sig) {

	case SIGQUIT:
	case SIGABRT:
	case SIGINT:
		sprintf(tmp, "%s/I.%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/show%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/subscribe.%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/surf.%d", TMP, getpid());
		unlink(tmp);
		mbunlock( UDBASE );
		printf("\n\n");
		ansi2("mr", 0, 0);
		printf("%s [%d] ", LOP01_MSG, sig);
		ansi2("me", 0, 0);
		printf("\n\n");
		init_user( "Oops", 0); 
		printf("\n");
		longjmp(jmpenv, 1);
		break;
	case SIGHUP:
		if (IP_CAUSED_HUP == getpid()) {
			sleep( 1 );
			IP_CAUSED_HUP = 0;
			ctrlx();
			strcpy(tmp, "/bin/sh ./etc/ipscript.Cleanup &");
			system( tmp );
			init_user( "Oops", 0);
			printf("\n");
			longjmp(jmpenv, 1);
		} 
	case SIGTERM:
		sprintf(tmp, "%s/I.%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/show%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/subscribe.%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/surf.%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/%s/CDIDX.%d", HOME, TMP, getpid());
		unlink( tmp );
		sprintf(tmp, "%s/%s/CDDIR.%d", HOME, TMP, getpid());
		unlink( tmp );
		sprintf(tmp, "%s/%s/CDJNK.%d", HOME, TMP, getpid());
		unlink( tmp );
		mbunlock( UDBASE );
		printf("\n\n");
		ansi2("mr", 0, 0);
		printf("%s", LOP02_MSG);
		ansi2("me", 0, 0);
		printf("");
		logout();
		exit(-1);
		break;
	case SIGALRM:
		alarm( 0 );
		AFTER_DARK = 1;
		longjmp(jmpenv, 1);
		break;
  }
}



/* #LP - This is the BBSs main job loop. */

void loop()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char l[LONGSTRING];
  UNSIGNED char befehl[STRING];
  UNSIGNED char argument[STRING];
  UNSIGNED char prompt[STRING];

  UNSIGNED char cmdline[STRING];

  UNSIGNED char prev_befehl[10][STRING];
  int wasok;

  int c;

  UNSIGNED char bef_buff[(STRING * 2)];
  int bef_rec;

  int ende = 0, ok, dummy, i;
  int to_del;
  int fpid;

  int be, demo = 0, demo_lin, dod = 0;

  struct stat fst;

  int info_on    = 0;
  int info_count = 0;

  sprintf(prev_befehl[1], "%s ", BEF[BB1].befehl);
  sprintf(prev_befehl[2], "%s ", BEF[BB2].befehl); 
  sprintf(prev_befehl[3], "%s ", BEF[BB3].befehl);
  sprintf(prev_befehl[4], "%s ", BEF[BB4].befehl);
  sprintf(prev_befehl[5], "%s ", BEF[BB5].befehl);
  sprintf(prev_befehl[6], "%s ", BEF[BB6].befehl);
  sprintf(prev_befehl[7], "%s ", BEF[BB7].befehl);
  sprintf(prev_befehl[8], "%s ", BEF[BB8].befehl);
  sprintf(prev_befehl[9], "%s ", BEF[BB9].befehl);

  if(USER.level == GUEST_LEV) info_on = 1; 
  
  wasok = 1;

  strcpy(bef_buff, (UNSIGNED char *) "AUTOEXEC");

  DISKUSSION = 0;
  AFTER_DARK = 0;

  VAR_NAME[0] = '\0';
  strcpy(VAR_ME, (UNSIGNED char *) USER.name);

  fido_fast = 0; fido_msg = 0;
  yet_adult = 0; adult_run = 0;

  do {
	if(setjmp(jmpenv) == 1){
		demo = 0;
		bef_buff[0] = '\0';
		if(AFTER_DARK == 1){
			saver();
			AFTER_DARK = 0;
		}
		rollback();
	}

	FASTER:
	
	signal(SIGINT,  sigcatch);
	signal(SIGQUIT, sigcatch);
	signal(SIGHUP,  sigcatch);
	signal(SIGABRT, sigcatch);
	signal(SIGTERM, sigcatch);

	G94ACTIVE = 0;

	sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
	stat(s, &fst);
	if(fst.st_size > IDX_SIZE){
		printf("%c\n\n%s\n", BELL, LOP03_MSG); 
	}
        IDX_SIZE = (long) fst.st_size;

	stat(MB_READY, &fst);
	if((int) fst.st_size != MBD_SIZE){
		ansi2( "md", 0, 0 );
		printf("%c\n%s\n", BELL, LOP03aMSG);
		ansi2( "me", 0, 0 );
		init_user( LOP03bMSG, 1 );
		printf("\n");
	}
	MBD_SIZE = (int) fst.st_size;

	recently_updated();

	if(bef_buff[0] != '\0'){
		strcpy(s, (UNSIGNED char *) bef_buff);		
		strcpy(cmdline, (UNSIGNED char *) makro( bef_buff ));
		IS_BUFFERED = 1;
		bef_rec++;
		goto BUFFERING;
	}
        else 
		IS_BUFFERED = 0;


	bef_rec = 0;


	time(&time_now);
	i = TOUT_TIME - ((int) time_now - time_start);
        if (i < 60) {
		if (i <= 0) {
			printf("\n\n");
			ansi2( "md", 0, 0 );
			show(THROWN_OUT, 9999, USER.more); 
			ansi2( "me", 0, 0 );
			return;
		}
		else
			printf("\n%s %d %s\n", LOP03cMSG, i, LOP03dMSG);
        }


	if(MENUE_USING == 0){	/* NONE FIDO style */

		switch (USER.prompt) {
		    case 1:
				strcpy(prompt, (UNSIGNED char *) mytime(0));
				break;
		    case 2:
				if((USE_AREAS == 1) && (strcomp(BRETT, "PM") != 0))
					sprintf(prompt, "%s -> %s", (UNSIGNED char *) upcased(AREA), NG);
				else	
					strcpy(prompt, (UNSIGNED char *) NG);
				break;
		    case 3:	
				strcpy(prompt, (UNSIGNED char *) rates());
				break;
		}


#ifdef _BOTTOMLINE
		printf("\n\n\n");
		ansi2( "cm", 1, USER.tlines + 2);
		if(USER.terminal != ISO6429)
			ansi2( "mr", 0, 0 );
		else
			ansi2( "X6", 0, 0 );
		sprintf(l, " %s  ix/MBox BBS                                                                ", 
			(UNSIGNED char *) mytime( 0 ));
		l[79] = '\0';
		printf("%s", l);
		ansi2( "me", 0, 0 );
		ansi2( "cm", 1, USER.tlines - 1);
#endif /* _BOTTOMLINE */

		printf("\n");

		if(info_on == 1){
			if(info_count >= 3){
				info_count = 0;
				ansi2( "us", 0, 0 );
				printf("%s", "ACHTUNG: Neues Infomationssystem! Befehl \"Info\" unbedingt testen!");
				ansi2( "me", 0, 0 );
				printf("\n\n");
			}
			info_count++;
		}	

		if(USER.terminal != ISO6429)
			ansi2("md", 0, 0);
		else
			ansi2("X4", 0, 0);
		printf("[%s] %s >", prompt, LOP06_MSG);
		ansi2("me", 0, 0);
		printf(" ");
	
		if (USER.bell == 1) printf("%c", BELL);
	
	
		befehl[0] = '\0';

#ifdef _CORELEFT
		if(coreleft() < _CORELEFT){
			sprintf(s, "%d", _CORELEFT);
			nerror( "loop.c", 288, "loop", "Out of memory:", s );
		}
#endif

		do {
#ifdef _SCREENSAVER
			if(G94ACTIVE != 1){
				signal(SIGALRM, sigcatch);
				alarm( 300 );	
			}
#endif
			strcpy(s, (UNSIGNED char *) getline(STRING, 11001, 32, befehl));
#ifdef _SCREENSAVER
			signal(SIGALRM, SIG_IGN);
			alarm( 0 );
#endif
	
#ifdef _BOTTOMLINE
			ansi2( "cm", 1, USER.tlines + 2);
			clearline();
			ansi2( "cm", 1, USER.tlines + 0);
#endif

			to_del = strlen(befehl);
			strcpy(cmdline, (UNSIGNED char *) s);

			if (s[0] == 48) {
				headline( LOP05_MSG );
				printf("\n");
				for (i = 9; i > 0; i--) {
					printf(" %d: %s\n", i, prev_befehl[i]);
				}
				goto FASTER;
			}
			if ((s[0] > 48) && (s[0] < 58)) {
				sprintf(befehl, "%s", prev_befehl[(s[0] - 48)]);
				printf("%c", CR);
				if (ansi2("ce", 0, 0) == 1) {
					printf("                                                               ");
				}
				ansi2("md", 0, 0);
				printf("%c[%s] %s > ", CR, prompt, LOP06_MSG);
				ansi2("me", 0, 0);
	

				printf("%c", CR);
				if(USER.terminal != ISO6429)
					ansi2("md", 0, 0);
				else
					ansi2("X4", 0, 0);
				printf("[%s] %s >", prompt, LOP06_MSG);
				ansi2("me", 0, 0);
				printf(" ");
			}
		} while ((s[0] > 47) && (s[0] < 58));

	}
	else{	/* Doing it in FIDO style ... */

		strcpy(s, (UNSIGNED char *) fido_menue());
	}

	
        if(makro_definition(s) != 0) goto FASTER;


	BUFFERING:

	strcpy(s, (UNSIGNED char *) makro(s));

	if(strcomp("AUTOEXEC", s) == 0){
		bef_buff[0] = '\0';
		goto FASTER;
	}

	while ((s[0] == 32) || (s[0] == '.')) {
		sprintf(befehl, "%s", (UNSIGNED char *) strcopy(s, 1, strlen(s)));
		sprintf(s, "%s", befehl);
	}

	i = 0; ok = 0;
	while((ok == 0) && (s[i] != '\0')){
		if(s[i] == ','){ 
			strcpy(bef_buff, (UNSIGNED char *) strcopy(s, (i+1), strlen(s)));
			s[i] = '\0';
			ok++;
		}			
		i++;
	}
	if(ok == 0) bef_buff[0] = '\0';
	
	strcpy(befehl, (UNSIGNED char *) cut_bef(s));
	strcpy(argument, (UNSIGNED char *) cut_arg(s));
	strcpy(s, (UNSIGNED char *) upcased(befehl));
	strcpy(befehl, s);

	sprintf(s, "%s %s", befehl, argument);

	if (wasok == 1) {
		ok = 0;
		for (i = 9; i > 0; i--) {
			if ((strcomp(s, prev_befehl[i]) == 0) && (strcomp(prev_befehl[i], s) == 0))
				ok++;
		}
		if ((ok == 0) && (befehl[0] > 32)) {
			for (i = 9; i > 1; i--) {
				sprintf(prev_befehl[i], "%s", prev_befehl[(i - 1)]);
			}
			sprintf(prev_befehl[1], "%s %s", befehl, argument);
		}
	}
	else {
		sprintf(prev_befehl[1], "%s %s", befehl, argument);
	}

	if(MENUE_USING == 0){
		sprintf(s, "[%s] %s %s", LOP04_MSG, befehl, argument);
	}
	else{
		sprintf(s, "<FIDOMENU> [%s] %s %s", LOP04_MSG, befehl, argument);
	}
	control(s, 3);

	sprintf(s, "%s %s", befehl, argument);
	whodo(s);
	
	wasok = 0;

	if (befehl[0] == '"') {
		ansi2("md", 0, 0);
		printf(" %s\n", LOP07_MSG);
		ansi2("me", 0, 0);
		goto FASTER;
	}
	if (befehl[0] == '\0') {
#ifdef _SMALLTALK
		smalltalk( cmdline );
#endif
		goto FASTER;
	}

	if(argument[0] == '?') {
		strcpy(argument, befehl);
		strcpy(befehl, BEF[BB7].befehl);
 	}

/*  ?  */

	if (befehl[0] == '?') {
		if (argument[0] != '*') {
			sprintf(s, " %s %d) ", LOP08_MSG, USER.level);
		} else {
			sprintf(s, " %s ", LOP09_MSG, USER.level);
		}
		if(USER.schluessel[3] != 128)
			headline(s);
		else
			show_raw( ANSI_COMMANDS, 10 );

		bef("?", argument);
		ansi2( "me", 0, 0 );
		goto FASTER;
	}

/* <BREAK> */

	if (strcomp(befehl, "<BREAK>") == 0) {
		printf("!@#?");
		ansi2("md", 0, 0);
		printf(" %s", LOP10_MSG);
		ansi2("me", 0, 0);
		printf("\n");
		goto FASTER;
	}
	wasok = 1;

	be = bef(befehl, argument);

	if(be == 1) goto FASTER;

	DEMO_POINT:

	if(is_premium( (UNSIGNED char *) fido_befehl( be ), 0 ) == -1){
		goto FASTER;
	}

	if((be == 690) && (strlen(argument) > 3)) be = 12345; /* For the "I" in english version! */
	

	switch (be) {

	    case 275:		/* RELOGIN */
		logout();
		intro( 1 );
		get_makros();     
		break;

	    case 240:		/* EXEC / MINIX */

		if (argument[0] == '\0') {
			ansi2("md", 0, 0);
			printf(" %s\n", LOP11_MSG);
			ansi2("me", 0, 0);
			intuition( 240 );
		}
		else {
			printf("\n\n");
			sprintf(s, "exec %s %s %d %d", RSH, argument, OLDUID, OLDGID);
			system(s);
		}
		break;

	    case 110:
	    case 120:		/* + -  */

		scanner(befehl[0]);
		break;

	    case 190:		/* HELP / HILFE */

		printf("\n\n");
		if (argument[0] < 33)
			help("=");
		else {
			if(argument[0] == '*'){	
				help("*");
			}
			else{
				strcpy(s, "#");
				strcat(s, upcased(argument));
				if (help(s) < 1) {
					printf("%s \"%s\" %s\n", LOP12_MSG, argument, LOP13_MSG);
				}
			}
		}
		break;

	    case 150:		/* BOARD / BRETT */

		if(strcomp("**", argument) == 0) strcpy(argument, (UNSIGNED char *) "^");
		brett(argument);
		break;

	    case 130:		/* CALLS / ANRUFER */

		if((argument[0] > 47) && (argument[0] < 123)){
			headblock( LOP14_MSG, LOP15_MSG );
			selected_calls( argument );
			break;
		}

		if(argument[0] == '!'){
			auslastung();
			break;
		}

		if(argument[0] == '#'){
			statistik();
			break;
		}

#ifdef _ALLTIME
		if(argument[0] == '$'){
			alltime();
			break;
		}
#endif

		if(argument[0] == '%'){
			headblock( LOP34_MSG, LOP35_MSG );
			printf("%s ..", LOP29_MSG);
	
			switch( (fpid = fork()) ){
				case -1 :
					break;
				case  0 : 
					while(1){
						printf(".");
						sleep(2);
					}	
					break;
			}
			sprintf(t, "%s/%d.srt", TMP, getpid());
			sprintf(l, SECONDCUT, CALLS, t);
			system(l); 			
			kill( fpid, SIGKILL );
			(void) wait( &fpid );
			clearline();
			show(t, 9999, USER.more + 100);
			unlink(t);
			printf("\n%s %d %s\n", LOP29aMSG, PRO_ENTRIES, LOP29bMSG);
			break;
		}
		headblock( LOP14_MSG, LOP15_MSG );

		if (argument[0] != '*') {
			if(USER.terminal != ISO6429)
				show(CALLS, MAX_SCR_LINES - 3, USER.more);
			else
				show(CALLS, MAX_SCR_LINES - 2, USER.more);
		}
		else {
			show(CALLS, 9999, USER.more + 100);
		}
		break;

	    case 200:		/* DIR / INHALT */

		inhalt2(argument, 'I');
		break;

	    case 210:		/* READ / LESEN */

		dummy = (pruefe(argument));
		if (dummy == 0) lesen(argument);
		if (dummy == -1) lesen2(argument, 'L');
		break;

	    case 230:		/* WRITE / SCHREIBEN */

		if (USER.level < WRITE_IN_LEV) {
			ansi2("md", 0, 0);
			printf(" %s\n", LOP16_MSG);
			ansi2("me", 0, 0);
		}
		else
			schreiben(argument);
		break;

	    case 220:		/* DELETE / LOESCHEN */
               
		strcpy(t, (UNSIGNED char *) stripped(argument));
		if (t[0] == '0') {
			break;
		}
 
		if (strchr(argument, '-') == 0)
			sprintf(t, "%s - %s", argument, argument);
		else
			strcpy(t, (UNSIGNED char *) argument);
		loeschen2(t, 'D');
		break;

	    case 160:		/* MAIL / BRIEF */

		if (USER.level < WRITE_IN_LEV) {
			ansi2("md", 0, 0);
			printf(" %s\n", LOP16_MSG);
			ansi2("me", 0, 0);
		}
		else
			if((brief(argument) == 0) && (strcomp(GUEST, USER.name) != 0)){
				sprintf(s, "%s?", USER.name);
				brief(s);
				sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
				stat(s, &fst);
			        IDX_SIZE = (int) fst.st_size;
			}
			else bef_buff[0] = '\0';
		break;

	    case 170:		/* CHAT */

#ifdef _HAVE_CHAT
		sprintf(s, "exec %s %s \"%s\" %d %d", RSH, CHAT, USER.nick, OLDUID, OLDGID);
#else
		sprintf(s, "exec %s %s \"%s\" %d %d", RSH, CHAT, argument, OLDUID, OLDGID);
#endif
		system(s);
		break;

	    case 250:		/* PM */

		strcpy(BRETT, "PM");
		printf("\n");
		sprintf(NG, "%s.PM", USER.name);
		sprintf(INHALT, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
		break;

	    case 260:		/* ACCOUNT / POSTFACH */

		postfach("*");
		break;

	    case 300:		/* USER */

		userliste(argument);
		break;

	    case 140:		/* MESSAGE / ANSAGE */

		ansage();
		break;

	    case 310:		/* SIGNATURE / UNTERSCHRIFT */

		unterschrift();
		break;

	    case 320:		/* VERSION */

		printf("\n\n");
		ansi2("md", 0, 0);
		printf("Version: ");
		ansi2("me", 0, 0);
		printf("%s %s %s\n", VERSION, PATCHLEVEL, AUTOR);

		if(argument[0] == '#'){
			ansi2("md", 0, 0);
			printf("\nMein spezieller Dank gilt folgenden Mitarbeitern, Beta-Testern und Ratgebern: \n\n");
			ansi2("me", 0, 0);
			
			printf("andreas@xenox.ruhr.de       - fuer den \"NewsFeed\" und seine Geduld\n");
			printf("                              bei unseren \"Sonderwuenschen\"\n\n");

			printf("az@unnet.w.open.de          - fuer seinen Einsatz beim \"Einrichten\"\n");
			printf("                              der Mailbox und der PD-Portierung\n\n");

			printf("joergg@unnet.ruhr.sub.org   - fuer seine Ideen, Tips, konstruktive\n");
			printf("                              Kritik und gruendliche Tests\n\n");		

			printf("klausr@skylink.ruhr.sub.org - fuer viele Vorschlaege, und vor allem\n");			
			printf("                              fuer seine praesizen Fehlerbeschreibungen\n\n");			

			printf("stefans@coduck.ruhr.sub.org - fuer seine Hilfe bei der Installation\n");
			printf("                              der 386er Patches und der PD-Beschaffung\n\n");

			printf("walterb@weller.ruhr.sub.org - fuer seine Unterstuetzung bei der Portierung auf\n");
			printf("                              UNIX SVR3 und bei der Installation\n\n");

			printf("hergo@ivcmd.boerde.de       - fuer seine Hilfe bei der Bildung einer Referenz-\n");
			printf("                              Version zur Verwendung von CDIFFs\n\n");
			
		}
		
		if(argument[0] == '*'){
			ansi2("md", 0, 0);
			printf("\n%s ", LOP17_MSG);
			ansi2("me", 0, 0);
#ifdef _SYS7
			printf("-D_SYS7 ");
#endif
#ifdef _MBOX
			printf("-D_MBOX ");
#endif
#ifdef _MINIX
			printf("-D_MINIX ");
#endif
#ifdef _ESTDIO
			printf("-D_ESTDIO ");
#endif
#ifdef _CORELEFT
			printf("-D_CORELEFT ");
#endif
#ifdef _DATESTAMP
			printf("-D_DATESTAMP ");
#endif
#ifdef _BAUDRATE
			printf("-D_BAUDRATE ");
#endif
#ifdef _MULTIMEDIA
			printf("-D_MULTIMEDIA ");
#endif
#ifdef _METAMAIL
			printf("-D_METAMAIL ");
#endif
#ifdef _UMLAUT
			printf("-D_UMLAUT ");
#endif

			printf("\n");
		}

		break;

	    case 270:		/* PORTINFO */

		port( argument );
		break;

	    case 280:		/* SETUP */

		sprintf(s, "%s", NG);
		sprintf(t, "%s", BRETT);
		setup();
		if (strcomp("PM", t) != 0) brett(s);
		break;

	    case 125:		/* ADMIN */

		sprintf(s, "%s", NG);
		sprintf(t, "%s", BRETT);
		admin();
		if (strcomp("PM", t) != 0) brett(s);
		break;

	    case 205:		/* ID */

		if(strcomp("-c", argument) == 0){ /* Memory fault - core dumped */
			printf("\n\nDebug-Modus! Test1: \"fclose(0)\"");
			fclose(0);   
			printf("\n             Test2: \"strlen()\"\n\n");
			strcpy(s, "Na dann wollen wir das Memory Management mal ein bisschen aufmischen ;-)");
			for(i = 0; i < 32000; i++){
				strcat(s, s);	
			}	
			break;
		}

		if(strcomp("*", argument) == 0){
			BAUDRATE = baudrate( MAX_BPS );
			printf("\n\n>>> Baudrate %d\n", BAUDRATE);
			break;
		}

		if(strcomp("#", argument) == 0){
			printf("\n\n>>> Coreleft %d\n", coreleft());
			break;
		}

		if(strcomp("T", argument) == 0){
			printf("\n\n>>> Timeout %d secs., max. number of calls %d\n", TOUT_TIME, TOUT_CALLS);
			break;
		}

		if(strcomp("$", argument) == 0){
			printf("\n\n>>> Colortest ");
			ansi2("md", 0, 0); printf("md "); ansi2("me", 0, 0);
			ansi2("mr", 0, 0); printf("mr "); ansi2("me", 0, 0);
			ansi2("mb", 0, 0); printf("mb "); ansi2("me", 0, 0);
			ansi2("so", 0, 0); printf("so "); ansi2("me", 0, 0);
			ansi2("us", 0, 0); printf("us "); ansi2("me", 0, 0);
			ansi2("X1", 0, 0); printf("X1 "); ansi2("me", 0, 0);
			ansi2("X2", 0, 0); printf("X2 "); ansi2("me", 0, 0);
			ansi2("X3", 0, 0); printf("X3 "); ansi2("me", 0, 0);
			ansi2("X4", 0, 0); printf("X4 "); ansi2("me", 0, 0);
			ansi2("X5", 0, 0); printf("X5 "); ansi2("me", 0, 0);
			ansi2("X6", 0, 0); printf("X6 "); ansi2("me", 0, 0);
			ansi2("X7", 0, 0); printf("X7 "); ansi2("me", 0, 0);
			ansi2("X8", 0, 0); printf("X8 "); ansi2("me", 0, 0);
			ansi2("X9", 0, 0); printf("X9 "); ansi2("me", 0, 0);
			ansi2("X0", 0, 0); printf("X0 "); ansi2("me", 0, 0);
			ansi2("XA", 0, 0); printf("XA "); ansi2("me", 0, 0);
			ansi2("XB", 0, 0); printf("XB "); ansi2("me", 0, 0);
			ansi2("XC", 0, 0); printf("XC "); ansi2("me", 0, 0);
			ansi2("XD", 0, 0); printf("XD "); ansi2("me", 0, 0);
			printf("\n");
			break;
		}

		printf("\n\n>>> %s (UID %d|%d|%d) (GID %d|%d|%d)\n", MYNAME,
		       getuid(), geteuid(), OLDUID,
		       getgid(), getegid(), OLDGID);
		break;

	    case 215:		/* LEVEL */

		show_level( argument );
		break;

	    case 290:		/* PREFERENCES / STATUS */

		status();
		break;

	    case 330: 		/* MACRO / MAKRO */

		set_makros();
		break;

	    case 340:		/* FORWARD / WEITERLEITEN */

		weiterleiten( argument );
		break;

	    case 350:           /* SLEEP */

		dummy = atoi( argument );
		if(dummy < 1) dummy = 1;
		printf("\n");
		ansi2( "mr", 0, 0 );
		printf(" %s ... ", LOP29_MSG);
		ansi2( "me", 0, 0 );	
		sleep( dummy );
		break;		

	    case 360:		/* KEYPRESSED */

		printf("\n");
		ansi2("mr", 0, 0);
		printf(" Taste ! ");
		ansi2("me", 0, 0);
		dummy = getint();
		if((dummy == CTRL_X) || (dummy == 'x') || (dummy == 'q')){
			bef_buff[0] = '\0';
			printf("\n");
		}
		break;

	    case 370:		/* DATE / DATUM */
		
		ansi2("md", 0, 0);
		printf("\n\n%s ", LOP18_MSG);
		ansi2("me", 0, 0); 
		printf("%s, ", (UNSIGNED char *) mydate( 2 ));
		printf("%s\n",  (UNSIGNED char *) mydate( 0 ));
		break;
	
	    case 380:		/* TIME / ZEIT */

		ansi2("md", 0, 0);
		sprintf(s, "%s                            ", LOP19_MSG);
		s[12] = '\0'; printf("\n\n%s", s);
		ansi2("me", 0, 0);
		sprintf(s, "%s", (UNSIGNED char *) mytime( 0 ));
		s[12] = '\0'; printf("%s ", s);
		/*
		ansi2("mb", 0, 0);
		printf("%s", LOP20bMSG);
		ansi2("me", 0, 0);
		*/
		ansi2("md", 0, 0);
		printf("\nOnline:     ");
		ansi2("me", 0, 0);
		time(&time_now);
		printf("%s\n", (UNSIGNED char *) make_time( (int) (time_now - time_start) ));
		ansi2("md", 0, 0);
		sprintf(s, "%s:                          ", LOP20aMSG);
		s[12] = '\0'; printf("%s", s);
		ansi2("me", 0, 0);
		printf("%s\n", (UNSIGNED char *) make_time( (int) (TOUT_TIME - (time_now - time_start)) ));
		break;

	    case 390:		/* GAMES / SPIELE */

		games();
		break;
	
	    case 400:		/* DIRECTION / RICHTUNG */

		ansi2("md", 0, 0);
		printf("\n\n%s ", LOP21_MSG);
		ansi2("me", 0, 0);

		if (USER.leserichtung == 1) {
			USER.leserichtung = 2;
			printf("%s\n", LOP22_MSG);
		}
		else {
			USER.leserichtung = 1;
			printf("%s\n", LOP22aMSG);
		}
		break;

	    case 410:           /* STATISTICS / STATISTIK */

		if ((argument[0] != '#') && (argument[0] != '$') && (argument[0] != '%') && (argument[0] != '!') && (argument[0] != '>') && (argument[0] != '.')) {

			headblock( LOP23_MSG, LOP24_MSG );

			if (argument[0] != '*') {
				show(MB_DLOG, MAX_SCR_LINES - 3, USER.more);
			}
			else {
				show(MB_DLOG, 9999, USER.more + 100);
			}
		}
		if(argument[0] == '$') {
			headline( LOP25_MSG );
			show(UUCPCOSTS, 9999, USER.more);
		}
   		if(argument[0] == '#') {
			headblock( LOP26_MSG, LOP27_MSG );
			show(PDLOG, 9999, USER.more + 100);
		}
		if(argument[0] == '>') {
			headblock( LOP27aMSG, LOP27bMSG );
			show(XMDLOG, 9999, USER.more + 100);
		}
		if(argument[0] == '%') {
			headblock( LOP32_MSG, LOP33_MSG );
			printf("%s ..", LOP29_MSG);
	
			switch( (fpid = fork()) ){
				case -1 :
					break;
				case  0 : 
					while(1){
						printf(".");
						sleep(2);
					}	
					break;
			}
			sprintf(t, "%s/%d.srt", TMP, getpid());
			sprintf(l, SORTEDCUT, PDLOG, t);
			system(l); 			
			kill( fpid, SIGKILL );
			(void) wait( &fpid );
			clearline();
			show(t, 9999, USER.more + 100);
			unlink(t);
		}
		if(argument[0] == '.') {
			headblock( LOP31aMSG, LOP31bMSG );
			printf("%s ..", LOP29_MSG);
	
			switch( (fpid = fork()) ){
				case -1 :
					break;
				case  0 : 
					while(1){
						printf(".");
						sleep(2);
					}	
					break;
			}
			sprintf(t, "%s/%d.srt", TMP, getpid());
			sprintf(l, FOURTHCUT, t);
			system(l); 			
			kill( fpid, SIGKILL );
			(void) wait( &fpid );
			clearline();
			show(t, 9999, USER.more + 100);
			unlink(t);
		}
		if(argument[0] == '!') {
			headline( " OUTDIAL " );
			show("/local/mbox/etc/outdial.log", 9999, USER.more);
		}

		break;

	    case 430:		/* SEARCH / SUCHEN */

		suchen( argument );
		break;	
	    			
	    case 420:		/* RING */

		ende = 1;
		break;

	    case 440:		/* DOWNLOAD */

		download( argument );
		break;

	    case 450:		/* PLAN */

		plan( argument );
		break;

	    case 460:		/* GROUP */

		if((strcomp("++", argument) == 0) || (strcomp("--", argument) == 0)){
			scanner( argument[0] + 1500 );
		}
		else{
			scanner( argument[0] + 500 );
		}	
		break;


	    case 470:		/* SYSINFO */

		sprintf(s, "%s.%s", SYSINFO, LANGUAGE);

		if(USER.schluessel[3] != 128){
			headline( " SYSiNFO " );
			if(show(s, 9999, USER.more) == -1) show(SYSINFO, 9999, USER.more);
		}
		else{
			show_raw( ANSI_SYSINFO, 10 );
			if(show(s, 9999, USER.more + 1000) == -1) show(SYSINFO, 9999, USER.more + 1000);
		}

		break;

	    case 480:		/* EDIT */

		edit( argument );
		break;

	    case 490:		/* THREAD / DIS */

		dis( argument );
		break;

	    case 500:		/* UMLAUT */

		ansi2("md", 0, 0);
		printf("\n\n%s ", LOP33aMSG);
		ansi2("me", 0, 0);

		if (UMLAUT_MODUS == 4) {
			UMLAUT_MODUS = USER.schluessel[2];
			switch(UMLAUT_MODUS){
				case 1 : printf("%s\n", ADM70dMSG);
					 break;
				case 2 : printf("%s\n", ADM70eMSG);
					 break;
				case 3 : printf("%s\n", ADM70fMSG);
					 break;
				case 4 : printf("%s\n", ADM70gMSG);
					 break;
			}
		}
		else {
			UMLAUT_MODUS = 4;
			printf("%s\n", LOP33bMSG);
		}
		break;

	    case 510:		/* MONITOR */

		i = atoi( argument );

		if(i <= 0){
			saver();
		}
		else{
			switch( (fpid = fork()) ){
				case -1 :
					break;
				case  0 :
#ifndef _ESTDIO
					nice( 15 );
#endif
					while(1){
						headblock( LOP14_MSG, LOP15_MSG );
						show(CALLS, MAX_SCR_LINES-2, USER.more);
						sleep( i ); 
						statistik();
						sleep( i ); 
						port( "*" );
						sleep( i ); 
						headblock( LOP23_MSG, LOP24_MSG );
						show(MB_DLOG, MAX_SCR_LINES-2, USER.more);
						sleep( i ); 
						auslastung();
						sleep( i );
						headblock( LOP26_MSG, LOP27_MSG );
						show(PDLOG, MAX_SCR_LINES-2, USER.more);
						sleep( i );
				}
			}
			c = getch();
			kill( fpid, SIGKILL );
			(void) wait( &fpid );		
		}
		break;

	    case 520:		/* UUDECODE */

		uudecode( argument );
		break;

	    case 530:		/* UN/SUBSCRIBE */

		subscribe();
		break;

	    case 540:           /* UPDATE UserDirectory */

		new_user_dir();
		break;

	    case 550:		/* PERF TEST */
	
		perf();
		break;

	    case 560:		/* ARCHIVE / ARCHIV */

		if (strcomp(BRETT, "PM") == 0) {
			mail_status( atoi(argument), '*' );
		}
		else printf(" <- %s", LOP36_MSG);
		break;

	    case 570:		/* ROT13 */

		ansi2("md", 0, 0);
		printf("\n\n%s ", SHO13_MSG);
		ansi2("me", 0, 0);

		if (ROT13_MODUS == 1) {
			ROT13_MODUS = 0;
			printf("%s\n", SHO15_MSG);
		}
		else {
			ROT13_MODUS = 1;
			printf("%s\n", SHO14_MSG);
		}
		break;

	    case 580:		/* COMBINE / KOMBINIEREN */

		kombinieren( argument );
		break;

	    case 590:		/* STOCK / BOERSE */

		boerse( argument );
		break;

	    case 600:		/* PREVIEW */

		preview( argument );
		break;

	    case 610:		/* DEMO */

		if(demo == 0){
			demo++;
			demo_lin = USER.more;
			USER.more = 0;
		}
		break;


	    case 620:		/* GRAFIK/GRAPHICS */
		
		if(UMLAUT_MODUS == INTEL_INSIDE){
			ansi2( "md", 0, 0 );
			printf("\n\n%s ", LOP37_MSG); 
			ansi2( "me", 0, 0 );
			if(USER.schluessel[3] == 128){
				USER.schluessel[3] = 96;
				printf("%s\n", LOP33bMSG); 
			}
			else{
				USER.schluessel[3] = 128;
				printf("%s\n", LOP33cMSG); 
			}
		}
		else{
			ansi2( "md", 0, 0 );
			printf(" <- %s\n", LOP33dMSG);
			ansi2( "me", 0, 0 );
			intuition( 620 );
		}
		break;
   
            case 630:		/* CDROM */

		cdrom( argument );
		break;

	    case 640:		/* SCANKEYBOARD */

		do{
			printf("\n\nTEST (Beenden mit 'q'): ");
			c = getint();
			printf("%3d ", c);
			if((c > 31) && (c < 127))
				printf("[%c]", c);
			if(c < 32)
				printf("[CTRL-%c]", (c + 64));
			if(c > 126)
				printf("[%c] ( >= 127 !)");	
			if(c == 27)
				printf(" ESC Sequenz ???");
		}while(isin("quit", c) == 0);

		printf("\n\n");
		break;

            case 650:		/* FINDER */

		finder( argument );
		break;            
        		

	    case 660:		/* WETTER/WEATHER */

		gloom();
		break;


	    case 670:		/* KONTO/RATES */

		if(USER.level < ADMIN_LEV){
			konto( USER.name );
		}
		else{
			if(argument[0] == '\0') 
				konto( USER.name );
			else
				konto( argument );
		}
		break;


	    case 680:		/* INTERNET */

		ip_menue( argument );
		break;

	    case 690:		/* INFO */

		infsys();
		info_on = 0;
		break;

	    case 700:		/* KONFIGURATION/CONFIG */
	
		configure();
		break;

	    case 710:		/* SPION/SPY */

		port2( argument );
		break;

	    case 720:		/* FIDO/MENUE */

		MENUE_USING = 1;
		fido_fast = 9876;   
		break;

	    case 730:		/* HTTP/WWW/HTML */

		http( argument );
		break;

	    case 740:		/* FORM */

#ifdef _UNNET	
		strcpy(t, (UNSIGNED char *) USER.name);
		i = 0; while(t[i] != '\0'){
			if(t[i] == ' ') t[i] = '.'; i++;
		}
		sprintf(s, "/local/form/form %s@%s", t, UUCPID2);		
		system( s );
#endif
		break;	
	
            case 750:		/* AREA */

		area( argument );
		break;

	    case 760:		/* VERTRETER / DEPUTY */

		deputy();
		break;

	    case 770:		/* MECKERN / MOAN */

		moan();
		break;

            case 995:		/* NEWSBATCH */

#ifdef _UNNET
		if(argument[0] == '\0'){
			strcpy(argument, (UNSIGNED char *) frwd_host);
			if(argument[0] == '\0'){
				ansi2( "md", 0, 0 );
				printf(" <- Kein Empfaenger \"Host\" angegeben!\n");
				ansi2( "me", 0, 0 );
				break;
			}
		}

		printf("\n\nNEWS-Artikel werden \"gepackt\" fuer [%s] ...\n", argument);
		sprintf(s, "/usr/local/lib/news/bin/batch/sendbatches %s", argument );
		system( s );
#endif
		break;		

            case 996:		/* REBUILDA */

		rebuild_aliases();
		break;

	    case 997:		/* CHECKIT */

		checkit();
		break;


	    case 1000:		/* User Defined Command */

		/* See 'befehl.c' how that works ;-) */
		break;

	    case 180:		/* END / ENDE */

		if (argument[0] != '!'){
			printf("\n\n");
			ansi2("mr", 0, 0);
			printf("%c%s [%c, %c] >", CR, LOP28_MSG, GBL06_MSG, GBL07_MSG);
			ansi2("me", 0, 0);
			printf(" ");
			
			c = yesno();
		}
		else{
			c = GBL06_MSG;
		}

		if (c == GBL06_MSG)
			ende = 1;
		else
			printf("\n");

		if(argument[0] == '*'){
			USER.lasttime = LASTTIME;
			strcpy(USER.lastlog, (UNSIGNED char *) datereconv( LASTLOG ));
		}
		else{
			strcpy(s, (UNSIGNED char *) mydate(0));
			s[10] = '\0';
			strcpy(USER.lastlog, s);
			strcpy(s, (UNSIGNED char *) mytime(1));
			USER.lasttime = timeconv(s);
		}

		break;

	    case -1:		/* LEVEL ??? */

		wasok = 0;
		ansi2("md", 0, 0);
		printf(" %s %d ...\n", LOP30_MSG, USER.level);
		ansi2("me", 0, 0);
		break;

	    default:

		wasok = 0;

#ifndef _SMALLTALK
		ansi2("md", 0, 0);
		printf(" %s\n", LOP31_MSG);
		ansi2("me", 0, 0);
#else
		if(smalltalk( cmdline ) != 0){
			ansi2("md", 0, 0);
			printf(" %s\n", LOP31_MSG);
			ansi2("me", 0, 0);
		}
		else bef_buff[0] = '\0';
#endif
	}

	if(demo != 0){

		demo++; dod = 0;

		switch(demo){
			case 2 : 	sprintf(s, " %s ", LOP09_MSG, USER.level);
					if(USER.schluessel[3] != 128)
						headline(s);
					else	
						show_raw( ANSI_COMMANDS, 10 );

					bef("?", "");  
					break;
			case 3 :	be = 320; strcpy( argument, "" );  
					break;
			case 4 : 	be = 410; strcpy( argument, "" ); dod += 2;
					break;
			case 5 : 	be = 270; strcpy( argument, "*" ); dod++; 
					break;
			case 6 : 	be = 130; strcpy( argument, "" ); dod++;
					break;
			case 7 : 	be = 215; strcpy( argument, "" ); dod += 2; 
					break;
			case 8 : 	be = 370; strcpy( argument, "" );  
					break;			
			case 9 : 	be = 150; strcpy( argument, "" ); dod++;
					break;
			case 10: 	be = 130; strcpy( argument, "#" ); dod++;
					break;
			case 11: 	be = 190; strcpy( argument, "H" ); dod += 2;
					break;	
			case 12: 	be = 250; strcpy( argument, "" ); dod++; 
					break;
			case 13: 	be = 200; strcpy( argument, "" ); 
					break;
			default:	demo = 0;			
		}

		if((demo != 0) && (demo != 2)){
			s[0] = '\0'; i = 0;
			while((s[0] == '\0') && (BEF[i].id != -1)){
				if(BEF[i].id == be) strcpy(s, BEF[i].befehl);
				i++;
			}
			if(argument[0] != '\0'){
				strcat(s, " "); strcat(s, argument);
			}
			printf("\n");
			if(USER.terminal != ISO6429)
				ansi2("md", 0, 0);
			else
				ansi2("X4", 0, 0);
	
			printf("[%s] Demo! >", VERSION);
			ansi2("me", 0, 0 );

			printf(" ");
			scribble( s );
			noctrlx();
			ctrlx();
		}

		if(dod != 0){
			sleep( 4 );
			if(dod > 1){
				ansi2( "cm", 0, 0 );
				for(i = 0; i < 25; i++){
					ansi2( "al", 0, 0 );
					msleep( 10 );
				}
			}
		}

		if(demo != 0) goto DEMO_POINT;

		printf("\n");
		USER.more = demo_lin;		
	}	

  } while (ende == 0);
}
