/* ix/MBox (help.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #HE help()           display help texts
   #IT intuition()	help on problems on a command line

   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>

#include "mbox.h"



/* #HE - Give help.

   [cmd]   ->  '*'        = Display the entire helpfile
               '='        = Show the short version of the helpfile

               '#Command' = find the entry for 'Command' and show
                            the belonging helptext

   This functions returns 0 on any errors or the number of found entries
   otherwise. */

int help(cmd)
UNSIGNED char cmd[];
{
  FILE *fp;
  UNSIGNED char s[LONGSTRING];
  int ok = 0, found = 0, toggle = 0, lines = 0, new = 0;

  show(KURZHILFE, 99, 99); /* RESET */
  
  if(cmd[0] == '='){
	if(USER.schluessel[3] != 128){
		headline( HLP01_MSG );
		show(KURZHILFE, 9999, USER.more);
	}
	else{
		show_raw( ANSI_HELP, 10 );
		show(KURZHILFE, 9999, USER.more + 1000);
	}

	return 9999;
  }

  maybe_locked(HILFE, "r");
  fp = fopen(HILFE, "r");
  if (fp == NULL) {
	nerror("help.c", 14, "help", "Can't read", HILFE);
  }
  if (cmd[0] != '#') {
	ok = 2;
	found++;
  }
  headline( HLP01_MSG );
  lines = 0;

  while(fgets(s, STRING, fp) != NULL){

	if(UMLAUT_MODUS != 4) 
		strcpy(s, (UNSIGNED char *) iso_line(s));
	
	strcpy(s, (UNSIGNED char *) richtext(s));

	if (USER.more > 0) {
		if (lines >= MAX_SCR_LINES) {
			lines = 0;
			if (more() != 0) return 1;
		}
	}
	if (ok == 2) {
		if (s[0] != '#') {
			printf("%s", s);
			lines++;
			if (toggle > 0) {
				ansi2("me", 0, 0);
				toggle = 0;
			}
		}
		else {
			printf("\n");
			lines++;
			ansi2("md", 0, 0);
			toggle++;
		}
	}
	else {
		if ((ok == 1) && (s[0] == '#')) {
			if(new != 0){
				ok = 0;
				/*
				printf("\n");
				*/
				lines++;
				new = 0;
			}
		}
		if ((ok == 1) && (s[0] != '#')) {
			printf("%s", s);
			new++;
			lines++;
			if (toggle > 0) {
				ansi2("me", 0, 0);
				toggle = 0;
			}
		}
		if ((ok == 0) && (s[0] == '#')) {
			if (strcomp(cmd, s) == 0) {
				ok = 1;
				found++;
				ansi2("md", 0, 0);
				toggle++;
			}
		}
	}
  }
  fclose(fp);

  return found;
}


/* #IT - Help quickly. */

intuition( be )
int be;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char x[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char xx[LONGSTRING];

  FILE *fp;

  int i, ok = 0;

  s[0] = '\0'; i = 0;
  while((s[0] == '\0') && (BEF[i].id != -1)){
	if(BEF[i].id == be) strcpy(s, BEF[i].befehl);
	i++;
  }
  
  sprintf(t, "%s/src/languages/%s.shh", HOME, LANGUAGE);
  fp = fopen(t, "r");
  if(fp == NULL){
	nerror("help.c", 155, "intuition", "Can't read", t);
	return;
  }

  ansi2( "us", 0, 0 );
  printf("\n-------------------------------------------------------------------------------\n");
  ansi2( "me", 0, 0 );

  while(fgets(ex, LONGSTRING, fp) != 0){
	if(strlen(ex) < 40) ok = 0;
	strcpy(t, (UNSIGNED char *) strcopy(ex, 0, 40));
	if((sgrep(t, s) != 0) || (ok > 0)){
		strcpy(xx, (UNSIGNED char *) richtext( ex ));
		strcpy(ex, (UNSIGNED char *) iso_line( xx ));
		printf("%s", ex );
		ok++;
	}
  } 
 
  fclose(fp); 

  ansi2( "us", 0, 0 );
  printf("-------------------------------------------------------------------------------\n");
  ansi2( "me", 0, 0 );
}
