
/* ix/MBox (cdrom.c) by Volker Schuermann, 25.02.1994

   This C source code contains the following functions:

   #DD cd_download()      Download files from CDROM
   #CD cdrom()            Support command 'cdrom'
   #CN cdname()	          Make up a uniq name for every CDROM
   #CB cdromB()           Treat CDROM as a normal newsgroup

   Contact <volkers@unnet.wupper.de> for help! */











#ifndef _ESTDIO
#include <stdio.h>
#else
#include <estdio.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <dirent.h>
#include <signal.h>

#include <errno.h>

#include "mbox.h"


#define MAX_CDDRIVES	10




/* #DD - Download files from a CDROM device */

cd_download( f )
UNSIGNED char f[];
{
  pd( f, f );
  printf("\n");
  ansi2( "mr", 0, 0 );
  printf(" Taste! ");
  ansi2( "me", 0, 0 );
  
  (void) getch();
}


/* #CD - The command "cdrom" ... */

void cdrom( arg ) 
UNSIGNED char arg[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char r[MAX_CDDRIVES][STRING];

  FILE *fp;

  DIR *dp;
  struct dirent *actdir;

  int x, a, i;
  int intro = 0;
  int status = 0;
  int y = 0;
  int ENDE = 0;
  int HAVE_DIR = 0;
  int IS_MOUNTED = 0;
  
  struct stat fst;


  headline( CDR01_MSG );
  printf("\n");

  sprintf(s, "%s/cdrom/cdrom.mnt", HOME );
  fp = fopen( s, "r" );
  if(fp == NULL){
	nerror("cdrom.c", 58, "cdrom", "Can't read", s);
	return; 
  }
  a = 1;
  while((fgets(s, STRING, fp) != 0) && (a < MAX_CDDRIVES)){
	if(s[0] >= '/'){
		strcpy(r[a], (UNSIGNED char *) stripped(s));
		a++;
	}
  }
  fclose(fp); 

  if(a < 3){
	strcpy(t, r[1]);   
  }
  else{
	x = 0;

	for(i = 1; i < a; i++){

		ansi2( "md", 0, 0 );
		sprintf(s, "<%s>", r[i]);	
  		printf("%-15s", s);
		ansi2( "me", 0, 0 );

		x++;
		if(x == 5){ 
			printf("\n");
			x = 0;
		}
	}

       	if(x != 0) printf("\n");

	do{
		printf("\n");

		ansi2( "mr", 0, 0 );
		printf("[CDROM] %s", CDR02_MSG);
		ansi2( "me", 0, 0 );
		printf(" ");

		strcpy(s, (UNSIGNED char *) getline( 70, 1, ' ', "") );

		if(s[0] == '\0'){
			printf("\n");
			return;
		}
		if(s[0] != '/'){
			sprintf(t, "/%s", s);
			strcpy(s, (UNSIGNED char *) t);
		}

		status = chdir( s );

		if(status != 0){
			printf("\n\n%s <%s> %s\n", CDR03_MSG, s, CDR04_MSG);
		}

	}while(status != 0);

	chdir( HOME );	

	strcpy(t, (UNSIGNED char *) stripped(s));
  }


  headline( CDR01_MSG );
  printf("\n"); 

  do{
	RESHOW:
	
        x = 0; y = 0; ENDE = 0; HAVE_DIR = 0; IS_MOUNTED = 0;

	dp = opendir( t );
 	if(dp == NULL){
		printf("%s\n", CDR05_MSG);	
		chdir( HOME );	
		return;
	}
	readdir(dp);
	readdir(dp);
	while(((actdir = readdir(dp)) != NULL) && (!ENDE)){
		sprintf(s, "%s/%s", t, actdir->d_name);
		stat(s, &fst);

		IS_MOUNTED++;

		if(intro == 0){
			intro++;
			sprintf(f, "%s/cdrom/%ld", HOME, fst.st_atime);
			if((arg[0] == '$') && (USER.level >= ADMIN_LEV)){
				security_ed( f );
				closedir(dp);	
				return;
			}
			fp = fopen( f, "r" );
			if(fp != NULL){
				ansi2( "us", 0, 0 );
				show_raw( f, 0 );
				ansi2( "me", 0, 0 );
				printf("\n");
			}
			else{
				fp = fopen( f, "w" );
				fprintf(fp, "Tell your sysop to do an update here!");
			}	
			fclose(fp);
		}

		if(fst.st_mode & S_IFDIR){
			ansi2( "md", 0, 0 );
			sprintf(s, "<%s>", actdir->d_name);	
 	 		printf("%-15s", s);
			ansi2( "me", 0, 0 );
			HAVE_DIR++;
		}
		else printf("%-15s", actdir->d_name);
		x++;
		if(x == 5){ 
			printf("\n");
			x = 0;
			y++;
			if(y >= MAX_SCR_LINES){
				if(more() == -1) ENDE++;
				y = 2;					
			}
		}	
	}
	closedir(dp);

	if(IS_MOUNTED == 0){
		printf("%s %s\n", CDR03_MSG, CDR04_MSG);
		chdir( HOME );	
		return;
 	}
	
	printf("\n");
        if(x != 0) printf("\n");


 	do{
		
		ansi2( "mr", 0, 0 );
		if(HAVE_DIR == 0)
			printf("[CDROM] %s", CDR01aMSG);
		else
			printf("[CDROM] %s", CDR02_MSG);
		ansi2( "me", 0, 0 );
		printf(" ");

		strcpy(s, (UNSIGNED char *) getline( 70, 1, ' ', "") );
		if(s[0] == '?'){
			help( "#CDROM" );
  			headline( CDR01_MSG );
  			printf("\n"); 
			goto RESHOW;
		}	

		strcpy(s, (UNSIGNED char *) stripped( s ));
		if(sgrep( s, " " ) != 0){
			ansi2( "md", 0, 0 );
			printf(" <- %s\n", CDR02aMSG);
			ansi2( "me", 0, 0 );
			strcpy(s, "?");	
		}

		if((sgrep( s, "..") != 0) || (sgrep( s, "/") != 0)){
			ansi2( "md", 0, 0 );
			printf(" <- %s\n", CDR02bMSG);
			ansi2( "me", 0, 0 );
			s[0] = '?';	
		}

	}while(s[0] == '?');

        if(s[0] != '\0'){

		sprintf(f, "[CDROM:] %s (%s)", s, t);
		control( f, 3 );

		sprintf(f, "%s/%s", t, s );
		a = stat(f, &fst);
		if((fst.st_mode & S_IFDIR) && (a == 0)){ 	/* SUBDIRECTORY */
			strcpy(t, (UNSIGNED char *) f); 
		}					
		else{					/* FILE FOR DOWNLOAD */
			cd_download( f );							
		}
		sprintf(f, " CDROM - [%s] - %s ", t, CDR07_MSG ); 
  		headline( f );
		printf("\n");
	}

  }while(s[0] != '\0');		

  chdir( HOME );

  printf("\n"); 
}



/* #CN - Make up a uniq name for every CDROM */

UNSIGNED char *cdname()
{
  FILE *fp;

  DIR *dp;
  struct dirent *actdir;
  UNSIGNED char s[STRING];
  int i;
  struct stat fst;
  long atime;
 

  strcpy(s, (UNSIGNED char *) BRETT);
  i = 2;
  while(s[i] != '\0'){
	if(s[i] == '/'){
		s[i] = '\0';
	}
	i++;
  }

  dp = opendir( s );
  if(dp == NULL){
	printf("%s\n", CDR05_MSG);	
	chdir( HOME );	
	return;
  }
  readdir(dp);
  readdir(dp);
  actdir = readdir(dp);
  strcat(s, (UNSIGNED char *) "/");
  strcat(s, (UNSIGNED char *) actdir->d_name);
  stat(s, &fst);
  atime = (long) fst.st_atime;

  if (atime < 50000000L){
	return (UNSIGNED char *) "0";
  }

  sprintf(s, "%s/cdrom/%ld.dir", HOME, atime);
  if(mkdir( s, 0777 ) == 0){
	sprintf(s, "%s/cdrom/%ld", HOME, atime);
	fp = fopen( s, "w" );
	fprintf(fp, "BRANDNEW CDROM!\n\nTell your sysop to update <%s/cdrom/%ld> pretty soon!\n", HOME, atime);
	fclose(fp);
  }
  sprintf(s, "%ld", atime);

  return (UNSIGNED char *) s;
}





int buzz;

void busy()
{
  UNSIGNED char s[6];

  /*
  strcpy(s, "*|/-\\");

  if(buzz < 1) buzz = 1;
  if(buzz > 4) buzz = 1;

  printf("%c%c%c)", BS, BS, s[buzz]);
  buzz++;
  */

  if(buzz < 1) buzz = 1;
  if(buzz > 4) buzz = 1;

  printf("%c%c%c%c%c%c%c", BS, BS, BS, BS, BS, BS, BS);

  switch(buzz){
	case 1 : printf("I     I");
		 break;
	case 2 : printf(" I   I ");
		 break;
	case 3 : printf("  I I  ");
		 break;
	case 4 : printf("   I   ");
		 break;
  }

  buzz++;
}


/* #CB - Treat a CDROM device like a usual newsgroup */

void cdromB( group, mode )
UNSIGNED char group[];
char mode;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char n[STRING];
  UNSIGNED char d[STRING];
  UNSIGNED char g[STRING];

  FILE *ff;
  FILE *fp;
  FILE *bbs;

  DIR *dp;
  struct dirent *actdir;
 
  struct stat fst;

  int i, a;
  int OK = 0;
  int IS_DIR = 0;


  if(mode == 'I'){

	if((strcomp(NG, "cdrom") == 0) || (strcomp(NG, "cdrom2") == 0)){
		printf("\n");
		ansi2( "us", 0, 0 );
		strcpy(t, (UNSIGNED char *) cdname());
		if(atol(t) < 1L){
			printf("%s <%s> %s\n", CDR03_MSG, NG, CDR04_MSG);
			return;
		}
		sprintf(s, "%s/cdrom/%s", HOME, t);
		show_raw( s, 0 );
		ansi2( "me", 0, 0 );
        }	

	
#ifndef _NOCDINDEX

	i = 0;
	while((NG[i] != '\0') && (NG[i] != '.')) i++;
	if(i != strlen(NG)){
		strcpy(s, (UNSIGNED char *) strcopy(NG, (i + 1), strlen(NG)));
	}
		else strcpy(s, (UNSIGNED char *) NG);
	strcpy(t, (UNSIGNED char *) shortname( s ));
	strcpy(f, (UNSIGNED char *) cdname());
	sprintf(s, "%s/cdrom/%s.dir/%s", HOME, f, t);
	
	fp = fopen( s, "r" );
	if(fp != NULL){
		fclose(fp);
		OK = 0; IS_DIR = 0;
		strcpy(INHALT, (UNSIGNED char *) s);
		printf("\n");
		goto QUICKIE;
	}

#endif	/* _NOCDINDEX */

	sprintf(d, "%s/%s/CDDIR.%d", HOME, TMP, getpid());
	fp = fopen(d, "w" );
	if(fp == NULL){
		nerror("cdrom.c", 299, "cdromB", "Can't write to", d);
	}

 	sprintf(s, "%s", (UNSIGNED char *) strcopy(group, 1, strlen(group)));
	i = 0;
	while(s[i] != '\0'){
		if(s[i] == '/') s[i] = '.';
		i++;
	}
	fprintf(fp, "%s.DIR  30001200  221 y\n", s);

	sprintf(g, "%s/%s/CDJNK.%d", HOME, TMP, getpid());
	ff = fopen(g, "w" );
	if(ff == NULL){
		nerror("cdrom.c", 305, "cdromB", "Can't write to", g);
	}
	fprintf(ff, "INDEX CDROM (JUNK)\n==================\n");

  	sprintf(t, "%s", group);
	dp = opendir( t );
 	if(dp == NULL){
		printf("%s\n", CDR05_MSG);	
		chdir( HOME );	
		return;
	}

	printf("\n%s ", CDR09_MSG);
	/*
	ansi2( "md", 0, 0 );
	printf("(*)");
	*/ 
	ansi2( "mr", 0, 0 );
	printf("I     I");

	a = 1000;
	readdir(dp);
	readdir(dp);
	while((actdir = readdir(dp)) != NULL){
		sprintf(s, "%s/%s", group, actdir->d_name);

		busy();

		stat(s, &fst);

		if(fst.st_mode & S_IFDIR){
			sprintf(s, "%s.%s", group, actdir->d_name);
			i = 0;
			while(s[i] != '\0'){
				s[i] = s[i+1];
				if(s[i] == '/') s[i] = '.';
				i++;
			}
			fprintf(fp, "%s  30001200  221 y\n", s);
			IS_DIR++;	
		}
		else{
			strcpy(n, (UNSIGNED char *) actdir->d_name);
			t[0] = '\0';
			fprintf(ff, "%-5d %-20.20s  %-43.43s  %ld\n", a, n, t, (int) (fst.st_size / 1024));
			a++;	
		}
	}	
	closedir(dp);
	fclose(fp);
	fclose(ff);

	ansi2( "me", 0, 0 );

	if(IS_DIR) goto DIR_EXIT;

	printf("%c%s ", CR, CDR10_MSG);
	/*
	ansi2( "md", 0, 0 );
	printf("(*)");
	*/
	ansi2( "mr", 0, 0 );
	printf("I     I");

	sprintf(f, "%s/%s/CDIDX.%d", HOME, TMP, getpid());
	fp = fopen(f, "w" );
	if(fp == NULL){
		nerror("cdrom.c", 367, "cdromB", "Can't write to", f);
	}
	fprintf(fp, "CDROM INDEX\n===========\n");

	sprintf(s, "%s/files.bbs", group);
	bbs = fopen(s, "r" );
	if(bbs == NULL){
		sprintf(s, "%s/00_index.txt", group);
		bbs = fopen(s, "r" );
		if(bbs == NULL){
			sprintf(s, "%s/index", group);
			bbs = fopen(s, "r" );
			if(bbs == NULL){
				sprintf(s, "%s/INDEX", group);
				bbs = fopen(s, "r" );
			}
		}
	}
	if(bbs != NULL){
		a = 1000;
		
		fgets(s, STRING, bbs);
		fgets(s, STRING, bbs);
		if(s[0] >= 'A') rewind(bbs);
	
		while(fgets(s, STRING, bbs) != NULL){

			busy();

			if(s[0] > ' '){
				i = 0;
				while((s[i] != ' ') && (s[i] != TAB) && (s[i] != '\0')){
					if((s[i] >= 'A') && (s[i] <= 'Z')) s[i] += 32;
					i++;
				}
				strcpy(n, (UNSIGNED char *) s);
				n[i] = '\0';

				sprintf(t, "%s/%s", group, n);
				stat(t, &fst);

				strcpy(t, (UNSIGNED char *) stripped(strcopy(s, i, strlen(s)))); 	
	
				fprintf(fp, "%-5d %-20.20s  %-43.43s  %ld\n", a, n, t, (int) (fst.st_size / 1024));
				a++;
			}
		}
		fclose(bbs);
		OK++;
	}
	fclose(fp);
	
	ansi2( "me", 0, 0 );


	DIR_EXIT:

	if(OK != 0){
		strcpy(INHALT, (UNSIGNED char *) f);
	}
	else{
		if(IS_DIR != 0)
			INHALT[0] = '\0';
		else
			strcpy(INHALT, (UNSIGNED char *) g);
	}

	i = 0;
	while((NG[i] != '\0') && (NG[i] != '.')) i++;
	if(i != strlen(NG)){
		strcpy(s, (UNSIGNED char *) strcopy(NG, (i + 1), strlen(NG)));
	}
		else strcpy(s, (UNSIGNED char *) NG);
	strcpy(t, (UNSIGNED char *) shortname( s ));
	strcpy(f, (UNSIGNED char *) cdname());
	sprintf(s, "%s/cdrom/%s.dir/%s", HOME, f, t);


#ifndef _NOCDINDEX

	if((IS_DIR == 0) && (strcomp(t, "cdrom") != 0) && (strcomp(t, "cdrom2") != 0)){
		fp = fopen( INHALT, "r" );
		ff = fopen( s, "w" );
		if(ff == NULL){
			nerror("cdrom.c", 497, "cdromB", "Can't write to", s);
		}
		while(fgets(s, STRING, fp) != 0){
			fputs(s, ff);
		}
		fclose(ff);
		fclose(fp);
	}

#endif	/* _NOCDINDEX */

	QUICKIE:

	clearline();
	ansi2( "up", 0, 0 );	
  }			/* End of INDEX Building */


  if(mode == 'L'){	/* Download CDROM Files */

        download( group );
  }

  chdir( HOME ); 
}
