/* ix/MBox/WENDY (misc.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:
 
   #BS blockset()              reformat text        
   #IS insert_file()           insert a file into the text
   #RS right_stipped()         strip of junk trailing text lines
   #HP help()                  display help text
   #IN insert()                insert char/block/line
   #EN enter()                 process <ENTER> key
   #VI vi()                    fake "VI" commands
   #PU pgup()                  one page backwards
   #PD pgdn()                  one page forwards
   #CE center()                reformat text
   #LE lines_end()             process <END> key
   #WW wordwarp()              handle text running over at eoln

   Contact <volkers@unnet.wupper.de> for help! */












#include "wendy.h"


unsigned char *right_stripped();



/* #BS - reformat text line */

blockset()
{
  FILE *fp;

  unsigned char s[STRING];
  unsigned char a[STRING];
  unsigned char q[LONGSTRING];

  int i, j = 0, l;
  int WIDE = MAXX;
  int whitespace = 1;

  
  strcpy(s, (unsigned char *) SCREEN[y]); l = strlen((unsigned char *) right_stripped(s));

  if(l < ((WIDE / 10) * 8)) return;

  while(l < WIDE){
	i = 0; whitespace = 1;

	while((l < WIDE) && (i < WIDE)){
		if(SCREEN[y][i] != BLANK) whitespace = 0;
		if(whitespace == 1){
			i++;
			continue;
		}
		strcpy(s, (unsigned char *) SCREEN[y]);
		strcpy(a, (unsigned char *) ATTRIB[y]);

		if(isin(".!?,;:", SCREEN[y][i]) != 0){
			if((WIDE - l - 3) > 0){
				i++;
				SCREEN[y][i] = '\0';
				strcat(SCREEN[y], (unsigned char *) "   ");
				strcat(SCREEN[y], (unsigned char *) strcopy(s, i, l));
				ATTRIB[y][i]   = ATTRIB[y][i-1];
				ATTRIB[y][i+1] = ATTRIB[y][i-1];
				ATTRIB[y][i+2] = ATTRIB[y][i-1];
				ATTRIB[y][i+3] = '\0';
				strcat(ATTRIB[y], (unsigned char *) strcopy(a, i, l));				
				i += 2;
			}
		}
		if(SCREEN[y][i] == BLANK){
			i++;
			SCREEN[y][i] = '\0';
			strcat(SCREEN[y], (unsigned char *) " ");
			strcat(SCREEN[y], (unsigned char *) strcopy(s, i, l));
			ATTRIB[y][i] = ATTRIB[y][i-1];
			ATTRIB[y][i+1] = '\0';
			strcat(ATTRIB[y], (unsigned char *) strcopy(a, i, l));				
		}
		i++;
		strcpy(q, (unsigned char *) SCREEN[y]);
		l = strlen((unsigned char *) right_stripped(q));
	}
  }
}



/* #IS - Insert a file into the text */

insert_file( t )
unsigned char t[];
{
  unsigned char s[STRING];
  unsigned char path[STRING];
  unsigned char tmp[STRING];
  int i = 0, ynow;

  FILE *fp, *ff;  

  while((t[i] != ' ') && (t[i] != '\0')) i++;
  strcpy(path, (unsigned char *) strcopy(t, (i+1), strlen(t)));

  fp = fopen( path, "r" );
  if(fp == 0){
#ifdef _LOCAL
	sprintf(t, " Datei <%s> nicht gefunden oder Zugriff verweigert. ", path);
#else
	sprintf(t, " File <%s> not found or no access rights. ", path);
#endif
	show_status( t );
        return;
  }

  sprintf(tmp, "/tmp/wendy.%d", getpid());

  ynow = ypos + y;

  restore_screen( ypos );

  ff = fopen( tmp, "w" );
  for(i = ynow; i <= lastline; i++){
	fprintf(ff, "%s\n", TEXT[i]);
  }
  fclose(ff);

  lastline = ynow;

  while(fgets(TEXT[lastline], LINELENGTH, fp) != 0) lastline++;
  fclose(fp);   

  fp = fopen( tmp, "r" );
  while(fgets(TEXT[lastline], LINELENGTH, fp) != 0) lastline++;
  fclose(fp);

  unlink( tmp );
 
  prep_screen( ypos );
  show_screen( START );
}



/* #RS - Strip of junk from the end of a text line */

unsigned char *right_stripped( s )
unsigned char s[];
{
  int i;
  
  i = strlen( (unsigned char *) s);

  while(((s[i] < 33) || (s[i] == BLANK)) && (i > -1)) i--;
  i++;
  s[i] = '\0';

  return (unsigned char *) s;
}



/* #HP - Help! */

help()
{
  FILE *fp;
  unsigned char s[STRING];
  int c, i;

  restore_screen( ypos );

  ansi( "cl" );
  c = MAXY;
  MAXY = 0;
  show_status( VERSION ); /* !! */
  MAXY = c;

  i = START;

  fp = fopen( HILFE, "r" );
  if(fp == NULL){
#ifdef _LOCAL
	printf("\n\nDatei <%s> nicht gefunden!\n\n", HILFE);
#else
	printf("\n\nFile <%s> not found!\n\n", HILFE);
#endif
  }
  else{
	while(fgets(s, STRING, fp) != 0){
		ansi2( "cm", 1, i );
		printf("%s\n", right_stripped(s));	
		i++;
	}
	fclose(fp);
  }

  c = getch();

  ansi( "cl" );

  show_status( version );
  prep_screen( ypos );
  show_screen( START );
}





/* #IN - Insert a char/line/block */

insert( c )
unsigned char c;
{
  unsigned char s[STRING];
  unsigned char q[LONGSTRING];

  strcpy(q, (unsigned char *) SCREEN[y]);

  if(strlen((unsigned char *) right_stripped(q)) >= MAXX){
	printf("%c", 7);
	if(x >= MAXX) x = MAXX;
	ansi2( "cm", x, y );
	return;
  }

  if(c == ' ') c = BLANK;

  strcpy(s, (unsigned char *) SCREEN[y]);
  s[x] = '\0'; 
  s[(x-1)] = c; 
  strcpy(q, (unsigned char *) SCREEN[y]);
  strcat(s, (unsigned char *) right_stripped(strcopy(q, (x-1), strlen(q))));
  strcat(s, " ");
  s[MAXX] = '\0';	
  strcpy(SCREEN[y], (unsigned char *) s);

  strcpy(s, (unsigned char *) ATTRIB[y]);
  s[x] = '\0';
  s[(x-1)] = RTF_attrib;
  strcpy(q, (unsigned char *) ATTRIB[y]);
  strcat(s, (unsigned char *) right_stripped(strcopy(q, (x-1), strlen(q))));
  strcat(s, "0");
  s[MAXX] = '\0';	
  strcpy(ATTRIB[y], (unsigned char *) s);

  if(ansi( "ic") != 0){
	show_line( SCREEN[y], ATTRIB[y], x );
  }
  else{
	if(c == BLANK)
		printf(" ");
	else
		printf("%c", c);		
  }
  x++;
  ansi2( "cm", x, y );
}



/* #EN - Process the <ENTER> key */

enter()
{
  int i, j;
  int memo;
  int ymem = y;
  
  	
  if(FORMATTER == 'b'){
	blockset();
	ansi( "me" );
	show_line( SCREEN[y], ATTRIB[y], 1 );  
	activate( RTF_attrib );
  }
 
  if(INS_mode != 0){
	memo = SCREEN[y][x]; 
	SCREEN[y][x] = (126);
	restore_screen( ypos );
	j = ypos + y - 2;
        for(i = lastline; i > j; i--){
		strcpy(TEXT[i+1], (unsigned char *) TEXT[i]);
		FLAG[i+1] = FLAG[i];
	} 
	lastline++;

	i = 0; j++;
	while((TEXT[j][i] != (126)) && (TEXT[j][i] != '\0')) i++;
	TEXT[j][i] = memo;

	strcpy(TEXT[(j+1)], (unsigned char *) strcopy(TEXT[j], (i-1), strlen(TEXT[j])));
	TEXT[j][(i-1)] = '\0'; strcat(TEXT[j], (unsigned char *) "<nl>\n");

	prep_screen( ypos );
	ansi2( "cm", 1, MAXY );
	ansi( "ce" );
	ansi2( "cm", x, y );

	if(ansi( "al" ) != 0){
		show_screen( (y-1) );	
	}
	else{
		show_line( SCREEN[y], ATTRIB[y], 1);
		y++;
		show_line( SCREEN[y], ATTRIB[y], 1);
		y--;
	}
  }
  if(y < MAXY){
	lastline++;
	ansi( "do" );
	y++; 
  }
  else{
	ctrlj();
  }
  x = 1;
  ansi2( "cm", x, y );
}



/* #VI - Fake a few "VI" commands */ 

int vi( f )
unsigned char f[];
{
  unsigned char s[STRING];
  int mode = 0;
  int newp = 0;

  show_status( ":" );
  ansi( "mr" );
  strcpy(s, (unsigned char *) stripped( (unsigned char *) getline( 70, 1, 32, "" )));


  newp = atoi(s);
  if(newp > 0){
	restore_screen( ypos );	

	if(newp > (lastline - MAXY))
		ypos = (lastline - MAXY);
	else
		ypos = newp;

	y = START;

	prep_screen( ypos );
	show_screen( START );	 
  }

  ansi( "me" );

  if((strcomp(s, "w")    == 0) || (strcomp(s, "w!") == 0)) ctrlw( f );
  if(strcomp(s, "wq")    == 0) {
	ctrlw( f );
	mode = CTRL_X;
  }
  if(strcomp("set", s)     == 0) ctrls();
  if(strcomp("scan", s)    == 0) SCANTEST = 1;
  if(strcomp("quit", s)    == 0) SCANTEST = 0;
  if((strcomp(s, "q")      == 0) || (strcomp(s, "q!") == 0)){
	ctrlx( f );
	mode = CTRL_X;
  }
  if(strcomp(s, "i")       == 0) ctrlv();
  if(strcomp("r ", s)	   == 0) insert_file( s );
  if(strcomp(s, "b") 	   == 0) block_set();

  activate( RTF_attrib );
  ansi2( "cm", x, y );

  return mode;
}



/* #PU - Move one page backwards */

pgup()
{
  int oldypos = ypos;
  

  if((ypos - (MAXY -1)) > 1) 
	ypos -= (MAXY -1);
  else
	ypos = 1;

  if(ypos == oldypos) return;

  restore_screen( oldypos );
  prep_screen( ypos );
  show_screen( START );
}



/* #PD - Move one page forwards */

pgdn()
{
  int oldypos = ypos;

  if((ypos + (MAXY -1)) < (lastline - (MAXY -1))) 
	ypos += (MAXY -1);
  else
	ypos = lastline - MAXY;
  if(ypos < 1) ypos = 1;

  if(ypos == oldypos) return;

  restore_screen( oldypos );
  prep_screen( ypos );
  show_screen( START );
}




/* #CE - Reformat text line */

center()
{
  int i, j = strlen((unsigned char *) stripped(SCREEN[y]));

  unsigned char s[LONGSTRING];
  unsigned char t[STRING];
 

  i = (MAXX - j) / 2;
 
  strcpy(s, (unsigned char *) "                                                    ");
  s[i] = '\0'; strcat(s, (unsigned char *) stripped(SCREEN[y]));
  strcat(s, (unsigned char *) "                                                    ");
  s[MAXX] = '\0';
  strcpy(SCREEN[y], (unsigned char *) s);
 
  strcpy(ATTRIB[y], (unsigned char *) "00000000000000000000000000000000000000000000000000000000000000000000000000000000");
 
  show_line( SCREEN[y], ATTRIB[y], 1 );
  strcpy(s, (unsigned char *) SCREEN[y]);
  x = strlen( (unsigned char *) right_stripped(s)) + 1;
  FLAG[(ypos + y - 1)] |= is_centered;
  ansi2( "cm", x, y );
}
 


/* #LE - Move cursor to end of line */

lines_end()
{
  unsigned char s[STRING];

  strcpy(s, (unsigned char *) SCREEN[y]);
  x = strlen((unsigned char *) right_stripped(s)) + 1;
  if(x > MAXX) x = MAXX;
  ansi2( "cm", x, y );
}



/* #WW - Handle overrunning text a the end of a line */	

int wordwrap()
{
  unsigned char s[STRING];
  int i = MAXX -1, j = 0;
  int a = y;
  int b = y + 1;

  while((i > 1) && (j == 0)){
 	if((SCREEN[a][i] == BLANK) || (SCREEN[a][i] < 33)) j = i;
	i--;
  }

  if(j == 0) return 1;

  j++; x = 0;

  for(i = j; i <= MAXX; i++){
	SCREEN[b][x] = SCREEN[a][i];
	SCREEN[a][i] = BLANK;

	ATTRIB[b][x] = ATTRIB[a][i];
	ATTRIB[a][i] = '0';

	x++; 
  } 
  show_line( SCREEN[a], ATTRIB[a], 1 );
  y++;
  show_line( SCREEN[b], ATTRIB[b], 1 );  
  y = a;

  return x;
}
