/* ix/MBox/WENDY (ctrl.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #CG ctrlg()          display state
   #CH ctrlh()          process <BS> key
   #CV ctrlv()          process <INS> key
   #CJ ctrlj()          process <DOWN> cursor key
   #CK ctrlk()          process <UP> cursor key
   #CN ctrln()          insert RTF CONTENT line
   #CU ctrlu()          choose RTF attribute
   #CS ctrls()          change setup
   #CT ctrlt()          delete from cursor position to eoln
   #CW ctrlw()          save text
   #CX ctrlx()          quit session
   #CY ctrly()          delete a line

   Contact <volkers@unnet.wupper.de> for help! */




#include "wendy.h"
 
 

 
/* #CG - Display state of the session */ 
 
ctrlg( f )
unsigned char f[];
{
  unsigned char s[STRING];
  unsigned char t[STRING];
 
  t[0] = '\0';

#ifdef _LOCAL 
  if(INS_mode != 0)
	strcpy(t, (unsigned char *) " - Einfuege-Modus");
 
  sprintf(s, " %s - Spalte %d, Zeile %d (%d) %s", f, x, (ypos + y - 2), lastline, t);
#else
  if(INS_mode != 0)
	strcpy(t, (unsigned char *) " - Insert-Mode");
 
  sprintf(s, " %s - Column %d, Line %d (%d) %s", f, x, (ypos + y -1), lastline, t);
#endif
  show_status( s );
  activate( RTF_attrib );
  ansi2( "cm", x, y );
}
 
 
 
/* #CH - Process <BS> key */
 
ctrlh()
{
  unsigned char s[LONGSTRING];
  unsigned char a[LONGSTRING];
  unsigned char q[LONGSTRING];
  int i, j;
 
  if(x == 1){
	if(y == START) return;
	strcpy(s, (unsigned char *) SCREEN[y-1]);
	i = strlen((unsigned char *) right_stripped(s));
	strcpy(s, (unsigned char *) SCREEN[y]);
	j = strlen((unsigned char *) right_stripped(s));
 
	SCREEN[(y-1)][i] = '\0';
	ATTRIB[(y-1)][i] = '\0';
 
	strcpy(s, (unsigned char *) SCREEN[(y-1)]); strcat(s, (unsigned char *) SCREEN[y]);
	strcat(s, (unsigned char *) "                           ");
	strcpy(a, (unsigned char *) ATTRIB[(y-1)]); strcat(a, (unsigned char *) ATTRIB[y]);
	strcat(a, (unsigned char *) "0000000000000000000000000000000000000000000000000000000000000000000000000000000");
 
	strcpy(SCREEN[y], (unsigned char *) strcopy(s, MAXX, MAXX+MAXX));
	strcpy(ATTRIB[y], (unsigned char *) strcopy(a, MAXX, MAXX+MAXX));
 
	s[MAXX] = '\0'; strcpy(SCREEN[(y-1)], (unsigned char *) s);
	a[MAXX] = '\0'; strcpy(ATTRIB[(y-1)], (unsigned char *) a);

	strcpy(q, (unsigned char *) right_stripped(SCREEN[y]));

	if(strlen((unsigned char *) right_stripped(q)) < 1)
		ctrly();
	else
		show_line( SCREEN[y], ATTRIB[y], 1 );

	y--; x = i + 1;
	show_line( SCREEN[y], ATTRIB[y], x );
	ansi2( "cm", x, y );

	return;
  }
 
  strcpy(s, (unsigned char *) SCREEN[y]);
  s[(x-2)] = '\0';
  strcat(s, (unsigned char *) strcopy(SCREEN[y], (x-1), strlen(SCREEN[y])));
  strcat(s, "            ");
  s[MAXX] = '\0';
  strcpy(SCREEN[y], (unsigned char *) s);
 
  strcpy(s, (unsigned char *) ATTRIB[y]);
  s[(x-2)] = '\0';
  strcat(s, (unsigned char *) strcopy(ATTRIB[y], (x-1), strlen(ATTRIB[y])));
  strcat(s, "0000000000000000000000000000000000000000000000000000000000000000000000000000000");
  s[MAXX] = '\0';
  strcpy(ATTRIB[y], (unsigned char *) s);
 
  x--;
  ansi2( "cm", x, y );
 
  if(ansi( "dc" ) != 0){
        show_line( SCREEN[y], ATTRIB[y], x );
	ansi2( "cm", x, y );
  }
}
 
 
 
/* #CV - Process <INS> key */
 
ctrlv()
{
  if(INS_mode == 0){
        INS_mode = 1;
#ifdef _LOCAL
        show_status( " WENDY: Einfuegemodus aktiviert. " );
#else
	show_status( " WENDY: Insert mode activated. " );
#endif
  }
  else{
        INS_mode = 0;
#ifdef _LOCAL
        show_status( " WENDY: Einfuegemodus aus. " );
#else
	show_status( " WENDY: Insert mode deactivated. " );
#endif
  }
  ansi2( "cm", x, y );
}
 
 
 
/* #CJ - Process cursor <DOWN> key */
 
ctrlj()
{
  int ymem = y;

  if((y < MAXY) && (y < lastline)){
	ansi( "do" );
        y++;
	return;
  }

  if(ypos < (lastline - MAXY)){
        restore_screen( ypos );
        ypos++;
        prep_screen( ypos );


	ansi2( "cm", 1, START );


	if(ansi( "dl" ) != 0){
		show_screen( START );
	}
	else{
		y = MAXY;
		show_line( SCREEN[MAXY], ATTRIB[MAXY], 1 );
		y = ymem;
	}
	ansi2( "cm", x, y );
  }
}
 
 
 
/* #CK - Process cursor <UP> key */
 
ctrlk()
{
  if(y > START){
	ansi( "up" );
        y--;
	return;
  }

  if(ypos > 1){			/* 1(!), nicht START (!) */
        restore_screen( ypos );
        ypos--;
        prep_screen( ypos );


	ansi2( "cm", 1, MAXY );
	ansi( "ce" );
	ansi2( "cm", x, y );


	if(ansi( "al" ) != 0){
		show_screen( START );
	}
	else{
		show_line( SCREEN[y], ATTRIB[y], 1);
		ansi2( "cm", x, y );
	}
  }
}
 
 
 

/* #CN - Insert a RTF "Content:" line */
 
ctrln()
{
  if(RTF_toggle == 0){
	FLAG[(ypos + y - 1)] &= ~is_plain;
	FLAG[(ypos + y - 1)] |=  is_richtext;
#ifdef _LOCAL
	show_status( "Der folgende Text wird klassifiziert als 'text/richtext'." );
#else
	show_status( "The following text is classified as 'text/richtext'." );
#endif
        RTF_toggle++;
  }
  else{
	FLAG[(ypos + y - 1)] &= ~is_richtext;
	FLAG[(ypos + y - 1)] |=  is_plain;
#ifdef _LOCAL
	show_status( "Der folgende Text wird klassifiziert als 'text/plain'." );
#else
	show_status( "The following text is classified as 'text/plain'." );
#endif
        RTF_toggle = 0;
  }
  activate( RTF_attrib );
  ansi2( "cm", x, y );
}

 
 

ctrlu_output()
{
  ansi( "me"); ansi( "us" );

  if(RTF_attrib == 'b'){
	ansi2( "cm", 8,  1 ); printf("B");	
  }
  if(FORMATTER == 'c'){
	ansi2( "cm", 16, 1 ); printf("C");	
  }
  if(RTF_attrib == 'f'){
	ansi2( "cm", 26, 1 ); printf("F");	
  }
  if(RTF_attrib == 'i'){
	ansi2( "cm", 35, 1 ); printf("I");	
  }
  if(RTF_attrib == '0'){
	ansi2( "cm", 45, 1 ); printf("N");	
  }
  if(FORMATTER == 'b'){
	ansi2( "cm", 57, 1 ); printf("o");	
  }
  if(RTF_attrib == 'u'){
	ansi2( "cm", 67, 1 ); printf("U");	
  }  

  ansi( "mr" );
  if(RTF_attrib != 'b'){
	ansi2( "cm", 8,  1 ); printf("B");	
  }
  if(FORMATTER != 'c'){
	ansi2( "cm", 16, 1 ); printf("C");	
  }
  if(RTF_attrib != 'f'){
	ansi2( "cm", 26, 1 ); printf("F");	
  }
  if(RTF_attrib != 'i'){
	ansi2( "cm", 35, 1 ); printf("I");	
  }
  if(RTF_attrib != '0'){
	ansi2( "cm", 45, 1 ); printf("N");	
  }
  if(FORMATTER != 'b'){
	ansi2( "cm", 57, 1 ); printf("o");	
  }
  if(RTF_attrib != 'u'){
	ansi2( "cm", 67, 1 ); printf("U");	
  }  

}
 

/* #CU - Choose RTF attribute */

ctrlu()
{
  int c;
 
  show_status( " RTF: <B>old  <C>enter  <F>lash  <I>talic  <N>ormal  Bl<o>ckset  <U>nderline " );

  REALLY++;

  do{
	ctrlu_output();
  	ansi2( "cm", 45, 1 );
	c = getch();
	if(c == ESC){
		do{
			c = getch();
		}while(c < 65);
		c = getch();
#ifdef _LOCAL
		show_status( " WENDY: Noe, Auswahl per Cursortaste ist noch nicht implementiert ;-) ");
#else
		show_status( " WENDY: Nope! Selection by cursor keys' not implemented yet!" );
#endif
		activate( RTF_attrib );
		ansi2( "cm", x, y );
		return;
 	}

	switch(c){
		case 'b' :
		case 'B' : 	if(RTF_attrib == 'b') 
					RTF_attrib = '0';
				else
					RTF_attrib = 'b';
				break;
		case 'c' :
		case 'C' :	if(FORMATTER == 'c')
					FORMATTER = 0;
				else
					FORMATTER = 'c';
				break;
		case 'f' :
		case 'F' :	if(RTF_attrib == 'f')
					RTF_attrib = '0';
				else
					RTF_attrib = 'f';
				break;
		case 'i' :
		case 'I' :	if(RTF_attrib == 'i')
					RTF_attrib = '0';
				else
					RTF_attrib = 'i';
				break;
		case 'n' :
		case 'N' :	FORMATTER = 0;
				RTF_attrib = '0';
				break;
		case 'o' :
		case 'O' :	if(FORMATTER == 'o')
					FORMATTER = 0;
				else
					FORMATTER = 'b';
				break;
		case 'u' :
		case 'U' :	if(RTF_attrib == 'u')
					RTF_attrib = '0';
				else
					RTF_attrib = 'u';
				break;
		
	}	
  }while(isin("bBcCfFiIoOuU") != 0);

  ctrlu_output();

  if(BLOCK.status == BLOCKMODE) block_ctrlu();

  activate( RTF_attrib );
  ansi2( "cm", x, y );
}
 
 
 



ctrls_output()
{
  if(MAXX <  10) MAXX =  10;
  if(MAXX > 136) MAXX = 136;
  if(MAXY <   4) MAXY =   4;
  if(MAXY >  24) MAXY =  24;

  ansi( "me" );
#ifdef _LOCAL
  ansi2( "cm", 25,  5); printf("%d  ", MAXX);
  ansi2( "cm", 25,  7); printf("%d  ", MAXY);

  ansi2( "cm", 67,  5); printf("%s           ", terminal);
  ansi2( "cm", 67,  7); printf("%s           ", umlaut);
#else
  ansi2( "cm", 27,  5); printf("%d  ", MAXX);
  ansi2( "cm", 27,  7); printf("%d  ", MAXY);

  ansi2( "cm", 66,  5); printf("%s           ", terminal);
  ansi2( "cm", 66,  7); printf("%s           ", umlaut);
#endif
}

/* #CS - Change setup */
 
ctrls()
{
  FILE *fp;
  unsigned char s[STRING];
  unsigned char *home;
  int c, d;


  restore_screen( ypos );
  ansi( "cl" );

#ifdef _LOCAL

  show_status( " WENDY: Parameter aendern ... " );
  
  ansi2( "cm",  1,  3 ); printf("Aktive Parameter:");

  ansi( "mr" );
  ansi2( "cm",  1,  5 ); printf(" 1 ");
  ansi2( "cm",  5,  5 ); printf(" Zeichen pro Zeile " );
  ansi2( "cm",  1,  7 ); printf(" 2 ");
  ansi2( "cm",  5,  7 ); printf(" Anzahl der Zeilen " );

  ansi2( "cm", 40,  5 ); printf(" 3 ");
  ansi2( "cm", 44,  5 ); printf(" Terminal-Emulation   " );
  ansi2( "cm", 40,  7 ); printf(" 4 " );
  ansi2( "cm", 44,  7 ); printf(" Umlaut-Konvertierung " );

  ansi( "me" );
  ansi2( "cm",  1, 10); printf("Vordefinierte Konfigurationen:");
  
  ansi( "mr" );
  ansi2( "cm",  1, 12); printf(" 5 ");
  ansi2( "cm",  5, 12); printf(" UNIX (Console)          ");
  ansi2( "cm",  1, 14); printf(" 6 ");
  ansi2( "cm",  5, 14); printf(" LINUX (Console)         ");
  ansi2( "cm",  1, 16); printf(" 7 ");
  ansi2( "cm",  5, 16); printf(" DOS (ProComm ab 2.4.1)  ");
  
  ansi2( "cm", 40, 12); printf(" 8 ");
  ansi2( "cm", 44, 12); printf(" DOS (TELIX ab 3.11)      ");
  ansi2( "cm", 40, 14); printf(" 9 ");
  ansi2( "cm", 44, 14); printf(" DOS (Telemate ab 2.11)   ");

  ctrls_output();
 
  do{
        ansi2( "cm", 1, 19); printf("Nun, was soll's denn sein?      ");
	ansi2( "cm", 28, 19 );
	c = getch();
	ansi2( "cm", 1, 19 );
	switch(c){
		case '1' :	ansi( "ce" );
				printf("Zeichen pro Zeile (10-136): ");
				sprintf(s, "%d", MAXX);
				strcpy(s, (unsigned char *) getline( 3, 1101, '.', s));
				MAXX = atoi(s);
				break;
		case '2' :	ansi( "ce" );
				printf("Bildschirmzeilen (4-24): ");
				sprintf(s, "%d", MAXY);
				strcpy(s, (unsigned char *) getline( 2, 1101, '.', s));
				MAXY = atoi(s);
				break;
		case '3' :	ansi( "mr" );
				ansi2( "cm",  1, 21); printf(" A ");
				ansi2( "cm",  5, 21); printf(" ANSI (X3.64)  ");
				ansi2( "cm", 30, 21); printf(" B ");
				ansi2( "cm", 34, 21); printf(" DEC VT100     "); 
				ansi2( "cm", 60, 21); printf(" C ");
				ansi2( "cm", 64, 21); printf(" MINIX CONSOLE ");
				ansi( "me" );

				ansi2( "cm", 1, 19 ); ansi( "ce" );
				printf("Terminal-Emulation (A-C): ");

				do{
					d = getch();
				}while(isin("abcABC", d) == 0);
	
				switch(d){
					case 'a' :
					case 'A' :	strcpy(terminal, (unsigned char *) "ansi");
							break;
					case 'b' :
					case 'B' :	strcpy(terminal, (unsigned char *) "vt100");
							break;
					case 'c' :
					case 'C' :	strcpy(terminal, (unsigned char *) "minix");
							break;
				}		
				ansi2( "cm",  1, 21); ansi( "ce" );	
				break;
		case '4' :	ansi( "mr" );
				ansi2( "cm",  1, 21); printf(" A ");
				ansi2( "cm",  5, 21); printf(" ISO-8859-1  ");
				ansi2( "cm", 30, 21); printf(" B ");
				ansi2( "cm", 34, 21); printf(" IBM-Umlaute "); 
				ansi( "me" );

				ansi2( "cm", 1, 19 ); ansi( "ce" );
				printf("Umlaut-Konvertierung (A-B): ");

				do{
					d = getch();
				}while(isin("abAB", d) == 0);
	
				switch(d){
					case 'a' :
					case 'A' :	strcpy(umlaut, (unsigned char *) "iso-8859-1");
							break;
					case 'b' :
					case 'B' :	strcpy(umlaut, (unsigned char *) "ibm");
							break;
				}		
				ansi2( "cm",  1, 21); ansi( "ce" );	
				break;
		case '5' :	MAXX = 80;
				MAXY = 24;
				wBS = 127; wDEL = 9151; wINS = 9150; wEND = 9152;
				strcpy(terminal, (unsigned char *) "vt100");
				strcpy(umlaut, (unsigned char *) "iso-8859-1");	
				break;
		case '6' :	MAXX = 80;
				MAXY = 24;
				wBS = 127; wDEL = 9151; wINS = 9150; wEND = 9152; 
				strcpy(terminal, (unsigned char *) "ansi-color");
				strcpy(umlaut, (unsigned char *) "iso-8850-1");	
				break;
		case '7' :	MAXX = 79;
				MAXY = 24;
				wBS = 8; wDEL = 9152; wINS = 9151; wEND = 9189;
				strcpy(terminal, (unsigned char *) "ansi");
				strcpy(umlaut, (unsigned char *) "ibm");	
				break;
		case '8' :	MAXX = 80;
				MAXY = 24;
				wBS = 8; wDEL = 9152; wINS = 9151; wEND = 9189;
				strcpy(terminal, (unsigned char *) "ansi");
				strcpy(umlaut, (unsigned char *) "ibm");	
				break;
		case '9' :	MAXX = 80;
				MAXY = 23;
				wBS = 8; wDEL = 9152; wINS = 9151; wEND = 9189;
				strcpy(terminal, (unsigned char *) "ansi");
				strcpy(umlaut, (unsigned char *) "ibm");	
				break;
	}
	ctrls_output();
  }while(isin("123456789", c) != 0);

  home = (unsigned char *) getenv( "HOME" );
  sprintf(s, "%s/.wendy", home);
  fp = fopen( s, "w" );
  if(fp != 0){
	fprintf(fp, "%d%c%c%c# Anzahl der Zeilen (4-24)\n", MAXY, TAB, TAB, TAB);
	fprintf(fp, "%d%c%c%c# Anzahl der Zeichen pro Zeile (10-136)\n", MAXX, TAB, TAB, TAB);
	fprintf(fp, "%s%c%c%c# Terminal-Emulation (ANSI, VT100, MINIX)\n", terminal, TAB, TAB, TAB);
 	fprintf(fp, "%s%c%c%c# Umlaut-Konvertierung (IBM, ISO-8859-1)\n", umlaut, TAB, TAB, TAB);
	fprintf(fp, "%d%c%c%c# BS Taste (8 o. 127)\n", wBS, TAB, TAB, TAB);
	fprintf(fp, "%d%c%c%c# DEL Taste\n", wDEL, TAB, TAB, TAB);
	fprintf(fp, "%d%c%c%c# INS Taste\n", wINS, TAB, TAB, TAB);
	fprintf(fp, "%d%c%c%c# END Taste\n", wEND, TAB, TAB, TAB);
	fclose(fp);
  }  

#else

  show_status( " WENDY: Changing settings ... " );
  
  ansi2( "cm",  1,  3 ); printf("Active Settings:");

  ansi( "mr" );
  ansi2( "cm",  1,  5 ); printf(" 1 ");
  ansi2( "cm",  5,  5 ); printf(" Characters per Line " );
  ansi2( "cm",  1,  7 ); printf(" 2 ");
  ansi2( "cm",  5,  7 ); printf(" Number of Lines     " );

  ansi2( "cm", 40,  5 ); printf(" 3 ");
  ansi2( "cm", 44,  5 ); printf(" Terminal-Emulation  " );
  ansi2( "cm", 40,  7 ); printf(" 4 " );
  ansi2( "cm", 44,  7 ); printf(" 'Umlaut'-Conversion " );

  ansi( "me" );
  ansi2( "cm",  1, 10); printf("Predefined Settings:");
  
  ansi( "mr" );
  ansi2( "cm",  1, 12); printf(" 5 ");
  ansi2( "cm",  5, 12); printf(" UNIX (Console)          ");
  ansi2( "cm",  1, 14); printf(" 6 ");
  ansi2( "cm",  5, 14); printf(" MINIX (Console)         ");
  ansi2( "cm",  1, 16); printf(" 7 ");
  ansi2( "cm",  5, 16); printf(" DOS (ProComm 2.4.1)     ");
  
  ansi2( "cm", 40, 12); printf(" 8 ");
  ansi2( "cm", 44, 12); printf(" DOS (TELIX  3.11)       ");
  ansi2( "cm", 40, 14); printf(" 9 ");
  ansi2( "cm", 44, 14); printf(" DOS (Telemate 2.11)     ");

  ctrls_output();
 
  do{                                                            
        ansi2( "cm", 1, 19); printf("Now, which one do you want ?    ");
	ansi2( "cm", 30, 19 );
	c = getch();
	ansi2( "cm", 1, 19 );
	switch(c){
		case '1' :	ansi( "ce" );
				printf("Characters per line (10-136): ");
				sprintf(s, "%d", MAXX);
				strcpy(s, (unsigned char *) getline( 3, 1101, '.', s));
				MAXX = atoi(s);
				break;
		case '2' :	ansi( "ce" );
				printf("Screenlines (4-24): ");
				sprintf(s, "%d", MAXY);
				strcpy(s, (unsigned char *) getline( 2, 1101, '.', s));
				MAXY = atoi(s);
				break;
		case '3' :	ansi( "mr" );
				ansi2( "cm",  1, 21); printf(" A ");
				ansi2( "cm",  5, 21); printf(" ANSI (X3.64)  ");
				ansi2( "cm", 30, 21); printf(" B ");
				ansi2( "cm", 34, 21); printf(" DEC VT100     "); 
				ansi2( "cm", 60, 21); printf(" C ");
				ansi2( "cm", 64, 21); printf(" MINIX CONSOLE ");
				ansi( "me" );

				ansi2( "cm", 1, 19 ); ansi( "ce" );
				printf("Terminal-Emulation (A-C): ");

				do{
					d = getch();
				}while(isin("abcABC", d) == 0);
	
				switch(d){
					case 'a' :
					case 'A' :	strcpy(terminal, (unsigned char *) "ansi");
							break;
					case 'b' :
					case 'B' :	strcpy(terminal, (unsigned char *) "vt100");
							break;
					case 'c' :
					case 'C' :	strcpy(terminal, (unsigned char *) "minix");
							break;
				}		
				ansi2( "cm",  1, 21); ansi( "ce" );	
				break;
		case '4' :	ansi( "mr" );
				ansi2( "cm",  1, 21); printf(" A ");
				ansi2( "cm",  5, 21); printf(" ISO-8859-1  ");
				ansi2( "cm", 30, 21); printf(" B ");
				ansi2( "cm", 34, 21); printf(" IBM-Conversion "); 
				ansi( "me" );

				ansi2( "cm", 1, 19 ); ansi( "ce" );
				printf("'Umlaut'-Conversions (A-B): ");

				do{
					d = getch();
				}while(isin("abAB", d) == 0);
	
				switch(d){
					case 'a' :
					case 'A' :	strcpy(umlaut, (unsigned char *) "iso-8859-1");
							break;
					case 'b' :
					case 'B' :	strcpy(umlaut, (unsigned char *) "ibm");
							break;
				}		
				ansi2( "cm",  1, 21); ansi( "ce" );	
				break;
		case '5' :	MAXX = 80;
				MAXY = 24;
				strcpy(terminal, (unsigned char *) "vt100");
				strcpy(umlaut, (unsigned char *) "iso-8859-1");	
				break;
		case '6' :	MAXX = 80;
				MAXY = 24;
				strcpy(terminal, (unsigned char *) "minix");
				strcpy(umlaut, (unsigned char *) "ibm");	
				break;
		case '7' :	MAXX = 79;
				MAXY = 24;
				strcpy(terminal, (unsigned char *) "ansi");
				strcpy(umlaut, (unsigned char *) "ibm");	
				break;
		case '8' :	MAXX = 80;
				MAXY = 24;
				strcpy(terminal, (unsigned char *) "ansi");
				strcpy(umlaut, (unsigned char *) "ibm");	
				break;
		case '9' :	MAXX = 80;
				MAXY = 23;
				strcpy(terminal, (unsigned char *) "ansi");
				strcpy(umlaut, (unsigned char *) "ibm");	
				break;
	}
	ctrls_output();
  }while(isin("123456789", c) != 0);

  home = (unsigned char *) getenv( "HOME" );
  sprintf(s, "%s/.wendy", home);
  fp = fopen( s, "w" );
  if(fp != 0){
	fprintf(fp, "%d%c%c%c# Number of lines (4-24)\n", MAXY, TAB, TAB, TAB);
	fprintf(fp, "%d%c%c%c# Characters per line (10-136)\n", MAXX, TAB, TAB, TAB);
	fprintf(fp, "%s%c%c%c# Terminal-Emulation (ANSI, VT100, MINIX)\n", terminal, TAB, TAB, TAB);
 	fprintf(fp, "%s%c%c%c# 'Umlaut'-Conversion (IBM, ISO-8859-1)\n", umlaut, TAB, TAB, TAB);
	fclose(fp);
  }  

#endif

  ansi( terminal, -1, -1 );

  ansi( "cl" );
  show_status( version );
  prep_screen( ypos );
  show_screen( START );
  x = 1; y = START;
  ansi2( "cm", x, y );
}
 
 
 
/* #CT - Delete from cursor position to eoln */
 
ctrlt()
{
  unsigned char s[LONGSTRING];
 
  strcpy(s, (unsigned char *) SCREEN[y]);
  s[(x-1)] = '\0';
  strcat(s, "            ");
  s[MAXX] = '\0';
  strcpy(SCREEN[y], (unsigned char *) s);
 
  strcpy(s, (unsigned char *) ATTRIB[y]);
  s[x] = '\0';
  strcat(s, "0000000000000000000000000000000000000000000000000000000000000000000000000000000");
  s[MAXX] = '\0';
  strcpy(ATTRIB[y], (unsigned char *) s);
 
  show_line( SCREEN[y], ATTRIB[y], 1 ); /* 1 !!! */
  ansi2( "cm", x, y );
}
 
 
 
/* #CW - Save the text in a file */
 
ctrlw( f )
unsigned char f[];
{
  FILE *fp;
  int i;
  int rtf = 0;
  unsigned char s[STRING];
  unsigned char q[LONGSTRING]; 

  restore_screen( ypos );

  if(BLOCK.status == BLOCKMODE){
	block_ctrlw();
	return;
  }
 
  strcpy(q, (unsigned char *) TEXT[lastline]);
  while((strlen((unsigned char *) right_stripped(q)) < 2) && (TEXT[lastline][0] < 33)){
        lastline--;
	strcpy(q, (unsigned char *) TEXT[lastline]);
  }
 
  fp = fopen( f, "w" );

  if(REALLY != 0){
        fprintf(fp, "Content-Type: text/richtext;\n");
        rtf++;
  } 

  for( i = START; i <= lastline; i++){

        if(TEXT[i][0] == '~'){
                strcpy(TEXT[i], (unsigned char *) strcopy(TEXT[i], 1, strlen(TEXT[i])));
        }

	if(((FLAG[i] & is_richtext) == is_richtext) && (rtf == 0)){
		fprintf(fp, "Content-Type: text/richtext; charset=iso-8859-1\n");
		rtf++;
	}

	if(((FLAG[i] & is_plain) == is_plain) && (rtf != 0)){
		fprintf(fp, "Content-Type: text/plain; charset=iso-8859-1\n");
		rtf = 0;
	}

	if((FLAG[i] & is_centered) == is_centered){
		fprintf(fp, "<center>%s</center>", (unsigned char *) stripped(TEXT[i]));
	}
	else{
		strcpy(q, (unsigned char *) TEXT[i]);
		strcpy(q, (unsigned char *) right_stripped(q));
		fputs(q, fp);
	}
 
        if(TEXT[(i+1)][0] != '~'){
                if(rtf == 0)
                        fprintf(fp, "\n");
                else
                        fprintf(fp, "<nl>\n");
        }
  }

  if(rtf != 0){
        fprintf(fp, "Content-Type: text/plain;\n");
  } 

  fclose(fp);

  CHANGED = 0;

#ifdef _LOCAL 
  sprintf(s, " WENDY: Datei <%s> mit %d Zeilen gesichert. ", f, lastline);
#else
  sprintf(s, " WENDY: File <%s> with %d lines saved. ", f, lastline);
#endif

  show_status( s );
  activate( RTF_attrib );
  ansi2( "cm", x, y );
}
 
 
 
/* #CX - Stop session and leave */
 
ctrlx( f )
{
  int c;

  signal( SIGQUIT, SIG_IGN );
 
  if(CHANGED != 0){
        printf("%c", 7);
#ifdef _LOCAL
        show_status( " WENDY: Datei noch nicht gesichert! Sichern? (J/N) " );
#else
	show_status( " WENDY: File not saved yet! Save? (Y/N) " );
#endif
        ansi( "mr" );
        c = yesno();
        ansi( "me" );
        if((c == 'J') || (c == 'Y')) ctrlw( f );
  }
  show_status( " WENDY: Bye, bye ... " );

  echo( 1 );

  signal( SIGTERM, SIG_DFL );
  signal( SIGQUIT, SIG_DFL );
  signal( SIGINT,  SIG_DFL );
  
  ansi( "me" );
  ansi2( "cm", 1, MAXY );
  ansi( "ce" );

  exit( 1 );
}
 
 
 
/* #CY - Delete a line */
 
ctrly()
{
  int i, j, ymem = y;

  if(BLOCK.status == BLOCKMODE){
	block_ctrly();
	return;
  }
 
  restore_screen( ypos );
  j = ypos + y - 1;
  for(i = j; i < lastline; i++){
        strcpy(TEXT[i], (unsigned char *) TEXT[i+1]);
	FLAG[i] = FLAG[i+1];
  }
  lastline--;
 
  prep_screen( ypos );

  if(ansi( "dl" ) != 0){
	show_screen( y );
  }
  else{
	y = MAXY;
	show_line( SCREEN[MAXY], ATTRIB[MAXY], 1 );
	y = ymem;
	ansi2( "cm", x, y );
  }
}

