
/*
Eagles Bulletin Board System
Copyright (C) 1994, Ray Rocker, rrrocker@rock.b11.ingr.com
                                rock@seabass.st.usm.edu
                                72673.2105@compuserve.com

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "client.h"
#include <ctype.h>

char permtab[MAX_CLNTCMDS];
char *currentboard = currboard;

/*
   Read menus are still hardcoded. We should fix this one day.
*/

int MainReadHelp(), MailReadHelp();
int MailDisplay(), MailDelete(), MailDelRange();
int MailReply(), GroupReply(), Forward(), SequentialRead();
int FileMenu(), FileHelp(), FileReadHelp();
int ReadMenuSelect();
int PostDisplay(), PostDelete(), PostMessage(), PostDelRange(), PostMark();
int PostEdit();
int FileDownload(), FileView(), FileReadMenuProto();
int FileReceive(), FileReadMenuSelect(), FileForward();

READMENUITEM mainreadlist[] = {
	'r',             PostDisplay,       0,           C_READMSG,
        "r               Read current message\n",
        CTRL('P'),       PostMessage,       OPEN_POST,   C_POST,
	"CTRL-P          Post a message on this board\n",
	's',		 ReadMenuSelect,    0,           C_BNAMES,
	"s               Select a new board\n",
	'S',		 SequentialRead,    0,           C_ENUMHDRS,
	"S               Sequentially read new messages from cursor\n",
        'd',             PostDelete,        0,           C_DELMSG,
        "d               Delete current message (if owned)\n",
	'D',             PostDelRange,      OPEN_MANAGE, C_DELRANGE,
	"D               Delete range of messages\n",
	'm',		 PostMark,	    OPEN_MANAGE, C_MARKMSG,
	"m               Mark message for non-deletion\n",
	'E',		 PostEdit,	    OPEN_MANAGE, C_REPLACEMSG,
	"E               Edit a post\n",
	'F',             Forward,           0,           C_FORWARDMSG,
        "F               Forward post to your home mailbox\n",
        'h',             MainReadHelp,      0,           0,
        "h               Get this help screen\n",
        CTRL('J'),       MainReadHelp,      0,           0,
        NULL,
        '\0',            NULL,              0,           0,
        NULL
};

READMENUITEM mailreadlist[] = {
	'r',             MailDisplay,       0,           C_READMSG,
        "r               Read current message\n",
        'R',             MailReply,         OPEN_POST,   C_MAIL,
	"R               Reply to sender of current message\n",
	'G',             GroupReply,        OPEN_POST,   C_MAIL,
        "G               Reply to sender and all other recipients\n", 
        'd',             MailDelete,        OPEN_MANAGE, C_DELMSG,
        "d               Delete current message\n",
	'D',             MailDelRange,      OPEN_MANAGE, C_DELRANGE,
	"D               Delete range of mail messages\n",
	'F',             Forward,           0,           C_FORWARDMSG,
        "F               Forward mail to your home mailbox\n",
        'h',             MailReadHelp,      0,           0,
        "h               Get this help screen\n",
        CTRL('J'),       MailReadHelp,      0,           0,
        NULL,
        '\0',            NULL,              0,           0,
        NULL
};

READMENUITEM filereadlist[] = {
#if !REMOTE_CLIENT
        't',             FileReadMenuProto, 0,           C_SETPROTO,
        "t               Set download protocol\n",
        'v',             FileView,          0,           C_DOWNLOAD,
	"v               View a text file\n",
#endif
        'r',             FileReceive,       0,           C_DOWNLOAD,
        "r               Recieve (download) selected file\n",
	'F',             FileForward,       0,           C_FORWARDFILE,
        "F               Mail file to yourself -- uuencodes if binary\n",
        's',             FileReadMenuSelect, 0,          C_FBNAMES,
        "s               Select a new file board\n",
        'h',             FileReadHelp,      0,           0,
        "h               Get this help screen\n",
        CTRL('J'),       FileReadHelp,      0,           0,
        NULL,
        '\0',            NULL,              0,           0,
        NULL
};
     
DoReadHelp(p, flags)
READMENUITEM *p ;
int flags;
{
  while(p->cmdkey) {
    if (HasReadMenuPerm(p->openaccess, flags) &&
        HasPerm(p->permaccess) && p->helpstr)
      prints(p->helpstr);
    p++ ;
  }
}

MovementReadHelp()
{
  standout();
  prints("Movement Commands\n");
  standend();
  prints("p               Previous Message\n");
  prints("n               Next Message\n");
  prints("P               Previous Page\n");
  prints("N               Next Page\n");
  prints("## <cr>         Goto Message ##\n");
  prints("$               Goto Last Message\n");
}

MiscReadHelp()
{
  prints("CTRL-L          Redraw Screen\n");
  prints("e               EXIT Read Menu\n");
}

ReadMenuHelp(title, list, flags)
char *title;
READMENUITEM *list;
int flags;
{
  clear();
  standout();
  prints(title);
  standend();
  move(2,0);
  MovementReadHelp();
  prints("\n");
  standout();
  prints("Miscellaneous Commands\n");
  standend();
  DoReadHelp(list, flags);
  MiscReadHelp();
  pressreturn();
  clear();
  return FULLUPDATE;    
}

/*ARGSUSED*/
MailReadHelp(hptr, curr, num, flags)
void *hptr;
LONG curr, num, flags;
{
  return (ReadMenuHelp("Mail Read Menu Help Screen\n", mailreadlist, flags));
}

/*ARGSUSED*/
MainReadHelp(hptr, curr, num, flags)
void *hptr;
LONG curr, num, flags;
{
  return (ReadMenuHelp("Read Menu Help Screen\n", mainreadlist, flags));
}

/*ARGSUSED*/
FileReadHelp(hptr, curr, num, flags)
void *hptr;
LONG curr, num, flags;
{
  return (ReadMenuHelp("Download Menu Help Screen\n", filereadlist, flags));
}

NotImpl()
{
  clear();
  prints("This function is not yet implemented.\n");
  pressreturn();
  return FULLUPDATE;
}

EndMenu()
{
  return EXITMENU;
}

SetPermTable()
{
  memcpy(permtab, myinfo.access, MAX_CLNTCMDS);
}

HasPerm(perm)
int perm;
{
  if (perm == 0) return 1;
  else if (perm < 0 || perm >= MAX_CLNTCMDS) return 0;
  else return (permtab[perm]-'0');
}

HasReadMenuPerm(perm, flags)
int perm, flags;
{
  if (perm == 0) return 1;
  else return (perm & flags);
}

int
MenuGetch()
{
  char c;
  while (1) {
    c = igetch();
    if (isprint(c)) break;
    if (c == '\r' || c == '\n' || c == '\010' || c == '\177') {
      c = '\n';
      break;
    }
    if (c == CTRL('L')) {
      redoscr() ;  
    }
  }
  return c;
}

