
/*
Eagles Bulletin Board System
Copyright (C) 1994, Ray Rocker, rrrocker@rock.b11.ingr.com
                                rock@seabass.st.usm.edu
                                72673.2105@compuserve.com

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "client.h"
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <ctype.h>
#ifndef NeXT
# include <malloc.h>
#endif

/* The currently selected file board */
NAME currfileboard;
NAMELIST fileboardlist;

/* The currently selected protocol */
NAME currprotocol;
#if !REMOTE_CLIENT
NAMELIST protolist;
#endif

/*ARGSUSED*/
AllFileBoardsFunc(indx, board, info)
int indx;
BOARD *board;
struct enum_info *info;
{
  if (info->topline == info->currline) {
    move(info->topline-1, 0);
    prints(" %-16s   %-58s\n", "Name", "Description");
  }

  prints(" %-15s    %s\n", board->name, board->description);

  info->currline++;
  info->count++;

  if (info->currline > info->bottomline) {
    int ch;
    standout();
    prints("--MORE--");
    standend();
    clrtoeol();
    while((ch = igetch()) != EOF) {
      if(ch == '\n' || ch == '\r' || ch == ' ')
	break;
      if(toupper(ch) == 'Q') {
	move(info->currline, 0);
	clrtoeol();
	return ENUM_QUIT;
      }
      else bell();
    }
    info->currline = info->topline;
  }
  return S_OK;
}

FileBoards()
{
  struct enum_info info;
  info.count = 0;
  info.topline = info.currline = 4;
  info.bottomline = t_lines-2;
  move(3,0);
  clrtobot();    
  bbs_enum_fileboards(t_lines-5, 0, AllFileBoardsFunc, &info);
  clrtobot();
  move(t_lines-1, 0);
  prints("%d %s displayed\n", info.count, info.count==1?"board":"boards");
  return PARTUPDATE;
}

FileSelect()
{
  NAME newboard;
  move(2,0);
  clrtobot();
  bbs_fileboardnames(&fileboardlist);
  if (fileboardlist == NULL) {
    prints("No file boards to select.\n");
    pressreturn();
    return FULLUPDATE;
  }
  namecomplete(fileboardlist, "Enter a board name: ", newboard);
  if (newboard[0] == '\0') return FULLUPDATE;
  else if (!is_in_namelist(fileboardlist, newboard)) {
    move(4,0);
    prints("Invalid board name.\n");
    pressreturn();
    return FULLUPDATE;
  }
  strcpy(currfileboard, newboard);
  return (FULLUPDATE | NEWDIRECT);
}

OpenFileBoard(openflags, newonly, resp)
int *openflags;
int newonly;
int *resp;
{
  int code;
  OPENINFO openinfo;
  code = bbs_open_fileboard(currfileboard, &openinfo);    
  if (resp) *resp = code;
  if (code != S_OK) return -1;
  if (openflags) *openflags = openinfo.flags;
  return (newonly ? openinfo.newmsgs : openinfo.totalmsgs);
}

CloseFileBoard()
{
  int code;
  code = bbs_close_board();
  return (code == S_OK ? 0 : -1);
}

#if !REMOTE_CLIENT

SelectProtocol()
{
  NAME protoname;
  move(2,0);
  clrtobot();
  bbs_protonames(&protolist);
  if (protolist == NULL) {
    prints("No protocols to select!\n");
    pressreturn();
    return FULLUPDATE;
  }
  namecomplete(protolist, "Select a protocol: ", protoname);
  if (protoname[0] == '\0') return FULLUPDATE;
  else if (!is_in_namelist(protolist, protoname)) {
    move(4,0);
    prints("Invalid protocol name.\n");
    pressreturn();
    return FULLUPDATE;
  }
  strcpy(currprotocol, protoname);
  bbs_set_protocol(protoname);  
  return FULLUPDATE;
}

FileView(hptr, currmsg, numrecs, openflags)
HEADER *hptr;
int currmsg, numrecs, openflags;
{
  int rc;
  PATH fname;

  clear();
  if (BITISSET(hptr->flags, FILE_BINARY)) {
    char ans[4];
    getdata(0, 0, "This may be a binary file. Continue (Y/N)? [N]: ",
            ans, sizeof ans, DOECHO, 0);
    if (*ans != 'Y' && *ans != 'y')
      return FULLUPDATE;
  }      

  rc = bbs_download(hptr->title, NULL, fname);
  if (rc != S_OK) {
    prints("Error accessing file '%s'!\n", hptr->title);
    pressreturn();
    return FULLUPDATE;
  }

  More(fname, 1);
  return FULLUPDATE;
}

GetSavedProtocol()
{
  ACCOUNT acct;
  if (bbs_owninfo(&acct) == S_OK) {
    strncpy(currprotocol, acct.protocol, sizeof currprotocol-1);
  }
}  

#endif

FileUpload()
{
  PATH fname;
  char *base, *slash;
  char ans[4];
#if REMOTE_CLIENT
  strcpy(currprotocol, "builtin");
#else
  if (currprotocol[0] == '\0') {
    GetSavedProtocol();
    if (currprotocol[0] == '\0') {
      clear();
      prints("You must select an upload protocol first.\n");      
      pressreturn();
      return FULLUPDATE;
    }
  }
#endif
  clear();
  if (getdata(0,0,"File to upload: ",fname,sizeof fname,DOECHO,1)==-1) {
    return FULLUPDATE;
  }

  if ((slash = strrchr(fname, '/')) != NULL) base = slash+1;
  else base = fname;

  prints("Uploading '%s'.\n", base);
  prints("Using %s protocol.\n", currprotocol);
  getdata(2, 0, "Are you sure (Y/N)? [Y]: ", ans, sizeof(ans), DOECHO, 0);
  if (*ans == 'N' || *ans == 'n') {
    prints("File NOT uploaded.\n");
  }
  else {
    int rc;
#if REMOTE_CLIENT
    prints("Uploading...please stand by.\n");
    rc = bbs_upload(fname, base, currprotocol);
#else
    prints("Setup modem program and press any key to upload.\n");
    refresh();
    fgetc(stdin);
    reset_tty();
    rc = bbs_upload(NULL, base, currprotocol);
    printf("\nDone. Press any key.\n");
    fgetc(stdin);        
    restore_tty();
    clear();
#endif
    switch (rc) {
    case S_OK: 
      prints("\nFile uploaded!\n");
      break;
    case S_INVALID: 
      prints("\nInvalid protocol for upload; try another?\n");
      break;
#if REMOTE_CLIENT
    case S_BADPATH:
      prints("\nCannot open %s!\n", fname);
      break;
#endif
    default:
      prints("\nError uploading file.\n");
    }
  }
  pressreturn();
  return FULLUPDATE;
}

FileReceive(hptr, currmsg, numrecs, openflags)
HEADER *hptr;
LONG currmsg, numrecs, openflags;
{
  char ans[4];
#if REMOTE_CLIENT
  PATH fname;
  strcpy(currprotocol, "builtin");
#else
  if (currprotocol[0] == '\0') {
    GetSavedProtocol();
    if (currprotocol[0] == '\0') {
      clear();
      prints("You must select a download protocol first.\n");      
      pressreturn();
      return FULLUPDATE;
    }
  }
#endif
  clear();
  prints("Downloading '%s'.\n", hptr->title);
  prints("Using %s protocol.\n", currprotocol);
  getdata(2, 0, "Are you sure (Y/N)? [Y]: ", ans, sizeof(ans), DOECHO, 0);
  if (*ans == 'N' || *ans == 'n') {
    prints("File NOT downloaded.\n");
  }
  else {
    int rc;
#if REMOTE_CLIENT
    if (getdata(3, 0, "Download to (RETURN = current directory): ",
                fname, sizeof fname, DOECHO, 1) == -1) {
      return FULLUPDATE;
    }      
    if (fname[0] == '\0') strncpy(fname, hptr->title, sizeof fname);
    prints("Receiving %d bytes. Please stand by.\n", hptr->size);
    rc = bbs_download(hptr->title, currprotocol, fname);
#else
    prints("Setup modem program and press any key to download.\n");
    refresh();
    fgetc(stdin);
    reset_tty();
    rc = bbs_download(hptr->title, currprotocol, NULL);
    printf("\nDone. Press any key.\n");
    fgetc(stdin);        
    restore_tty();
    clear();
#endif
    switch (rc) {
    case S_OK: 
      prints("\nFile downloaded!\n");
      break;
    case S_INVALID: 
      prints("\nInvalid protocol for download; try another?\n");
      break;
#if REMOTE_CLIENT
    case S_BADPATH:
      prints("\nCannot write to %s!\n", fname);
      break;
#endif
    default:
      prints("\nError retrieving file from server!\n");
    }
  }
  pressreturn();
  return FULLUPDATE;
}

/*ARGSUSED*/
FileForward(hptr, currmsg, numrecs, openflags)
HEADER *hptr;
int currmsg, numrecs, openflags;
{
  int rc = FULLUPDATE;
  ACCOUNT acct;
  char ans[4];
  clear();
  if (bbs_owninfo(&acct) != S_OK) {
    prints("Can't fetch address from your account record!\n");
    pressreturn();
    return rc;
  }
  prints("Mailing '%s' to:\n", hptr->title);
  prints("%s\n", acct.email);
  getdata(2,0,"Are you sure (Y/N)? [Y]: ",ans,sizeof(ans),DOECHO,0);
  move(4,0);
  if (*ans == 'N' || *ans == 'n') {
    prints("Message not forwarded.\n");
  }        
  else {
    switch (bbs_forward_file(hptr->title)) {
    case S_OK:
      prints("Mail sent!\n");
      break;
    case S_INVALID:
      prints("Forward failed: not a valid address.\n");
      break;
    case S_NOTFOUND:
      prints("Forward failed: could not open file.\n");
      break;
    default:
      prints("Forward failed: system or configuration error.\n");
      break;
    }
  }
  pressreturn();
  return rc;
}

/*ARGSUSED*/
FileReadMenuSelect(hptr, currmsg, numrecs, openflags)
HEADER *hptr;
int currmsg, numrecs, openflags;
{
  return (FileSelect());
}

#if !REMOTE_CLIENT

/*ARGSUSED*/
FileReadMenuProto(hptr, currmsg, numrecs, openflags)
HEADER *hptr;
int currmsg, numrecs, openflags;
{
  return (SelectProtocol());
}

#endif
