#include <assert.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

int purge_user(int days) {
  time_t t;
  uid_t uid;
  char login[9], cmd[256];
  struct user_rec ur;
  FILE *user_file = fopen(USER_FILE, "rb"); assert(user_file != NULL);
  time(&t);
  while (!user_rec_read(&ur, user_file)) {
    if ((t - ur.last) / (24 * 60 * 60) >= days) {
      fclose(user_file);
      login_from_uid(ur.uid, login); 
      sprintf(cmd, "user_del %s", login);
      system(cmd);
      return 0;
    }
  }
  fclose(user_file);
  return 1;
}

void main(int argc, char **argv) {
  int days;
  if (argc != 2) {
    printf("usage: user_purge <days>\n");
    exit(0);
  }
  days = atoi(argv[1]);
  if (days <= 14) {
    printf("<days> must be > 14.\n");
    exit(1);
  }
  while (!purge_user(days));
}
