#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

void main() {
  FILE *user_file;
  int found = 0;
  uid_t uid;
  struct user_rec ur;
  char *login = getenv("LOGNAME");
  assert(login != NULL);
  uid = uid_from_login(login);
  user_file = fopen(USER_FILE, "rb"); assert(user_file != NULL);
  while (!user_rec_read(&ur, user_file)) {
    if ((ur.uid == uid) && ur.expire) {
      found = 1;
      printf("%.2f day(s) remaining.\n",
             (float) (ur.expire - time(NULL)) / (24 * 60 * 60));
      break;
    }
  } 
  fclose(user_file);
  if (!found) printf("no expiration date!\n");
}
