#include "nist.h"

void usage(char *progname)
{
    char
        *cp;

    if ((cp = strrchr(progname, '/')))  /* find the 1st char of the progname */
        cp++;
    else
        cp = progname;

    copyright(cp, "Frank B. Brokken",   /* provide the copyright notice */
        "Time Standardizer", VERSION, YEAR);

    error                               /* and the usage */
    (
        "Usage: %s flag(s)\n"
        "Where flag(s): at least one of:\n"
        "   -a <[-]hh:mm:ss>: alter the received time by 'hh:mm:ss'\n"
        "   -d:               display the received time\n"
        "   -h <host>:        use provided host-name or address\n"
        "                     (default: %s)\n"
        "   -q:               run quietly\n"
        "   -s:               account for Daylight Saving Time if active\n"
        "   -t:               the time is updated\n"
        "\n"
        , cp
        , host
    );
}

