#include "nist.h"

void options(int argc, char **argv)
{
    while (*++argv)                     /* process all arguments */
    {
        if (**argv == '-')              /* option ? */
        {
            switch ((*argv)[1])         /* select the appropriate one */
            {
                case 'a':
                    ++argv;             /* skip the option */

                                    

                    *argv +=            /* negative timeadjustment  */
                        (minus = (**argv == '-'));
                                        /* shift beyond the '-'     */

                    if (sscanf(*argv, "%d:%d:%d", &dh, &dm, &ds) != 3)
                        error("incorrect timespecification %s with -a", *argv);

                    dh %= 24;           /* use times up to 23:59:59 */
                    dm %= 60;
                    ds %= 60;

                    if (!quiet)
                        printf("Using delta-time %s%2.2d:%2.2d:%2.2d\n",
                                minus ? "-" : "",
                                dh, dm, ds);

                    if (minus)
                    {
                        dh = -dh;
                        dm = -dm;
                        ds = -ds;
                    }
                break;

                case 'd':
                    display = 1;        /* display the time */
                break;

                case 'h':
                    host = *++argv;     /* alternative host */
                break;

                case 'q':
                    quiet = 1;          /* run quietly */
                break;

                case 's':
                    check_dst = 1;      /* check for DST */
                break;

                case 't':
                    time_update = 1;    /* update the time */
                break;

                default:
                    printf ("Ignoring unsupported flag %s\n", *argv);
            }
        }
    }
}
