/*                              nist.h

   A C++ header file generated by cpp for nist.cc

*/

#ifndef _nist_H_
#define _nist_H_

#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h> 
#include <sys/socket.h>
#include <time.h> 
#include <sys/time.h>

                                     /* The name of the timeserver.          */
#define TIME_SERVER "time_a.timefreq.bldrdoc.gov"

#define VERSION     "1.01"          /* recompile usage.c when altered:      */
#define YEAR        "1995"

void copyright(char const *progname,        /* copyright function           */
            char const *author,
            char const *function,
            char const *version,
            char const *year);
void error(char *fmt, ...);                 /* provides errormessage/exits  */
void init_sockaddr(struct sockaddr_in *name,/* initializes a socket         */
     char const *hostname,
     unsigned short int port);
int  linuxserver(char *cmd);                /* time provided by a linuxserver */
void local_time(void);                      /* get the local time from -a   */
int  nistserver(char *cmd);                 /* time provided by nist        */
void options(int argc, char **argv);        /* processes options            */
void query_server(void);                    /* ask the server for the time  */
void set_time(void);                        /* set the system time          */
void usage(char *progname);                 /* provides usageinfo           */

extern int
    check_dst,
    display,                        /* display the received time */
    minus,                          /* neg. timeadjust */
    dh,                             /* delta hours */
    dm,                             /* delta minutes */
    ds,                             /* delta seconds */
    quiet,                          /* run quietly */
    time_update,                    /* update the time */
    yy,                             /* retrieved time info */
    mo,
    dd,
    hh,
    mm,
    ss;

extern char
    *host;

extern struct tm
    local;

#endif
