#include "nist.h"

int
    max_daynr[] =
    {
        0,      /* numbers rather than indices are used with mo */
        31,     /* Jan */
        28,     /* Feb */
        31,     /* Mar */
        30,     /* Apr */
        31,     /* May */
        30,     /* Jun */
        31,     /* Jul */
        31,     /* Aug */
        30,     /* Sep */
        31,     /* Oct */
        30,     /* Nov */
        31,     /* Dec */
    };

void local_time()
{
    int
        carry = 0;
    struct timeval
        tv;

    gettimeofday(&tv, NULL);                /* settings from the local time */
    local = *localtime(&tv.tv_sec);         /* convert to broken-down parts */

    dh += (check_dst && local.tm_isdst);    /* check for DST: add 1 if active */

    max_daynr[2] = 28 + !(yy & 3);          /* correct max_daynr[february]  */
                                            /* for a leap-year: 1 extra day */
                                            /* if yy can be divided by 4,   */
                                            /* i.e., nothing in the last 2  */
                                            /* bits                         */

                                            /* local number of seconds      */
    ss += ds + 60 * (mm + dm + 60 * (hh + dh));

    if (ss < 0)                             /* to the previous day          */
    {
        carry--;                            /* carry one day back           */
        ss += 24 * 60 * 60;                 /* seconds into the previous day*/
    }
    else if (ss > 24 * 60 * 60)             /* next day                     */
    {
        carry++;                            /* set carry                    */
        ss -= 24 * 60 * 60;                 /* seconds into the next day    */
    }

    hh = ss / (60 * 60);                    /* set the number of hours      */
    ss %= (60 * 60);                        /* remaining number of seconds  */
    mm = ss / 60;                           /* set the number of minutes    */
    ss %= 60;                               /* set the number of seconds    */

    dd += carry;                            /* alter the day */

    if (dd > max_daynr[mo])                 /* moving into the next mo */
    {
        dd = 1;                             /* next day */
        if (++mo > 12)                      /* into the next year ? */
        {
            mo = 1;                         /* back to Jan */
            yy++;                           /* next year */
            yy %= 100;                      /* no century info */
        }
    }
    else if (dd < 1)                        /* go back to the previous month */
    {
        if (--mo < 1)                       /* before this year ? */
        {
            mo = 12;
            if (--yy < 0)                   /* previous year */
                yy = 99;                    /* previous century */
        }
        dd = max_daynr[mo];                 /* set the day */
    }

    if (!quiet)                             /* show the local time */
        printf("Local time: %2.2d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d\n",
                            yy, mo, dd,       hh, mm, ss);
}
