/*****************************************************************************
	         idledaemon - idle login killer for the Linux OS
           (C)opyright 1994-1995, B. Scott Burkett, All Rights Reserved
 ***************************************************************************** 
 $Header: /usr3/src/idled/RCS/idled.h,v 1.4 1995/05/09 13:14:30 root Exp $
 ***************************************************************************** 
 $Log: idled.h,v $
 * Revision 1.4  1995/05/09  13:14:30  root
 * Cosmetic - Added RCS strings
 *
 *****************************************************************************/

#define	 VERSION "1.02c"
#define  COPYRIGHT "(C)opyright 1994-1995, B. Scott Burkett, All Rights Reserved"

#define  IDLED_TABLE_SIZE	100

#ifndef TRUE
#define TRUE 	1
#define FALSE	!TRUE
#endif

void Init(void);
void Process(void);
time_t GetTimes(void);
void Guillotine(int cfgndx);
void be_daemon(void);
void err_sys(char *msg);
void Report(void);
void MessageKill(void);
void MessageWarn(void);
void ParseCmdLine(int ac, char *av[]);
void ReadCFGFile(void);
int CheckNoidleout(void);
int BeenWarned(int pid);
void MarkAsWarned(int pid);
void WarnNoMore( int ndx );
void SendFile(char *filename);
void SetSignals(void);
void cleanup(int signum);
int ProcActive(int pid);
int JudgementDay(int *cfgndx);

typedef struct	_warned { 
	int	pid;
	char	wflag;
} _WARNED;

typedef struct  _cfg {
	char	_username[12];
	char 	_ttydevice[20];
	int	_idle;
	int	_grace;
	char	_notifybymail;
	int 	_sessionlimit;
} _CFG;

extern struct utmp	*userrec;
extern FILE		*uf, *tty;
extern char		buf[80], logbuf[80];
extern _WARNED 		warned[ IDLED_TABLE_SIZE ];  
extern _CFG    		cfg[ IDLED_TABLE_SIZE ];
extern _CFG		tmpcfg;
extern int		_maxidletime, _warnfirst, _debug, _sleepdelay;
extern int		highentry;

