/* chsh.c - change ones shell
 * Initially written and still maintained by Peter Orbaek <poe@daimi.aau.dk>
 * Currently maintained at ftp://ftp.daimi.aau.dk/pub/linux/poe/
 */
/* minor bugfixes: flebbe@tat.physik.uni-tuebingen.de */
/* Hacked by Alvaro Martinez Echevarria, alvaro@enano.etsit.upm.es,
   to allow peaceful coexistence with yp. Nov 94. */

#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pwd.h>
#include <string.h>

#define MAX_SHELLS 20
#define until(b) while(!(b))
#define MAX_LENGTH      1024

char buffer[8000];

extern int is_local(char *);

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct passwd *pe;
	char *pwdstr, *newsh, *bufptr;
	FILE *fp;
	char *shells[MAX_SHELLS];
	int n,nr;
	char *user;
	uid_t gotuid = getuid();
	FILE *fd_in, *fd_out;
	char line[MAX_LENGTH];
	int error = 0;
	char colonuser[16];

	umask(022);

	if(argc > 2) {
		puts("Too many arguments");
		exit(1);
	} else if(argc == 2) {
		if(gotuid) {
			puts("Only root can change the shell for others");
			exit(1);
		}
		user = argv[1];
	} else {
		user = getlogin();
	}
	
	if(!(pe = getpwnam(user))) {
		puts("Can't find you anywhere! Are you really a user?");
		exit(1);
	}

	if (!(is_local(user))) {
		puts("Sorry, I can only change local shells");
		exit(1);
	}


	if(gotuid && gotuid != pe->pw_uid) {
		puts("UID and username does not match, imposter!");
		exit(1);
	}

	if(gotuid && pe->pw_passwd && pe->pw_passwd[0]) {
		pwdstr = getpass("Enter password: ");
		if(strncmp(pe->pw_passwd, crypt(pwdstr, pe->pw_passwd), 14)) {
			puts("Illegal password, imposter.");
			exit(1);
		}
	}

	printf("The current shell is: %s\n", pe->pw_shell);

redo_it:
	if(fp = fopen("/etc/shells", "r")) {
		puts("You can choose one of the following:");
		nr = 1;
		bufptr = buffer;
		while(fgets(bufptr, 79, fp) && nr < MAX_SHELLS 
		   && bufptr < buffer + 7999) {
			printf("%d: %s", nr, bufptr);
			bufptr[strlen(bufptr)-1] = '\0';
			shells[nr-1] = bufptr;
			bufptr += strlen(bufptr)+1;
			nr++;
		}
		fclose(fp);
		
		do {
			printf("Enter a number between 1 and %d: ", nr-1);
			fflush(stdout);
			scanf("%d", &n);
		} until(1 <= n && n <= nr-1);
		newsh = shells[n-1];
	} else {
		printf("Enter the full path of the new shell: ");
		fflush(stdout);
		fgets(buffer, 70, stdin);
		buffer[strlen(buffer)-1] = '\0';
		newsh = buffer;
	}
	
	if(access(newsh, X_OK) < 0) {
		printf("Can't find %s, try again...\n", newsh);
		goto redo_it;
	}

	/* now write new passwd file */
	if(access("/etc/ptmp", F_OK) == 0) {
		puts("/etc/ptmp exists, can't change shell");
		exit(1);
	}
	
	if(!(fd_out = fopen("/etc/ptmp", "w"))) {
		puts("Can't open /etc/ptmp, can't change shell");
		exit(1);
	}

	if(!(fd_in = fopen("/etc/passwd", "r"))) {
		puts("Can't read /etc/passwd, can't update shell");
		exit(1);
	}

	strcpy(colonuser, user);
	strcat(colonuser, ":");
	while(fgets(line, sizeof(line), fd_in)) {
		if(!strncmp(line,colonuser,strlen(colonuser))) {
			pe->pw_shell = newsh;
			if(putpwent(pe, fd_out) < 0) {
				error = 1;
			}
		} else {
			if(fputs(line,fd_out) < 0) {
				error = 1;
			}
		}
		if(error) {
			puts("Error while writing new password file, shell not changed.");
			fclose(fd_out);
			endpwent();
			unlink("/etc/ptmp");
			exit(1);
		}
	}
	fclose(fd_in);
	fclose(fd_out);

	unlink("/etc/passwd.OLD");
	link("/etc/passwd", "/etc/passwd.OLD");
	unlink("/etc/passwd");
	link("/etc/ptmp", "/etc/passwd");
	unlink("/etc/ptmp");
	chmod("/etc/passwd", 0644);
	chown("/etc/passwd", 0, 0);

	puts("Shell changed.");	
	return 0;
}
