/* panel.h -- the data structures and function prototypes used in panel.c. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_PANEL_H
#define _GIT_PANEL_H


#include <sys/types.h>
#include <limits.h>
#include <stddef.h>


#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
          
#if HAVE_DIRENT_H
#include <dirent.h>
#define NAMLEN(dirent) strlen((dirent)->d_name)
#else /* !HAVE_DIRENT_H */
#define dirent direct
#define NAMLEN(dirent) (dirent)->d_namlen
#ifdef HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif /* HAVE_SYS_NDIR_H */
#ifdef HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif /* HAVE_SYS_DIR_H */
#ifdef HAVE_NDIR_H
#include <ndir.h>
#endif /* HAVE_NDIR_H */
#endif /* !HAVE_DIRENT_H */

#include "stdc.h"


/* Panel actions */
#define act_NOACTION		 0
#define act_ENTER		 1
#define act_COPY		 2
#define act_DELETE		 3
#define act_SELECT		 4
#define act_SELECT_ALL		 5
#define act_UNSELECT_ALL	 6
#define act_TOGGLE		 7

#define act_DISPLAY_NEXT_MODE	 8
#define act_DISPLAY_OWNER_GROUP	 9
#define act_DISPLAY_DATE_TIME	10
#define act_DISPLAY_SIZE	11
#define act_DISPLAY_MODE	12
#define act_DISPLAY_FULL_NAME	13

#define act_SORT_NEXT_METHOD	14
#define act_SORT_BY_NAME	15
#define act_SORT_BY_EXTENSION   16
#define act_SORT_BY_SIZE	17
#define act_SORT_BY_DATE	18
#define act_SORT_BY_MODE	19
#define act_SORT_BY_OWNER_ID	20
#define act_SORT_BY_GROUP_ID	21
#define act_SORT_BY_OWNER_NAME	22
#define act_SORT_BY_GROUP_NAME	23

#define act_MKDIR		24
#define act_MOVE		25
#define act_UP			26
#define act_DOWN		27
#define act_PGUP		28
#define act_PGDOWN		29
#define act_HOME		30
#define act_END			31
#define act_CHDIR    		32
#define act_REFRESH		33
#define act_SWITCH		34

#define act_PATTERN_SELECT	35
#define act_PATTERN_UNSELECT	36


/* File sort methods */
#define SORT_BY_NAME		 0
#define SORT_BY_EXTENSION	 1
#define SORT_BY_SIZE		 2
#define SORT_BY_DATE		 3
#define SORT_BY_MODE		 4
#define SORT_BY_OWNER_ID	 5
#define SORT_BY_GROUP_ID	 6
#define SORT_BY_OWNER_NAME	 7
#define SORT_BY_GROUP_NAME	 8


/* File display modes */
#define DISPLAY_OWNER_GROUP	 0
#define DISPLAY_DATE_TIME	 1
#define DISPLAY_SIZE		 2
#define DISPLAY_MODE		 3
#define DISPLAY_FULL_NAME	 4


/* File types */
#define DIR_ENTRY		 0
#define FILE_ENTRY		 1
#define SYMLINK_ENTRY		 2
#define FIFO_ENTRY		 3
#define SOCKET_ENTRY		 4


#define ACTIVE_PANEL_MARKER	'>'
#define INACTIVE_PANEL_MARKER	'*'


typedef struct
{
    char	 *name;
    size_t	  size;
    mode_t	  mode;
    uid_t	  uid;
    gid_t	  gid;
    time_t	  mtime;
    char	 *owner;
    char	 *group;
    char	  date[16];
    unsigned      selected   : 1,
    		  type       : 4,
    		  executable : 1;
} dir_entry_struct;


typedef struct
{
    DIR *dir;
    window *win;
#ifdef HAVE_LINUX
    int msdosfs;
#endif	/* HAVE_LINUX */
    int on_screen;
    int current_entry;
    char *path, *temp;
    int first_on_screen;
    unsigned int maxname;
    dir_entry_struct *dir_entry;
    int last_index, multiple_files;
    int lines, columns, begin_x, begin_y;
    int display_mode, sort_method, chkdest;
    int entries, focus, selected_files, pathlen;
} panel;


extern panel *panel_init __P((int, int, int, int, char *, int *));
extern void panel_init_iterator __P((panel *));
extern int panel_get_next __P((panel *));
extern void panel_end __P((panel *));
extern void panel_set_focus __P((panel *, int, panel *));
extern void panel_no_optimizations __P((panel *));
extern int panel_action __P((panel *, int, panel *, void *, int));
extern char *panel_get_path __P((panel *, char *, unsigned));
extern char *panel_get_current_file_name __P((panel *));
extern int panel_get_current_file_uid __P((panel *));
extern int panel_get_current_file_gid __P((panel *));
extern int panel_get_current_file_mode __P((panel *));
extern int panel_get_current_file_type __P((panel *));


#endif	/* _GIT_PANEL_H */
