
.\" +----------
.\" |
.\" |			  GIT/GITPS/GITVIEW man page
.\" | 			 Release 4.3.5, January 1995
.\" |
.\" |	   Copyright 1993, 1994, 1995 Free Software Foundation, Inc.
.\" |
.\" |	This file is part of GIT (GNU Interactive Tools)
.\" |
.\" |	GIT is free software; you can redistribute it and/or modify it under
.\" | the terms of the GNU General Public License as published by the Free
.\" | Software Foundation; either version 2, or (at your option) any later
.\" | version.
.\" |
.\" | GIT is distributed in the hope that it will be useful, but WITHOUT ANY
.\" | WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
.\" | FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
.\" | details.
.\" |
.\" | You should have received a copy of the GNU General Public License along
.\" | with GIT; see the file COPYING. If not, write to the Free Software
.\" | Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.\" |
.\" |
.TH git 1 "January 1995" "Release 4.3.5"
.SH NAME
git \- GNU Interactive Tools version 4.3.5
.SH SYNTAX
.I git
.br
.I gitps
.IR "" "[" ps (1)
like parameters]
.br
.I gitview
filename

.SH NOTE
The main configuration file of the
.I GIT
package is
.B ".gitrc.TERM"
where
.B TERM
is the value of the environment
variable
.BR "" ' TERM '
e.g for Linux console your environment contains something like
.BR "" ' "TERM=console" '
so the configuration file name is
.BR ".gitrc.console" "."
You can (and should) have a configuration file for each terminal type you use.

.SH DESCRIPTION
.I git
is a
.B file system browser
with some shell facilities which was designed to make your work much
easier and much efficient.

.I gitps
is an interactive process viewer/killer. It calls internally the
.IR ps (1)
utility so that's the reason why
.I gitps
parameters are in fact
.IR ps (1)
ones. Running
.I gitps
it is self explanatory. Use the
arrows, PageUp, PageDown, Home, End, ^N, ^P, ^V, ESC v to move in
the list, ^L to refresh it and F10 or ^G to leave. You can change
these keys, just read the sections
.B [GITPS-Setup], [GITPS-Color], [GITPS-Monochrome] and [GITPS-Keys]
in the configuration file
.BR ".gitrc.TERM" .
See also 
.BR "CONFIGURATION FILES" .

.I gitview
is an hex/ascii file viewer. Too simple to need a separate manual page. Use
the arrows, PageUp, PageDown, Home, End, ^N, ^P, ^V, ESC v to move in
the file, ^L to refresh the screen and F10 or ^G to leave. You can
change those keys, just read the sections
.B [GITVIEW-Setup], [GITVIEW-Color], [GITVIEW-Monochrome] and [GITVIEW-Keys]
in the configuration file
.BR ".gitrc.TERM" .
See also 
.BR "CONFIGURATION FILES" .

.SH FILE-SYSTEM BROWSER
.I git
is made of two panels. The left one and the right one. Each
one contains a file system directory. You can browse the
directory tree with the usual cursor keys and pressing
.B ENTER
when you want to enter or leave a directory.
You may change the panels by pressing
.BR TAB .
See also 
.BR "BUILT-IN COMMANDS" .

.SH INPUT LINE
Under the two panels there is a shell like input line which
you can use to type normal shell commands. The input line
supports unlimited characters and keeps a history of the typed
commands. GIT uses the GNU history library for that.
See also 
.BR "BUILT-IN COMMANDS" .

.SH WARNINGS AND ERRORS REPORTING
Under the input line there is a status bar. You can see there
the status of the currently executed command, the warnings and
errors and you will be prompted if a decision has to be taken.

.SH ENVIRONMENT VARIABLES
The configuration files use shell environment variables to call
the shell, editor, mail reader, compress and virtual memory status
utility. That means that if you set
.BR GIT_SHELL ", " GIT_EDITOR ", " GIT_RMAIL ", " GIT_COMPRESS " or "
.B GIT_VMSTAT
to some value, that value will be used instead of the default one.
The defaults are:

.B GIT_SHELL='/bin/sh'
.br
.B GIT_EDITOR='vi'
.br
.B GIT_RMAIL='emacs -f rmail'
.br
.B GIT_COMPRESS='gzip -9'
.br
.B GIT_VMSTAT='free'

If
.B GIT_SHELL
is not defined but
.B SHELL
is,
.B GIT_SHELL
will be set to that value. If
.B GIT_EDITOR
is not defined but
.B EDITOR
is,
.B GIT_EDITOR
will be set to that value. If you want to change the default settings,
put something like this into your .profile :

.B export GIT_SHELL='/usr/local/bin/bash'
.br
.B export GIT_EDITOR='emacs'
.br
.B export GIT_RMAIL='elm'
.br
.B export GIT_COMPRESS='compress'
.br
.B export GIT_VMSTAT='vmstat'

.SH CONFIGURATION FILES
There is one configuration file per terminal type in
.IR git / gitps / gitview .
The configuration file(s) resides in the user's home directory
or (the default versions) in the directory $(prefix)/lib
(usually /usr/local/lib).
The generic name is
.BR ".gitrc.TERM" .
.B "GIT"
allows each terminal type to have its own configuration file
.BR "" ( TERM
is the value of the
.BR "" ' TERM '
environment variable (e.g vt102). For the 
Linux console the configuration file is
.BR ".gitrc.console" ")."

If you have compiled the
.I GIT
package with
.B HAVE_LIBTERMCAP
and your system has a huge termcap database (/etc/termcap), you can copy the
termcap definition(s) of your terminal(s) in a file ($HOME/.termcap e.g.).
After that, set your
.B TERMCAP
environment variable to point to it. You should
add something like this to your
.BR ".profile" ":"

.B "TERMCAP=/home/mike/.termcap"

.IR git / gitps / gitview
can run without such a file, but on systems with huge termcap databases,
copying the definitions of the most used terminals in a local
.B .termcap
will result in
.IR git / gitps / gitview
starting faster.
.IR git / gitps / gitview
doesn't use termcap key definitions. You must define the keys you
want directly in the
.B ".git.TERM"
file in 
.B "[GITxxx-Keys]"
sections.

If you have compiled the
.I GIT
package with
.BR HAVE_LIBTERMINFO ,
or on your system the termcap database is
emulated using the terminfo library (like in the HP-UX system),
don't bother about speed.

See also the sections
.BR "[GITxxx-Keys]" .

The configuration file
.B ".gitrc.TERM"
is the file searched by
.IR git / gitps / gitview
each time they are started, in order to configure themselves.
.B ".gitrc.TERM"
it is first searched in the home directory then, if not found, in the
directory $(prefix)/lib (usually /usr/local/lib). The configuration file
is structured on sections, each section containing variables in the
following format:

.in +.5i
.B variable_name
=
.BR first_field ; second_field ; " ..."
.in -.5i

After the variable_name at least one space or tab is required.
All characters after a 
.BR "" \' # \'
are ignored and if you comment
a section name, the whole section is ignored.

The default configuration file
.B .gitrc.TERM
supports most of the usual commands. To find out more about them please read
it.
.I git
allows you to change both the utility used to perform a particular operation
(using compress instead of gzip :-) ) and the key associated with it. There is
also possible to remove/add new commands.

The configuration file contains the following sections:

.B "1. [Setup]"

In this section the variables have only one field.

a. 
.B TempDirectory
.br
 - this variable specifies the location of the temporary files created by
.IR git .

b.
.B AnsiColorSequences
.br
 - this variable should be set to
.B ON
if the terminal supports standard
.B ANSI
color sequences. Otherwise it should be
.BR OFF .
If
.B AnsiColorSequences
is
.BR ON ,
.B [GITxxx-Color]
sections
will be used in the configuration files
.BR ".gitrc.TERM" .
Otherwise,
.IR git / gitps / gitview
will use the
.B [GITxxx-Monochrome]
sections.

c.
.B UseLastScreenChar
.br
 - this variable is used for terminals that can't write on the last character
of the screen without scrolling the entire screen. If your terminal has no
problem writing there (Linux console, vt100, vt102, xterm, ...) set it to
.BR ON .
Otherwise (hpterm), it should be
.BR OFF .


c.
.B ForegroundAtExit
.br
d.
.B BackgroundAtExit
 - this variables are used to specify the foreground and background colors that
.I GIT
should set at exit.


.B "2. [GIT-Setup]"

In this section the variables have only one field.

a. 
.B StartupFileDisplayMode
 - this variable specifies the file specific information
displayed at startup. It can be any of 
.B OwnerGroup
,
.B DateTime
,
.B Size
,
.B Mode
or
.BR FullName .
 - this value initially affects both panels but it can be changed separately
afterward.

b.
.B StartupFileSortMethod

 - this variable specifies the startup sort method. It can be any of
.B Name
,
.B Extension
,
.B Size
,
.B Date
,
.B Mode
,
.B OwnerId
,
.B GroupId
,
.B OwnerName
or
.BR GroupName .
 - this value initially affects both panels but it can be changed separately
afterward.

c. 
.B StartupLeftPanelPath
.br
d.
.B StartupRightPanelPath
 - those variables specifies the startup path for each panel.

e.
.B HistoryFile
 - this variable specifies the history file name. The default value is
.BR ~/.githistory .

f.
.B NormalModeHelp
.br
g.
.B CommandLineModeHelp
 - those variables describe the status bar contents for each
.I git
mode when no errors occurred (git is idle).
.I git
can display on the status bar a help string and/or some system information
(system type, hostname, machine type and the current date) using escape
characters (s, h, m or d preceded by backslash):
.in +.5i
.BR s "    ->      the system type"
.br
.BR h "    ->      the host name"
.br
.BR m "    ->      the machine type"
.br
.BR d "    ->      the current date"
.br
See also
.BR show-terminal .

h.
.B InfoDisplay
 - if this variable is OFF, auxiliary file informations are not displayed.
This can be useful if you are using a very slow terminal.

i.
.B FrameDisplay
 - if this variable is OFF, the git frame is not displayed. This can be
useful if you are using a very slow terminal.

j.
.B LeadingDotMatch

 - if this variable is
.BR OFF ,
when matching files for
.B select-files-matching-pattern
/
.B unselect-files-matching-pattern
then the leading
.B "'.'"
in the file name is matched only explicitly.


.B "3. [GITPS-Setup]"

In this section the variables have only one field.

a.
.B GitPsModeHelp
 - this variable describe the
.I gitps
status bar contents.

.B "4. [GITVIEW-Setup]"

In this section the variables have only one field.

a.
.B GitViewModeHelp
 - this variable describe the
.I gitview
status bar contents.

.B "5. [GITxxx-Color] / [GITxxx-Monochrome]"

In this sections the variables have only one field.

These sections permits you to customize the colors of
.IR git ,
.I gitps
and
.IR gitview .
Reading the
.B ".gitrc.TERM"
configuration file should be self explanatory.
See also the
.B [Setup]
section.

.B "6. [GIT-Keys]"

This section describes the actions
.I git
takes when a specified
key is pressed. In this section a variable can have up to 6
fields separated by \';\'.
Each line in this section looks like:

.BR key_sequence " " "" = " " "" command_name ; formatted_command ; new_dir ;
.br
.BR "               " "" save_screen ; pause ; hide

.B WARNING
: you can't continue the variable fields description on the next line.


a.
.B key_sequence
 -
.B key_sequence
is the key sequence associated with the given command. You can use any key
sequence wich doesn't start with an ascii character (0x20 to 0x7e). You
can specify the
.B ESC
character as
.B "^[" 
, the
.B ^
character as
.B ^^
, the
.B backspace
character as
.B ^_
, the
.B ctrl-space
character as
.B ^$
and the
.B space
character as
.BR ^@ " ."
Ascii characters are used by the input line.

You can use some symbolic key names instead of the key sequence:
.BR F0 ,
.BR F1 ,
.BR F2 , " ..."
.BR F10 ,
.BR UP ,
.BR DOWN ,
.BR RIGHT ,
.BR LEFT ,
.BR INS ,
.BR DEL ,
.BR HOME ,
.BR END ,
.B PGUP
and
.BR PGDOWN .
For the function & cursor keys, it's a better idea to get the key
sequences from the termcap/terminfo database if they can be found there.
So, the command for the F1 key on the Linux console (the configuration
file is
.BR .gitrc.console )
can be:
.br
		F1  = GIT-HELP; man git
.br
	or
.br
		^[A = GIT-HELP; man git
.br
If some key doesn't have a termcap/terminfo description (like the
F11/F12 keys on the Linux console) you can specify the key sequence
in the usual way.

b.
.B command_name
 -
.B command_name
is a command generic name. Even if it is not always used, the
.B command_name
must be present (if a command is associated with
.BR key_sequence ).
If it is not, no action will be taken when pressing
.B key_sequence.
There are two types of commands in
.I git
:
.B built-in
commands and
.B user defined
commands.
If the
.B command_name
section contains a built-in command specification
.BR "" ( copy-files , " " "" rename-move-files , " " "" make-directory
etc), the other fields are ignored.


The
.B BUILT-IN COMMANDS
are:

.B copy-files
 - copies files from one panel to another.

.B rename-move-files
 - moves files from one panel to another.

.B make-directory
 - makes directories.

.B delete-files
 - deletes files and empty directories.

.B exit
 - exits
.IR git .

.B previous-history-element
 - copies to the input line the previous command in the history list.

.B show-terminal
 - switches between the two
.I git
modes (starting with Linux 0.99.12 this option is completely used only if
you are super user because normal users can't do a screen dump).

.B refresh
 - refreshes the contents of the current panel.

.B goto-root-directory
 - changes the current directory to root.

.B switch-panels
 - switches the left panel with the right one.

.B next-history-element
 - copies the next command in the history list to the input line.

.B panel-display-next-mode
 - switches to the next file display mode.

.B panel-display-owner-group
 - displays the file owner & group.

.B panel-display-date-time
 - displays the file date & time.

.B panel-display-size
 - displays the file size.

.B panel-display-mode
 - displays the file mode.

.B panel-display-full-name
 - displays the full file name (if possible).

.B panel-sort-next-method
 - switches to the next sort method.

.B panel-sort-by-name
 - sorts the files by extension.

.B panel-sort-by-extension
 - sorts the files by name.

.B panel-sort-by-size
 - sorts the files by size.

.B panel-sort-by-date
 - sorts the files by date.

.B panel-sort-by-mode
 - sorts the files by mode.

.B panel-sort-by-owner-id
 - sorts the files by owner id.

.B panel-sort-by-group-id
 - sorts the files by group id.

.B panel-sort-by-owner-name
 - sorts the files by owner name.

.B panel-sort-by-group-name
 - sorts the files by group name.

.B select-file
 - selects/unselects files. All the files can be selected by pressing
.BR "" ' + '
(and ENTER) or unselected by pressing
.BR "" ' - "'."
By pressing
.BR "" ' * '
selected files becomes unselected and unselected files becomes selected.

.B file-to-input-line
 - copies to the input line the current file name .

.B beginning-of-panel
 - puts the cursor onto the first entry in the current directory list.

.B end-of-panel
 - puts the cursor onto the last entry in the current directory list.

.B scroll-down
 - puts the cursor up one page in the current directory file list.

.B scroll-up
 - puts the cursor down one page in the current directory file list.

.B previous-line
 - puts the cursor up one entry in the current directory file list.

.B next-line
 - puts the cursor down one entry in the current directory file list.

.B other-panel
 - puts the cursor in the other panel.

.B change-directory
 - changes the current directory to a user specified directory.

.B hard-refresh
 - forces a screen refresh.

.B select-files-matching-pattern
 - selects files matching a given pattern.

.B unselect-files-matching-pattern
 - unselects files matching a given pattern.

.B conform-current-directory
 - the other panel current directory will become the current directory of
the current panel.

.B conform-other-directory
 - the current directory of the current panel will become the current
directory of the other panel.

.B other-path-to-input-line
 - copy the other panel path to the input line.

.B selected-files-to-input-line
 - copy all the current panel selected file names to the input line.

.B backward-char
 - Move the point backward one character.

.B forward-char
 - Move the point forward one character.

.B backward-word
 - Move the point backward one word.

.B forward-word
 - Move the point forward one word.

.B beginning-of-line
 - Move the point at the beginning of the line.

.B end-of-line
 - Move the point at the end of the line.

.B delete-char
 - Delete the character at the point.

.B backward-delete-char
 - Delete the character before the point.

.B backward-kill-word
 - Kill characters backward until encountering the end of a word.

.B kill-line
 - Delete the entire input line.

.B kill-to-beginning-of-line
 - Delete the text between the beginning of the line and the point.

.B kill-to-end-of-line
 - Delete the text between the point and the end of line.

.B just-one-space
 - Remove all the tabs and spaces arround the point, leaving just one space.

.B delete-horizontal-space
 - Remove all the tabs and spaces arround the point.

.B action
 - If the current file is executable, runs it.  If it is a directory, chdir
to it.

.B set-mark
 - Set mark where point is.

.B kill-region
 - Kill between point and mark.  The text is deleted but saved in
the kill ring.

.B kill-ring-save
 - Save the region as if killed, but don't kill it.

.B yank
 - Reinsert the last stretch of killed text.

.B exchange-point-and-mark
 - Exchange point and mark.


c.
.B formatted_command
 -
.B formatted_command
is a shell command which can contain some scanf like format specifiers.
With their help you can get the current directory entry name (the directory
entry under the cursor), owner, group and mode. These are the available
.BR "format specifiers" :

 -
.B %s{question,default_answer}
.br
When
.I git
encounters a
.B %s
in the formatted_command
asks the user the question 'question' whose default
answer is 'default_answer' and replaces the
.B %s{ , }
with the user answer. Both 'question' and 'default_answer' can
contain any other format specifiers except
.BR %s .

.B WARNING
: no spaces between
.B %s
and
.BR "" \' { \' "" .

 -
.B %f
.br
.I git
will replace
.B %f
with the current directory entry name only if it is a file (not a directory).

 -
.B %d
.br
.I git
will replace 
.B %d
with the current directory entry name only if it is a directory (not a file).

 -
.B %l
.br
.I git
will replace
.B %l
with the current directory entry name only if it is a symbolic link with no
target.

 -
.B %t
.br
.I git
will replace
.B %t
with the current directory entry name only if it is a named pipe.

 -
.B %z
.br
.I git
will replace
.B %z
with the current directory entry name only if it is a socket.

 -
.B %a
.br
.I git
will always replace
.B %a
with the current directory entry name.

 -
.B %m
.br
.I git
will always replace
.B %m
in the formatted_command with the current file mode.

 -
.B %g
.br
.I git
will always replace
.B %g
in the formatted_command with the current file group.

 -
.B %o
.br
.I git
will always replace
.B %o
in the formatted_command with the current file owner.

 -
.B %p
.br
.I git
will always replace
.B %p
in the formatted_command with the current panel path.

 -
.B %b
.br
.I git
will always replace
.B %b
in the formatted_command with the current panel directory name.
.br

 -
.B %i
.br
.I git
will always replace
.B %i
in the formatted_command with all the current panel selected file names.
.br

Using
.B uppercase format specifiers
you will be able to access the other panel path, file and directory names.

d.
.B new_dir
 - if the
.B formatted_command
successfully exits (exit code = 0) and this field is present then
.B new_dir
will become the current panel directory.
The character
.B ~
used at the begining of the
.B new_dir
field is replaced by the user's home
directory.

e.
.B save_screen
 - this field is an character (usually 'y' or 'n') who tells
.I git
to save ('y') or not to save ('n') the terminal screen
after executing the
.B formatted_command.
Saving the screen is not necessary while editing or viewing a
file because the information left after the editor or
the viewer exits is not important. Saving the screen
means that that screen will be restored before the
execution of the next command. This field is used only if you are
super user under Linux and you are working on a virtual console.
By default this field is 'y'.

f.
.B pause
 - for some commands you may wish to read their results	before
repainting the panels. If this field is present
.I git
will wait for a key to be pressed before restoring the panels.
By default this field is 'n'.

g.
.B hide
 - there are some commands that aren't displaying any
useful information if successfully complete their
execution: mount, chmod, chown, chgrp, sync ... and if
an error occurs then a line or two are sended to
stderr.	If this option is 'y', the stdout and stderr
will be redirected to some files
.BR "" ( stdout.pid
and
.B stderr.pid
, where
.B pid
is
.I git
.IR pid )
and only if the command exit code is not 0, the
.B stderr.pid
file will be displayed, line by line, onto the status bar. This
way the panels will not be deleted and then repainted
and the command appears to be built-in. 
.B stdout.pid
and
.B stderr.pid
are created in the
.B TempDirectory
specified in the
.B [Setup]
section. By default this field is 'n'.

The default configuration file
.B "$HOME/.gitrc.TERM"
supports most of the usual commands. To find out more about them please
read it.
.I git
allows you to change both the utility used to perform
a particular operation (using compress instead of gzip :-) ) and
the key associated with it. There is also possible to
.BR remove / add
new commands.

.B 7. [GITPS-Keys]

This section describes the actions
.I gitps
takes when a specified key is pressed. In this sections the variables
have only one field. Only built-in operations are available in
.IR gitps .
Each line in this section looks like:

.BR key_sequence " " "" = " " "" built_in_command_name


a.
.B key_sequence
 -
.B key_sequence
is the key sequence associated with the given command. You can use any key
sequence wich doesn't start with an ascii character (0x20 to 0x7e). You 
can specify the
.B ESC
character as
.B "^[" 
, the
.B ^
character as
.BR ^^
and
.B space
as
.BR ^@ " ."

b.
.B built_in_command_name
 -
.B built_in_command_name
is the name of the built-in operation to run when
.B key_sequence
is pressed. The built-in operations are:

.BR "" "- " previous-line
- moves to the previous process in the processes list
.br
.BR "" "- " next-line
- moves to the next process in the processes list
.br
.BR "" "- " scroll-down
- moves one page up in the processes list
.br
.BR "" "- " scroll-up
- moves one page down in the processes list
.br
.BR "" "- " beginning-of-panel
- moves to the first process in the processes list
.br
.BR "" "- " end-of-panel
- moves to the last process in the processes list
.br
.BR "" "- " next-signal
- sets the next signal in the signals list as the current signal
.br
.BR "" "- " SIGHUP
.br
.BR "" "- " SIGINT
.br
.BR "" "- " SIGQUIT
.br
.BR "" "- " SIGILL
.br
.BR "" "- " SIGFPE
.br
.BR "" "- " SIGKILL
.br
.BR "" "- " SIGUSR1
.br
.BR "" "- " SIGSEGV
.br
.BR "" "- " SIGUSR2
.br
.BR "" "- " SIGPIPE
.br
.BR "" "- " SIGALRM
.br
.BR "" "- " SIGTERM
.br
.BR "" "- " SIGCHLD
.br
.BR "" "- " SIGCONT
- sets the SIG... signal as the current signal
.br
.BR "" "- " kill-process
- sends the current signal to the current process
.br
.BR "" "- " refresh
- refresh the processes list by re-calling
.BR ps "(1)"
.br
.BR "" "- " hard-refresh
- force the screen refresh the screen by re-calling
.BR ps "(1)"
and invalidating the terminal cache.
.br
.BR "" "- " exit
- exits

.B 8. [GITVIEW-Keys]

This section describes the actions
.I gitview
takes when a specified key is pressed. In this sections the variables
have only one field. Only built-in operations are available in
.IR gitview .
Each line in this section looks like:

.BR key_sequence " " "" = " " "" built_in_command_name


a.
.B key_sequence
 -
.B key_sequence
is the key sequence associated with the given command. You can use any key
sequence wich doesn't start with an ascii character (0x20 to 0x7e). You 
can specify the
.B ESC
character as
.B "^[" 
, the
.B ^
character as
.BR ^^
and
.B space
as
.BR ^@ " ."


b.
.B built_in_command_name
 -
.B built_in_command_name
is the name of the built-in operation to run when
.B key_sequence
is pressed. The built-in operations are:

.BR "" "- " previous-line
- moves to the previous line (16 bytes) in the file
.br
.BR "" "- " next-line
- moves to the next line (16 bytes) in the file
.br
.BR "" "- " scroll-down
- moves one page up (0x100 bytes) in the file
.br
.BR "" "- " scroll-up
- moves one page down (0x100 bytes) in the file
.br
.BR "" "- " beginning-of-panel
- moves to the beginning of the file
.br
.BR "" "- " end-of-panel
- moves to the end of the file
.br
.BR "" "- " refresh
- refresh the screen by re-reading the file
.br
.BR "" "- " hard-refresh
- force the screen refresh the screen by re-reading the file and
invalidating the terminal cache.
.br
.BR "" "- " exit
- exits



.SH CANCELING OPERATIONS
All built-in operations and input requests can be stopped by pressing
.BR ^G .
.br
.I git
can be suspended by pressing
.BR ^Z .


.SH LIMITATIONS
.B "1."
Background execution is not fully supported. That means you
may specify an 
.B &
terminated command line in the
configuration file but the result of the background executed
command (stdout and stderr redirection, as explained before)
will be overwritten by the result of newer commands and, if
an error occurs, you will not see it.

.B "2."
When
.I git
is compiled for
.BR Linux ,
the default built-in color descriptions are for color monitors,
so you can't (decently) run
.I git
on a b/w monitor without the
.B ".gitrc.TERM"
file correctly configured.
.B ".gitrc.TERM"
should be configured with
.BR "ColorMonitor = OFF" .
If you are working on a serial b/w tty,
.B LinuxConsole
should be
.B OFF
too.

.B "3."
.B Job
support is implemented only in
.IR git .

.B "4."
Due to the fact that the
.BR "" ' ; '
character is used as a field separator in the
configuration files, you can't write something like that in the
.B .gitrc.TERM
files:

^AAA = SHOW-USERS-AND-GROUPS; more /etc/passwd; more /etc/group

because 'more /etc/group' will be considered as a directory to switch to.
You must write a small script instead:

#!/bin/sh
.br
more /etc/passwd; more /etc/group

Supposing the script name is
.BR "" ' show_ug '
, the
.B .gitrc.TERM
line will be like that:

^AAA = SHOW-USERS-AND-GROUPS; show_ug


.SH BUGS
None so far. :-)

Please send bug reports to
.IR tudor@cs.pub.ro

.SH SEE ALSO
termcap(5) terminfo(5) sh(1) ps(1) mount(8) umount(8) gitaction(1) gitmount(1)
gitmatch(1) gitcmp(1) gitkeys(1) gitredir(1) gitrgrep(1)

.SH FILES
/usr/local/bin/git
.br
/usr/local/bin/gitps
.br
/usr/local/bin/gitview
.br
/usr/local/man/man1/git.1
.br
/usr/local/man/man1/gitps.1
.br
/usr/local/man/man1/gitview.1
.br
/usr/local/info/git.info
.br
/usr/local/lib/.gitrc.TERM
.br
$HOME/.gitrc.TERM

.SH AUTHORS
.I Tudor Hulubei
.br
- tudor@cs.pub.ro
.br
.I Andrei Pitis
.br
- pink@cs.pub.ro
.br
.B "Politehnica" University of Bucharest
.br
.B Romania
