/*
 * Programm XBLAST V10.4 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 16th 1994
 * started August 1993
 *
 * File: sprite.c
 * bitmap data of player sprites
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include "include.h"


/* daten fuer winner */

unsigned char winner_mask[SIZE_OF_WINNER] =
{
  /* Bitmap x=0 y=96 w=64 h=96 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 0x00, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xcf, 0x00, 
  0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x01, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 
  0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x00, 0x00};



unsigned char winner_bits[MAX_PLAYER][SIZE_OF_WINNER] = 
{
  
  {
    /* Bitmap x=128 y=96 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x0c, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x50, 0x01, 0x00, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x03, 0x00, 0x20, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 
    0x00, 0x00, 0x52, 0x01, 0x00, 0x80, 0x00, 0x00, 
    0x00, 0x00, 0x41, 0xf8, 0x3f, 0x80, 0x01, 0x00, 
    0x00, 0x00, 0x01, 0x07, 0xc0, 0x01, 0x01, 0x00, 
    0x00, 0x80, 0xc0, 0x00, 0x00, 0x86, 0x02, 0x00, 
    0x00, 0x80, 0x30, 0x00, 0x00, 0x18, 0x03, 0x00, 
    0x00, 0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 0x00, 
    0x00, 0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 0x00, 
    0x00, 0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 0x00, 
    0x00, 0xe6, 0x08, 0x7e, 0xfc, 0x20, 0xcf, 0x00, 
    0x00, 0x99, 0x08, 0x7e, 0xfc, 0xa0, 0x32, 0x01, 
    0x80, 0xd0, 0x08, 0x7e, 0xfc, 0x20, 0x13, 0x02, 
    0x80, 0xa0, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 0x02, 
    0x80, 0xc0, 0x08, 0x7e, 0xfc, 0x20, 0x03, 0x03, 
    0x80, 0xa0, 0x08, 0x7e, 0xfc, 0xa0, 0x82, 0x02, 
    0x00, 0x61, 0x11, 0x3c, 0x78, 0x50, 0x4d, 0x01, 
    0x00, 0xbe, 0x61, 0x00, 0x00, 0xac, 0xf3, 0x00, 
    0x00, 0x44, 0x83, 0x01, 0x00, 0xd3, 0x61, 0x00, 
    0x00, 0x84, 0x2e, 0xfe, 0xff, 0xe8, 0x50, 0x00, 
    0x00, 0x08, 0x5d, 0x00, 0x00, 0x75, 0x20, 0x00, 
    0x00, 0x08, 0xba, 0xaa, 0xaa, 0x3a, 0x30, 0x00, 
    0x00, 0x10, 0xf0, 0xff, 0xff, 0x0f, 0x18, 0x00, 
    0x00, 0x10, 0xe0, 0xff, 0xff, 0x07, 0x14, 0x00, 
    0x00, 0x20, 0xc0, 0xfe, 0xff, 0x06, 0x0a, 0x00, 
    0x00, 0x40, 0xc0, 0x00, 0x00, 0x07, 0x05, 0x00, 
    0x00, 0x80, 0xe0, 0x00, 0x40, 0xae, 0x02, 0x00, 
    0x00, 0x00, 0xd3, 0x00, 0x3c, 0xd7, 0x01, 0x00, 
    0x00, 0x00, 0x6c, 0x00, 0x3a, 0x6e, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0x00, 0x3e, 0x1d, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x3e, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x1c, 0x15, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x15, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0xe0, 0x8f, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x3f, 0xf8, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xe0, 0x4f, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x03, 0xa0, 0x05, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x06, 0xd0, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x0c, 0x68, 0x05, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0x58, 0x35, 0x0a, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 0x00, 
    0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 0x00, 
    0x00, 0x00, 0xcf, 0xf7, 0xcf, 0xe7, 0x01, 0x00, 
    0x00, 0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 0x00, 
    0x00, 0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 0x00, 
    0x00, 0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x00, 0x00}, 
  
  
  {
    /* Bitmap x=192 y=96 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xa0, 0xfe, 0xff, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0xff, 0xff, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0x0c, 0xfe, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0x57, 0x07, 0xc0, 0xff, 0x01, 0x00, 
    0x00, 0x80, 0xff, 0x00, 0x00, 0xfe, 0x03, 0x00, 
    0x00, 0x80, 0x3f, 0x00, 0x00, 0xf8, 0x03, 0x00, 
    0x00, 0x80, 0x0f, 0x3c, 0x78, 0xe0, 0x03, 0x00, 
    0x00, 0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 0x00, 
    0x00, 0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 0x00, 
    0x00, 0xe6, 0x0f, 0x7e, 0xfc, 0xe0, 0xcf, 0x00, 
    0x00, 0x99, 0x0f, 0x7e, 0xfc, 0xe0, 0x33, 0x01, 
    0x80, 0xd0, 0x0f, 0x7e, 0xfc, 0xe0, 0x13, 0x02, 
    0x80, 0xa0, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 0x02, 
    0x80, 0xc0, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 0x02, 
    0x80, 0xa0, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 0x02, 
    0x00, 0x61, 0x1f, 0x3c, 0x78, 0xf0, 0x0d, 0x01, 
    0x00, 0xbe, 0x7f, 0x00, 0x00, 0xfc, 0xf3, 0x00, 
    0x00, 0x44, 0xff, 0x01, 0x00, 0xff, 0x61, 0x00, 
    0x00, 0x84, 0xfe, 0xff, 0xff, 0xff, 0x50, 0x00, 
    0x00, 0x08, 0xfd, 0xff, 0xff, 0x7f, 0x20, 0x00, 
    0x00, 0x08, 0xfa, 0xff, 0xff, 0x3f, 0x30, 0x00, 
    0x00, 0x10, 0xb0, 0xff, 0xff, 0x0b, 0x18, 0x00, 
    0x00, 0x10, 0xe0, 0xfc, 0xff, 0x04, 0x14, 0x00, 
    0x00, 0x20, 0xc0, 0x01, 0x00, 0x07, 0x0a, 0x00, 
    0x00, 0x40, 0xc0, 0xf8, 0xbf, 0x07, 0x05, 0x00, 
    0x00, 0x80, 0xe0, 0xfc, 0x43, 0xaf, 0x02, 0x00, 
    0x00, 0x00, 0xd3, 0xf8, 0xbd, 0xd7, 0x01, 0x00, 
    0x00, 0x00, 0x6c, 0xfc, 0xba, 0x6f, 0x00, 0x00, 
    0x00, 0x00, 0xb0, 0xfa, 0xbe, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x70, 0xfd, 0xbe, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xfe, 0xdd, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0xe3, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0xd0, 0x17, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xd0, 0x17, 0x08, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xd0, 0x17, 0x08, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xd0, 0x17, 0x0c, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xff, 0xff, 0x05, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0xff, 0xff, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0xfc, 0x7f, 0x05, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xfc, 0x3f, 0x0a, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 0x00, 
    0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 0x00, 
    0x00, 0x00, 0xcf, 0xf7, 0xcf, 0xe7, 0x01, 0x00, 
    0x00, 0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 0x00, 
    0x00, 0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 0x00, 
    0x00, 0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x00, 0x00}, 
  
  
  {
    /* Bitmap x=256 y=96 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x5e, 0xf5, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xab, 0xaa, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x70, 0x55, 0x55, 0x1d, 0x00, 0x00, 
    0x00, 0x00, 0x08, 0xaa, 0xaa, 0x2a, 0x00, 0x00, 
    0x00, 0x00, 0x04, 0x54, 0x55, 0x55, 0x00, 0x00, 
    0x00, 0x00, 0x02, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 
    0x00, 0x00, 0x05, 0xfd, 0x7f, 0xd5, 0x01, 0x00, 
    0x00, 0x00, 0xab, 0x07, 0xc0, 0xab, 0x01, 0x00, 
    0x00, 0x80, 0xd5, 0x00, 0x00, 0xd6, 0x03, 0x00, 
    0x00, 0x80, 0x3a, 0x00, 0x00, 0xb8, 0x03, 0x00, 
    0x00, 0x80, 0x0d, 0x3c, 0x78, 0xe0, 0x03, 0x00, 
    0x00, 0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 0x00, 
    0x00, 0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 0x00, 
    0x00, 0xe6, 0x0a, 0x7e, 0xfc, 0xa0, 0xcf, 0x00, 
    0x00, 0x99, 0x0d, 0x7e, 0xfc, 0xe0, 0x33, 0x01, 
    0x80, 0xd0, 0x0a, 0x7e, 0xfc, 0xa0, 0x13, 0x02, 
    0x80, 0xa0, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 0x02, 
    0x80, 0xc0, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 0x03, 
    0x80, 0xa0, 0x0d, 0x7e, 0xfc, 0xe0, 0x83, 0x02, 
    0x00, 0x61, 0x1b, 0x3c, 0x78, 0xf0, 0x4d, 0x01, 
    0x00, 0xbe, 0x75, 0x00, 0x00, 0xfc, 0xf3, 0x00, 
    0x00, 0x44, 0xab, 0x01, 0x00, 0xff, 0x61, 0x00, 
    0x00, 0x84, 0x5e, 0xff, 0xff, 0xfd, 0x50, 0x00, 
    0x00, 0x08, 0xfd, 0xaa, 0xaa, 0x7f, 0x20, 0x00, 
    0x00, 0x08, 0xfa, 0xff, 0xff, 0x3f, 0x30, 0x00, 
    0x00, 0x10, 0xf0, 0xff, 0xff, 0x0f, 0x18, 0x00, 
    0x00, 0x10, 0xe0, 0xff, 0xff, 0x07, 0x14, 0x00, 
    0x00, 0x20, 0xc0, 0xff, 0x7f, 0x07, 0x0a, 0x00, 
    0x00, 0x40, 0xc0, 0xaa, 0x8a, 0x06, 0x05, 0x00, 
    0x00, 0x80, 0xe0, 0x55, 0x41, 0xaf, 0x02, 0x00, 
    0x00, 0x00, 0xd3, 0xaa, 0x3e, 0xd7, 0x01, 0x00, 
    0x00, 0x00, 0x6c, 0x55, 0x3a, 0x6f, 0x00, 0x00, 
    0x00, 0x00, 0xb0, 0xaa, 0xbe, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x50, 0x55, 0x3e, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xb0, 0xaa, 0xbe, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x50, 0x55, 0x41, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xb0, 0xaa, 0xaa, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x50, 0xf5, 0xdf, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x3f, 0xf8, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xea, 0xef, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x57, 0xf5, 0x05, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0xae, 0xfa, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x5c, 0x7d, 0x05, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xf8, 0x3f, 0x0a, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 0x00, 
    0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 0x00, 
    0x00, 0x00, 0xcf, 0xf7, 0xcf, 0xe7, 0x01, 0x00, 
    0x00, 0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 0x00, 
    0x00, 0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 0x00, 
    0x00, 0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x00, 0x00}, 
  
  
  {
    /* Bitmap x=320 y=96 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x60, 0x0d, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0xae, 0xea, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x50, 0x51, 0x15, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xa8, 0x2a, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x53, 0x15, 0x20, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xa8, 0x2a, 0x40, 0x00, 0x00, 
    0x00, 0x00, 0x52, 0x51, 0x15, 0x80, 0x00, 0x00, 
    0x00, 0x00, 0x41, 0xf8, 0x3f, 0x80, 0x01, 0x00, 
    0x00, 0x00, 0x01, 0x07, 0xc0, 0x01, 0x01, 0x00, 
    0x00, 0x80, 0xc0, 0x00, 0x00, 0x86, 0x02, 0x00, 
    0x00, 0x80, 0x30, 0x00, 0x00, 0x18, 0x03, 0x00, 
    0x00, 0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 0x00, 
    0x00, 0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 0x00, 
    0x00, 0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 0x00, 
    0x00, 0xe6, 0x08, 0x7e, 0xfc, 0x20, 0xcf, 0x00, 
    0x00, 0x99, 0x08, 0x7e, 0xfc, 0xa0, 0x32, 0x01, 
    0x80, 0xd0, 0x08, 0x7e, 0xfc, 0x20, 0x13, 0x02, 
    0x80, 0xa0, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 0x02, 
    0x80, 0xc0, 0x08, 0x7e, 0xfc, 0x20, 0x03, 0x03, 
    0x80, 0xa0, 0x08, 0x7e, 0xfc, 0xa0, 0x82, 0x02, 
    0x00, 0x61, 0x11, 0x3c, 0x78, 0x50, 0x4d, 0x01, 
    0x00, 0xfe, 0x61, 0x00, 0x00, 0xac, 0xfb, 0x00, 
    0x00, 0xd4, 0x83, 0x01, 0x00, 0xd3, 0x75, 0x00, 
    0x00, 0xac, 0x2f, 0xfe, 0xff, 0xe8, 0x7a, 0x00, 
    0x00, 0x58, 0x5f, 0x00, 0x00, 0x75, 0x35, 0x00, 
    0x00, 0xa8, 0xbe, 0xaa, 0xaa, 0xba, 0x3a, 0x00, 
    0x00, 0x50, 0xf5, 0xff, 0xff, 0x5f, 0x1d, 0x00, 
    0x00, 0xb0, 0xea, 0xff, 0xff, 0xaf, 0x1e, 0x00, 
    0x00, 0x60, 0xf5, 0xfe, 0xff, 0x56, 0x0f, 0x00, 
    0x00, 0xc0, 0xea, 0x00, 0x00, 0xaf, 0x07, 0x00, 
    0x00, 0x80, 0xf5, 0x00, 0x40, 0xfe, 0x03, 0x00, 
    0x00, 0x00, 0xfb, 0x00, 0x3c, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0x7c, 0x00, 0x3a, 0x7e, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0x00, 0x3e, 0x1d, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x3e, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x1c, 0x15, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x15, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0xe0, 0x8f, 0x1a, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x3f, 0xf8, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xe0, 0x4f, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x03, 0xa0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x06, 0xd0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x40, 0x0d, 0x68, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xa0, 0x5a, 0xb5, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xa0, 0x3e, 0xa8, 0x0e, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xb0, 0xfe, 0xbf, 0x1e, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0xfd, 0x5f, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xbe, 0xfe, 0xbf, 0xfe, 0x00, 0x00, 
    0x00, 0x00, 0x7f, 0xfd, 0x7f, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0xcf, 0xf7, 0xcf, 0xe7, 0x01, 0x00, 
    0x00, 0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 0x00, 
    0x00, 0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 0x00, 
    0x00, 0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 0x00, 
    0x00, 0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x00, 0x00}, 
  
  
};

/* include file fuer sprite-daten */	

unsigned char sprite_mask[(MAX_ANIME-1)][SIZE_OF_SPRITE] = 
{
  {
    /* Bitmap x=0 y=0 w=64 h=96 */
    0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  {
    /* Bitmap x=64 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0x3f, 0xf0, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x03, 0x00,},
  
  {
    /* Bitmap x=128 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0x1f, 0xf8, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x1f, 0x00},
  
  {
    /* Bitmap x=192 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  
  {
    /* Bitmap x=256 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0x1f, 0xf8, 0x0f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  
  {
    /* Bitmap x=320 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0x3f, 0xf0, 0x1f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  
  {
    /* Bitmap x=384 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0x01, 0x00, 
    0x7c, 0x80, 0xff, 0xff, 0x0f, 0x00, 
    0xfe, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
    0xfe, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
    0xfe, 0xfb, 0xff, 0xff, 0xff, 0x00, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0x02, 
    0xfc, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x00, 0xff, 0xff, 0xff, 0x3f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xfe, 0xff, 0xff, 0x7f, 0x02, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x02, 
    0x00, 0xfc, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xf8, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfc, 0xfd, 0xff, 0x00, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  
  {
    /* Bitmap x=448 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0x01, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x0f, 0x00, 
    0x7c, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
    0xfe, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
    0xfe, 0xfb, 0xff, 0xff, 0xff, 0x00, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0x02, 
    0xfe, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x7c, 0xff, 0xff, 0xff, 0x3f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x04, 
    0x00, 0xfe, 0xff, 0xff, 0x7f, 0x02, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x02, 
    0x00, 0xfc, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xf8, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfc, 0xfd, 0xff, 0x00, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  
  {
    /* Bitmap x=512 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x3e, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x7f, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0xff, 0xfd, 0xff, 0xff, 0x7f, 0x00, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0xff, 0xff, 0xff, 0xff, 0x7f, 0x01, 
    0xff, 0xff, 0xff, 0xff, 0x1f, 0x01, 
    0xbe, 0xff, 0xff, 0xff, 0x1f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x02, 
    0x00, 0xff, 0xff, 0xff, 0x3f, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0x1f, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xfe, 0x7f, 0x00, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x03, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x80, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00},
  
  {
    /* Bitmap x=576 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x07, 0x00, 0x00, 
    0x00, 0x80, 0xff, 0x3f, 0x00, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x01, 0x3e, 
    0x00, 0xfc, 0xff, 0xff, 0x07, 0x7f, 
    0x00, 0xfe, 0xff, 0xff, 0x0f, 0x7f, 
    0x00, 0xff, 0xff, 0xff, 0xdf, 0x7f, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x40, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x40, 0xfc, 0xff, 0xff, 0xff, 0x3f, 
    0x20, 0xfc, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x40, 0xfe, 0xff, 0xff, 0x7f, 0x00, 
    0x40, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0xff, 0xbf, 0x3f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00},
  {
    /* Bitmap x=0 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x07, 0x00, 0x00, 
    0x00, 0x80, 0xff, 0x3f, 0x00, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x01, 0x3e, 
    0x00, 0xfc, 0xff, 0xff, 0x07, 0x7f, 
    0x00, 0xfe, 0xff, 0xff, 0x0f, 0x7f, 
    0x00, 0xff, 0xff, 0xff, 0xdf, 0x7f, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x40, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x40, 0xfc, 0xff, 0xff, 0xff, 0x3f, 
    0x20, 0xfc, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x40, 0xfe, 0xff, 0xff, 0x7f, 0x00, 
    0x40, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0xff, 0xbf, 0x3f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00},
  
  {
    /* Bitmap x=64 y=0 w=64 h=96 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x07, 0x00, 0x00, 
    0x00, 0x80, 0xff, 0x3f, 0x00, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x01, 0x3e, 
    0x00, 0xfc, 0xff, 0xff, 0x07, 0x7f, 
    0x00, 0xfe, 0xff, 0xff, 0x0f, 0x7f, 
    0x00, 0xff, 0xff, 0xff, 0xdf, 0x7f, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x40, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x40, 0xfc, 0xff, 0xff, 0xff, 0x3f, 
    0x20, 0xfc, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x40, 0xfe, 0xff, 0xff, 0x7f, 0x00, 
    0x40, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0x00, 0xff, 0xbf, 0x3f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x01, 0x00},
  
  
  {
    /* Bitmap x=0 y=0 w=64 h=96 */
    0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  
  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x1f, 0x00,
    0x00, 0x00, 0xf0, 0x9f, 0x3f, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x3f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x3f, 0x00,
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00,
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01,
    0x80, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x80, 0xff, 0xff, 0xff, 0x3f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x7f, 0x00,
    0x80, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x7f, 0x00,
    0x80, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00,
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00,
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07,
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f,
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f,
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07,
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01,
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00,
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00,
    0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0x3f, 0xf8, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x03, 0x00,
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03,
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01,
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00,
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
  
  
  {
    /* Bitmap x=0 y=192 w=64 h=96 */
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
    0x00, 0xb8, 0xff, 0xff, 0x3b, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xe0, 0xff, 0xff, 0xff, 0xff, 0x0f, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0xc0, 0xff, 0xff, 0xff, 0xff, 0x07, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xe0, 0x3f, 0xf8, 0x0f, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x0f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
    0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
    0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
    0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
  
  
};



unsigned char sprite_bits[MAX_PLAYER][(MAX_ANIME-1)][SIZE_OF_SPRITE] = 
{
  {
    /* player 1*/
    {
      /* Bitmap x=0 y=192 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0a, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x07, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x18, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
      0x00, 0x18, 0x03, 0x00, 0x40, 0x00, 
      0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 
      0x00, 0x51, 0x01, 0x00, 0x80, 0x01, 
      0x00, 0x41, 0x00, 0x00, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x80, 0x02, 
      0x80, 0xc0, 0x01, 0x00, 0x07, 0x03, 
      0x80, 0x30, 0x00, 0x00, 0x98, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x11, 0x7e, 0xfc, 0xb0, 0x01, 
      0x00, 0x22, 0x3c, 0x78, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x06, 
      0x40, 0xe0, 0x00, 0x00, 0x07, 0x05, 
      0x20, 0xd0, 0x00, 0x40, 0x06, 0x0a, 
      0x20, 0xe8, 0x00, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x00, 0x3a, 0x1e, 0x0a, 
      0x20, 0x7a, 0x00, 0x3e, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x3e, 0x1a, 0x0a, 
      0x20, 0x7a, 0x00, 0x1c, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x00, 0x1a, 0x0a, 
      0x40, 0x68, 0x00, 0x00, 0x0d, 0x04, 
      0x40, 0x3c, 0xe0, 0x8f, 0x7a, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0x07, 0xd0, 0x06, 0x00, 
      0x00, 0x40, 0x0c, 0x68, 0x05, 0x00, 
      0x00, 0x20, 0x58, 0x35, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 
      0x00, 0xcf, 0xf3, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
    {
      /* Bitmap x=64 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 
      0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x05, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x07, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x18, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
      0x00, 0x18, 0x03, 0x00, 0x40, 0x00, 
      0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 
      0x00, 0x51, 0x01, 0x00, 0x80, 0x01, 
      0x00, 0x41, 0x00, 0x00, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x80, 0x02, 
      0x80, 0xc0, 0x01, 0x00, 0x07, 0x03, 
      0x80, 0x30, 0x00, 0x00, 0x98, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x11, 0x7e, 0xfc, 0xb0, 0x01, 
      0x00, 0x22, 0x3c, 0x78, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x06, 
      0x40, 0xe0, 0x00, 0x00, 0x07, 0x05, 
      0x20, 0xd0, 0x00, 0x40, 0x06, 0x0a, 
      0x20, 0xe8, 0x00, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x00, 0x3a, 0x1e, 0x0a, 
      0x20, 0x7a, 0x00, 0x3e, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x3e, 0x1a, 0x0a, 
      0x20, 0x7a, 0x00, 0x1c, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x00, 0x1a, 0x0a, 
      0x40, 0x68, 0x00, 0x00, 0x0d, 0x04, 
      0x40, 0x3c, 0xe0, 0x8f, 0x7a, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0x07, 0xd0, 0x06, 0x00, 
      0x00, 0x40, 0x0c, 0x68, 0x0d, 0x00, 
      0x00, 0x40, 0x58, 0x35, 0x0a, 0x00, 
      0x00, 0x40, 0xf4, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x28, 0x10, 0x0a, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf8, 0x3f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf4, 0xcf, 0x67, 0x00, 
      0x00, 0x3e, 0xf8, 0x0f, 0xc0, 0x00, 
      0x00, 0x3f, 0xf4, 0x0f, 0xe0, 0x01, 
      0x00, 0x3f, 0xf8, 0x1f, 0xd0, 0x01, 
      0x80, 0x3f, 0xf4, 0x3f, 0xe8, 0x03, 
      0x80, 0x3f, 0xfc, 0x7f, 0xf5, 0x03, 
      0x80, 0xcf, 0xf3, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x07, 0xf4, 0xff, 0xff, 0x01, 
      0x00, 0x06, 0xea, 0xff, 0xff, 0x00, 
      0x00, 0x0c, 0xfd, 0xff, 0x7f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x1f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x03, 0x00},
    {
      /* Bitmap x=128 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xc0, 0x18, 0x00, 0x00, 
      0x00, 0x00, 0x40, 0x14, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x07, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x18, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
      0x00, 0x18, 0x03, 0x00, 0x40, 0x00, 
      0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 
      0x00, 0x51, 0x01, 0x00, 0x80, 0x01, 
      0x00, 0x41, 0x00, 0x00, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x80, 0x02, 
      0x80, 0xc0, 0x01, 0x00, 0x07, 0x03, 
      0x80, 0x30, 0x00, 0x00, 0x98, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x11, 0x7e, 0xfc, 0xb0, 0x01, 
      0x00, 0x22, 0x3c, 0x78, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x06, 
      0x40, 0xe0, 0x00, 0x00, 0x07, 0x05, 
      0x20, 0xd0, 0x00, 0x40, 0x06, 0x0a, 
      0x20, 0xe8, 0x00, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x00, 0x3a, 0x1e, 0x0a, 
      0x20, 0x7a, 0x00, 0x3e, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x3e, 0x1a, 0x0a, 
      0x20, 0x7a, 0x00, 0x1c, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x00, 0x1a, 0x0a, 
      0x40, 0x68, 0x00, 0x00, 0x0d, 0x04, 
      0x40, 0x3c, 0xe0, 0x8f, 0x7a, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0x07, 0xd0, 0x06, 0x00, 
      0x00, 0x60, 0x0c, 0x68, 0x05, 0x00, 
      0x00, 0x20, 0x58, 0x35, 0x06, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x05, 0x00, 
      0x00, 0x20, 0x18, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf4, 0x0f, 0x0c, 0x00, 
      0x00, 0x30, 0xf8, 0x1f, 0x1a, 0x00, 
      0x00, 0xcc, 0xf7, 0x1f, 0x7c, 0x00, 
      0x00, 0x06, 0xe8, 0x1f, 0xfa, 0x00, 
      0x00, 0x07, 0xf4, 0x1f, 0xfc, 0x01, 
      0x00, 0x07, 0xea, 0x1f, 0xfa, 0x01, 
      0x80, 0x0f, 0xfd, 0x1f, 0xfc, 0x03, 
      0x80, 0xaf, 0xfe, 0x7f, 0xfa, 0x03, 
      0x80, 0xff, 0xff, 0x8f, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xc0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe0, 0x01, 
      0x00, 0xfe, 0xff, 0x0f, 0xd0, 0x00, 
      0x00, 0xfc, 0xff, 0x3f, 0x68, 0x00, 
      0x00, 0xf0, 0xff, 0x7f, 0x35, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x1f, 0x00},
    {
      /* Bitmap x=192 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x07, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x18, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
      0x00, 0x18, 0x03, 0x00, 0x40, 0x00, 
      0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 
      0x00, 0x51, 0x01, 0x00, 0x00, 0x01, 
      0x00, 0x41, 0xc0, 0x07, 0x00, 0x01, 
      0x80, 0x00, 0x60, 0x0c, 0x80, 0x02, 
      0x80, 0x00, 0x20, 0x0a, 0x00, 0x03, 
      0x80, 0x00, 0x20, 0x0c, 0x80, 0x02, 
      0x80, 0x00, 0xa0, 0x0a, 0x00, 0x03, 
      0x80, 0x00, 0x60, 0x0d, 0x80, 0x02, 
      0x80, 0x00, 0xc0, 0x07, 0x00, 0x03, 
      0x80, 0x00, 0x00, 0x00, 0x80, 0x02, 
      0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 
      0x80, 0x00, 0x00, 0x00, 0x80, 0x02, 
      0x80, 0x00, 0x00, 0x00, 0x40, 0x03, 
      0x80, 0x00, 0x00, 0x00, 0x80, 0x02, 
      0x00, 0x01, 0x00, 0x00, 0x40, 0x01, 
      0x00, 0x01, 0x00, 0x00, 0xa0, 0x01, 
      0x00, 0x02, 0x00, 0x00, 0xd0, 0x00, 
      0x00, 0x0c, 0x00, 0x00, 0x68, 0x00, 
      0x00, 0x58, 0x00, 0x00, 0x35, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x04, 
      0x40, 0xc0, 0xfc, 0x7f, 0x07, 0x04, 
      0x20, 0xe0, 0x02, 0x80, 0x06, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xfe, 0xff, 0x0e, 0x0a, 
      0x20, 0x74, 0x02, 0x80, 0x1d, 0x0c, 
      0x20, 0x38, 0xfa, 0xbf, 0x1a, 0x0a, 
      0x20, 0x34, 0xfa, 0xbf, 0x1d, 0x0d, 
      0x20, 0x38, 0xfa, 0xaf, 0x1a, 0x0a, 
      0x40, 0x34, 0x1a, 0xa0, 0x1d, 0x05, 
      0x80, 0x38, 0xfa, 0xbf, 0x9a, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7e, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x40, 0xfe, 0xff, 0x05, 0x00, 
      0x00, 0x20, 0x0c, 0x20, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xe8, 0x0f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x2e, 0xf4, 0x1f, 0xea, 0x00, 
      0x00, 0x27, 0xfc, 0x3f, 0xcc, 0x01, 
      0x00, 0xc7, 0xeb, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xf0, 0x0f, 0xd0, 0x03, 
      0x80, 0x0f, 0xe8, 0x0f, 0xe8, 0x03, 
      0x80, 0x5f, 0xf5, 0x5f, 0xf5, 0x03, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
    {
      /* Bitmap x=256 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x07, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x18, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
      0x00, 0x18, 0x03, 0x00, 0x40, 0x00, 
      0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 
      0x00, 0x51, 0x01, 0x00, 0x00, 0x01, 
      0x00, 0x41, 0x00, 0x00, 0x00, 0x01, 
      0x80, 0x00, 0xe0, 0x03, 0x80, 0x02, 
      0x80, 0x00, 0x30, 0x06, 0x00, 0x03, 
      0x80, 0x00, 0x10, 0x05, 0x80, 0x02, 
      0x80, 0x00, 0x10, 0x06, 0x00, 0x03, 
      0x80, 0x00, 0x50, 0x05, 0x80, 0x02, 
      0x80, 0x00, 0xb0, 0x06, 0x00, 0x03, 
      0x80, 0x00, 0xe0, 0x03, 0x80, 0x02, 
      0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 
      0x80, 0x00, 0x00, 0x00, 0x80, 0x02, 
      0x80, 0x00, 0x00, 0x00, 0x40, 0x03, 
      0x80, 0x00, 0x00, 0x00, 0x80, 0x02, 
      0x00, 0x01, 0x00, 0x00, 0x40, 0x01, 
      0x00, 0x01, 0x00, 0x00, 0xa0, 0x01, 
      0x00, 0x02, 0x00, 0x00, 0xd0, 0x00, 
      0x00, 0x0c, 0x00, 0x00, 0x68, 0x00, 
      0x00, 0x58, 0x00, 0x00, 0x35, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x04, 
      0x40, 0xc0, 0xfc, 0x7f, 0x07, 0x04, 
      0x20, 0xe0, 0x02, 0x80, 0x06, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xfe, 0xff, 0x0e, 0x0a, 
      0x20, 0x74, 0x02, 0x80, 0x1d, 0x0c, 
      0x20, 0x38, 0xfa, 0xbf, 0x1a, 0x0a, 
      0x20, 0x34, 0xfa, 0xbf, 0x1d, 0x0d, 
      0x20, 0x38, 0xfa, 0xaf, 0x1a, 0x0a, 
      0x40, 0x34, 0x1a, 0xa0, 0x1d, 0x05, 
      0x80, 0x38, 0xfa, 0xbf, 0x9a, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7e, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x20, 0xfe, 0xff, 0x05, 0x00, 
      0x00, 0x20, 0x08, 0x20, 0x06, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x05, 0x00, 
      0x00, 0x30, 0x18, 0x08, 0x0a, 0x00, 
      0x00, 0x28, 0xf4, 0x0f, 0x0d, 0x00, 
      0x00, 0x24, 0xf8, 0x0f, 0x1a, 0x00, 
      0x00, 0xc4, 0xef, 0x1f, 0x7c, 0x00, 
      0x00, 0x06, 0xf0, 0x1f, 0xfa, 0x00, 
      0x00, 0x0f, 0xe8, 0x1f, 0xfc, 0x01, 
      0x00, 0x5f, 0xf5, 0x1f, 0xfa, 0x01, 
      0x80, 0xff, 0xff, 0x1f, 0xec, 0x03, 
      0x80, 0xff, 0xff, 0x3f, 0xda, 0x03, 
      0x80, 0xff, 0xff, 0xcf, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xd0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe8, 0x01, 
      0x00, 0xfe, 0xff, 0x5f, 0xf5, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00, },
    {
      /* Bitmap x=320 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x07, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x18, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
      0x00, 0x18, 0x03, 0x00, 0x40, 0x00, 
      0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 
      0x00, 0x51, 0x01, 0x00, 0x00, 0x01, 
      0x00, 0x41, 0x00, 0x00, 0x00, 0x01, 
      0x80, 0x00, 0x80, 0x0f, 0x80, 0x02, 
      0x80, 0x00, 0xc0, 0x18, 0x00, 0x03, 
      0x80, 0x00, 0x40, 0x14, 0x80, 0x02, 
      0x80, 0x00, 0x40, 0x18, 0x00, 0x03, 
      0x80, 0x00, 0x40, 0x15, 0x80, 0x02, 
      0x80, 0x00, 0xc0, 0x1a, 0x00, 0x03, 
      0x80, 0x00, 0x80, 0x0f, 0x80, 0x02, 
      0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 
      0x80, 0x00, 0x00, 0x00, 0x80, 0x02, 
      0x80, 0x00, 0x00, 0x00, 0x40, 0x03, 
      0x80, 0x00, 0x00, 0x00, 0x80, 0x02, 
      0x00, 0x01, 0x00, 0x00, 0x40, 0x01, 
      0x00, 0x01, 0x00, 0x00, 0xa0, 0x01, 
      0x00, 0x02, 0x00, 0x00, 0xd0, 0x00, 
      0x00, 0x0c, 0x00, 0x00, 0x68, 0x00, 
      0x00, 0x58, 0x00, 0x00, 0x35, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x04, 
      0x40, 0xc0, 0xfc, 0x7f, 0x07, 0x04, 
      0x20, 0xe0, 0x02, 0x80, 0x06, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xfe, 0xff, 0x0e, 0x0a, 
      0x20, 0x74, 0x02, 0x80, 0x1d, 0x0c, 
      0x20, 0x38, 0xfa, 0xbf, 0x1a, 0x0a, 
      0x20, 0x34, 0xfa, 0xbf, 0x1d, 0x0d, 
      0x20, 0x38, 0xfa, 0xaf, 0x1a, 0x0a, 
      0x40, 0x34, 0x1a, 0xa0, 0x1d, 0x05, 
      0x80, 0x38, 0xfa, 0xbf, 0x9a, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7e, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x40, 0xfe, 0xff, 0x0d, 0x00, 
      0x00, 0x40, 0x08, 0x20, 0x0a, 0x00, 
      0x00, 0x40, 0xf4, 0x1f, 0x0c, 0x00, 
      0x00, 0x20, 0x28, 0x10, 0x1a, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x2c, 0x00, 
      0x00, 0x30, 0xe8, 0x3f, 0x5a, 0x00, 
      0x00, 0x3c, 0xf4, 0xcf, 0x67, 0x00, 
      0x00, 0x3e, 0xf8, 0x0f, 0xd0, 0x00, 
      0x00, 0x3f, 0xf4, 0x0f, 0xe8, 0x01, 
      0x00, 0x3f, 0xf8, 0x5f, 0xf5, 0x01, 
      0x80, 0x2f, 0xf4, 0xff, 0xff, 0x03, 
      0x80, 0x27, 0xf8, 0xff, 0xff, 0x03, 
      0x80, 0xc7, 0xef, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xf0, 0xff, 0xff, 0x01, 
      0x00, 0x0f, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x5e, 0xf5, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
    {
      /* Bitmap x=384 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0xc0, 0x01, 0x00, 
      0x7c, 0x80, 0x00, 0x00, 0x0e, 0x00, 
      0xc6, 0xa0, 0x02, 0x00, 0x30, 0x00, 
      0xa2, 0x00, 0x00, 0x00, 0x40, 0x00, 
      0xc2, 0x33, 0x06, 0x00, 0x80, 0x00, 
      0xaa, 0x04, 0x00, 0x00, 0x00, 0x01, 
      0xd6, 0xa4, 0x02, 0x00, 0xff, 0x02, 
      0xfc, 0x83, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x01, 0x00, 0x40, 0x20, 0x04, 
      0x00, 0x01, 0x00, 0x40, 0x58, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x58, 0x04, 
      0x00, 0x02, 0x00, 0x40, 0x40, 0x02, 
      0x00, 0x02, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x04, 0x00, 0x00, 0xff, 0x01, 
      0x00, 0x28, 0x00, 0x00, 0xa8, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x54, 0x00, 
      0x00, 0xe0, 0xaa, 0xaa, 0x3a, 0x00, 
      0x00, 0x80, 0xd7, 0x57, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x1f, 0xf0, 0x01, 0x00, 
      0x00, 0x02, 0x11, 0x18, 0x02, 0x00, 
      0x00, 0xfe, 0x13, 0x14, 0x03, 0x00, 
      0x00, 0x02, 0x0a, 0x18, 0x06, 0x00, 
      0x00, 0xfa, 0x0a, 0x14, 0x05, 0x00, 
      0x00, 0xfa, 0x0a, 0x0a, 0x06, 0x00, 
      0x00, 0xba, 0x0a, 0x0c, 0x05, 0x00, 
      0x00, 0xba, 0x0a, 0x0a, 0x06, 0x00, 
      0x00, 0xba, 0x0a, 0x05, 0x05, 0x00, 
      0x00, 0xba, 0x12, 0x86, 0x02, 0x00, 
      0x00, 0xba, 0x12, 0x05, 0x07, 0x00, 
      0x00, 0xba, 0x12, 0x86, 0x05, 0x00, 
      0x00, 0xba, 0x3e, 0xfd, 0x05, 0x00, 
      0x00, 0x9a, 0x3e, 0xfe, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0x70, 0x07, 0x00, 
      0x00, 0xfc, 0x43, 0xb0, 0x01, 0x00, 
      0x00, 0x00, 0xa1, 0xd8, 0x00, 0x00, 
      0x00, 0x00, 0x1a, 0xb7, 0x00, 0x00, 
      0x00, 0x00, 0x14, 0x58, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x18, 0x00, 0x00, 
      0x00, 0x80, 0x3f, 0xf4, 0x03, 0x00, 
      0x00, 0xf0, 0x3f, 0xfa, 0x1f, 0x00, 
      0x00, 0xfc, 0x2f, 0xcc, 0x7f, 0x00, 
      0x00, 0xfe, 0x27, 0x8a, 0xff, 0x00, 
      0x00, 0xff, 0x17, 0xad, 0xff, 0x01, 
      0x00, 0xff, 0x1f, 0xd6, 0xff, 0x01, 
      0x80, 0xff, 0x1f, 0xfd, 0xff, 0x03, 
      0x80, 0xff, 0xef, 0xc3, 0xff, 0x03, 
      0x80, 0xff, 0x07, 0x80, 0xff, 0x03, 
      0x00, 0xff, 0x07, 0xa0, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xd5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
    {
      /* Bitmap x=448 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0xc0, 0x01, 0x00, 
      0x00, 0x80, 0x00, 0x00, 0x0e, 0x00, 
      0x7c, 0xa0, 0x02, 0x00, 0x30, 0x00, 
      0xc6, 0x00, 0x00, 0x00, 0x40, 0x00, 
      0xa2, 0x33, 0x06, 0x00, 0x80, 0x00, 
      0xc2, 0x04, 0x00, 0x00, 0x00, 0x01, 
      0xaa, 0xa4, 0x02, 0x00, 0xff, 0x02, 
      0xd6, 0x83, 0x00, 0x80, 0x20, 0x02, 
      0x7c, 0x01, 0x00, 0x40, 0x20, 0x04, 
      0x00, 0x01, 0x00, 0x40, 0x58, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x58, 0x04, 
      0x00, 0x02, 0x00, 0x40, 0x40, 0x02, 
      0x00, 0x02, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x04, 0x00, 0x00, 0xff, 0x01, 
      0x00, 0x28, 0x00, 0x00, 0xa8, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x54, 0x00, 
      0x00, 0xe0, 0xaa, 0xaa, 0x3a, 0x00, 
      0x00, 0x80, 0xd7, 0x57, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x1f, 0xf0, 0x01, 0x00, 
      0x00, 0x02, 0x11, 0x18, 0x02, 0x00, 
      0x00, 0xfe, 0x13, 0x14, 0x03, 0x00, 
      0x00, 0x02, 0x0a, 0x18, 0x06, 0x00, 
      0x00, 0xfa, 0x0a, 0x14, 0x05, 0x00, 
      0x00, 0xfa, 0x0a, 0x0a, 0x06, 0x00, 
      0x00, 0xba, 0x0a, 0x0c, 0x05, 0x00, 
      0x00, 0xba, 0x0a, 0x0a, 0x06, 0x00, 
      0x00, 0xba, 0x0a, 0x05, 0x05, 0x00, 
      0x00, 0xba, 0x12, 0x86, 0x02, 0x00, 
      0x00, 0xba, 0x12, 0x05, 0x07, 0x00, 
      0x00, 0xba, 0x12, 0x86, 0x05, 0x00, 
      0x00, 0xba, 0x3e, 0xfd, 0x05, 0x00, 
      0x00, 0x9a, 0x3e, 0xfe, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0x70, 0x07, 0x00, 
      0x00, 0xfc, 0x43, 0xb0, 0x01, 0x00, 
      0x00, 0x00, 0xa1, 0xd8, 0x00, 0x00, 
      0x00, 0x00, 0x1a, 0xb7, 0x00, 0x00, 
      0x00, 0x00, 0x14, 0x28, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 
      0x00, 0x00, 0x14, 0x68, 0x00, 0x00, 
      0x00, 0x80, 0x23, 0xd0, 0x03, 0x00, 
      0x00, 0xf0, 0x63, 0xe0, 0x1f, 0x00, 
      0x00, 0xfc, 0xdc, 0xd0, 0x7f, 0x00, 
      0x00, 0x7e, 0x30, 0xe1, 0xff, 0x00, 
      0x00, 0x7f, 0x00, 0xd1, 0xff, 0x01, 
      0x00, 0xff, 0xaa, 0xe1, 0xff, 0x01, 
      0x80, 0xff, 0x5f, 0xd1, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0x3e, 0xfc, 0x03, 
      0x80, 0xff, 0x7f, 0x00, 0xf8, 0x03, 
      0x00, 0xff, 0x7f, 0x00, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0x55, 0xfd, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
    {
      /* Bitmap x=512 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0xc0, 0x01, 0x00, 
      0x00, 0x80, 0x00, 0x00, 0x0e, 0x00, 
      0x7c, 0xa0, 0x02, 0x00, 0x30, 0x00, 
      0xc6, 0x00, 0x00, 0x00, 0x40, 0x00, 
      0xa2, 0x33, 0x06, 0x00, 0x80, 0x00, 
      0xc2, 0x04, 0x00, 0x00, 0x00, 0x01, 
      0xaa, 0xa4, 0x02, 0x00, 0xff, 0x02, 
      0xd6, 0x83, 0x00, 0x80, 0x20, 0x02, 
      0x7c, 0x01, 0x00, 0x40, 0x20, 0x04, 
      0x00, 0x01, 0x00, 0x40, 0x58, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x01, 0x00, 0x20, 0x58, 0x04, 
      0x00, 0x02, 0x00, 0x40, 0x40, 0x02, 
      0x00, 0x02, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x04, 0x00, 0x00, 0xff, 0x01, 
      0x00, 0x28, 0x00, 0x00, 0xa8, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x54, 0x00, 
      0x00, 0xe0, 0xaa, 0xaa, 0x3a, 0x00, 
      0x00, 0x80, 0xd7, 0x57, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x1f, 0xf4, 0x01, 0x00, 
      0x00, 0x02, 0x11, 0x18, 0x02, 0x00, 
      0x00, 0xfe, 0x13, 0x14, 0x03, 0x00, 
      0x00, 0x02, 0x0a, 0x18, 0x06, 0x00, 
      0x00, 0xfa, 0x0a, 0x14, 0x05, 0x00, 
      0x00, 0xfa, 0x0a, 0x0a, 0x06, 0x00, 
      0x00, 0xba, 0x0a, 0x0c, 0x05, 0x00, 
      0x00, 0xba, 0x0a, 0x0a, 0x06, 0x00, 
      0x00, 0xba, 0x0a, 0x05, 0x05, 0x00, 
      0x00, 0xba, 0x12, 0x86, 0x02, 0x00, 
      0x00, 0xba, 0x12, 0x05, 0x07, 0x00, 
      0x00, 0xba, 0x12, 0x86, 0x05, 0x00, 
      0x00, 0xba, 0x3e, 0xfd, 0x05, 0x00, 
      0x00, 0x9a, 0x3e, 0xfe, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0x70, 0x07, 0x00, 
      0x00, 0xfc, 0x43, 0xb0, 0x01, 0x00, 
      0x00, 0x00, 0xa1, 0xd8, 0x00, 0x00, 
      0x00, 0x00, 0x1a, 0xb7, 0x00, 0x00, 
      0x00, 0x00, 0x14, 0x58, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x3a, 0x00, 0x00, 
      0x00, 0x80, 0x1f, 0xd4, 0x03, 0x00, 
      0x00, 0xf0, 0x1f, 0xea, 0x1f, 0x00, 
      0x00, 0xfc, 0x0f, 0x3d, 0x7c, 0x00, 
      0x00, 0xfe, 0x87, 0x02, 0xf8, 0x00, 
      0x00, 0xff, 0x43, 0x01, 0xfa, 0x01, 
      0x00, 0xff, 0xa3, 0x55, 0xfd, 0x01, 
      0x80, 0xff, 0xdc, 0xff, 0xff, 0x03, 
      0x80, 0x7f, 0x30, 0xfc, 0xff, 0x03, 
      0x80, 0x7f, 0x00, 0xf8, 0xff, 0x03, 
      0x00, 0xff, 0xaa, 0xfa, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xfd, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00},
    {
      /* Bitmap x=576 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xfc, 0x07, 0x00, 0x00, 
      0x00, 0x80, 0x03, 0x38, 0x00, 0x00, 
      0x00, 0x10, 0x00, 0xc0, 0x01, 0x3e, 
      0x00, 0x54, 0x00, 0x00, 0x06, 0x63, 
      0x00, 0x00, 0x00, 0x00, 0x08, 0x51, 
      0x00, 0xc6, 0x00, 0x00, 0xd0, 0x61, 
      0x80, 0x00, 0x00, 0x00, 0x20, 0x55, 
      0x40, 0x55, 0x00, 0x00, 0x20, 0x6b, 
      0x40, 0x10, 0x01, 0x00, 0xc0, 0x3f, 
      0x20, 0x04, 0x02, 0x00, 0xc0, 0x00, 
      0x20, 0x1a, 0x02, 0x00, 0xa0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xc0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xa0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xc0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xa0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xc0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xa0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xc0, 0x00, 
      0x20, 0x3a, 0x04, 0x00, 0xa0, 0x00, 
      0x20, 0x1a, 0x04, 0x00, 0xd0, 0x00, 
      0x40, 0x02, 0x02, 0x00, 0x60, 0x00, 
      0x40, 0x04, 0x01, 0x00, 0x50, 0x00, 
      0x80, 0xff, 0x00, 0x00, 0x28, 0x00, 
      0x00, 0x15, 0x00, 0x00, 0x15, 0x00, 
      0x00, 0x2a, 0x00, 0x80, 0x0a, 0x00, 
      0x00, 0x5c, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xe0, 0xea, 0xeb, 0x01, 0x00, 
      0x00, 0x00, 0x1f, 0xbc, 0x3f, 0x00, 
      0x00, 0x80, 0x0f, 0xf8, 0x40, 0x00, 
      0x00, 0x40, 0x08, 0xac, 0x40, 0x00, 
      0x00, 0x40, 0x08, 0xd8, 0x7f, 0x00, 
      0x00, 0x20, 0x0a, 0x74, 0x40, 0x00, 
      0x00, 0xa0, 0x09, 0x58, 0x5f, 0x00, 
      0x00, 0xa0, 0x11, 0x74, 0x5f, 0x00, 
      0x00, 0xa0, 0x11, 0x58, 0x57, 0x00, 
      0x00, 0xa0, 0x11, 0x74, 0x57, 0x00, 
      0x00, 0x20, 0x20, 0x5a, 0x57, 0x00, 
      0x00, 0x40, 0x20, 0x6c, 0x57, 0x00, 
      0x00, 0xe0, 0x20, 0x5a, 0x57, 0x00, 
      0x00, 0xa0, 0x21, 0x6d, 0x57, 0x00, 
      0x00, 0xa0, 0x3f, 0x7e, 0x57, 0x00, 
      0x00, 0xa0, 0x7f, 0x7d, 0x53, 0x00, 
      0x00, 0xa0, 0x9f, 0x7f, 0x5f, 0x00, 
      0x00, 0xe0, 0x0e, 0x7f, 0x40, 0x00, 
      0x00, 0x80, 0x88, 0xd2, 0x3f, 0x00, 
      0x00, 0x00, 0x59, 0xad, 0x00, 0x00, 
      0x00, 0x00, 0xed, 0x5a, 0x00, 0x00, 
      0x00, 0x00, 0x0a, 0x2d, 0x00, 0x00, 
      0x00, 0x00, 0x0c, 0x1a, 0x00, 0x00, 
      0x00, 0x00, 0x08, 0x0d, 0x00, 0x00, 
      0x00, 0xc0, 0x0f, 0xfe, 0x01, 0x00, 
      0x00, 0xf8, 0x1f, 0xfd, 0x0f, 0x00, 
      0x00, 0xfe, 0x13, 0xf6, 0x3f, 0x00, 
      0x00, 0xff, 0x11, 0xe5, 0x7f, 0x00, 
      0x80, 0xff, 0x31, 0xea, 0xff, 0x00, 
      0x80, 0xff, 0x23, 0xfc, 0xff, 0x00, 
      0xc0, 0xff, 0x3f, 0xfa, 0xff, 0x01, 
      0xc0, 0xff, 0xc3, 0xf7, 0xff, 0x01, 
      0xc0, 0xff, 0x01, 0xe8, 0xff, 0x01, 
      0x80, 0xff, 0x01, 0xf4, 0xff, 0x00, 
      0x80, 0xff, 0xab, 0xfa, 0xff, 0x00, 
      0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x01, 0x00}, 
    
    
    {
      /* Bitmap x=0 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 
      0x00, 0x20, 0x00, 0x80, 0x03, 0x00, 
      0x00, 0xa8, 0x00, 0x00, 0x0c, 0x7c, 
      0x00, 0x00, 0x00, 0x00, 0x10, 0xc6, 
      0x00, 0x8c, 0x01, 0x00, 0xa0, 0xa3, 
      0x00, 0x01, 0x00, 0x00, 0x40, 0xc2, 
      0x80, 0xaa, 0x00, 0x00, 0x40, 0xaa, 
      0x80, 0x20, 0x02, 0x00, 0x80, 0xd7, 
      0x40, 0x08, 0x04, 0x00, 0x80, 0x7d, 
      0x40, 0x34, 0x04, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x34, 0x08, 0x00, 0xa0, 0x01, 
      0x80, 0x04, 0x04, 0x00, 0xc0, 0x00, 
      0x80, 0x08, 0x02, 0x00, 0xa0, 0x00, 
      0x00, 0xff, 0x01, 0x00, 0x50, 0x00, 
      0x00, 0x2a, 0x00, 0x00, 0x2a, 0x00, 
      0x00, 0x54, 0x00, 0x00, 0x15, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x0e, 0x00, 
      0x00, 0xc0, 0xd5, 0xd7, 0x03, 0x00, 
      0x00, 0x00, 0x3e, 0x78, 0x7f, 0x00, 
      0x00, 0x00, 0x1f, 0xf0, 0x81, 0x00, 
      0x00, 0x80, 0x10, 0x58, 0x81, 0x00, 
      0x00, 0x80, 0x10, 0xb0, 0xff, 0x00, 
      0x00, 0x40, 0x14, 0xe8, 0x80, 0x00, 
      0x00, 0x40, 0x13, 0xb0, 0xbe, 0x00, 
      0x00, 0x40, 0x23, 0xe8, 0xbe, 0x00, 
      0x00, 0x40, 0x23, 0xb0, 0xae, 0x00, 
      0x00, 0x40, 0x23, 0xe8, 0xae, 0x00, 
      0x00, 0x40, 0x40, 0xb4, 0xae, 0x00, 
      0x00, 0x80, 0x40, 0xd8, 0xae, 0x00, 
      0x00, 0xc0, 0x41, 0xb4, 0xae, 0x00, 
      0x00, 0x40, 0x43, 0xda, 0xae, 0x00, 
      0x00, 0x40, 0x7f, 0xfc, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfa, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1d, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x11, 0xa5, 0x7f, 0x00, 
      0x00, 0x00, 0xb2, 0x5a, 0x01, 0x00, 
      0x00, 0x00, 0xda, 0xb5, 0x00, 0x00, 
      0x00, 0x00, 0x08, 0x7a, 0x00, 0x00, 
      0x00, 0x00, 0x08, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x04, 0x5a, 0x00, 0x00, 
      0x00, 0x80, 0x07, 0x8d, 0x03, 0x00, 
      0x00, 0xf0, 0x87, 0x86, 0x1f, 0x00, 
      0x00, 0xfc, 0x47, 0x67, 0x7f, 0x00, 
      0x00, 0xfe, 0x87, 0x99, 0xfe, 0x00, 
      0x00, 0xff, 0x47, 0x41, 0xfd, 0x01, 
      0x00, 0xff, 0x87, 0xa9, 0xfe, 0x01, 
      0x80, 0xff, 0x47, 0xf5, 0xff, 0x03, 
      0x80, 0x7f, 0xf8, 0xfe, 0xff, 0x03, 
      0x80, 0x3f, 0x00, 0xfd, 0xff, 0x03, 
      0x00, 0x3f, 0x80, 0xfe, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=64 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 
      0x00, 0x20, 0x00, 0x80, 0x03, 0x00, 
      0x00, 0xa8, 0x00, 0x00, 0x0c, 0x7c, 
      0x00, 0x00, 0x00, 0x00, 0x10, 0xc6, 
      0x00, 0x8c, 0x01, 0x00, 0xa0, 0xa3, 
      0x00, 0x01, 0x00, 0x00, 0x40, 0xc2, 
      0x80, 0xaa, 0x00, 0x00, 0x40, 0xaa, 
      0x80, 0x20, 0x02, 0x00, 0x80, 0xd7, 
      0x40, 0x08, 0x04, 0x00, 0x80, 0x7d, 
      0x40, 0x34, 0x04, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x80, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0x40, 0x01, 
      0x40, 0x34, 0x08, 0x00, 0xa0, 0x01, 
      0x80, 0x04, 0x04, 0x00, 0xc0, 0x00, 
      0x80, 0x08, 0x02, 0x00, 0xa0, 0x00, 
      0x00, 0xff, 0x01, 0x00, 0x50, 0x00, 
      0x00, 0x2a, 0x00, 0x00, 0x2a, 0x00, 
      0x00, 0x54, 0x00, 0x00, 0x15, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x0e, 0x00, 
      0x00, 0xc0, 0xd5, 0xd7, 0x03, 0x00, 
      0x00, 0x00, 0x3e, 0x78, 0x7f, 0x00, 
      0x00, 0x00, 0x1f, 0xf0, 0x81, 0x00, 
      0x00, 0x80, 0x10, 0x58, 0x81, 0x00, 
      0x00, 0x80, 0x10, 0xb0, 0xff, 0x00, 
      0x00, 0x40, 0x14, 0xe8, 0x80, 0x00, 
      0x00, 0x40, 0x13, 0xb0, 0xbe, 0x00, 
      0x00, 0x40, 0x23, 0xe8, 0xbe, 0x00, 
      0x00, 0x40, 0x23, 0xb0, 0xae, 0x00, 
      0x00, 0x40, 0x23, 0xe8, 0xae, 0x00, 
      0x00, 0x40, 0x40, 0xb4, 0xae, 0x00, 
      0x00, 0x80, 0x40, 0xd8, 0xae, 0x00, 
      0x00, 0xc0, 0x41, 0xb4, 0xae, 0x00, 
      0x00, 0x40, 0x43, 0xda, 0xae, 0x00, 
      0x00, 0x40, 0x7f, 0xfc, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfa, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1d, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x11, 0xa5, 0x7f, 0x00, 
      0x00, 0x00, 0xb2, 0x5a, 0x01, 0x00, 
      0x00, 0x00, 0xd2, 0x95, 0x00, 0x00, 
      0x00, 0x00, 0x14, 0x5a, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x1a, 0x00, 0x00, 
      0x00, 0x80, 0x17, 0xf4, 0x03, 0x00, 
      0x00, 0xf0, 0x27, 0xf8, 0x1f, 0x00, 
      0x00, 0x7c, 0x78, 0xf4, 0x7f, 0x00, 
      0x00, 0x3e, 0x80, 0xe8, 0xff, 0x00, 
      0x00, 0x3f, 0x80, 0xd1, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xa3, 0xff, 0x01, 
      0x80, 0xff, 0xff, 0x67, 0xfe, 0x03, 
      0x80, 0xff, 0x7f, 0x18, 0xfe, 0x03, 
      0x80, 0xff, 0x3f, 0x00, 0xfd, 0x03, 
      0x00, 0xff, 0x3f, 0xa0, 0xfe, 0x01, 
      0x00, 0xff, 0x7f, 0xf5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=320 y=0 w=64 h=48 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x08, 0x00, 0x00, 
      0x00, 0x00, 0x70, 0x1b, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xfc, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xfc, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 
      0x00, 0x1e, 0x00, 0x00, 0xf0, 0x00, 
      0x00, 0x0f, 0x00, 0x00, 0xe0, 0x01, 
      0x00, 0x07, 0x00, 0x00, 0xc0, 0x01, 
      0x80, 0x07, 0x00, 0x00, 0xc0, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x3c, 0x78, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1f, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x3e, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 
      
      0x00, 0x78, 0x00, 0x00, 0x3c, 0x00, 
      0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 
      0x00, 0xfe, 0xa9, 0x2a, 0xff, 0x00, 
      0x80, 0xa7, 0xa9, 0x2a, 0xcb, 0x03, 
      0xc0, 0xa7, 0x03, 0x80, 0xcb, 0x07, 
      0xc0, 0xc7, 0xfe, 0xff, 0xc6, 0x07, 
      0xe0, 0xc3, 0xe1, 0x1f, 0x87, 0x0f, 
      0xe0, 0x79, 0x83, 0x82, 0x3d, 0x0f, 
      0xe0, 0x7c, 0xfe, 0xfe, 0x7c, 0x0e, 
      0x20, 0xfc, 0x80, 0x02, 0x7e, 0x08, 
      0x20, 0xfe, 0xf1, 0x1e, 0xff, 0x08, 
      0x60, 0x7f, 0xff, 0xfe, 0xfd, 0x0d, 
      0xe0, 0xfc, 0x80, 0x02, 0x7e, 0x0e, 
      0x40, 0xfe, 0xf1, 0x1f, 0xff, 0x04, 
      0xc0, 0xfc, 0x7f, 0xfc, 0x7f, 0x06, 
      0x80, 0xf9, 0xff, 0xfe, 0x3f, 0x03, 
      0x00, 0x93, 0x7f, 0xfc, 0x93, 0x01, 
      0x00, 0xff, 0xff, 0xfe, 0xff, 0x01, 
      0x00, 0xd7, 0x73, 0x9c, 0xd7, 0x01, 
      0x00, 0xd6, 0x03, 0x80, 0xd7, 0x00, 
      0x00, 0xfc, 0xf7, 0xdf, 0x7f, 0x00, 
      0x00, 0xc0, 0xf9, 0x3f, 0x07, 0x00, 
      0x00, 0xc0, 0xf3, 0x9f, 0x07, 0x00, 
      0x00, 0xe0, 0xf9, 0x3f, 0x0f, 0x00, 
      0x00, 0xe0, 0xf8, 0x3f, 0x0e, 0x00, 
      0x00, 0xe0, 0x39, 0x38, 0x0f, 0x00, 
      0x00, 0xe0, 0xfd, 0x7f, 0x0f, 0x00, 
      0x00, 0xf0, 0xfa, 0xbf, 0x1e, 0x00, 
      0x00, 0xfc, 0xfd, 0x7f, 0x7f, 0x00, 
      0x00, 0xfe, 0xfd, 0x7f, 0xff, 0x00, 
      0x00, 0xff, 0xf9, 0x3f, 0xff, 0x01, 
      0x00, 0xff, 0xf3, 0x9f, 0xff, 0x01, 
      0x80, 0x7f, 0xfe, 0xff, 0xfc, 0x03, 
      0x80, 0x9f, 0xfa, 0xbf, 0xf2, 0x03, 
      0x80, 0x6f, 0xfd, 0x7f, 0xed, 0x03, 
      0x00, 0xbf, 0xfe, 0xff, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    {
      /* Bitmap x=384 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 
      0x00, 0x00, 0xf0, 0x9f, 0x31, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x28, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x37, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x18, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
      0x00, 0x18, 0x03, 0x00, 0x40, 0x00, 
      0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 
      0x00, 0x51, 0x01, 0x00, 0x00, 0x01, 
      0x00, 0x41, 0x00, 0x00, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x00, 0x01, 
      0x80, 0xc0, 0x01, 0x00, 0x37, 0x01, 
      0x80, 0x30, 0x00, 0x00, 0xf8, 0x00, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x00, 
      0x80, 0x08, 0x00, 0x00, 0x50, 0x00, 
      0x80, 0x08, 0x00, 0x00, 0x60, 0x00, 
      0x80, 0x08, 0x42, 0x84, 0x50, 0x00, 
      0x80, 0x08, 0x66, 0xcc, 0x60, 0x00, 
      0x80, 0x08, 0x3c, 0x78, 0x50, 0x00, 
      0x80, 0x08, 0x18, 0x30, 0x60, 0x00, 
      0x80, 0x08, 0x3c, 0x78, 0x70, 0x00, 
      0x00, 0x09, 0x66, 0xcc, 0xe0, 0x00, 
      0x00, 0x11, 0x42, 0x84, 0xb0, 0x00, 
      0x00, 0x22, 0x00, 0x00, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x06, 
      0x40, 0xf0, 0x01, 0x00, 0x07, 0x05, 
      0x20, 0x68, 0x0e, 0x40, 0x06, 0x0a, 
      0x20, 0x24, 0x38, 0x3c, 0x0f, 0x0c, 
      0x20, 0x6c, 0x60, 0x3a, 0x1c, 0x0a, 
      0x20, 0x3a, 0xc0, 0x3e, 0x1d, 0x0c, 
      0x20, 0x74, 0x80, 0x3f, 0x1a, 0x0a, 
      0x20, 0x3a, 0x00, 0x1f, 0x1d, 0x0c, 
      0x20, 0xf4, 0x01, 0x03, 0x1a, 0x0a, 
      0x40, 0x68, 0xce, 0x01, 0x0d, 0x04, 
      0x40, 0x3c, 0x78, 0x80, 0x7a, 0x06, 
      0x80, 0xc3, 0x01, 0x80, 0x87, 0x03, 
      0x00, 0xc1, 0x03, 0xe6, 0x07, 0x01, 
      0x00, 0xc1, 0x87, 0xf9, 0x83, 0x01, 
      0x00, 0xa1, 0x47, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0x46, 0x78, 0xa6, 0x00, 
      0x00, 0x7c, 0x47, 0x98, 0x7f, 0x00, 
      0x00, 0x40, 0x44, 0x46, 0x05, 0x00, 
      0x00, 0x40, 0x8c, 0x21, 0x06, 0x00, 
      0x00, 0x20, 0x10, 0x10, 0x05, 0x00, 
      0x00, 0x20, 0xe8, 0x4f, 0x06, 0x00, 
      0x00, 0x20, 0x34, 0x48, 0x07, 0x00, 
      0x00, 0x20, 0xf8, 0xbf, 0x02, 0x00, 
      0x00, 0x30, 0xf4, 0xbf, 0x1d, 0x00, 
      0x00, 0x3c, 0xf8, 0x3f, 0x7e, 0x00, 
      0x00, 0x3e, 0xf4, 0x3f, 0xfc, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfe, 0x01, 
      0x00, 0xcf, 0xf3, 0x1f, 0xf4, 0x01, 
      0x80, 0x07, 0xe8, 0x1f, 0xe8, 0x03, 
      0x80, 0x07, 0xf4, 0x1f, 0xfc, 0x03, 
      0x80, 0x07, 0xea, 0x3f, 0xea, 0x03, 
      0x00, 0x0f, 0xfd, 0x7f, 0xf6, 0x01, 
      0x00, 0xaf, 0xfe, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    {
      /* Bitmap x=128 y=192 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0a, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00, 
      0x00, 0x00, 0x01, 0x00, 0x07, 0x00, 
      0x00, 0x40, 0x00, 0x00, 0x18, 0x00, 
      0x00, 0x50, 0x01, 0x00, 0x20, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 
      0x00, 0x1a, 0x03, 0x00, 0x80, 0x00, 
      0x00, 0x01, 0x00, 0x00, 0x80, 0x01, 
      0x00, 0x51, 0x01, 0x00, 0x00, 0x01, 
      0x80, 0x40, 0x00, 0x00, 0x80, 0x02, 
      0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 
      0x80, 0x80, 0xff, 0xff, 0x83, 0x02, 
      0x80, 0x70, 0x00, 0x00, 0x1c, 0x03, 
      0x80, 0x08, 0x00, 0x00, 0xa0, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x09, 0x7e, 0xfc, 0xa0, 0x01, 
      0x00, 0x12, 0x7e, 0xfc, 0xd0, 0x00, 
      0x00, 0x2c, 0x7e, 0xfc, 0x68, 0x00, 
      0x00, 0x58, 0x3c, 0x78, 0x34, 0x00, 
      0x00, 0xb8, 0x01, 0x00, 0x3b, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xfe, 0xff, 0x06, 0x06, 
      0x40, 0xe0, 0x00, 0x00, 0x07, 0x05, 
      0x20, 0xd0, 0x00, 0x40, 0x06, 0x0a, 
      0x20, 0xe8, 0x00, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x00, 0x3a, 0x1e, 0x0a, 
      0x20, 0x7a, 0x00, 0x3e, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x3e, 0x1a, 0x0a, 
      0x20, 0x7a, 0x00, 0x1c, 0x1d, 0x0c, 
      0x20, 0x34, 0x00, 0x00, 0x1a, 0x0a, 
      0x40, 0x68, 0x00, 0x00, 0x0d, 0x04, 
      0x40, 0x3c, 0xe0, 0x8f, 0x7a, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0x07, 0xd0, 0x06, 0x00, 
      0x00, 0x40, 0x0c, 0x68, 0x05, 0x00, 
      0x00, 0x20, 0x58, 0x35, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 
      0x00, 0xcf, 0xf7, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 

  },
  
  /* player 2*/
  {
    
    {
      /* Bitmap x=0 y=288 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x08, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x08, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x3f, 0x00, 
      0x00, 0x14, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x0e, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 
      0x80, 0x57, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0x01, 0x00, 0xff, 0x03, 
      0x80, 0x3f, 0x00, 0x00, 0xf8, 0x03, 
      0x80, 0x0f, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0f, 0x3c, 0x78, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1f, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x3e, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0xfc, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xb6, 0xff, 0xff, 0xdb, 0x00, 
      0x80, 0x41, 0xfc, 0xff, 0x04, 0x03, 
      0x40, 0x40, 0x01, 0x00, 0x07, 0x06, 
      0x40, 0xe0, 0xf8, 0xbf, 0x07, 0x05, 
      0x20, 0x50, 0xfc, 0x43, 0x07, 0x0a, 
      0x20, 0xe8, 0xf8, 0xbd, 0x0f, 0x0c, 
      0x20, 0x74, 0xfc, 0xba, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0xfd, 0xbe, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfe, 0xdd, 0x1f, 0x0c, 
      0x20, 0xf4, 0xff, 0xe3, 0x1f, 0x0a, 
      0x40, 0xe8, 0xff, 0xff, 0x0f, 0x04, 
      0x40, 0xfc, 0x1f, 0xf0, 0x7f, 0x06, 
      0x80, 0x43, 0xd0, 0x17, 0x85, 0x03, 
      0x00, 0x61, 0xd0, 0x17, 0x06, 0x01, 
      0x00, 0xc1, 0xd0, 0x17, 0x83, 0x01, 
      0x00, 0xa1, 0xd0, 0x17, 0x42, 0x01, 
      0x00, 0xd2, 0x1f, 0xf0, 0xa7, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0x40, 0xfc, 0x7f, 0x05, 0x00, 
      0x00, 0x20, 0xfc, 0x3f, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 
      0x00, 0xcf, 0xf3, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=64 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 
      0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x3f, 0x00, 
      0x00, 0x14, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x0e, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 
      0x80, 0x57, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0x01, 0x00, 0xff, 0x03, 
      0x80, 0x3f, 0x00, 0x00, 0xf8, 0x03, 
      0x80, 0x0f, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0f, 0x3c, 0x78, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1f, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x3e, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0xfc, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xb6, 0xff, 0xff, 0xdb, 0x00, 
      0x80, 0x41, 0xfa, 0xff, 0x04, 0x03, 
      0x40, 0x40, 0x01, 0x00, 0x07, 0x06, 
      0x40, 0xe0, 0xf8, 0xbf, 0x07, 0x05, 
      0x20, 0x50, 0xfc, 0x43, 0x07, 0x0a, 
      0x20, 0xe8, 0xf8, 0xbd, 0x0f, 0x0c, 
      0x20, 0x74, 0xfc, 0xba, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0xfd, 0xbe, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfe, 0xdd, 0x1f, 0x0c, 
      0x20, 0xf4, 0xff, 0xe3, 0x1f, 0x0a, 
      0x40, 0xe8, 0xff, 0xff, 0x0f, 0x04, 
      0x40, 0xfc, 0x1f, 0xf0, 0x7f, 0x06, 
      0x80, 0x43, 0xd0, 0x17, 0x85, 0x03, 
      0x00, 0x61, 0xd0, 0x17, 0x06, 0x01, 
      0x00, 0xc1, 0xd0, 0x17, 0x83, 0x01, 
      0x00, 0xa1, 0xd0, 0x17, 0x42, 0x01, 
      0x00, 0xd2, 0x1f, 0xf0, 0xa7, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0x40, 0xfc, 0x7f, 0x05, 0x00, 
      0x00, 0x40, 0xf8, 0x3f, 0x0a, 0x00, 
      0x00, 0x40, 0xf4, 0x1f, 0x0c, 0x00, 
      0x00, 0x20, 0x28, 0x10, 0x0a, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf8, 0x3f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf4, 0xcf, 0x67, 0x00, 
      0x00, 0x3e, 0xf8, 0x0f, 0xc0, 0x00, 
      0x00, 0x3f, 0xf4, 0x0f, 0xe0, 0x01, 
      0x00, 0x3f, 0xf8, 0x1f, 0xd0, 0x01, 
      0x80, 0x3f, 0xf4, 0x3f, 0xe8, 0x03, 
      0x80, 0x3f, 0xfc, 0x7f, 0xf5, 0x03, 
      0x80, 0xcf, 0xf3, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x07, 0xf4, 0xff, 0xff, 0x01, 
      0x00, 0x06, 0xea, 0xff, 0xff, 0x00, 
      0x00, 0x0c, 0xfd, 0xff, 0x7f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x1f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=128 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xc0, 0x18, 0x00, 0x00, 
      0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x3f, 0x00, 
      0x00, 0x14, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x0e, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 
      0x80, 0x57, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0x01, 0x00, 0xff, 0x03, 
      0x80, 0x3f, 0x00, 0x00, 0xf8, 0x03, 
      0x80, 0x0f, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0f, 0x3c, 0x78, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1f, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x3e, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0xfc, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xb6, 0xff, 0xff, 0xdb, 0x00, 
      0x80, 0x41, 0xfa, 0xff, 0x04, 0x03, 
      0x40, 0x40, 0x01, 0x00, 0x07, 0x06, 
      0x40, 0xe0, 0xf8, 0xbf, 0x07, 0x05, 
      0x20, 0x50, 0xfc, 0x43, 0x07, 0x0a, 
      0x20, 0xe8, 0xf8, 0xbd, 0x0f, 0x0c, 
      0x20, 0x74, 0xfc, 0xba, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0xfd, 0xbe, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfe, 0xdd, 0x1f, 0x0c, 
      0x20, 0xf4, 0xff, 0xe3, 0x1f, 0x0a, 
      0x40, 0xe8, 0xff, 0xff, 0x0f, 0x04, 
      0x40, 0xfc, 0x1f, 0xf0, 0x7f, 0x06, 
      0x80, 0x43, 0xd0, 0x17, 0x85, 0x03, 
      0x00, 0x61, 0xd0, 0x17, 0x06, 0x01, 
      0x00, 0xc1, 0xd0, 0x17, 0x83, 0x01, 
      0x00, 0xa1, 0xd0, 0x17, 0x42, 0x01, 
      0x00, 0xd2, 0x1f, 0xf0, 0xa7, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0x40, 0xfc, 0x7f, 0x05, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x06, 0x00, 
      0x00, 0x20, 0xf4, 0x0f, 0x05, 0x00, 
      0x00, 0x20, 0x18, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf4, 0x0f, 0x0c, 0x00, 
      0x00, 0x30, 0xf8, 0x1f, 0x1a, 0x00, 
      0x00, 0xcc, 0xf7, 0x1f, 0x7c, 0x00, 
      0x00, 0x06, 0xe8, 0x1f, 0xfa, 0x00, 
      0x00, 0x07, 0xf4, 0x1f, 0xfc, 0x01, 
      0x00, 0x07, 0xea, 0x1f, 0xfa, 0x01, 
      0x80, 0x0f, 0xfd, 0x1f, 0xfc, 0x03, 
      0x80, 0xaf, 0xfe, 0x7f, 0xfa, 0x03, 
      0x80, 0xff, 0xff, 0x8f, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xc0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe0, 0x01, 
      0x00, 0xfe, 0xff, 0x0f, 0xd0, 0x00, 
      0x00, 0xfc, 0xff, 0x3f, 0x68, 0x00, 
      0x00, 0xf0, 0xff, 0x7f, 0x35, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x1f, 0x00}, 
    
    
    {
      /* Bitmap x=192 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x3f, 0x00, 
      0x00, 0x14, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x0e, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 
      0x80, 0x57, 0x7f, 0xfc, 0xff, 0x03, 
      0x80, 0xff, 0x3f, 0xfa, 0xff, 0x03, 
      0x80, 0xff, 0x3f, 0xfc, 0xff, 0x03, 
      0x80, 0xff, 0xbf, 0xfa, 0xff, 0x03, 
      0x80, 0xff, 0x7f, 0xfd, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xb6, 0xff, 0xff, 0xdb, 0x00, 
      0x80, 0x41, 0xfa, 0xff, 0x04, 0x03, 
      0x40, 0x40, 0x01, 0x00, 0x07, 0x04, 
      0x40, 0xc0, 0xfe, 0xff, 0x07, 0x04, 
      0x20, 0x60, 0x02, 0x80, 0x07, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xfe, 0xff, 0x0f, 0x0a, 
      0x20, 0xf4, 0x02, 0x80, 0x1f, 0x0c, 
      0x20, 0x78, 0xfb, 0xbf, 0x1f, 0x0a, 
      0x20, 0xf4, 0xfa, 0xbf, 0x1f, 0x0d, 
      0x20, 0xf8, 0xfb, 0xaf, 0x1f, 0x0a, 
      0x40, 0xf4, 0x1b, 0xa0, 0x1f, 0x05, 
      0x80, 0xf8, 0xfb, 0xbf, 0x9f, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1b, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x40, 0xfe, 0xff, 0x05, 0x00, 
      0x00, 0x20, 0xfc, 0x3f, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xe8, 0x0f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x2e, 0xf4, 0x1f, 0xea, 0x00, 
      0x00, 0x27, 0xfc, 0x3f, 0xcc, 0x01, 
      0x00, 0xc7, 0xeb, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xf0, 0x0f, 0xd0, 0x03, 
      0x80, 0x0f, 0xe8, 0x0f, 0xe8, 0x03, 
      0x80, 0x5f, 0xf5, 0x5f, 0xf5, 0x03, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=256 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x3f, 0x00, 
      0x00, 0x14, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x0e, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 
      0x80, 0x57, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0x3f, 0xfe, 0xff, 0x03, 
      0x80, 0xff, 0x1f, 0xfd, 0xff, 0x03, 
      0x80, 0xff, 0x1f, 0xfe, 0xff, 0x03, 
      0x80, 0xff, 0x5f, 0xfd, 0xff, 0x03, 
      0x80, 0xff, 0xbf, 0xfe, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xb6, 0xff, 0xff, 0xdb, 0x00, 
      0x80, 0x41, 0xfa, 0xff, 0x04, 0x03, 
      0x40, 0x40, 0x01, 0x00, 0x07, 0x04, 
      0x40, 0xc0, 0xfe, 0xff, 0x07, 0x04, 
      0x20, 0x60, 0x02, 0x80, 0x07, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xfe, 0xff, 0x0f, 0x0a, 
      0x20, 0xf4, 0x02, 0x80, 0x1f, 0x0c, 
      0x20, 0x78, 0xfb, 0xbf, 0x1f, 0x0a, 
      0x20, 0xf4, 0xfa, 0xbf, 0x1f, 0x0d, 
      0x20, 0xf8, 0xfb, 0xaf, 0x1f, 0x0a, 
      0x40, 0xf4, 0x1b, 0xa0, 0x1f, 0x05, 
      0x80, 0xf8, 0xfb, 0xbf, 0x9f, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1b, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x20, 0xfe, 0xff, 0x05, 0x00, 
      0x00, 0x20, 0xf8, 0x3f, 0x06, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x05, 0x00, 
      0x00, 0x30, 0x18, 0x08, 0x0a, 0x00, 
      0x00, 0x28, 0xf4, 0x0f, 0x0d, 0x00, 
      0x00, 0x24, 0xf8, 0x0f, 0x1a, 0x00, 
      0x00, 0xc4, 0xef, 0x1f, 0x7c, 0x00, 
      0x00, 0x06, 0xf0, 0x1f, 0xfa, 0x00, 
      0x00, 0x0f, 0xe8, 0x1f, 0xfc, 0x01, 
      0x00, 0x5f, 0xf5, 0x1f, 0xfa, 0x01, 
      0x80, 0xff, 0xff, 0x1f, 0xec, 0x03, 
      0x80, 0xff, 0xff, 0x3f, 0xda, 0x03, 
      0x80, 0xff, 0xff, 0xcf, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xd0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe8, 0x01, 
      0x00, 0xfe, 0xff, 0x5f, 0xf5, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=320 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x3f, 0x00, 
      0x00, 0x14, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x0e, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 
      0x80, 0x57, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xf8, 0xff, 0x03, 
      0x80, 0xff, 0x7f, 0xf4, 0xff, 0x03, 
      0x80, 0xff, 0x7f, 0xf8, 0xff, 0x03, 
      0x80, 0xff, 0x7f, 0xf5, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xfa, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xb6, 0xff, 0xff, 0xdb, 0x00, 
      0x80, 0x41, 0xfa, 0xff, 0x04, 0x03, 
      0x40, 0x40, 0x01, 0x00, 0x07, 0x04, 
      0x40, 0xc0, 0xfe, 0xff, 0x07, 0x04, 
      0x20, 0x60, 0x02, 0x80, 0x07, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xfe, 0xff, 0x0f, 0x0a, 
      0x20, 0xf4, 0x02, 0x80, 0x1f, 0x0c, 
      0x20, 0x78, 0xfb, 0xbf, 0x1f, 0x0a, 
      0x20, 0xf4, 0xfa, 0xbf, 0x1f, 0x0d, 
      0x20, 0xf8, 0xfb, 0xaf, 0x1f, 0x0a, 
      0x40, 0xf4, 0x1b, 0xa0, 0x1f, 0x05, 
      0x80, 0xf8, 0xfb, 0xbf, 0x9f, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1b, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x40, 0xfe, 0xff, 0x0d, 0x00, 
      0x00, 0x40, 0xf8, 0x3f, 0x0a, 0x00, 
      0x00, 0x40, 0xf4, 0x1f, 0x0c, 0x00, 
      0x00, 0x20, 0x28, 0x10, 0x1a, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x2c, 0x00, 
      0x00, 0x30, 0xe8, 0x3f, 0x5a, 0x00, 
      0x00, 0x3c, 0xf4, 0xcf, 0x67, 0x00, 
      0x00, 0x3e, 0xf8, 0x0f, 0xd0, 0x00, 
      0x00, 0x3f, 0xf4, 0x0f, 0xe8, 0x01, 
      0x00, 0x3f, 0xf8, 0x5f, 0xf5, 0x01, 
      0x80, 0x2f, 0xf4, 0xff, 0xff, 0x03, 
      0x80, 0x27, 0xf8, 0xff, 0xff, 0x03, 
      0x80, 0xc7, 0xef, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xf0, 0xff, 0xff, 0x01, 
      0x00, 0x0f, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x5e, 0xf5, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=384 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0xfc, 0xff, 0x01, 0x00, 
      0x7c, 0x80, 0xff, 0xff, 0x0f, 0x00, 
      0xc6, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0xa2, 0x50, 0xfd, 0xff, 0x7f, 0x00, 
      0xc2, 0x2b, 0xfe, 0xff, 0xff, 0x00, 
      0xaa, 0x1c, 0xfc, 0xff, 0xff, 0x01, 
      0xd6, 0x0e, 0xfe, 0xff, 0xff, 0x02, 
      0xfc, 0x1f, 0xfd, 0xff, 0x20, 0x02, 
      0x00, 0xaf, 0xfe, 0x7f, 0x20, 0x04, 
      0x00, 0xff, 0xff, 0x7f, 0x58, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x58, 0x04, 
      0x00, 0xfe, 0xff, 0x7f, 0x40, 0x02, 
      0x00, 0xfe, 0xff, 0xff, 0x20, 0x02, 
      0x00, 0xfc, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xf8, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x13, 0x08, 0x01, 0x00, 
      0x00, 0x02, 0x1b, 0xf8, 0x03, 0x00, 
      0x00, 0xfe, 0x17, 0xf4, 0x03, 0x00, 
      0x00, 0x02, 0x0a, 0xf8, 0x07, 0x00, 
      0x00, 0xfa, 0x0e, 0xf4, 0x07, 0x00, 
      0x00, 0xfa, 0x0a, 0xfa, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0xfc, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xfa, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0xfd, 0x07, 0x00, 
      0x00, 0xba, 0x1e, 0xfe, 0x03, 0x00, 
      0x00, 0xba, 0x1e, 0xfd, 0x03, 0x00, 
      0x00, 0xba, 0x1e, 0xfe, 0x06, 0x00, 
      0x00, 0xba, 0x22, 0x05, 0x07, 0x00, 
      0x00, 0x9a, 0x22, 0x86, 0x06, 0x00, 
      0x00, 0xfa, 0xc2, 0x09, 0x07, 0x00, 
      0x00, 0x02, 0x42, 0x90, 0x03, 0x00, 
      0x00, 0xfc, 0x7f, 0xf0, 0x01, 0x00, 
      0x00, 0x00, 0xbf, 0xf8, 0x00, 0x00, 
      0x00, 0x00, 0x1e, 0xf7, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x78, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x18, 0x00, 0x00, 
      0x00, 0x80, 0x3f, 0xf4, 0x03, 0x00, 
      0x00, 0xf0, 0x3f, 0xfa, 0x1f, 0x00, 
      0x00, 0xfc, 0x2f, 0xcc, 0x7f, 0x00, 
      0x00, 0xfe, 0x27, 0x8a, 0xff, 0x00, 
      0x00, 0xff, 0x17, 0xad, 0xff, 0x01, 
      0x00, 0xff, 0x1f, 0xd6, 0xff, 0x01, 
      0x80, 0xff, 0x1f, 0xfd, 0xff, 0x03, 
      0x80, 0xff, 0xef, 0xc3, 0xff, 0x03, 
      0x80, 0xff, 0x07, 0x80, 0xff, 0x03, 
      0x00, 0xff, 0x07, 0xa0, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xd5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=448 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0xfc, 0xff, 0x01, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x0f, 0x00, 
      0x7c, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0xc6, 0x50, 0xfd, 0xff, 0x7f, 0x00, 
      0xa2, 0x2b, 0xfe, 0xff, 0xff, 0x00, 
      0xc2, 0x1c, 0xfc, 0xff, 0xff, 0x01, 
      0xaa, 0x0e, 0xfe, 0xff, 0xff, 0x02, 
      0xd6, 0x1f, 0xfd, 0xff, 0x20, 0x02, 
      0x7c, 0xaf, 0xfe, 0x7f, 0x20, 0x04, 
      0x00, 0xff, 0xff, 0x7f, 0x58, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x58, 0x04, 
      0x00, 0xfe, 0xff, 0x7f, 0x40, 0x02, 
      0x00, 0xfe, 0xff, 0xff, 0x20, 0x02, 
      0x00, 0xfc, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xf8, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x13, 0x10, 0x01, 0x00, 
      0x00, 0x02, 0x1b, 0xf8, 0x03, 0x00, 
      0x00, 0xfe, 0x17, 0xf4, 0x03, 0x00, 
      0x00, 0x02, 0x0a, 0xf8, 0x07, 0x00, 
      0x00, 0xfa, 0x0e, 0xf4, 0x07, 0x00, 
      0x00, 0xfa, 0x0a, 0xfa, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0xfc, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xfa, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0xfd, 0x07, 0x00, 
      0x00, 0xba, 0x1e, 0xfe, 0x03, 0x00, 
      0x00, 0xba, 0x1e, 0xfd, 0x07, 0x00, 
      0x00, 0xba, 0x1e, 0xfe, 0x06, 0x00, 
      0x00, 0xba, 0x22, 0x05, 0x07, 0x00, 
      0x00, 0x9a, 0x22, 0x86, 0x06, 0x00, 
      0x00, 0xfa, 0xc2, 0x09, 0x07, 0x00, 
      0x00, 0x02, 0x42, 0x90, 0x07, 0x00, 
      0x00, 0xfc, 0x7f, 0xf0, 0x01, 0x00, 
      0x00, 0x00, 0xbf, 0xf8, 0x00, 0x00, 
      0x00, 0x00, 0x1e, 0xf7, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x68, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 
      0x00, 0x00, 0x14, 0x68, 0x00, 0x00, 
      0x00, 0x80, 0x23, 0xd0, 0x03, 0x00, 
      0x00, 0xf0, 0x63, 0xe0, 0x1f, 0x00, 
      0x00, 0xfc, 0xdc, 0xd0, 0x7f, 0x00, 
      0x00, 0x7e, 0x30, 0xe1, 0xff, 0x00, 
      0x00, 0x7f, 0x00, 0xd1, 0xff, 0x01, 
      0x00, 0xff, 0xaa, 0xe1, 0xff, 0x01, 
      0x80, 0xff, 0x5f, 0xd1, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0x3e, 0xfc, 0x03, 
      0x80, 0xff, 0x7f, 0x00, 0xf8, 0x03, 
      0x00, 0xff, 0x7f, 0x00, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0x55, 0xfd, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=512 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0xfc, 0xff, 0x01, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x0f, 0x00, 
      0x7c, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0xc6, 0x50, 0xfd, 0xff, 0x7f, 0x00, 
      0xa2, 0x2b, 0xfe, 0xff, 0xff, 0x00, 
      0xc2, 0x1c, 0xfc, 0xff, 0xff, 0x01, 
      0xaa, 0x0e, 0xfe, 0xff, 0xff, 0x02, 
      0xd6, 0x1f, 0xfd, 0xff, 0x20, 0x02, 
      0x7c, 0xaf, 0xfe, 0x7f, 0x20, 0x04, 
      0x00, 0xff, 0xff, 0x7f, 0x58, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x5c, 0x04, 
      0x00, 0xff, 0xff, 0x3f, 0x58, 0x04, 
      0x00, 0xfe, 0xff, 0x7f, 0x40, 0x02, 
      0x00, 0xfe, 0xff, 0xff, 0x20, 0x02, 
      0x00, 0xfc, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xf8, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x13, 0x10, 0x01, 0x00, 
      0x00, 0x02, 0x1b, 0xf8, 0x03, 0x00, 
      0x00, 0xfe, 0x17, 0xf4, 0x03, 0x00, 
      0x00, 0x02, 0x0a, 0xf8, 0x07, 0x00, 
      0x00, 0xfa, 0x0e, 0xf4, 0x07, 0x00, 
      0x00, 0xfa, 0x0a, 0xfa, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0xfc, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xfa, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0xfd, 0x07, 0x00, 
      0x00, 0xba, 0x1e, 0xfe, 0x03, 0x00, 
      0x00, 0xba, 0x1e, 0xfd, 0x07, 0x00, 
      0x00, 0xba, 0x1e, 0xfe, 0x06, 0x00, 
      0x00, 0xba, 0x22, 0x05, 0x07, 0x00, 
      0x00, 0x9a, 0x22, 0x86, 0x06, 0x00, 
      0x00, 0xfa, 0xc2, 0x09, 0x07, 0x00, 
      0x00, 0x02, 0x42, 0x90, 0x07, 0x00, 
      0x00, 0xfc, 0x7f, 0xf0, 0x01, 0x00, 
      0x00, 0x00, 0xbf, 0xf8, 0x00, 0x00, 
      0x00, 0x00, 0x1e, 0xf7, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x78, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x38, 0x00, 0x00, 
      0x00, 0x80, 0x1f, 0xd4, 0x03, 0x00, 
      0x00, 0xf0, 0x1f, 0xca, 0x1f, 0x00, 
      0x00, 0xfc, 0x0f, 0x3d, 0x7c, 0x00, 
      0x00, 0xfe, 0x87, 0x02, 0xf8, 0x00, 
      0x00, 0xff, 0x43, 0x01, 0xfa, 0x01, 
      0x00, 0xff, 0xa3, 0x55, 0xfd, 0x01, 
      0x80, 0xff, 0xdc, 0xff, 0xff, 0x03, 
      0x80, 0x7f, 0x30, 0xfc, 0xff, 0x03, 
      0x80, 0x7f, 0x00, 0xf8, 0xff, 0x03, 
      0x00, 0xff, 0xaa, 0xfa, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xfd, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=576 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xfc, 0x07, 0x00, 0x00, 
      0x00, 0x80, 0xff, 0x3f, 0x00, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x01, 0x3e, 
      0x00, 0xfc, 0xff, 0xff, 0x07, 0x63, 
      0x00, 0xaa, 0xff, 0xff, 0x0f, 0x51, 
      0x00, 0xc5, 0xff, 0xff, 0xdf, 0x61, 
      0x80, 0xa7, 0xff, 0xff, 0x3f, 0x55, 
      0x40, 0xff, 0xff, 0xff, 0x3f, 0x6b, 
      0x40, 0x04, 0xff, 0xff, 0xff, 0x3f, 
      0x20, 0x04, 0xfe, 0xff, 0xff, 0x00, 
      0x20, 0x1a, 0xfe, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x3a, 0xfc, 0xff, 0xff, 0x00, 
      0x20, 0x1a, 0xfc, 0xff, 0xff, 0x00, 
      0x40, 0x02, 0xfe, 0xff, 0x7f, 0x00, 
      0x40, 0x04, 0xff, 0xff, 0x7f, 0x00, 
      0x80, 0xff, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xff, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xfe, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x01, 0x00, 
      0x00, 0x00, 0x1f, 0xbc, 0x3f, 0x00, 
      0x00, 0x80, 0x09, 0xe8, 0x40, 0x00, 
      0x00, 0xc0, 0x0f, 0xfc, 0x40, 0x00, 
      0x00, 0xc0, 0x0d, 0xf8, 0x7f, 0x00, 
      0x00, 0x60, 0x0e, 0x74, 0x40, 0x00, 
      0x00, 0xa0, 0x0d, 0x78, 0x5f, 0x00, 
      0x00, 0xa0, 0x1d, 0x74, 0x5f, 0x00, 
      0x00, 0xa0, 0x1d, 0x78, 0x57, 0x00, 
      0x00, 0xa0, 0x1d, 0x74, 0x57, 0x00, 
      0x00, 0x20, 0x3e, 0x7a, 0x57, 0x00, 
      0x00, 0xc0, 0x3f, 0x7c, 0x57, 0x00, 
      0x00, 0xe0, 0x3f, 0x7a, 0x57, 0x00, 
      0x00, 0xa0, 0x3e, 0x7d, 0x57, 0x00, 
      0x00, 0xa0, 0x20, 0x46, 0x57, 0x00, 
      0x00, 0xa0, 0x60, 0x45, 0x53, 0x00, 
      0x00, 0xa0, 0x90, 0x43, 0x5f, 0x00, 
      0x00, 0xe0, 0x09, 0x43, 0x40, 0x00, 
      0x00, 0x80, 0x8f, 0xfe, 0x3f, 0x00, 
      0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 
      0x00, 0x00, 0xef, 0x7a, 0x00, 0x00, 
      0x00, 0x00, 0x0e, 0x3c, 0x00, 0x00, 
      0x00, 0x00, 0x0c, 0x1a, 0x00, 0x00, 
      0x00, 0x00, 0x08, 0x0d, 0x00, 0x00, 
      0x00, 0xc0, 0x0f, 0xfe, 0x01, 0x00, 
      0x00, 0xf8, 0x1f, 0xfd, 0x0f, 0x00, 
      0x00, 0xfe, 0x13, 0xf6, 0x3f, 0x00, 
      0x00, 0xff, 0x11, 0xed, 0x7f, 0x00, 
      0x80, 0xff, 0x31, 0xfa, 0xff, 0x00, 
      0x80, 0xff, 0x2b, 0xfc, 0xff, 0x00, 
      0xc0, 0xff, 0x3f, 0xfa, 0xff, 0x01, 
      0xc0, 0xff, 0xc3, 0xf7, 0xff, 0x01, 
      0xc0, 0xff, 0x01, 0xe8, 0xff, 0x01, 
      0x80, 0xff, 0x01, 0xf4, 0xff, 0x00, 
      0x80, 0xff, 0xab, 0xfa, 0xff, 0x00, 
      0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x01, 0x00}, 
    
    {
      /* Bitmap x=0 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x03, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x7c, 
      0x00, 0x54, 0xff, 0xff, 0x1f, 0xc6, 
      0x00, 0x8a, 0xff, 0xff, 0xbf, 0xa3, 
      0x00, 0x4f, 0xff, 0xff, 0x7f, 0xc2, 
      0x80, 0xfe, 0xff, 0xff, 0x7f, 0xaa, 
      0x80, 0x08, 0xfe, 0xff, 0xff, 0xd7, 
      0x40, 0x08, 0xfc, 0xff, 0xff, 0x7d, 
      0x40, 0x34, 0xfc, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x34, 0xf8, 0xff, 0xff, 0x01, 
      0x80, 0x04, 0xfc, 0xff, 0xff, 0x00, 
      0x80, 0x08, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x03, 0x00, 
      0x00, 0x00, 0x3e, 0x78, 0x7f, 0x00, 
      0x00, 0x00, 0x1f, 0xf0, 0x81, 0x00, 
      0x00, 0x80, 0x1f, 0xf8, 0x81, 0x00, 
      0x00, 0x80, 0x1b, 0xf0, 0xff, 0x00, 
      0x00, 0xc0, 0x1c, 0xe8, 0x80, 0x00, 
      0x00, 0x40, 0x1b, 0xf0, 0xbe, 0x00, 
      0x00, 0x40, 0x3b, 0xe8, 0xbe, 0x00, 
      0x00, 0x40, 0x3b, 0xf0, 0xae, 0x00, 
      0x00, 0x40, 0x3b, 0xe8, 0xae, 0x00, 
      0x00, 0x40, 0x7c, 0xf4, 0xae, 0x00, 
      0x00, 0x80, 0x7f, 0xf8, 0xae, 0x00, 
      0x00, 0xc0, 0x7f, 0xf4, 0xae, 0x00, 
      0x00, 0x40, 0x7d, 0xfa, 0xae, 0x00, 
      0x00, 0x40, 0x41, 0xac, 0xae, 0x00, 
      0x00, 0x40, 0xc1, 0xca, 0xa6, 0x00, 
      0x00, 0x40, 0x21, 0xa7, 0xbe, 0x00, 
      0x00, 0xc0, 0x13, 0xc6, 0x80, 0x00, 
      0x00, 0x00, 0x1f, 0xfd, 0x7f, 0x00, 
      0x00, 0x00, 0xbe, 0xfa, 0x01, 0x00, 
      0x00, 0x00, 0xde, 0xf5, 0x00, 0x00, 
      0x00, 0x00, 0x08, 0x7a, 0x00, 0x00, 
      0x00, 0x00, 0x08, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x04, 0x5a, 0x00, 0x00, 
      0x00, 0x80, 0x07, 0x8d, 0x03, 0x00, 
      0x00, 0xf0, 0x87, 0x86, 0x1f, 0x00, 
      0x00, 0xfc, 0x47, 0x67, 0x7f, 0x00, 
      0x00, 0xfe, 0x87, 0x99, 0xfe, 0x00, 
      0x00, 0xff, 0x47, 0x41, 0xfd, 0x01, 
      0x00, 0xff, 0x87, 0xa9, 0xfe, 0x01, 
      0x80, 0xff, 0x47, 0xf5, 0xff, 0x03, 
      0x80, 0x7f, 0xf8, 0xfe, 0xff, 0x03, 
      0x80, 0x3f, 0x00, 0xfd, 0xff, 0x03, 
      0x00, 0x3f, 0x80, 0xfe, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=64 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x03, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x7c, 
      0x00, 0x54, 0xff, 0xff, 0x1f, 0xc6, 
      0x00, 0x8a, 0xff, 0xff, 0xbf, 0xa3, 
      0x00, 0x4f, 0xff, 0xff, 0x7f, 0xc2, 
      0x80, 0xfe, 0xff, 0xff, 0x7f, 0xaa, 
      0x80, 0x08, 0xfe, 0xff, 0xff, 0xd7, 
      0x40, 0x08, 0xfc, 0xff, 0xff, 0x7d, 
      0x40, 0x34, 0xfc, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x74, 0xf8, 0xff, 0xff, 0x01, 
      0x40, 0x34, 0xf8, 0xff, 0xff, 0x01, 
      0x80, 0x04, 0xfc, 0xff, 0xff, 0x00, 
      0x80, 0x08, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xfe, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x03, 0x00, 
      0x00, 0x00, 0x3e, 0x78, 0x7f, 0x00, 
      0x00, 0x00, 0x1f, 0xf0, 0x81, 0x00, 
      0x00, 0x80, 0x1f, 0xf8, 0x81, 0x00, 
      0x00, 0x80, 0x1b, 0xf0, 0xff, 0x00, 
      0x00, 0xc0, 0x1c, 0xe8, 0x80, 0x00, 
      0x00, 0x40, 0x1b, 0xf0, 0xbe, 0x00, 
      0x00, 0x40, 0x3b, 0xe8, 0xbe, 0x00, 
      0x00, 0x40, 0x3b, 0xf0, 0xae, 0x00, 
      0x00, 0x40, 0x3b, 0xe8, 0xae, 0x00, 
      0x00, 0x40, 0x7c, 0xf4, 0xae, 0x00, 
      0x00, 0x80, 0x7f, 0xf8, 0xae, 0x00, 
      0x00, 0xc0, 0x7f, 0xf4, 0xae, 0x00, 
      0x00, 0x40, 0x7d, 0xfa, 0xae, 0x00, 
      0x00, 0x40, 0x41, 0xac, 0xae, 0x00, 
      0x00, 0x40, 0xc1, 0xca, 0xa6, 0x00, 
      0x00, 0x40, 0x21, 0xa7, 0xbe, 0x00, 
      0x00, 0xc0, 0x13, 0xc2, 0x80, 0x00, 
      0x00, 0x00, 0x1f, 0xfd, 0x7f, 0x00, 
      0x00, 0x00, 0xbe, 0xfa, 0x01, 0x00, 
      0x00, 0x00, 0xde, 0xf5, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x7a, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x1a, 0x00, 0x00, 
      0x00, 0x80, 0x17, 0xf4, 0x03, 0x00, 
      0x00, 0xf0, 0x27, 0xf8, 0x1f, 0x00, 
      0x00, 0x7c, 0x78, 0xf4, 0x7f, 0x00, 
      0x00, 0x3e, 0x80, 0xe8, 0xff, 0x00, 
      0x00, 0x3f, 0x80, 0xd1, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xa3, 0xff, 0x01, 
      0x80, 0xff, 0xff, 0x67, 0xfe, 0x03, 
      0x80, 0xff, 0x7f, 0x18, 0xfe, 0x03, 
      0x80, 0xff, 0x3f, 0x00, 0xfd, 0x03, 
      0x00, 0xff, 0x3f, 0xa0, 0xfe, 0x01, 
      0x00, 0xff, 0x7f, 0xf5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00} ,
    
    
    {
      /* Bitmap x=320 y=0 w=64 h=48 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x08, 0x00, 0x00, 
      0x00, 0x00, 0x70, 0x1b, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xfc, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xfc, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 
      0x00, 0x1e, 0x00, 0x00, 0xf0, 0x00, 
      0x00, 0x0f, 0x00, 0x00, 0xe0, 0x01, 
      0x00, 0x07, 0x00, 0x00, 0xc0, 0x01, 
      0x80, 0x07, 0x00, 0x00, 0xc0, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x3c, 0x78, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1f, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x3e, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 
      
      0x00, 0x78, 0x00, 0x00, 0x3c, 0x00, 
      0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 
      0x00, 0xfe, 0xa9, 0x2a, 0xff, 0x00, 
      0x80, 0xa7, 0xa9, 0x2a, 0xcb, 0x03, 
      0xc0, 0xa7, 0x03, 0x80, 0xcb, 0x07, 
      0xc0, 0xc7, 0xfe, 0xff, 0xc6, 0x07, 
      0xe0, 0xc3, 0xe1, 0x1f, 0x87, 0x0f, 
      0xe0, 0x79, 0x83, 0x82, 0x3d, 0x0f, 
      0xe0, 0x7c, 0xfe, 0xfe, 0x7c, 0x0e, 
      0x20, 0xfc, 0x80, 0x02, 0x7e, 0x08, 
      0x20, 0xfe, 0xf1, 0x1e, 0xff, 0x08, 
      0x60, 0x7f, 0xff, 0xfe, 0xfd, 0x0d, 
      0xe0, 0xfc, 0x80, 0x02, 0x7e, 0x0e, 
      0x40, 0xfe, 0xf1, 0x1f, 0xff, 0x04, 
      0xc0, 0xfc, 0x7f, 0xfc, 0x7f, 0x06, 
      0x80, 0xf9, 0xff, 0xfe, 0x3f, 0x03, 
      0x00, 0x93, 0x7f, 0xfc, 0x93, 0x01, 
      0x00, 0xff, 0xff, 0xfe, 0xff, 0x01, 
      0x00, 0xd7, 0x73, 0x9c, 0xd7, 0x01, 
      0x00, 0xd6, 0x03, 0x80, 0xd7, 0x00, 
      0x00, 0xfc, 0xf7, 0xdf, 0x7f, 0x00, 
      0x00, 0xc0, 0xf9, 0x3f, 0x07, 0x00, 
      0x00, 0xc0, 0xf3, 0x9f, 0x07, 0x00, 
      0x00, 0xe0, 0xf9, 0x3f, 0x0f, 0x00, 
      0x00, 0xe0, 0xf8, 0x3f, 0x0e, 0x00, 
      0x00, 0xe0, 0x39, 0x38, 0x0f, 0x00, 
      0x00, 0xe0, 0xfd, 0x7f, 0x0f, 0x00, 
      0x00, 0xf0, 0xfa, 0xbf, 0x1e, 0x00, 
      0x00, 0xfc, 0xfd, 0x7f, 0x7f, 0x00, 
      0x00, 0xfe, 0xfd, 0x7f, 0xff, 0x00, 
      0x00, 0xff, 0xf9, 0x3f, 0xff, 0x01, 
      0x00, 0xff, 0xf3, 0x9f, 0xff, 0x01, 
      0x80, 0x7f, 0xfe, 0xff, 0xfc, 0x03, 
      0x80, 0x9f, 0xfa, 0xbf, 0xf2, 0x03, 
      0x80, 0x6f, 0xfd, 0x7f, 0xed, 0x03, 
      0x00, 0xbf, 0xfe, 0xff, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    {
      /* Bitmap x=448 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 
      0x00, 0x00, 0xf0, 0x9f, 0x31, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x20, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x27, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x3f, 0x00, 
      0x00, 0x14, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x0e, 0xfe, 0xff, 0xff, 0x00, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0x8f, 0xfe, 0xff, 0xff, 0x01, 
      0x80, 0x57, 0xff, 0xff, 0xff, 0x01, 
      0x80, 0xff, 0x01, 0x00, 0xff, 0x01, 
      0x80, 0x3f, 0x00, 0x00, 0xe8, 0x00, 
      0x80, 0x0f, 0x00, 0x00, 0x20, 0x00, 
      0x80, 0x0f, 0x00, 0x00, 0x50, 0x00, 
      0x80, 0x0f, 0x00, 0x00, 0x60, 0x00, 
      0x80, 0x0f, 0x42, 0x84, 0x50, 0x00, 
      0x80, 0x0f, 0x66, 0xcc, 0x60, 0x00, 
      0x80, 0x0f, 0x3c, 0x78, 0x50, 0x00, 
      0x80, 0x0f, 0x18, 0x30, 0x60, 0x00, 
      0x80, 0x0f, 0x3c, 0x78, 0x70, 0x00, 
      0x00, 0x0f, 0x66, 0xcc, 0xe0, 0x00, 
      0x00, 0x1f, 0x42, 0x84, 0xf0, 0x00, 
      0x00, 0x3e, 0x00, 0x00, 0xf8, 0x00, 
      0x00, 0xfc, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xb6, 0xff, 0xff, 0xdb, 0x00, 
      0x80, 0x41, 0xfe, 0xff, 0x04, 0x03, 
      0x40, 0xc0, 0x01, 0x00, 0x07, 0x06, 
      0x40, 0xf0, 0xff, 0xbf, 0x07, 0x05, 
      0x20, 0x68, 0xfe, 0x43, 0x07, 0x0a, 
      0x20, 0x24, 0xf8, 0xbd, 0x0f, 0x0c, 
      0x20, 0x6c, 0xe0, 0xba, 0x1f, 0x0a, 
      0x20, 0x3a, 0xc0, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0x80, 0xbf, 0x1f, 0x0a, 
      0x20, 0x3a, 0x00, 0xdf, 0x1f, 0x0c, 
      0x20, 0xf4, 0x01, 0xe1, 0x1f, 0x0a, 
      0x40, 0xe8, 0xcf, 0xff, 0x0f, 0x04, 
      0x40, 0xfc, 0xff, 0xff, 0x7f, 0x06, 
      0x80, 0xc3, 0xff, 0x7f, 0x84, 0x03, 
      0x00, 0xc1, 0xfc, 0x19, 0x04, 0x01, 
      0x00, 0xc1, 0x38, 0x06, 0x82, 0x01, 
      0x00, 0xa1, 0xd9, 0x07, 0x42, 0x01, 
      0x00, 0xd2, 0xda, 0x87, 0xa7, 0x00, 
      0x00, 0x7c, 0xdf, 0xe7, 0x7f, 0x00, 
      0x00, 0x40, 0xbc, 0x59, 0x05, 0x00, 
      0x00, 0x40, 0x7c, 0x3e, 0x06, 0x00, 
      0x00, 0x20, 0xf0, 0x1f, 0x05, 0x00, 
      0x00, 0x20, 0xe8, 0x4f, 0x06, 0x00, 
      0x00, 0x20, 0x34, 0x48, 0x07, 0x00, 
      0x00, 0x20, 0xf8, 0xbf, 0x02, 0x00, 
      0x00, 0x30, 0xf4, 0xbf, 0x1d, 0x00, 
      0x00, 0x3c, 0xf8, 0x3f, 0x7e, 0x00, 
      0x00, 0x3e, 0xf4, 0x3f, 0xfc, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfe, 0x01, 
      0x00, 0xcf, 0xf3, 0x1f, 0xf4, 0x01, 
      0x80, 0x07, 0xe8, 0x1f, 0xe8, 0x03, 
      0x80, 0x07, 0xf4, 0x1f, 0xfc, 0x03, 
      0x80, 0x07, 0xea, 0x3f, 0xea, 0x03, 
      0x00, 0x0f, 0xfd, 0x7f, 0xf6, 0x01, 
      0x00, 0xaf, 0xfe, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    {
      /* Bitmap x=192 y=192 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0a, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xac, 0xfe, 0xff, 0x7f, 0x00, 
      0x00, 0x16, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0x0f, 0xfe, 0xff, 0xff, 0x01, 
      0x00, 0x07, 0xff, 0xff, 0xff, 0x01, 
      0x80, 0x8f, 0xfe, 0xff, 0xff, 0x03, 
      0x80, 0x57, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0xff, 0xff, 0x03, 
      0x80, 0x7f, 0x00, 0x00, 0xfc, 0x03, 
      0x80, 0x0f, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0f, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0f, 0x3c, 0x78, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1e, 0x7e, 0xfc, 0xf0, 0x00, 
      0x00, 0x3c, 0x7e, 0xfc, 0x78, 0x00, 
      0x00, 0x78, 0x3c, 0x78, 0x3c, 0x00, 
      0x00, 0xf8, 0x01, 0x00, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0x41, 0xfc, 0xff, 0x04, 0x03, 
      0x40, 0x40, 0x01, 0x00, 0x07, 0x06, 
      0x40, 0xe0, 0xf8, 0xbf, 0x07, 0x05, 
      0x20, 0x50, 0xfc, 0x43, 0x07, 0x0a, 
      0x20, 0xe8, 0xf8, 0xbd, 0x0f, 0x0c, 
      0x20, 0x74, 0xfc, 0xba, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0xfd, 0xbe, 0x1f, 0x0a, 
      0x20, 0xfa, 0xfe, 0xdd, 0x1f, 0x0c, 
      0x20, 0xf4, 0xff, 0xe3, 0x1f, 0x0a, 
      0x40, 0xe8, 0xff, 0xff, 0x0f, 0x04, 
      0x40, 0xfc, 0x1f, 0xf0, 0x7f, 0x06, 
      0x80, 0x43, 0xd0, 0x17, 0x85, 0x03, 
      0x00, 0x61, 0xd0, 0x17, 0x06, 0x01, 
      0x00, 0xc1, 0xd0, 0x17, 0x83, 0x01, 
      0x00, 0xa1, 0xd0, 0x17, 0x42, 0x01, 
      0x00, 0xd2, 0x1f, 0xf0, 0xa7, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0x40, 0xfc, 0x7f, 0x05, 0x00, 
      0x00, 0x20, 0xfc, 0x3f, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 
      0x00, 0xcf, 0xf3, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
  },
  
  /* player 3 */
  {
    
    {
      /* Bitmap x=192 y=0 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0a, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0x0c, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x03, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x05, 0x55, 0x55, 0x55, 0x01, 
      0x80, 0x82, 0xfe, 0xff, 0xaa, 0x03, 
      0x80, 0xd5, 0x01, 0x00, 0xd7, 0x03, 
      0x80, 0x3a, 0x00, 0x00, 0xb8, 0x03, 
      0x80, 0x0d, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0a, 0x3c, 0x78, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x00, 0x0d, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1b, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x36, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xd8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x06, 
      0x40, 0xe0, 0xaa, 0x8a, 0x06, 0x05, 
      0x20, 0xd0, 0x55, 0x41, 0x07, 0x0a, 
      0x20, 0xe8, 0xaa, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x55, 0x3a, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x3e, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0x9c, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x41, 0x1f, 0x0a, 
      0x40, 0xe8, 0xaa, 0xaa, 0x0f, 0x04, 
      0x40, 0x7c, 0xf5, 0xdf, 0x7f, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0xea, 0xef, 0xa7, 0x00, 
      0x00, 0xfc, 0x57, 0xf5, 0x7f, 0x00, 
      0x00, 0x40, 0xaf, 0xfa, 0x06, 0x00, 
      0x00, 0x40, 0x5c, 0x7d, 0x05, 0x00, 
      0x00, 0x20, 0xf8, 0x3f, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 
      0x00, 0xcf, 0xf3, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=256 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 
      0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x05, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0x0c, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x03, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x05, 0x55, 0x55, 0x55, 0x01, 
      0x80, 0x82, 0xfe, 0xff, 0xaa, 0x03, 
      0x80, 0xd5, 0x01, 0x00, 0xd7, 0x03, 
      0x80, 0x3a, 0x00, 0x00, 0xb8, 0x03, 
      0x80, 0x0d, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0a, 0x3c, 0x78, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x00, 0x0d, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1b, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x36, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xd8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x06, 
      0x40, 0xe0, 0xaa, 0x8a, 0x06, 0x05, 
      0x20, 0xd0, 0x55, 0x41, 0x07, 0x0a, 
      0x20, 0xe8, 0xaa, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x55, 0x3a, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x3e, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0x9c, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x41, 0x1f, 0x0a, 
      0x40, 0xe8, 0xaa, 0xaa, 0x0f, 0x04, 
      0x40, 0x7c, 0xf5, 0xdf, 0x7f, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0xea, 0xef, 0xa7, 0x00, 
      0x00, 0xfc, 0x57, 0xf5, 0x7f, 0x00, 
      0x00, 0x40, 0xaf, 0xfa, 0x06, 0x00, 
      0x00, 0x40, 0x5c, 0x7d, 0x0d, 0x00, 
      0x00, 0x40, 0xf8, 0x3f, 0x0a, 0x00, 
      0x00, 0x40, 0xf4, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x28, 0x10, 0x0a, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf8, 0x3f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf4, 0xcf, 0x67, 0x00, 
      0x00, 0x3e, 0xf8, 0x0f, 0xc0, 0x00, 
      0x00, 0x3f, 0xf4, 0x0f, 0xe0, 0x01, 
      0x00, 0x3f, 0xf8, 0x1f, 0xd0, 0x01, 
      0x80, 0x3f, 0xf4, 0x3f, 0xe8, 0x03, 
      0x80, 0x3f, 0xfc, 0x7f, 0xf5, 0x03, 
      0x80, 0xcf, 0xf3, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x07, 0xf4, 0xff, 0xff, 0x01, 
      0x00, 0x06, 0xea, 0xff, 0xff, 0x00, 
      0x00, 0x0c, 0xfd, 0xff, 0x7f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x1f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=320 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xc0, 0x18, 0x00, 0x00, 
      0x00, 0x00, 0x40, 0x14, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0x0c, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x03, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x05, 0x55, 0x55, 0x55, 0x01, 
      0x80, 0x82, 0xfe, 0xff, 0xaa, 0x03, 
      0x80, 0xd5, 0x01, 0x00, 0xd7, 0x03, 
      0x80, 0x3a, 0x00, 0x00, 0xb8, 0x03, 
      0x80, 0x0d, 0x00, 0x00, 0xe0, 0x03, 
      0x80, 0x0a, 0x3c, 0x78, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x80, 0x0d, 0x7e, 0xfc, 0xe0, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x03, 
      0x00, 0x0d, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1b, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x36, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0xfc, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x06, 
      0x40, 0xe0, 0xaa, 0x8a, 0x06, 0x05, 
      0x20, 0xd0, 0x55, 0x41, 0x07, 0x0a, 
      0x20, 0xe8, 0xaa, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x55, 0x3a, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x3e, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0x9c, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x41, 0x1f, 0x0a, 
      0x40, 0xe8, 0xaa, 0xaa, 0x0f, 0x04, 
      0x40, 0x7c, 0xf5, 0xdf, 0x7f, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xda, 0xeb, 0xef, 0xb7, 0x00, 
      0x00, 0xfc, 0x57, 0xf5, 0x7f, 0x00, 
      0x00, 0x40, 0xaf, 0xfa, 0x06, 0x00, 
      0x00, 0x60, 0x5c, 0x7d, 0x05, 0x00, 
      0x00, 0x20, 0xf8, 0x3f, 0x06, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x05, 0x00, 
      0x00, 0x20, 0x18, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf4, 0x0f, 0x0c, 0x00, 
      0x00, 0x30, 0xf8, 0x1f, 0x1a, 0x00, 
      0x00, 0xcc, 0xf7, 0x1f, 0x7c, 0x00, 
      0x00, 0x06, 0xe8, 0x1f, 0xfa, 0x00, 
      0x00, 0x07, 0xf4, 0x1f, 0xfc, 0x01, 
      0x00, 0x07, 0xea, 0x1f, 0xfa, 0x01, 
      0x80, 0x0f, 0xfd, 0x1f, 0xfc, 0x03, 
      0x80, 0xaf, 0xfe, 0x7f, 0xfa, 0x03, 
      0x80, 0xff, 0xff, 0x8f, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xc0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe0, 0x01, 
      0x00, 0xfe, 0xff, 0x0f, 0xd0, 0x00, 
      0x00, 0xfc, 0xff, 0x3f, 0x68, 0x00, 
      0x00, 0xf0, 0xff, 0x7f, 0x35, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x1f, 0x00}, 
    
    
    {
      /* Bitmap x=384 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0x0c, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x03, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x05, 0xd5, 0x57, 0x55, 0x01, 
      0x80, 0x82, 0x6a, 0xac, 0xaa, 0x03, 
      0x80, 0x55, 0x35, 0x5a, 0xd5, 0x03, 
      0x80, 0xaa, 0x2a, 0xac, 0xaa, 0x03, 
      0x80, 0x55, 0xb5, 0x5a, 0xd5, 0x03, 
      0x80, 0xaa, 0x6a, 0xad, 0xaa, 0x03, 
      0x80, 0x55, 0xd5, 0x57, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0x03, 
      0x80, 0x55, 0x55, 0x55, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0x03, 
      0x80, 0x55, 0x55, 0x55, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaa, 0xea, 0x03, 
      0x00, 0x55, 0x55, 0x55, 0xf5, 0x01, 
      0x00, 0xab, 0xaa, 0xaa, 0xfa, 0x01, 
      0x00, 0x5e, 0x55, 0x55, 0xfd, 0x00, 
      0x00, 0xbc, 0xaa, 0xaa, 0x7e, 0x00, 
      0x00, 0xf8, 0x55, 0xd5, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x04, 
      0x40, 0xc0, 0xfe, 0xff, 0x07, 0x04, 
      0x20, 0xe0, 0x03, 0x80, 0x07, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xff, 0xff, 0x0f, 0x0a, 
      0x20, 0xf4, 0x02, 0x80, 0x1f, 0x0c, 
      0x20, 0x78, 0xfb, 0xbf, 0x1f, 0x0a, 
      0x20, 0xb4, 0xfa, 0xbf, 0x1f, 0x0d, 
      0x20, 0x78, 0xfb, 0xaf, 0x1f, 0x0a, 
      0x40, 0xb4, 0x1a, 0xa0, 0x1f, 0x05, 
      0x80, 0x78, 0xfb, 0xbf, 0x9f, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7e, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x40, 0xfe, 0xff, 0x05, 0x00, 
      0x00, 0x20, 0xac, 0x2a, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xe8, 0x0f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x2e, 0xf4, 0x1f, 0xea, 0x00, 
      0x00, 0x27, 0xfc, 0x3f, 0xcc, 0x01, 
      0x00, 0xc7, 0xeb, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xf0, 0x0f, 0xd0, 0x03, 
      0x80, 0x0f, 0xe8, 0x0f, 0xe8, 0x03, 
      0x80, 0x5f, 0xf5, 0x5f, 0xf5, 0x03, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=448 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0x0c, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x03, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x05, 0x55, 0x55, 0x55, 0x01, 
      0x80, 0x82, 0xea, 0xab, 0xaa, 0x03, 
      0x80, 0x55, 0x35, 0x56, 0xd5, 0x03, 
      0x80, 0xaa, 0x1a, 0xad, 0xaa, 0x03, 
      0x80, 0x55, 0x15, 0x56, 0xd5, 0x03, 
      0x80, 0xaa, 0x5a, 0xad, 0xaa, 0x03, 
      0x80, 0x55, 0xb5, 0x56, 0xd5, 0x03, 
      0x80, 0xaa, 0xea, 0xab, 0xaa, 0x03, 
      0x80, 0x55, 0x55, 0x55, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0x03, 
      0x80, 0x55, 0x55, 0x55, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaa, 0xea, 0x03, 
      0x00, 0x55, 0x55, 0x55, 0xf5, 0x01, 
      0x00, 0xab, 0xaa, 0xaa, 0xfa, 0x01, 
      0x00, 0x5e, 0x55, 0x55, 0xfd, 0x00, 
      0x00, 0xbc, 0xaa, 0xaa, 0x7e, 0x00, 
      0x00, 0xf8, 0x55, 0xd5, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x04, 
      0x40, 0xc0, 0xfe, 0xff, 0x07, 0x04, 
      0x20, 0xe0, 0x03, 0x80, 0x07, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xff, 0xff, 0x0f, 0x0a, 
      0x20, 0xf4, 0x02, 0x80, 0x1f, 0x0c, 
      0x20, 0x78, 0xfb, 0xbf, 0x1f, 0x0a, 
      0x20, 0xb4, 0xfa, 0xbf, 0x1f, 0x0d, 
      0x20, 0x78, 0xfb, 0xaf, 0x1f, 0x0a, 
      0x40, 0xb4, 0x1a, 0xa0, 0x1f, 0x05, 
      0x80, 0x78, 0xfb, 0xbf, 0x9f, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7e, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x20, 0xfe, 0xff, 0x05, 0x00, 
      0x00, 0x20, 0xa8, 0x2a, 0x06, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x05, 0x00, 
      0x00, 0x30, 0x18, 0x08, 0x0a, 0x00, 
      0x00, 0x28, 0xf4, 0x0f, 0x0d, 0x00, 
      0x00, 0x24, 0xf8, 0x0f, 0x1a, 0x00, 
      0x00, 0xc4, 0xef, 0x1f, 0x7c, 0x00, 
      0x00, 0x06, 0xf0, 0x1f, 0xfa, 0x00, 
      0x00, 0x0f, 0xe8, 0x1f, 0xfc, 0x01, 
      0x00, 0x5f, 0xf5, 0x1f, 0xfa, 0x01, 
      0x80, 0xff, 0xff, 0x1f, 0xec, 0x03, 
      0x80, 0xff, 0xff, 0x3f, 0xda, 0x03, 
      0x80, 0xff, 0xff, 0xcf, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xd0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe8, 0x01, 
      0x00, 0xfe, 0xff, 0x5f, 0xf5, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=512 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0x0c, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x03, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x05, 0x55, 0x55, 0x55, 0x01, 
      0x80, 0x82, 0xaa, 0xaf, 0xaa, 0x03, 
      0x80, 0x55, 0xd5, 0x58, 0xd5, 0x03, 
      0x80, 0xaa, 0x6a, 0xb4, 0xaa, 0x03, 
      0x80, 0x55, 0x55, 0x58, 0xd5, 0x03, 
      0x80, 0xaa, 0x6a, 0xb5, 0xaa, 0x03, 
      0x80, 0x55, 0xd5, 0x5a, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaf, 0xaa, 0x03, 
      0x80, 0x55, 0x55, 0x55, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0x03, 
      0x80, 0x55, 0x55, 0x55, 0xd5, 0x03, 
      0x80, 0xaa, 0xaa, 0xaa, 0xea, 0x03, 
      0x00, 0x55, 0x55, 0x55, 0xf5, 0x01, 
      0x00, 0xab, 0xaa, 0xaa, 0xfa, 0x01, 
      0x00, 0x5e, 0x55, 0x55, 0xfd, 0x00, 
      0x00, 0xbc, 0xaa, 0xaa, 0x7e, 0x00, 
      0x00, 0xf8, 0x55, 0xd5, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x04, 
      0x40, 0xc0, 0xfe, 0xff, 0x07, 0x04, 
      0x20, 0xe0, 0x03, 0x80, 0x07, 0x0a, 
      0x20, 0xd0, 0x02, 0x80, 0x07, 0x0c, 
      0x20, 0x68, 0xff, 0xff, 0x0f, 0x0a, 
      0x20, 0xf4, 0x02, 0x80, 0x1f, 0x0c, 
      0x20, 0x78, 0xfb, 0xbf, 0x1f, 0x0a, 
      0x20, 0xb4, 0xfa, 0xbf, 0x1f, 0x0d, 
      0x20, 0x78, 0xfb, 0xaf, 0x1f, 0x0a, 
      0x40, 0xb4, 0x1a, 0xa0, 0x1f, 0x05, 
      0x80, 0x78, 0xfb, 0xbf, 0x9f, 0x02, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7e, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x05, 0x00, 
      0x00, 0x40, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x40, 0xfe, 0xff, 0x0d, 0x00, 
      0x00, 0x40, 0xa8, 0x2a, 0x0a, 0x00, 
      0x00, 0x40, 0xf4, 0x1f, 0x0c, 0x00, 
      0x00, 0x20, 0x28, 0x10, 0x1a, 0x00, 
      0x00, 0x20, 0xf4, 0x1f, 0x2c, 0x00, 
      0x00, 0x30, 0xe8, 0x3f, 0x5a, 0x00, 
      0x00, 0x3c, 0xf4, 0xcf, 0x67, 0x00, 
      0x00, 0x3e, 0xf8, 0x0f, 0xd0, 0x00, 
      0x00, 0x3f, 0xf4, 0x0f, 0xe8, 0x01, 
      0x00, 0x3f, 0xf8, 0x5f, 0xf5, 0x01, 
      0x80, 0x2f, 0xf4, 0xff, 0xff, 0x03, 
      0x80, 0x27, 0xf8, 0xff, 0xff, 0x03, 
      0x80, 0xc7, 0xef, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xf0, 0xff, 0xff, 0x01, 
      0x00, 0x0f, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x5e, 0xf5, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=192 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x5c, 0xd5, 0x01, 0x00, 
      0x7c, 0x80, 0xab, 0xaa, 0x0e, 0x00, 
      0xc6, 0x60, 0x55, 0x55, 0x35, 0x00, 
      0xa2, 0xb0, 0xaa, 0xaa, 0x6a, 0x00, 
      0xc2, 0x1b, 0x54, 0x55, 0xd5, 0x00, 
      0xaa, 0x0c, 0xaa, 0xaa, 0xaa, 0x01, 
      0xd6, 0x06, 0x54, 0x55, 0xff, 0x02, 
      0xfc, 0x0b, 0xaa, 0xaa, 0x20, 0x02, 
      0x00, 0x05, 0x55, 0x55, 0x20, 0x04, 
      0x00, 0xab, 0xaa, 0x6a, 0x58, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x58, 0x04, 
      0x00, 0xaa, 0xaa, 0x6a, 0x40, 0x02, 
      0x00, 0x56, 0x55, 0xd5, 0x20, 0x02, 
      0x00, 0xac, 0xaa, 0xaa, 0xff, 0x01, 
      0x00, 0x78, 0x55, 0x55, 0xfd, 0x00, 
      0x00, 0xf0, 0xab, 0xaa, 0x7e, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x1f, 0xf0, 0x01, 0x00, 
      0x00, 0x02, 0x15, 0x58, 0x03, 0x00, 
      0x00, 0xfe, 0x1b, 0xb4, 0x03, 0x00, 
      0x00, 0x02, 0x0e, 0x58, 0x07, 0x00, 
      0x00, 0xfa, 0x0a, 0xb4, 0x07, 0x00, 
      0x00, 0xfa, 0x0e, 0x5a, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xac, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0x5a, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xad, 0x07, 0x00, 
      0x00, 0xba, 0x16, 0xd6, 0x03, 0x00, 
      0x00, 0xba, 0x1a, 0xad, 0x07, 0x00, 
      0x00, 0xba, 0x16, 0xd6, 0x05, 0x00, 
      0x00, 0xba, 0x3e, 0xfd, 0x05, 0x00, 
      0x00, 0x9a, 0x3e, 0xfe, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0xf0, 0x07, 0x00, 
      0x00, 0xfc, 0x6b, 0xf0, 0x01, 0x00, 
      0x00, 0x00, 0xb5, 0xf8, 0x00, 0x00, 
      0x00, 0x00, 0x1e, 0xf7, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x78, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x18, 0x00, 0x00, 
      0x00, 0x80, 0x3f, 0xf4, 0x03, 0x00, 
      0x00, 0xf0, 0x3f, 0xfa, 0x1f, 0x00, 
      0x00, 0xfc, 0x2f, 0xcc, 0x7f, 0x00, 
      0x00, 0xfe, 0x27, 0x8a, 0xff, 0x00, 
      0x00, 0xff, 0x17, 0xad, 0xff, 0x01, 
      0x00, 0xff, 0x1f, 0xd6, 0xff, 0x01, 
      0x80, 0xff, 0x1f, 0xfd, 0xff, 0x03, 
      0x80, 0xff, 0xef, 0xc3, 0xff, 0x03, 
      0x80, 0xff, 0x07, 0x80, 0xff, 0x03, 
      0x00, 0xff, 0x07, 0xa0, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xd5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=256 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x5c, 0xd5, 0x01, 0x00, 
      0x00, 0x80, 0xab, 0xaa, 0x0e, 0x00, 
      0x7c, 0x60, 0x55, 0x55, 0x35, 0x00, 
      0xc6, 0xb0, 0xaa, 0xaa, 0x6a, 0x00, 
      0xa2, 0x1b, 0x54, 0x55, 0xd5, 0x00, 
      0xc2, 0x0c, 0xaa, 0xaa, 0xaa, 0x01, 
      0xaa, 0x06, 0x54, 0x55, 0xff, 0x02, 
      0xd6, 0x0b, 0xaa, 0xaa, 0x20, 0x02, 
      0x7c, 0x05, 0x55, 0x55, 0x20, 0x04, 
      0x00, 0xab, 0xaa, 0x6a, 0x58, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x58, 0x04, 
      0x00, 0xaa, 0xaa, 0x6a, 0x40, 0x02, 
      0x00, 0x56, 0x55, 0xd5, 0x20, 0x02, 
      0x00, 0xac, 0xaa, 0xaa, 0xff, 0x01, 
      0x00, 0x78, 0x55, 0x55, 0xfd, 0x00, 
      0x00, 0xf0, 0xab, 0xaa, 0x7e, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x1f, 0xf0, 0x01, 0x00, 
      0x00, 0x02, 0x15, 0x58, 0x03, 0x00, 
      0x00, 0xfe, 0x1b, 0xb4, 0x03, 0x00, 
      0x00, 0x02, 0x0e, 0x58, 0x07, 0x00, 
      0x00, 0xfa, 0x0a, 0xb4, 0x07, 0x00, 
      0x00, 0xfa, 0x0e, 0x5a, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xac, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0x5a, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xad, 0x07, 0x00, 
      0x00, 0xba, 0x16, 0xd6, 0x03, 0x00, 
      0x00, 0xba, 0x1a, 0xad, 0x07, 0x00, 
      0x00, 0xba, 0x16, 0xd6, 0x05, 0x00, 
      0x00, 0xba, 0x3e, 0xfd, 0x05, 0x00, 
      0x00, 0x9a, 0x3e, 0xfe, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0xf0, 0x07, 0x00, 
      0x00, 0xfc, 0x6b, 0xf0, 0x01, 0x00, 
      0x00, 0x00, 0xb5, 0xf8, 0x00, 0x00, 
      0x00, 0x00, 0x1e, 0xf7, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x68, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 
      0x00, 0x00, 0x14, 0x68, 0x00, 0x00, 
      0x00, 0x80, 0x23, 0xd0, 0x03, 0x00, 
      0x00, 0xf0, 0x63, 0xe0, 0x1f, 0x00, 
      0x00, 0xfc, 0xdc, 0xd0, 0x7f, 0x00, 
      0x00, 0x7e, 0x30, 0xe1, 0xff, 0x00, 
      0x00, 0x7f, 0x00, 0xd1, 0xff, 0x01, 
      0x00, 0xff, 0xaa, 0xe1, 0xff, 0x01, 
      0x80, 0xff, 0x5f, 0xd1, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0x3e, 0xfc, 0x03, 
      0x80, 0xff, 0x7f, 0x00, 0xf8, 0x03, 
      0x00, 0xff, 0x7f, 0x00, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0x55, 0xfd, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=320 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0x5c, 0xd5, 0x01, 0x00, 
      0x00, 0x80, 0xab, 0xaa, 0x0e, 0x00, 
      0x7c, 0x60, 0x55, 0x55, 0x35, 0x00, 
      0xc6, 0xb0, 0xaa, 0xaa, 0x6a, 0x00, 
      0xa2, 0x1b, 0x54, 0x55, 0xd5, 0x00, 
      0xc2, 0x0c, 0xaa, 0xaa, 0xaa, 0x01, 
      0xaa, 0x06, 0x54, 0x55, 0xff, 0x02, 
      0xd6, 0x0b, 0xaa, 0xaa, 0x20, 0x02, 
      0x7c, 0x05, 0x55, 0x55, 0x20, 0x04, 
      0x00, 0xab, 0xaa, 0x6a, 0x58, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x5c, 0x04, 
      0x00, 0xab, 0xaa, 0x2a, 0x5c, 0x04, 
      0x00, 0x55, 0x55, 0x35, 0x58, 0x04, 
      0x00, 0xaa, 0xaa, 0x6a, 0x40, 0x02, 
      0x00, 0x56, 0x55, 0xd5, 0x20, 0x02, 
      0x00, 0xac, 0xaa, 0xaa, 0xff, 0x01, 
      0x00, 0x78, 0x55, 0x55, 0xfd, 0x00, 
      0x00, 0xf0, 0xab, 0xaa, 0x7e, 0x00, 
      0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00, 
      0x00, 0x02, 0x1f, 0xf4, 0x01, 0x00, 
      0x00, 0x02, 0x15, 0x58, 0x03, 0x00, 
      0x00, 0xfe, 0x1b, 0xb4, 0x03, 0x00, 
      0x00, 0x02, 0x0e, 0x58, 0x07, 0x00, 
      0x00, 0xfa, 0x0a, 0xb4, 0x07, 0x00, 
      0x00, 0xfa, 0x0e, 0x5a, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xac, 0x07, 0x00, 
      0x00, 0xba, 0x0e, 0x5a, 0x07, 0x00, 
      0x00, 0xba, 0x0a, 0xad, 0x07, 0x00, 
      0x00, 0xba, 0x16, 0xd6, 0x03, 0x00, 
      0x00, 0xba, 0x1a, 0xad, 0x07, 0x00, 
      0x00, 0xba, 0x16, 0xd6, 0x05, 0x00, 
      0x00, 0xba, 0x3e, 0xfd, 0x05, 0x00, 
      0x00, 0x9a, 0x3e, 0xfe, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0xf0, 0x07, 0x00, 
      0x00, 0xfc, 0x6b, 0xf0, 0x01, 0x00, 
      0x00, 0x00, 0xb5, 0xf8, 0x00, 0x00, 
      0x00, 0x00, 0x1e, 0xf7, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x78, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x3a, 0x00, 0x00, 
      0x00, 0x80, 0x1f, 0xd4, 0x03, 0x00, 
      0x00, 0xf0, 0x1f, 0xea, 0x1f, 0x00, 
      0x00, 0xfc, 0x0f, 0x3d, 0x7c, 0x00, 
      0x00, 0xfe, 0x87, 0x02, 0xf8, 0x00, 
      0x00, 0xff, 0x43, 0x01, 0xfa, 0x01, 
      0x00, 0xff, 0xa3, 0x55, 0xfd, 0x01, 
      0x80, 0xff, 0xdc, 0xff, 0xff, 0x03, 
      0x80, 0x7f, 0x30, 0xfc, 0xff, 0x03, 
      0x80, 0x7f, 0x00, 0xf8, 0xff, 0x03, 
      0x00, 0xff, 0xaa, 0xfa, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xfd, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=384 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0x57, 0x75, 0x00, 0x00, 
      0x00, 0xe0, 0xaa, 0xaa, 0x03, 0x7c, 
      0x00, 0x58, 0x55, 0x55, 0x0d, 0xc6, 
      0x00, 0xac, 0xaa, 0xaa, 0x1a, 0xa2, 
      0x00, 0x06, 0x55, 0x55, 0xb5, 0xc3, 
      0x00, 0x83, 0xaa, 0xaa, 0x6a, 0xaa, 
      0x80, 0xfe, 0x55, 0x55, 0x55, 0xd6, 
      0x80, 0x08, 0xaa, 0xaa, 0xaa, 0x7f, 
      0x40, 0x08, 0x54, 0x55, 0xd5, 0x01, 
      0x40, 0x34, 0xac, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x34, 0x58, 0x55, 0xf5, 0x01, 
      0x80, 0x04, 0xac, 0xaa, 0xea, 0x00, 
      0x80, 0x08, 0x56, 0x55, 0xf5, 0x00, 
      0x00, 0xff, 0xab, 0xaa, 0x7a, 0x00, 
      0x00, 0x7e, 0x55, 0x55, 0x3f, 0x00, 
      0x00, 0xfc, 0xaa, 0xaa, 0x1f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x03, 0x00, 
      0x00, 0x00, 0x3e, 0xf8, 0x7f, 0x00, 
      0x00, 0x00, 0x1f, 0xf0, 0x81, 0x00, 
      0x00, 0x80, 0x1a, 0xf8, 0x81, 0x00, 
      0x00, 0x80, 0x15, 0xf0, 0xff, 0x00, 
      0x00, 0xc0, 0x1e, 0xe8, 0x80, 0x00, 
      0x00, 0x40, 0x17, 0xf0, 0xbe, 0x00, 
      0x00, 0xc0, 0x2b, 0xe8, 0xbe, 0x00, 
      0x00, 0x40, 0x37, 0xf0, 0xae, 0x00, 
      0x00, 0xc0, 0x2b, 0xe8, 0xae, 0x00, 
      0x00, 0x40, 0x55, 0xf4, 0xae, 0x00, 
      0x00, 0x80, 0x6a, 0xf8, 0xae, 0x00, 
      0x00, 0xc0, 0x55, 0xf4, 0xae, 0x00, 
      0x00, 0x40, 0x6b, 0xfa, 0xae, 0x00, 
      0x00, 0x40, 0x7f, 0xfc, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfa, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1f, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x15, 0xfd, 0x7f, 0x00, 
      0x00, 0x00, 0xba, 0xfa, 0x01, 0x00, 
      0x00, 0x00, 0xde, 0xf5, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x7a, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x10, 0x1a, 0x00, 0x00, 
      0x00, 0x80, 0x1f, 0xfc, 0x03, 0x00, 
      0x00, 0xf0, 0x3f, 0xfa, 0x1f, 0x00, 
      0x00, 0xfc, 0x27, 0xec, 0x7f, 0x00, 
      0x00, 0xfe, 0x23, 0xca, 0xff, 0x00, 
      0x00, 0xff, 0x63, 0xd4, 0xff, 0x01, 
      0x00, 0xff, 0x47, 0xf8, 0xff, 0x01, 
      0x80, 0xff, 0x7f, 0xf4, 0xff, 0x03, 
      0x80, 0xff, 0x87, 0xef, 0xff, 0x03, 
      0x80, 0xff, 0x03, 0xd0, 0xff, 0x03, 
      0x00, 0xff, 0x03, 0xe8, 0xff, 0x01, 
      0x00, 0xff, 0x57, 0xf5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=448 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0x57, 0x75, 0x00, 0x00, 
      0x00, 0xe0, 0xaa, 0xaa, 0x03, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x0d, 0x7c, 
      0x00, 0xac, 0xaa, 0xaa, 0x1a, 0xc6, 
      0x00, 0x06, 0x55, 0x55, 0xb5, 0xa3, 
      0x00, 0x83, 0xaa, 0xaa, 0x6a, 0xc2, 
      0x80, 0xfe, 0x55, 0x55, 0x55, 0xaa, 
      0x80, 0x08, 0xaa, 0xaa, 0xaa, 0xd7, 
      0x40, 0x08, 0x54, 0x55, 0xd5, 0x7d, 
      0x40, 0x34, 0xac, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x34, 0x58, 0x55, 0xf5, 0x01, 
      0x80, 0x04, 0xac, 0xaa, 0xea, 0x00, 
      0x80, 0x08, 0x56, 0x55, 0xf5, 0x00, 
      0x00, 0xff, 0xab, 0xaa, 0x7a, 0x00, 
      0x00, 0x7e, 0x55, 0x55, 0x3f, 0x00, 
      0x00, 0xfc, 0xaa, 0xaa, 0x1f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x03, 0x00, 
      0x00, 0x00, 0x3e, 0xf8, 0x7f, 0x00, 
      0x00, 0x00, 0x1f, 0xf0, 0x81, 0x00, 
      0x00, 0x80, 0x1a, 0xf8, 0x81, 0x00, 
      0x00, 0x80, 0x15, 0xf0, 0xff, 0x00, 
      0x00, 0xc0, 0x1e, 0xe8, 0x80, 0x00, 
      0x00, 0x40, 0x17, 0xf0, 0xbe, 0x00, 
      0x00, 0xc0, 0x2b, 0xe8, 0xbe, 0x00, 
      0x00, 0x40, 0x37, 0xf0, 0xae, 0x00, 
      0x00, 0xc0, 0x2b, 0xe8, 0xae, 0x00, 
      0x00, 0x40, 0x55, 0xf4, 0xae, 0x00, 
      0x00, 0x80, 0x6a, 0xf8, 0xae, 0x00, 
      0x00, 0xc0, 0x55, 0xf4, 0xae, 0x00, 
      0x00, 0x40, 0x6b, 0xfa, 0xae, 0x00, 
      0x00, 0x40, 0x7f, 0xfc, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfa, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1f, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x15, 0xfd, 0x7f, 0x00, 
      0x00, 0x00, 0xba, 0xfa, 0x01, 0x00, 
      0x00, 0x00, 0xde, 0xf5, 0x00, 0x00, 
      0x00, 0x00, 0x0c, 0x7a, 0x00, 0x00, 
      0x00, 0x00, 0x08, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x04, 0x5a, 0x00, 0x00, 
      0x00, 0x80, 0x07, 0x8d, 0x03, 0x00, 
      0x00, 0xf0, 0x87, 0x86, 0x1f, 0x00, 
      0x00, 0xfc, 0x47, 0x67, 0x7f, 0x00, 
      0x00, 0xfe, 0x87, 0x99, 0xfe, 0x00, 
      0x00, 0xff, 0x47, 0x41, 0xfd, 0x01, 
      0x00, 0xff, 0x87, 0xa9, 0xfe, 0x01, 
      0x80, 0xff, 0x47, 0xf5, 0xff, 0x03, 
      0x80, 0x7f, 0xf8, 0xfe, 0xff, 0x03, 
      0x80, 0x3f, 0x00, 0xfd, 0xff, 0x03, 
      0x00, 0x3f, 0x80, 0xfe, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=512 y=192 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0x57, 0x75, 0x00, 0x00, 
      0x00, 0xe0, 0xaa, 0xaa, 0x03, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x0d, 0x7c, 
      0x00, 0xac, 0xaa, 0xaa, 0x1a, 0xc6, 
      0x00, 0x06, 0x55, 0x55, 0xb5, 0xa3, 
      0x00, 0x83, 0xaa, 0xaa, 0x6a, 0xc2, 
      0x80, 0xfe, 0x55, 0x55, 0x55, 0xaa, 
      0x80, 0x08, 0xaa, 0xaa, 0xaa, 0xd7, 
      0x40, 0x08, 0x54, 0x55, 0xd5, 0x7d, 
      0x40, 0x34, 0xac, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x74, 0x58, 0x55, 0xd5, 0x01, 
      0x40, 0x74, 0xa8, 0xaa, 0xea, 0x01, 
      0x40, 0x34, 0x58, 0x55, 0xf5, 0x01, 
      0x80, 0x04, 0xac, 0xaa, 0xea, 0x00, 
      0x80, 0x08, 0x56, 0x55, 0xf5, 0x00, 
      0x00, 0xff, 0xab, 0xaa, 0x7a, 0x00, 
      0x00, 0x7e, 0x55, 0x55, 0x3f, 0x00, 
      0x00, 0xfc, 0xaa, 0xaa, 0x1f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0xff, 0xff, 0x03, 0x00, 
      0x00, 0x00, 0x3e, 0x78, 0x7f, 0x00, 
      0x00, 0x00, 0x1f, 0xf0, 0x81, 0x00, 
      0x00, 0x80, 0x1a, 0xf8, 0x81, 0x00, 
      0x00, 0x80, 0x15, 0xf0, 0xff, 0x00, 
      0x00, 0xc0, 0x1e, 0xe8, 0x80, 0x00, 
      0x00, 0x40, 0x17, 0xf0, 0xbe, 0x00, 
      0x00, 0xc0, 0x2b, 0xe8, 0xbe, 0x00, 
      0x00, 0x40, 0x37, 0xf0, 0xae, 0x00, 
      0x00, 0xc0, 0x2b, 0xe8, 0xae, 0x00, 
      0x00, 0x40, 0x55, 0xf4, 0xae, 0x00, 
      0x00, 0x80, 0x6a, 0xf8, 0xae, 0x00, 
      0x00, 0xc0, 0x55, 0xf4, 0xae, 0x00, 
      0x00, 0x40, 0x6b, 0xfa, 0xae, 0x00, 
      0x00, 0x40, 0x7f, 0xfc, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfa, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1f, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x15, 0xfd, 0x7f, 0x00, 
      0x00, 0x00, 0xba, 0xfa, 0x01, 0x00, 
      0x00, 0x00, 0xde, 0xf5, 0x00, 0x00, 
      0x00, 0x00, 0x1c, 0x7a, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x34, 0x00, 0x00, 
      0x00, 0x00, 0x18, 0x1a, 0x00, 0x00, 
      0x00, 0x80, 0x17, 0xf4, 0x03, 0x00, 
      0x00, 0xf0, 0x27, 0xf8, 0x1f, 0x00, 
      0x00, 0x7c, 0x78, 0xf4, 0x7f, 0x00, 
      0x00, 0x3e, 0x80, 0xe8, 0xff, 0x00, 
      0x00, 0x3f, 0x80, 0xd1, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xa3, 0xff, 0x01, 
      0x80, 0xff, 0xff, 0x67, 0xfe, 0x03, 
      0x80, 0xff, 0x7f, 0x18, 0xfe, 0x03, 
      0x80, 0xff, 0x3f, 0x00, 0xfd, 0x03, 
      0x00, 0xff, 0x3f, 0xa0, 0xfe, 0x01, 
      0x00, 0xff, 0x7f, 0xf5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    
    {
      /* Bitmap x=320 y=0 w=64 h=48 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x08, 0x00, 0x00, 
      0x00, 0x00, 0x70, 0x1b, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xfc, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xfc, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 
      0x00, 0x1e, 0x00, 0x00, 0xf0, 0x00, 
      0x00, 0x0f, 0x00, 0x00, 0xe0, 0x01, 
      0x00, 0x07, 0x00, 0x00, 0xc0, 0x01, 
      0x80, 0x07, 0x00, 0x00, 0xc0, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x3c, 0x78, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1f, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x3e, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 
      
      0x00, 0x78, 0x00, 0x00, 0x3c, 0x00, 
      0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 
      0x00, 0xfe, 0xa9, 0x2a, 0xff, 0x00, 
      0x80, 0xa7, 0xa9, 0x2a, 0xcb, 0x03, 
      0xc0, 0xa7, 0x03, 0x80, 0xcb, 0x07, 
      0xc0, 0xc7, 0xfe, 0xff, 0xc6, 0x07, 
      0xe0, 0xc3, 0xe1, 0x1f, 0x87, 0x0f, 
      0xe0, 0x79, 0x83, 0x82, 0x3d, 0x0f, 
      0xe0, 0x7c, 0xfe, 0xfe, 0x7c, 0x0e, 
      0x20, 0xfc, 0x80, 0x02, 0x7e, 0x08, 
      0x20, 0xfe, 0xf1, 0x1e, 0xff, 0x08, 
      0x60, 0x7f, 0xff, 0xfe, 0xfd, 0x0d, 
      0xe0, 0xfc, 0x80, 0x02, 0x7e, 0x0e, 
      0x40, 0xfe, 0xf1, 0x1f, 0xff, 0x04, 
      0xc0, 0xfc, 0x7f, 0xfc, 0x7f, 0x06, 
      0x80, 0xf9, 0xff, 0xfe, 0x3f, 0x03, 
      0x00, 0x93, 0x7f, 0xfc, 0x93, 0x01, 
      0x00, 0xff, 0xff, 0xfe, 0xff, 0x01, 
      0x00, 0xd7, 0x73, 0x9c, 0xd7, 0x01, 
      0x00, 0xd6, 0x03, 0x80, 0xd7, 0x00, 
      0x00, 0xfc, 0xf7, 0xdf, 0x7f, 0x00, 
      0x00, 0xc0, 0xf9, 0x3f, 0x07, 0x00, 
      0x00, 0xc0, 0xf3, 0x9f, 0x07, 0x00, 
      0x00, 0xe0, 0xf9, 0x3f, 0x0f, 0x00, 
      0x00, 0xe0, 0xf8, 0x3f, 0x0e, 0x00, 
      0x00, 0xe0, 0x39, 0x38, 0x0f, 0x00, 
      0x00, 0xe0, 0xfd, 0x7f, 0x0f, 0x00, 
      0x00, 0xf0, 0xfa, 0xbf, 0x1e, 0x00, 
      0x00, 0xfc, 0xfd, 0x7f, 0x7f, 0x00, 
      0x00, 0xfe, 0xfd, 0x7f, 0xff, 0x00, 
      0x00, 0xff, 0xf9, 0x3f, 0xff, 0x01, 
      0x00, 0xff, 0xf3, 0x9f, 0xff, 0x01, 
      0x80, 0x7f, 0xfe, 0xff, 0xfc, 0x03, 
      0x80, 0x9f, 0xfa, 0xbf, 0xf2, 0x03, 
      0x80, 0x6f, 0xfd, 0x7f, 0xed, 0x03, 
      0x00, 0xbf, 0xfe, 0xff, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    {
      /* Bitmap x=512 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 
      0x00, 0x00, 0xf0, 0x9f, 0x31, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x28, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x37, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0x0c, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x03, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x05, 0x55, 0x55, 0x55, 0x01, 
      0x80, 0x82, 0xfe, 0xff, 0xaa, 0x01, 
      0x80, 0xd5, 0x01, 0x00, 0x77, 0x01, 
      0x80, 0x3a, 0x00, 0x00, 0xf8, 0x00, 
      0x80, 0x0d, 0x00, 0x00, 0x20, 0x00, 
      0x80, 0x0a, 0x00, 0x00, 0x50, 0x00, 
      0x80, 0x0d, 0x00, 0x00, 0x60, 0x00, 
      0x80, 0x0a, 0x42, 0x84, 0x50, 0x00, 
      0x80, 0x0d, 0x66, 0xcc, 0x60, 0x00, 
      0x80, 0x0a, 0x3c, 0x78, 0x50, 0x00, 
      0x80, 0x0d, 0x18, 0x30, 0x60, 0x00, 
      0x80, 0x0a, 0x3c, 0x78, 0x70, 0x00, 
      0x00, 0x0d, 0x66, 0xcc, 0xe0, 0x00, 
      0x00, 0x1b, 0x42, 0x84, 0xf0, 0x00, 
      0x00, 0x36, 0x00, 0x00, 0xf8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x7e, 0x00, 
      0x00, 0xd8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0xf8, 0xff, 0xff, 0x3f, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x06, 
      0x40, 0xf0, 0xab, 0x8a, 0x07, 0x05, 
      0x20, 0x68, 0x5e, 0x41, 0x07, 0x0a, 
      0x20, 0x34, 0xb8, 0x3c, 0x0f, 0x0c, 
      0x20, 0x6c, 0x60, 0x3a, 0x1f, 0x0a, 
      0x20, 0x3a, 0xc0, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0x80, 0x3f, 0x1f, 0x0a, 
      0x20, 0x3a, 0x00, 0x9f, 0x1f, 0x0c, 
      0x20, 0xf4, 0x01, 0x47, 0x1f, 0x0a, 
      0x40, 0xe8, 0xce, 0xab, 0x0f, 0x04, 
      0x40, 0x7c, 0x7d, 0xd5, 0x7f, 0x06, 
      0x80, 0xc3, 0xab, 0xaa, 0x87, 0x03, 
      0x00, 0xc1, 0x57, 0xf7, 0x07, 0x01, 
      0x00, 0xc1, 0xaf, 0xf9, 0x83, 0x01, 
      0x00, 0xa1, 0x57, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0x6e, 0xf8, 0xa7, 0x00, 
      0x00, 0x7c, 0x57, 0xf8, 0x7f, 0x00, 
      0x00, 0x40, 0x6c, 0x7e, 0x05, 0x00, 
      0x00, 0x40, 0xdc, 0x3d, 0x06, 0x00, 
      0x00, 0x20, 0xf0, 0x1f, 0x05, 0x00, 
      0x00, 0x20, 0xe8, 0x4f, 0x06, 0x00, 
      0x00, 0x20, 0x34, 0x48, 0x07, 0x00, 
      0x00, 0x20, 0xf8, 0xbf, 0x02, 0x00, 
      0x00, 0x30, 0xf4, 0xbf, 0x1d, 0x00, 
      0x00, 0x3c, 0xf8, 0x3f, 0x7e, 0x00, 
      0x00, 0x3e, 0xf4, 0x3f, 0xfc, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfe, 0x01, 
      0x00, 0xcf, 0xf3, 0x1f, 0xf4, 0x01, 
      0x80, 0x07, 0xe8, 0x1f, 0xe8, 0x03, 
      0x80, 0x07, 0xf4, 0x1f, 0xfc, 0x03, 
      0x80, 0x07, 0xea, 0x3f, 0xea, 0x03, 
      0x00, 0x0f, 0xfd, 0x7f, 0xf6, 0x01, 
      0x00, 0xaf, 0xfe, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=256 y=192 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0a, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0xc0, 0x55, 0x55, 0x07, 0x00, 
      0x00, 0xb0, 0xaa, 0xaa, 0x1a, 0x00, 
      0x00, 0x58, 0x55, 0x55, 0x35, 0x00, 
      0x00, 0xac, 0xaa, 0xaa, 0x6a, 0x00, 
      0x00, 0x06, 0x55, 0x55, 0xd5, 0x00, 
      0x00, 0x83, 0xaa, 0xaa, 0xaa, 0x01, 
      0x00, 0x01, 0x55, 0x55, 0x55, 0x01, 
      0x80, 0x82, 0xaa, 0xaa, 0xaa, 0x02, 
      0x80, 0x41, 0x55, 0x55, 0x55, 0x03, 
      0x80, 0xaa, 0xff, 0xff, 0xab, 0x02, 
      0x80, 0x75, 0x00, 0x00, 0x5c, 0x03, 
      0x80, 0x0a, 0x00, 0x00, 0xa0, 0x02, 
      0x80, 0x0d, 0x00, 0x00, 0x60, 0x03, 
      0x80, 0x0a, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x0d, 0x7e, 0xfc, 0x60, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x0d, 0x7e, 0xfc, 0x60, 0x03, 
      0x80, 0x0a, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x0d, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x0b, 0x7e, 0xfc, 0xa0, 0x01, 
      0x00, 0x16, 0x7e, 0xfc, 0xd0, 0x00, 
      0x00, 0x2c, 0x7e, 0xfc, 0x68, 0x00, 
      0x00, 0x58, 0x3c, 0x78, 0x34, 0x00, 
      0x00, 0xb8, 0x01, 0x00, 0x3b, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xc1, 0xff, 0xff, 0x07, 0x03, 
      0x40, 0xc0, 0xff, 0xff, 0x07, 0x06, 
      0x40, 0xe0, 0xaa, 0x8a, 0x06, 0x05, 
      0x20, 0xd0, 0x55, 0x41, 0x07, 0x0a, 
      0x20, 0xe8, 0xaa, 0x3c, 0x0f, 0x0c, 
      0x20, 0x74, 0x55, 0x3a, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0xbe, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x3e, 0x1f, 0x0a, 
      0x20, 0xfa, 0xaa, 0x9c, 0x1f, 0x0c, 
      0x20, 0x74, 0x55, 0x41, 0x1f, 0x0a, 
      0x40, 0xe8, 0xaa, 0xaa, 0x0f, 0x04, 
      0x40, 0x7c, 0xf5, 0xdf, 0x7f, 0x06, 
      0x80, 0xc3, 0x3f, 0xf8, 0x87, 0x03, 
      0x00, 0xe1, 0x3f, 0xf8, 0x07, 0x01, 
      0x00, 0xc1, 0x3f, 0xf8, 0x83, 0x01, 
      0x00, 0xa1, 0x3f, 0xf8, 0x43, 0x01, 
      0x00, 0xd2, 0xea, 0xef, 0xa7, 0x00, 
      0x00, 0xfc, 0x57, 0xf5, 0x7f, 0x00, 
      0x00, 0x40, 0xaf, 0xfa, 0x06, 0x00, 
      0x00, 0x40, 0x5c, 0x7d, 0x05, 0x00, 
      0x00, 0x20, 0xf8, 0x3f, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0d, 0x00, 
      0x00, 0x20, 0x34, 0x08, 0x0a, 0x00, 
      0x00, 0x20, 0xf8, 0x1f, 0x0c, 0x00, 
      0x00, 0x30, 0xf4, 0x1f, 0x1a, 0x00, 
      0x00, 0x3c, 0xf8, 0x1f, 0x7c, 0x00, 
      0x00, 0x3e, 0xf4, 0x1f, 0xfa, 0x00, 
      0x00, 0x3f, 0xfc, 0x3f, 0xfc, 0x01, 
      0x00, 0xcf, 0xf3, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
  },
  
  /* player 4 */
  {


    
    {
      /* Bitmap x=192 y=96 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0d, 0x00, 0x00, 
      0x00, 0x00, 0xa0, 0x0e, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0x40, 0x50, 0x15, 0x07, 0x00, 
      0x00, 0x50, 0xa9, 0x2a, 0x18, 0x00, 
      0x00, 0x00, 0x50, 0x15, 0x20, 0x00, 
      0x00, 0x18, 0xab, 0x2a, 0x40, 0x00, 
      0x00, 0x02, 0x50, 0x15, 0x80, 0x00, 
      0x00, 0x51, 0xa9, 0x2a, 0x80, 0x01, 
      0x00, 0x41, 0x50, 0x15, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x80, 0x02, 
      0x80, 0xc0, 0x01, 0x00, 0x07, 0x03, 
      0x80, 0x30, 0x00, 0x00, 0x98, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x11, 0x7e, 0xfc, 0xb0, 0x01, 
      0x00, 0x22, 0x3c, 0x78, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x07, 
      0xc0, 0xea, 0x00, 0x00, 0xaf, 0x07, 
      0x60, 0xf5, 0x00, 0x40, 0x56, 0x0f, 
      0xa0, 0xfa, 0x00, 0x3c, 0xaf, 0x0e, 
      0x60, 0x7d, 0x00, 0x3a, 0x5e, 0x0f, 
      0xa0, 0x7e, 0x00, 0x3e, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x3e, 0x5a, 0x0f, 
      0xa0, 0x7e, 0x00, 0x1c, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x00, 0x5a, 0x0f, 
      0xc0, 0x7a, 0x00, 0x00, 0xad, 0x06, 
      0x40, 0x3d, 0xe0, 0x8f, 0x7a, 0x07, 
      0x80, 0xc3, 0xbf, 0xfa, 0x87, 0x03, 
      0x00, 0xe1, 0x7f, 0xfd, 0x07, 0x01, 
      0x00, 0xc1, 0xbf, 0xfa, 0x83, 0x01, 
      0x00, 0xa1, 0x7f, 0xfd, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0xc0, 0x07, 0xd0, 0x07, 0x00, 
      0x00, 0x40, 0x0d, 0x68, 0x07, 0x00, 
      0x00, 0xa0, 0x5a, 0xb5, 0x0f, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xa0, 0x3e, 0xa8, 0x0e, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xb0, 0xfe, 0xbf, 0x1e, 0x00, 
      0x00, 0x7c, 0xfd, 0x5f, 0x7f, 0x00, 
      0x00, 0xbe, 0xfe, 0xbf, 0xfe, 0x00, 
      0x00, 0x7f, 0xfd, 0x7f, 0xff, 0x01, 
      0x00, 0xcf, 0xf3, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=256 y=96 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 
      0x00, 0x00, 0xb0, 0x06, 0x00, 0x00, 
      0x00, 0x00, 0x50, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0x40, 0x50, 0x15, 0x07, 0x00, 
      0x00, 0x50, 0xa9, 0x2a, 0x18, 0x00, 
      0x00, 0x00, 0x50, 0x15, 0x20, 0x00, 
      0x00, 0x18, 0xab, 0x2a, 0x40, 0x00, 
      0x00, 0x02, 0x50, 0x15, 0x80, 0x00, 
      0x00, 0x51, 0xa9, 0x2a, 0x80, 0x01, 
      0x00, 0x41, 0x50, 0x15, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x80, 0x02, 
      0x80, 0xc0, 0x01, 0x00, 0x07, 0x03, 
      0x80, 0x30, 0x00, 0x00, 0x98, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x11, 0x7e, 0xfc, 0xb0, 0x01, 
      0x00, 0x22, 0x3c, 0x78, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x07, 
      0xc0, 0xea, 0x00, 0x00, 0xaf, 0x07, 
      0x60, 0xf5, 0x00, 0x40, 0x56, 0x0f, 
      0xa0, 0xfa, 0x00, 0x3c, 0xaf, 0x0e, 
      0x60, 0x7d, 0x00, 0x3a, 0x5e, 0x0f, 
      0xa0, 0x7e, 0x00, 0x3e, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x3e, 0x5a, 0x0f, 
      0xa0, 0x7e, 0x00, 0x1c, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x00, 0x5a, 0x0f, 
      0xc0, 0x7a, 0x00, 0x00, 0xad, 0x06, 
      0x40, 0x3d, 0xe0, 0x8f, 0x7a, 0x07, 
      0x80, 0xc3, 0xbf, 0xfa, 0x87, 0x03, 
      0x00, 0xe1, 0x7f, 0xfd, 0x07, 0x01, 
      0x00, 0xc1, 0xbf, 0xfa, 0x83, 0x01, 
      0x00, 0xa1, 0x7f, 0xfd, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0xc0, 0x07, 0xd0, 0x07, 0x00, 
      0x00, 0x40, 0x0d, 0x68, 0x0f, 0x00, 
      0x00, 0xc0, 0x5a, 0xb5, 0x0e, 0x00, 
      0x00, 0x40, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xa0, 0x3e, 0xb0, 0x0e, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xb0, 0xfe, 0xbf, 0x1e, 0x00, 
      0x00, 0x7c, 0xfd, 0xcf, 0x67, 0x00, 
      0x00, 0xbe, 0xfe, 0x0f, 0xc0, 0x00, 
      0x00, 0x7f, 0xfd, 0x0f, 0xe0, 0x01, 
      0x00, 0xbf, 0xfe, 0x1f, 0xd0, 0x01, 
      0x80, 0x7f, 0xfd, 0x3f, 0xe8, 0x03, 
      0x80, 0xbf, 0xfe, 0x7f, 0xf5, 0x03, 
      0x80, 0xcf, 0xf3, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x07, 0xf4, 0xff, 0xff, 0x01, 
      0x00, 0x06, 0xea, 0xff, 0xff, 0x00, 
      0x00, 0x0c, 0xfd, 0xff, 0x7f, 0x00, 
      0x00, 0xa8, 0xfe, 0xff, 0x1f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=320 y=96 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xc0, 0x1a, 0x00, 0x00, 
      0x00, 0x00, 0x40, 0x1d, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0x40, 0x50, 0x15, 0x07, 0x00, 
      0x00, 0x50, 0xa9, 0x2a, 0x18, 0x00, 
      0x00, 0x00, 0x50, 0x15, 0x20, 0x00, 
      0x00, 0x18, 0xab, 0x2a, 0x40, 0x00, 
      0x00, 0x02, 0x50, 0x15, 0x80, 0x00, 
      0x00, 0x51, 0xa9, 0x2a, 0x80, 0x01, 
      0x00, 0x41, 0x50, 0x15, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x80, 0x02, 
      0x80, 0xc0, 0x01, 0x00, 0x07, 0x03, 
      0x80, 0x30, 0x00, 0x00, 0x98, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x11, 0x7e, 0xfc, 0xb0, 0x01, 
      0x00, 0x22, 0x3c, 0x78, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x07, 
      0xc0, 0xea, 0x00, 0x00, 0xaf, 0x07, 
      0x60, 0xf5, 0x00, 0x40, 0x56, 0x0f, 
      0xa0, 0xfa, 0x00, 0x3c, 0xaf, 0x0e, 
      0x60, 0x7d, 0x00, 0x3a, 0x5e, 0x0f, 
      0xa0, 0x7e, 0x00, 0x3e, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x3e, 0x5a, 0x0f, 
      0xa0, 0x7e, 0x00, 0x1c, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x00, 0x5a, 0x0f, 
      0xc0, 0x7a, 0x00, 0x00, 0xad, 0x06, 
      0x40, 0x3d, 0xe0, 0x8f, 0x7a, 0x07, 
      0x80, 0xc3, 0xbf, 0xfa, 0x87, 0x03, 
      0x00, 0xe1, 0x7f, 0xfd, 0x07, 0x01, 
      0x00, 0xc1, 0xbf, 0xfa, 0x83, 0x01, 
      0x00, 0xa1, 0x7f, 0xfd, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0xc0, 0x07, 0xd0, 0x07, 0x00, 
      0x00, 0x60, 0x0d, 0xe8, 0x07, 0x00, 
      0x00, 0xa0, 0x5e, 0xb5, 0x07, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x07, 0x00, 
      0x00, 0xa0, 0x1e, 0xa8, 0x0e, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xb0, 0xfe, 0xbf, 0x1e, 0x00, 
      0x00, 0xcc, 0xf7, 0x5f, 0x7f, 0x00, 
      0x00, 0x06, 0xe8, 0xbf, 0xfe, 0x00, 
      0x00, 0x07, 0xf4, 0x5f, 0xff, 0x01, 
      0x00, 0x07, 0xea, 0xbf, 0xfe, 0x01, 
      0x80, 0x0f, 0xfd, 0x5f, 0xff, 0x03, 
      0x80, 0xaf, 0xfe, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0x8f, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xc0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe0, 0x01, 
      0x00, 0xfe, 0xff, 0x0f, 0xd0, 0x00, 
      0x00, 0xfc, 0xff, 0x3f, 0x68, 0x00, 
      0x00, 0xf0, 0xff, 0x7f, 0x35, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x1f, 0x00}, 
    
    
    {
      /* Bitmap x=384 y=96 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0x40, 0x50, 0x15, 0x07, 0x00, 
      0x00, 0x50, 0xa9, 0x2a, 0x18, 0x00, 
      0x00, 0x00, 0x50, 0x15, 0x20, 0x00, 
      0x00, 0x18, 0xab, 0x2a, 0x40, 0x00, 
      0x00, 0x02, 0x50, 0x15, 0x80, 0x00, 
      0x00, 0x51, 0xa9, 0x2a, 0x00, 0x01, 
      0x00, 0x41, 0xd0, 0x17, 0x00, 0x01, 
      0x80, 0x00, 0x68, 0x2d, 0x80, 0x02, 
      0x80, 0x00, 0xb0, 0x1e, 0x00, 0x03, 
      0x80, 0x00, 0x68, 0x2f, 0x80, 0x02, 
      0x80, 0x00, 0xb0, 0x1f, 0x00, 0x03, 
      0x80, 0x00, 0xe8, 0x2f, 0x80, 0x02, 
      0x80, 0x00, 0xd0, 0x17, 0x00, 0x03, 
      0x80, 0x00, 0xa8, 0x2a, 0x80, 0x02, 
      0x80, 0x00, 0x50, 0x15, 0x00, 0x03, 
      0x80, 0x00, 0xa8, 0x2a, 0x80, 0x02, 
      0x80, 0x00, 0x50, 0x15, 0x40, 0x03, 
      0x80, 0x00, 0xa8, 0x2a, 0x80, 0x02, 
      0x00, 0x01, 0x50, 0x15, 0x40, 0x01, 
      0x00, 0x01, 0xa8, 0x2a, 0xa0, 0x01, 
      0x00, 0x02, 0x50, 0x15, 0xd0, 0x00, 
      0x00, 0x0c, 0xa8, 0x2a, 0x68, 0x00, 
      0x00, 0x58, 0x50, 0x15, 0x35, 0x00, 
      0x00, 0xb8, 0xfa, 0xbf, 0x3a, 0x00, 
      0x00, 0xf6, 0xfd, 0x7f, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x05, 
      0xc0, 0xea, 0xfc, 0x7f, 0xaf, 0x06, 
      0x60, 0xf5, 0x02, 0x80, 0x56, 0x0f, 
      0xa0, 0xfa, 0x02, 0x80, 0xaf, 0x0e, 
      0x60, 0x7d, 0xfe, 0xff, 0x5e, 0x0f, 
      0xa0, 0x7e, 0x02, 0x80, 0xbd, 0x0e, 
      0x60, 0x3d, 0xfa, 0xbf, 0x5a, 0x0f, 
      0xa0, 0x3e, 0xfa, 0xbf, 0xbd, 0x0f, 
      0x60, 0x3d, 0xfa, 0xaf, 0x5a, 0x0f, 
      0xc0, 0x3e, 0x1a, 0xa0, 0xbd, 0x07, 
      0x80, 0x3d, 0xfa, 0xbf, 0xda, 0x03, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x07, 0x00, 
      0x00, 0xc0, 0x02, 0x80, 0x07, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xa0, 0x0e, 0xa0, 0x0f, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xa0, 0x3e, 0xa8, 0x0e, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xb0, 0xfe, 0xbf, 0x1e, 0x00, 
      0x00, 0x7c, 0xfd, 0x5f, 0x7f, 0x00, 
      0x00, 0xae, 0xfe, 0xbf, 0xee, 0x00, 
      0x00, 0x67, 0xfd, 0x7f, 0xcf, 0x01, 
      0x00, 0xc7, 0xeb, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xf0, 0x0f, 0xd0, 0x03, 
      0x80, 0x0f, 0xe8, 0x0f, 0xe8, 0x03, 
      0x80, 0x5f, 0xf5, 0x5f, 0xf5, 0x03, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=448 y=96 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0x40, 0x50, 0x15, 0x07, 0x00, 
      0x00, 0x50, 0xa9, 0x2a, 0x18, 0x00, 
      0x00, 0x00, 0x50, 0x15, 0x20, 0x00, 
      0x00, 0x18, 0xab, 0x2a, 0x40, 0x00, 
      0x00, 0x02, 0x50, 0x15, 0x80, 0x00, 
      0x00, 0x51, 0xa9, 0x2a, 0x00, 0x01, 
      0x00, 0x41, 0x50, 0x15, 0x00, 0x01, 
      0x80, 0x00, 0xe8, 0x2b, 0x80, 0x02, 
      0x80, 0x00, 0xb0, 0x16, 0x00, 0x03, 
      0x80, 0x00, 0x58, 0x2f, 0x80, 0x02, 
      0x80, 0x00, 0xb0, 0x17, 0x00, 0x03, 
      0x80, 0x00, 0xd8, 0x2f, 0x80, 0x02, 
      0x80, 0x00, 0xf0, 0x17, 0x00, 0x03, 
      0x80, 0x00, 0xe8, 0x2b, 0x80, 0x02, 
      0x80, 0x00, 0x50, 0x15, 0x00, 0x03, 
      0x80, 0x00, 0xa8, 0x2a, 0x80, 0x02, 
      0x80, 0x00, 0x50, 0x15, 0x40, 0x03, 
      0x80, 0x00, 0xa8, 0x2a, 0x80, 0x02, 
      0x00, 0x01, 0x50, 0x15, 0x40, 0x01, 
      0x00, 0x01, 0xa8, 0x2a, 0xa0, 0x01, 
      0x00, 0x02, 0x50, 0x15, 0xd0, 0x00, 
      0x00, 0x0c, 0xa8, 0x2a, 0x68, 0x00, 
      0x00, 0x58, 0x50, 0x15, 0x35, 0x00, 
      0x00, 0xb8, 0xfa, 0xbf, 0x3a, 0x00, 
      0x00, 0xf6, 0xfd, 0x7f, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x05, 
      0xc0, 0xea, 0xfc, 0x7f, 0xaf, 0x06, 
      0x60, 0xf5, 0x02, 0x80, 0x56, 0x0f, 
      0xa0, 0xfa, 0x02, 0x80, 0xaf, 0x0e, 
      0x60, 0x7d, 0xfe, 0xff, 0x5e, 0x0f, 
      0xa0, 0x7e, 0x02, 0x80, 0xbd, 0x0e, 
      0x60, 0x3d, 0xfa, 0xbf, 0x5a, 0x0f, 
      0xa0, 0x3e, 0xfa, 0xbf, 0xbd, 0x0f, 
      0x60, 0x3d, 0xfa, 0xaf, 0x5a, 0x0f, 
      0xc0, 0x3e, 0x1a, 0xa0, 0xbd, 0x07, 
      0x80, 0x3d, 0xfa, 0xbf, 0xda, 0x03, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7f, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x07, 0x00, 
      0x00, 0xc0, 0x02, 0x80, 0x07, 0x00, 
      0x00, 0x60, 0xff, 0xff, 0x07, 0x00, 
      0x00, 0xa0, 0x0e, 0xa0, 0x07, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x07, 0x00, 
      0x00, 0xb0, 0x1e, 0xa8, 0x0f, 0x00, 
      0x00, 0x68, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xa4, 0xfe, 0xaf, 0x1e, 0x00, 
      0x00, 0xc4, 0xef, 0x5f, 0x7f, 0x00, 
      0x00, 0x06, 0xf0, 0xbf, 0xfe, 0x00, 
      0x00, 0x0f, 0xe8, 0x5f, 0xff, 0x01, 
      0x00, 0x5f, 0xf5, 0xbf, 0xfe, 0x01, 
      0x80, 0xff, 0xff, 0x5f, 0xef, 0x03, 
      0x80, 0xff, 0xff, 0xbf, 0xde, 0x03, 
      0x80, 0xff, 0xff, 0xcf, 0xe7, 0x03, 
      0x00, 0xff, 0xff, 0x0f, 0xd0, 0x01, 
      0x00, 0xff, 0xff, 0x0f, 0xe8, 0x01, 
      0x00, 0xfe, 0xff, 0x5f, 0xf5, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=512 y=96 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0x40, 0x50, 0x15, 0x07, 0x00, 
      0x00, 0x50, 0xa9, 0x2a, 0x18, 0x00, 
      0x00, 0x00, 0x50, 0x15, 0x20, 0x00, 
      0x00, 0x18, 0xab, 0x2a, 0x40, 0x00, 
      0x00, 0x02, 0x50, 0x15, 0x80, 0x00, 
      0x00, 0x51, 0xa9, 0x2a, 0x00, 0x01, 
      0x00, 0x41, 0x50, 0x15, 0x00, 0x01, 
      0x80, 0x00, 0xa8, 0x2f, 0x80, 0x02, 
      0x80, 0x00, 0xd0, 0x1a, 0x00, 0x03, 
      0x80, 0x00, 0x68, 0x3d, 0x80, 0x02, 
      0x80, 0x00, 0xd0, 0x1e, 0x00, 0x03, 
      0x80, 0x00, 0x68, 0x3f, 0x80, 0x02, 
      0x80, 0x00, 0xd0, 0x1f, 0x00, 0x03, 
      0x80, 0x00, 0xa8, 0x2f, 0x80, 0x02, 
      0x80, 0x00, 0x50, 0x15, 0x00, 0x03, 
      0x80, 0x00, 0xa8, 0x2a, 0x80, 0x02, 
      0x80, 0x00, 0x50, 0x15, 0x40, 0x03, 
      0x80, 0x00, 0xa8, 0x2a, 0x80, 0x02, 
      0x00, 0x01, 0x50, 0x15, 0x40, 0x01, 
      0x00, 0x01, 0xa8, 0x2a, 0xa0, 0x01, 
      0x00, 0x02, 0x50, 0x15, 0xd0, 0x00, 
      0x00, 0x0c, 0xa8, 0x2a, 0x68, 0x00, 
      0x00, 0x58, 0x50, 0x15, 0x35, 0x00, 
      0x00, 0xb8, 0xfa, 0xbf, 0x3a, 0x00, 
      0x00, 0xf6, 0xfd, 0x7f, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x05, 
      0xc0, 0xea, 0xfc, 0x7f, 0xaf, 0x06, 
      0x60, 0xf5, 0x02, 0x80, 0x56, 0x0f, 
      0xa0, 0xfa, 0x02, 0x80, 0xaf, 0x0e, 
      0x60, 0x7d, 0xfe, 0xff, 0x5e, 0x0f, 
      0xa0, 0x7e, 0x02, 0x80, 0xbd, 0x0e, 
      0x60, 0x3d, 0xfa, 0xbf, 0x5a, 0x0f, 
      0xa0, 0x3e, 0xfa, 0xbf, 0xbd, 0x0f, 
      0x60, 0x3d, 0xfa, 0xaf, 0x5a, 0x0f, 
      0xc0, 0x3e, 0x1a, 0xa0, 0xbd, 0x07, 
      0x80, 0x3d, 0xfa, 0xbf, 0xda, 0x03, 
      0x80, 0xef, 0x03, 0x80, 0xe7, 0x03, 
      0x00, 0xd1, 0xfb, 0xbf, 0x8f, 0x01, 
      0x00, 0xe9, 0xfb, 0xbf, 0x57, 0x01, 
      0x00, 0xd6, 0xfb, 0xaf, 0xaf, 0x00, 
      0x00, 0xfc, 0x1a, 0xa0, 0x7e, 0x00, 
      0x00, 0x40, 0xfb, 0xbf, 0x07, 0x00, 
      0x00, 0xc0, 0x02, 0x80, 0x06, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0x0f, 0x00, 
      0x00, 0xc0, 0x0a, 0xa0, 0x0e, 0x00, 
      0x00, 0x40, 0xfd, 0x7f, 0x0f, 0x00, 
      0x00, 0xa0, 0x3a, 0xb0, 0x1e, 0x00, 
      0x00, 0x60, 0xfd, 0x7f, 0x2f, 0x00, 
      0x00, 0xb0, 0xfe, 0xff, 0x5e, 0x00, 
      0x00, 0x7c, 0xfd, 0xcf, 0x67, 0x00, 
      0x00, 0xbe, 0xfe, 0x0f, 0xd0, 0x00, 
      0x00, 0x7f, 0xfd, 0x0f, 0xe8, 0x01, 
      0x00, 0xbf, 0xfe, 0x5f, 0xf5, 0x01, 
      0x80, 0x6f, 0xfd, 0xff, 0xff, 0x03, 
      0x80, 0xa7, 0xfe, 0xff, 0xff, 0x03, 
      0x80, 0xc7, 0xef, 0xff, 0xff, 0x03, 
      0x00, 0x07, 0xf0, 0xff, 0xff, 0x01, 
      0x00, 0x0f, 0xe8, 0xff, 0xff, 0x01, 
      0x00, 0x5e, 0xf5, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    
    
    {
      /* Bitmap x=192 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0xbc, 0xea, 0x01, 0x00, 
      0x7c, 0x80, 0x50, 0x55, 0x0f, 0x00, 
      0xd6, 0xa0, 0x0a, 0x80, 0x3a, 0x00, 
      0xea, 0x00, 0x00, 0x00, 0x54, 0x00, 
      0xf6, 0x33, 0x06, 0x00, 0xa0, 0x00, 
      0xfa, 0x04, 0x00, 0x00, 0x40, 0x01, 
      0xfe, 0xa4, 0x02, 0x00, 0xff, 0x02, 
      0xfc, 0x87, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x0b, 0x00, 0x40, 0x20, 0x04, 
      0x00, 0x05, 0x00, 0x40, 0x58, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x0b, 0x00, 0x20, 0x58, 0x04, 
      0x00, 0x06, 0x00, 0x40, 0x40, 0x02, 
      0x00, 0x0a, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x1c, 0x00, 0x00, 0xff, 0x01, 
      0x00, 0x38, 0x00, 0x00, 0xa8, 0x00, 
      0x00, 0xf0, 0x01, 0x00, 0x54, 0x00, 
      0x00, 0xe0, 0xab, 0xaa, 0x3a, 0x00, 
      0x00, 0x80, 0xd7, 0x57, 0x07, 0x00, 
      0x00, 0xfc, 0x7f, 0xfd, 0x01, 0x00, 
      0x00, 0x02, 0xbf, 0xfa, 0x01, 0x00, 
      0x00, 0x02, 0x51, 0x1d, 0x02, 0x00, 
      0x00, 0xfe, 0xb3, 0x1e, 0x03, 0x00, 
      0x00, 0x02, 0x5a, 0x1d, 0x06, 0x00, 
      0x00, 0xfa, 0xaa, 0x1e, 0x05, 0x00, 
      0x00, 0xfa, 0x5a, 0x0f, 0x06, 0x00, 
      0x00, 0xba, 0xaa, 0x0e, 0x05, 0x00, 
      0x00, 0xba, 0x5a, 0x0f, 0x06, 0x00, 
      0x00, 0xba, 0xaa, 0x07, 0x05, 0x00, 
      0x00, 0xba, 0x52, 0x87, 0x02, 0x00, 
      0x00, 0xba, 0xb2, 0x07, 0x07, 0x00, 
      0x00, 0xba, 0x52, 0x87, 0x05, 0x00, 
      0x00, 0xba, 0xbe, 0xff, 0x05, 0x00, 
      0x00, 0x9a, 0x7e, 0xff, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0x70, 0x07, 0x00, 
      0x00, 0xfc, 0x43, 0xb0, 0x01, 0x00, 
      0x00, 0x00, 0xe1, 0xd8, 0x00, 0x00, 
      0x00, 0x00, 0xba, 0xbf, 0x00, 0x00, 
      0x00, 0x00, 0x54, 0x5d, 0x00, 0x00, 
      0x00, 0x00, 0xb8, 0x3e, 0x00, 0x00, 
      0x00, 0x00, 0x50, 0x1d, 0x00, 0x00, 
      0x00, 0x80, 0xbf, 0xfe, 0x03, 0x00, 
      0x00, 0xf0, 0x7f, 0xff, 0x1f, 0x00, 
      0x00, 0xfc, 0xaf, 0xce, 0x7f, 0x00, 
      0x00, 0xfe, 0x67, 0x8f, 0xff, 0x00, 
      0x00, 0xff, 0xb7, 0xaf, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xd7, 0xff, 0x01, 
      0x80, 0xff, 0xbf, 0xff, 0xff, 0x03, 
      0x80, 0xff, 0xef, 0xc3, 0xff, 0x03, 
      0x80, 0xff, 0x07, 0x80, 0xff, 0x03, 
      0x00, 0xff, 0x07, 0xa0, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xd5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=256 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0xbc, 0xea, 0x01, 0x00, 
      0x00, 0x80, 0x50, 0x55, 0x0f, 0x00, 
      0x7c, 0xa0, 0x0a, 0x80, 0x3a, 0x00, 
      0xd6, 0x00, 0x00, 0x00, 0x54, 0x00, 
      0xea, 0x33, 0x06, 0x00, 0xa0, 0x00, 
      0xf6, 0x04, 0x00, 0x00, 0x40, 0x01, 
      0xfa, 0xa4, 0x02, 0x00, 0xff, 0x02, 
      0xfe, 0x87, 0x00, 0x80, 0x20, 0x02, 
      0x7c, 0x0b, 0x00, 0x40, 0x20, 0x04, 
      0x00, 0x05, 0x00, 0x40, 0x58, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x0b, 0x00, 0x20, 0x58, 0x04, 
      0x00, 0x06, 0x00, 0x40, 0x40, 0x02, 
      0x00, 0x0a, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x1c, 0x00, 0x00, 0xff, 0x01, 
      0x00, 0x38, 0x00, 0x00, 0xa8, 0x00, 
      0x00, 0xf0, 0x01, 0x00, 0x54, 0x00, 
      0x00, 0xe0, 0xab, 0xaa, 0x3a, 0x00, 
      0x00, 0x80, 0xd7, 0x57, 0x07, 0x00, 
      0x00, 0xfc, 0x7f, 0xfd, 0x01, 0x00, 
      0x00, 0x02, 0xbf, 0xfa, 0x01, 0x00, 
      0x00, 0x02, 0x51, 0x1d, 0x02, 0x00, 
      0x00, 0xfe, 0xb3, 0x1e, 0x03, 0x00, 
      0x00, 0x02, 0x5a, 0x1d, 0x06, 0x00, 
      0x00, 0xfa, 0xaa, 0x1e, 0x05, 0x00, 
      0x00, 0xfa, 0x5a, 0x0f, 0x06, 0x00, 
      0x00, 0xba, 0xaa, 0x0e, 0x05, 0x00, 
      0x00, 0xba, 0x5a, 0x0f, 0x06, 0x00, 
      0x00, 0xba, 0xaa, 0x07, 0x05, 0x00, 
      0x00, 0xba, 0x52, 0x87, 0x02, 0x00, 
      0x00, 0xba, 0xb2, 0x07, 0x07, 0x00, 
      0x00, 0xba, 0x52, 0x87, 0x05, 0x00, 
      0x00, 0xba, 0xbe, 0xff, 0x05, 0x00, 
      0x00, 0x9a, 0x7e, 0xff, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0x70, 0x07, 0x00, 
      0x00, 0xfc, 0x43, 0xb0, 0x01, 0x00, 
      0x00, 0x00, 0xe1, 0xd8, 0x00, 0x00, 
      0x00, 0x00, 0xba, 0xbf, 0x00, 0x00, 
      0x00, 0x00, 0x54, 0x3d, 0x00, 0x00, 
      0x00, 0x00, 0xb8, 0x3a, 0x00, 0x00, 
      0x00, 0x00, 0x54, 0x7d, 0x00, 0x00, 
      0x00, 0x80, 0xab, 0xfa, 0x03, 0x00, 
      0x00, 0xf0, 0x77, 0xf5, 0x1f, 0x00, 
      0x00, 0xfc, 0xfc, 0xfa, 0x7f, 0x00, 
      0x00, 0x7e, 0x30, 0xf5, 0xff, 0x00, 
      0x00, 0x7f, 0x00, 0xfb, 0xff, 0x01, 
      0x00, 0xff, 0xaa, 0xf5, 0xff, 0x01, 
      0x80, 0xff, 0x5f, 0xfb, 0xff, 0x03, 
      0x80, 0xff, 0xff, 0x3e, 0xfc, 0x03, 
      0x80, 0xff, 0x7f, 0x00, 0xf8, 0x03, 
      0x00, 0xff, 0x7f, 0x00, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0x55, 0xfd, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=320 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 
      0x00, 0x00, 0xbc, 0xea, 0x01, 0x00, 
      0x00, 0x80, 0x50, 0x55, 0x0f, 0x00, 
      0x7c, 0xa0, 0x0a, 0x80, 0x3a, 0x00, 
      0xd6, 0x00, 0x00, 0x00, 0x54, 0x00, 
      0xea, 0x33, 0x06, 0x00, 0xa0, 0x00, 
      0xf6, 0x04, 0x00, 0x00, 0x40, 0x01, 
      0xfa, 0xa4, 0x02, 0x00, 0xff, 0x02, 
      0xfe, 0x87, 0x00, 0x80, 0x20, 0x02, 
      0x7c, 0x0b, 0x00, 0x40, 0x20, 0x04, 
      0x00, 0x05, 0x00, 0x40, 0x58, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x05, 0x00, 0x20, 0x5c, 0x04, 
      0x00, 0x03, 0x00, 0x20, 0x58, 0x04, 
      0x00, 0x06, 0x00, 0x40, 0x40, 0x02, 
      0x00, 0x0a, 0x00, 0x80, 0x20, 0x02, 
      0x00, 0x1c, 0x00, 0x00, 0xff, 0x01, 
      0x00, 0x38, 0x00, 0x00, 0xa8, 0x00, 
      0x00, 0xf0, 0x01, 0x00, 0x54, 0x00, 
      0x00, 0xe0, 0xab, 0xaa, 0x3a, 0x00, 
      0x00, 0x80, 0xd7, 0x57, 0x07, 0x00, 
      0x00, 0xfc, 0x7f, 0xfd, 0x01, 0x00, 
      0x00, 0x02, 0xbf, 0xfe, 0x01, 0x00, 
      0x00, 0x02, 0x51, 0x1d, 0x02, 0x00, 
      0x00, 0xfe, 0xb3, 0x1e, 0x03, 0x00, 
      0x00, 0x02, 0x5a, 0x1d, 0x06, 0x00, 
      0x00, 0xfa, 0xaa, 0x1e, 0x05, 0x00, 
      0x00, 0xfa, 0x5a, 0x0f, 0x06, 0x00, 
      0x00, 0xba, 0xaa, 0x0e, 0x05, 0x00, 
      0x00, 0xba, 0x5a, 0x0f, 0x06, 0x00, 
      0x00, 0xba, 0xaa, 0x07, 0x05, 0x00, 
      0x00, 0xba, 0x52, 0x87, 0x02, 0x00, 
      0x00, 0xba, 0xb2, 0x07, 0x07, 0x00, 
      0x00, 0xba, 0x52, 0x87, 0x05, 0x00, 
      0x00, 0xba, 0xbe, 0xff, 0x05, 0x00, 
      0x00, 0x9a, 0x7e, 0xff, 0x05, 0x00, 
      0x00, 0xfa, 0xfe, 0xf9, 0x05, 0x00, 
      0x00, 0x02, 0x7e, 0xf0, 0x07, 0x00, 
      0x00, 0xfc, 0x43, 0xf0, 0x01, 0x00, 
      0x00, 0x00, 0xe1, 0xf8, 0x00, 0x00, 
      0x00, 0x00, 0xba, 0xff, 0x00, 0x00, 
      0x00, 0x00, 0x54, 0x7d, 0x00, 0x00, 
      0x00, 0x00, 0xb8, 0x3e, 0x00, 0x00, 
      0x00, 0x00, 0x50, 0x3f, 0x00, 0x00, 
      0x00, 0x80, 0xbf, 0xfe, 0x03, 0x00, 
      0x00, 0xf0, 0x5f, 0xff, 0x1f, 0x00, 
      0x00, 0xfc, 0xaf, 0x3f, 0x7c, 0x00, 
      0x00, 0xfe, 0xd7, 0x03, 0xf8, 0x00, 
      0x00, 0xff, 0xeb, 0x01, 0xfa, 0x01, 
      0x00, 0xff, 0xf7, 0x55, 0xfd, 0x01, 
      0x80, 0xff, 0xfc, 0xff, 0xff, 0x03, 
      0x80, 0x7f, 0x30, 0xfc, 0xff, 0x03, 
      0x80, 0x7f, 0x00, 0xf8, 0xff, 0x03, 
      0x00, 0xff, 0xaa, 0xfa, 0xff, 0x01, 
      0x00, 0xff, 0x5f, 0xfd, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=384 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xaf, 0x7a, 0x00, 0x00, 
      0x00, 0x20, 0x54, 0xd5, 0x03, 0x7c, 
      0x00, 0xa8, 0x02, 0xa0, 0x0e, 0xd6, 
      0x00, 0x00, 0x00, 0x00, 0x15, 0xea, 
      0x00, 0x8c, 0x01, 0x00, 0xa8, 0xf7, 
      0x00, 0x01, 0x00, 0x00, 0x50, 0xfa, 
      0x80, 0xaa, 0x00, 0x00, 0x60, 0xfe, 
      0x80, 0x20, 0x02, 0x00, 0xc0, 0x7f, 
      0x40, 0x08, 0x04, 0x00, 0xa0, 0x01, 
      0x40, 0x34, 0x04, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x34, 0x08, 0x00, 0xe0, 0x01, 
      0x80, 0x04, 0x04, 0x00, 0xe0, 0x00, 
      0x80, 0x08, 0x02, 0x00, 0xe0, 0x00, 
      0x00, 0xff, 0x01, 0x00, 0x70, 0x00, 
      0x00, 0x2a, 0x00, 0x00, 0x3a, 0x00, 
      0x00, 0x54, 0x00, 0x00, 0x1d, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x0f, 0x00, 
      0x00, 0xc0, 0xd5, 0xd7, 0x03, 0x00, 
      0x00, 0x00, 0x7e, 0x7d, 0x7f, 0x00, 
      0x00, 0x00, 0xbf, 0xfa, 0x81, 0x00, 
      0x00, 0x80, 0x50, 0x5d, 0x81, 0x00, 
      0x00, 0x80, 0xb0, 0xba, 0xff, 0x00, 
      0x00, 0x40, 0x54, 0xfd, 0x80, 0x00, 
      0x00, 0x40, 0xb3, 0xba, 0xbe, 0x00, 
      0x00, 0x40, 0x63, 0xfd, 0xbe, 0x00, 
      0x00, 0x40, 0xa3, 0xba, 0xae, 0x00, 
      0x00, 0x40, 0x63, 0xfd, 0xae, 0x00, 
      0x00, 0x40, 0xc0, 0xbe, 0xae, 0x00, 
      0x00, 0x80, 0x40, 0xdd, 0xae, 0x00, 
      0x00, 0xc0, 0xc1, 0xbe, 0xae, 0x00, 
      0x00, 0x40, 0x43, 0xdf, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfe, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1d, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x11, 0x8d, 0x7f, 0x00, 
      0x00, 0x00, 0xb2, 0x5e, 0x01, 0x00, 
      0x00, 0x00, 0xfa, 0xbf, 0x00, 0x00, 
      0x00, 0x00, 0x54, 0x5f, 0x00, 0x00, 
      0x00, 0x00, 0xb8, 0x3e, 0x00, 0x00, 
      0x00, 0x00, 0x50, 0x1f, 0x00, 0x00, 
      0x00, 0x80, 0xbf, 0xfe, 0x03, 0x00, 
      0x00, 0xf0, 0x7f, 0xff, 0x1f, 0x00, 
      0x00, 0xfc, 0xa7, 0xee, 0x7f, 0x00, 
      0x00, 0xfe, 0x63, 0xcf, 0xff, 0x00, 
      0x00, 0xff, 0xe3, 0xde, 0xff, 0x01, 
      0x00, 0xff, 0x47, 0xfd, 0xff, 0x01, 
      0x80, 0xff, 0xff, 0xfe, 0xff, 0x03, 
      0x80, 0xff, 0x87, 0xef, 0xff, 0x03, 
      0x80, 0xff, 0x03, 0xd0, 0xff, 0x03, 
      0x00, 0xff, 0x03, 0xe8, 0xff, 0x01, 
      0x00, 0xff, 0x57, 0xf5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=448 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xaf, 0x7a, 0x00, 0x00, 
      0x00, 0x20, 0x54, 0xd5, 0x03, 0x00, 
      0x00, 0xa8, 0x02, 0xa0, 0x0e, 0x7c, 
      0x00, 0x00, 0x00, 0x00, 0x15, 0xd6, 
      0x00, 0x8c, 0x01, 0x00, 0xa8, 0xeb, 
      0x00, 0x01, 0x00, 0x00, 0x50, 0xf6, 
      0x80, 0xaa, 0x00, 0x00, 0x60, 0xfa, 
      0x80, 0x20, 0x02, 0x00, 0xc0, 0xff, 
      0x40, 0x08, 0x04, 0x00, 0xa0, 0x7d, 
      0x40, 0x34, 0x04, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x34, 0x08, 0x00, 0xe0, 0x01, 
      0x80, 0x04, 0x04, 0x00, 0xe0, 0x00, 
      0x80, 0x08, 0x02, 0x00, 0xe0, 0x00, 
      0x00, 0xff, 0x01, 0x00, 0x70, 0x00, 
      0x00, 0x2a, 0x00, 0x00, 0x3a, 0x00, 
      0x00, 0x54, 0x00, 0x00, 0x1d, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x0e, 0x00, 
      0x00, 0xc0, 0xd5, 0xd7, 0x03, 0x00, 
      0x00, 0x00, 0x7e, 0x7d, 0x7f, 0x00, 
      0x00, 0x00, 0xbf, 0xfa, 0x81, 0x00, 
      0x00, 0x80, 0x50, 0x5d, 0x81, 0x00, 
      0x00, 0x80, 0xb0, 0xba, 0xff, 0x00, 
      0x00, 0x40, 0x54, 0xfd, 0x80, 0x00, 
      0x00, 0x40, 0xb3, 0xba, 0xbe, 0x00, 
      0x00, 0x40, 0x63, 0xfd, 0xbe, 0x00, 
      0x00, 0x40, 0xa3, 0xba, 0xae, 0x00, 
      0x00, 0x40, 0x63, 0xfd, 0xae, 0x00, 
      0x00, 0x40, 0xc0, 0xbe, 0xae, 0x00, 
      0x00, 0x80, 0x40, 0xdd, 0xae, 0x00, 
      0x00, 0xc0, 0xc1, 0xbe, 0xae, 0x00, 
      0x00, 0x40, 0x43, 0xdf, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfe, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xff, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1d, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x11, 0x85, 0x7f, 0x00, 
      0x00, 0x00, 0xb2, 0x5e, 0x01, 0x00, 
      0x00, 0x00, 0xfa, 0xbf, 0x00, 0x00, 
      0x00, 0x00, 0x58, 0x7f, 0x00, 0x00, 
      0x00, 0x00, 0xa8, 0x3e, 0x00, 0x00, 
      0x00, 0x00, 0x54, 0x7f, 0x00, 0x00, 
      0x00, 0x80, 0xaf, 0xef, 0x03, 0x00, 
      0x00, 0xf0, 0xd7, 0xf7, 0x1f, 0x00, 
      0x00, 0xfc, 0xef, 0x6f, 0x7f, 0x00, 
      0x00, 0xfe, 0xd7, 0x99, 0xfe, 0x00, 
      0x00, 0xff, 0xef, 0x41, 0xfd, 0x01, 
      0x00, 0xff, 0xd7, 0xa9, 0xfe, 0x01, 
      0x80, 0xff, 0xef, 0xf5, 0xff, 0x03, 
      0x80, 0x7f, 0xf8, 0xfe, 0xff, 0x03, 
      0x80, 0x3f, 0x00, 0xfd, 0xff, 0x03, 
      0x00, 0x3f, 0x80, 0xfe, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=512 y=288 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xaf, 0x7a, 0x00, 0x00, 
      0x00, 0x20, 0x54, 0xd5, 0x03, 0x00, 
      0x00, 0xa8, 0x02, 0xa0, 0x0e, 0x7c, 
      0x00, 0x00, 0x00, 0x00, 0x15, 0xd6, 
      0x00, 0x8c, 0x01, 0x00, 0xa8, 0xeb, 
      0x00, 0x01, 0x00, 0x00, 0x50, 0xf6, 
      0x80, 0xaa, 0x00, 0x00, 0x60, 0xfa, 
      0x80, 0x20, 0x02, 0x00, 0xc0, 0xff, 
      0x40, 0x08, 0x04, 0x00, 0xa0, 0x7d, 
      0x40, 0x34, 0x04, 0x00, 0x40, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x74, 0x08, 0x00, 0xc0, 0x01, 
      0x40, 0x34, 0x08, 0x00, 0xe0, 0x01, 
      0x80, 0x04, 0x04, 0x00, 0xe0, 0x00, 
      0x80, 0x08, 0x02, 0x00, 0xe0, 0x00, 
      0x00, 0xff, 0x01, 0x00, 0x70, 0x00, 
      0x00, 0x2a, 0x00, 0x00, 0x3a, 0x00, 
      0x00, 0x54, 0x00, 0x00, 0x1d, 0x00, 
      0x00, 0xb8, 0xaa, 0xaa, 0x0e, 0x00, 
      0x00, 0xc0, 0xd5, 0xd7, 0x03, 0x00, 
      0x00, 0x00, 0x7e, 0x7d, 0x7f, 0x00, 
      0x00, 0x00, 0xbf, 0xfa, 0x81, 0x00, 
      0x00, 0x80, 0x50, 0x5d, 0x81, 0x00, 
      0x00, 0x80, 0xb0, 0xba, 0xff, 0x00, 
      0x00, 0x40, 0x54, 0xed, 0x80, 0x00, 
      0x00, 0x40, 0xb3, 0xba, 0xbe, 0x00, 
      0x00, 0x40, 0x63, 0xed, 0xbe, 0x00, 
      0x00, 0x40, 0xa3, 0xba, 0xae, 0x00, 
      0x00, 0x40, 0x63, 0xed, 0xae, 0x00, 
      0x00, 0x40, 0xc0, 0xb6, 0xae, 0x00, 
      0x00, 0x80, 0x40, 0xdd, 0xae, 0x00, 
      0x00, 0xc0, 0xc1, 0xb6, 0xae, 0x00, 
      0x00, 0x40, 0x43, 0xdb, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfe, 0xae, 0x00, 
      0x00, 0x40, 0xff, 0xfb, 0xa6, 0x00, 
      0x00, 0x40, 0x3f, 0xff, 0xbe, 0x00, 
      0x00, 0xc0, 0x1d, 0xfe, 0x80, 0x00, 
      0x00, 0x00, 0x11, 0x8f, 0x7f, 0x00, 
      0x00, 0x00, 0xb2, 0x5f, 0x01, 0x00, 
      0x00, 0x00, 0xf2, 0xbf, 0x00, 0x00, 
      0x00, 0x00, 0x54, 0x5f, 0x00, 0x00, 
      0x00, 0x00, 0xb8, 0x3e, 0x00, 0x00, 
      0x00, 0x00, 0x58, 0x1f, 0x00, 0x00, 
      0x00, 0x80, 0xb7, 0xfe, 0x03, 0x00, 
      0x00, 0xf0, 0x6f, 0xfd, 0x1f, 0x00, 
      0x00, 0x7c, 0xf8, 0xfe, 0x7f, 0x00, 
      0x00, 0x3e, 0x80, 0xfd, 0xff, 0x00, 
      0x00, 0x3f, 0x80, 0xfb, 0xff, 0x01, 
      0x00, 0x7f, 0x55, 0xf7, 0xff, 0x01, 
      0x80, 0xff, 0xff, 0x6f, 0xfe, 0x03, 
      0x80, 0xff, 0x7f, 0x18, 0xfe, 0x03, 
      0x80, 0xff, 0x3f, 0x00, 0xfd, 0x03, 
      0x00, 0xff, 0x3f, 0xa0, 0xfe, 0x01, 
      0x00, 0xff, 0x7f, 0xf5, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    
    {
      /* Bitmap x=320 y=0 w=64 h=48 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 
      0x00, 0x00, 0xe0, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x08, 0x00, 0x00, 
      0x00, 0x00, 0x70, 0x1b, 0x00, 0x00, 
      0x00, 0x00, 0xfe, 0xfc, 0x00, 0x00, 
      0x00, 0xc0, 0xff, 0xfc, 0x07, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0xf8, 0x03, 0x80, 0x3f, 0x00, 
      0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 
      0x00, 0x1e, 0x00, 0x00, 0xf0, 0x00, 
      0x00, 0x0f, 0x00, 0x00, 0xe0, 0x01, 
      0x00, 0x07, 0x00, 0x00, 0xc0, 0x01, 
      0x80, 0x07, 0x00, 0x00, 0xc0, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
      0x80, 0x03, 0x3c, 0x78, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x03, 0x7e, 0xfc, 0x80, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x07, 0x7e, 0xfc, 0xc0, 0x03, 
      0x80, 0x0f, 0x7e, 0xfc, 0xe0, 0x03, 
      0x00, 0x0f, 0x7e, 0xfc, 0xe0, 0x01, 
      0x00, 0x1f, 0x7e, 0xfc, 0xf0, 0x01, 
      0x00, 0x3e, 0x3c, 0x78, 0xf8, 0x00, 
      0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 
      
      0x00, 0x78, 0x00, 0x00, 0x3c, 0x00, 
      0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 
      0x00, 0xfe, 0xa9, 0x2a, 0xff, 0x00, 
      0x80, 0xa7, 0xa9, 0x2a, 0xcb, 0x03, 
      0xc0, 0xa7, 0x03, 0x80, 0xcb, 0x07, 
      0xc0, 0xc7, 0xfe, 0xff, 0xc6, 0x07, 
      0xe0, 0xc3, 0xe1, 0x1f, 0x87, 0x0f, 
      0xe0, 0x79, 0x83, 0x82, 0x3d, 0x0f, 
      0xe0, 0x7c, 0xfe, 0xfe, 0x7c, 0x0e, 
      0x20, 0xfc, 0x80, 0x02, 0x7e, 0x08, 
      0x20, 0xfe, 0xf1, 0x1e, 0xff, 0x08, 
      0x60, 0x7f, 0xff, 0xfe, 0xfd, 0x0d, 
      0xe0, 0xfc, 0x80, 0x02, 0x7e, 0x0e, 
      0x40, 0xfe, 0xf1, 0x1f, 0xff, 0x04, 
      0xc0, 0xfc, 0x7f, 0xfc, 0x7f, 0x06, 
      0x80, 0xf9, 0xff, 0xfe, 0x3f, 0x03, 
      0x00, 0x93, 0x7f, 0xfc, 0x93, 0x01, 
      0x00, 0xff, 0xff, 0xfe, 0xff, 0x01, 
      0x00, 0xd7, 0x73, 0x9c, 0xd7, 0x01, 
      0x00, 0xd6, 0x03, 0x80, 0xd7, 0x00, 
      0x00, 0xfc, 0xf7, 0xdf, 0x7f, 0x00, 
      0x00, 0xc0, 0xf9, 0x3f, 0x07, 0x00, 
      0x00, 0xc0, 0xf3, 0x9f, 0x07, 0x00, 
      0x00, 0xe0, 0xf9, 0x3f, 0x0f, 0x00, 
      0x00, 0xe0, 0xf8, 0x3f, 0x0e, 0x00, 
      0x00, 0xe0, 0x39, 0x38, 0x0f, 0x00, 
      0x00, 0xe0, 0xfd, 0x7f, 0x0f, 0x00, 
      0x00, 0xf0, 0xfa, 0xbf, 0x1e, 0x00, 
      0x00, 0xfc, 0xfd, 0x7f, 0x7f, 0x00, 
      0x00, 0xfe, 0xfd, 0x7f, 0xff, 0x00, 
      0x00, 0xff, 0xf9, 0x3f, 0xff, 0x01, 
      0x00, 0xff, 0xf3, 0x9f, 0xff, 0x01, 
      0x80, 0x7f, 0xfe, 0xff, 0xfc, 0x03, 
      0x80, 0x9f, 0xfa, 0xbf, 0xf2, 0x03, 
      0x80, 0x6f, 0xfd, 0x7f, 0xed, 0x03, 
      0x00, 0xbf, 0xfe, 0xff, 0xfa, 0x01, 
      0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 

    {
      /* Bitmap x=576 y=0 w=64 h=96 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 
      0x00, 0x00, 0xf0, 0x9f, 0x35, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x3a, 0x00, 
      0x00, 0x40, 0x50, 0x15, 0x3f, 0x00, 
      0x00, 0x50, 0xa9, 0x2a, 0x38, 0x00, 
      0x00, 0x00, 0x50, 0x15, 0x20, 0x00, 
      0x00, 0x18, 0xab, 0x2a, 0x40, 0x00, 
      0x00, 0x02, 0x50, 0x15, 0x80, 0x00, 
      0x00, 0x51, 0xa9, 0x2a, 0x00, 0x01, 
      0x00, 0x41, 0x50, 0x15, 0x00, 0x01, 
      0x80, 0x00, 0xfe, 0xff, 0x00, 0x01, 
      0x80, 0xc0, 0x01, 0x00, 0x37, 0x01, 
      0x80, 0x30, 0x00, 0x00, 0xf8, 0x00, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x00, 
      0x80, 0x08, 0x00, 0x00, 0x50, 0x00, 
      0x80, 0x08, 0x00, 0x00, 0x60, 0x00, 
      0x80, 0x08, 0x42, 0x84, 0x50, 0x00, 
      0x80, 0x08, 0x66, 0xcc, 0x60, 0x00, 
      0x80, 0x08, 0x3c, 0x78, 0x50, 0x00, 
      0x80, 0x08, 0x18, 0x30, 0x60, 0x00, 
      0x80, 0x08, 0x3c, 0x78, 0x70, 0x00, 
      0x00, 0x09, 0x66, 0xcc, 0xe0, 0x00, 
      0x00, 0x11, 0x42, 0x84, 0xb0, 0x00, 
      0x00, 0x22, 0x00, 0x00, 0xd8, 0x00, 
      0x00, 0xec, 0x00, 0x00, 0x6e, 0x00, 
      0x00, 0x58, 0x03, 0x80, 0x35, 0x00, 
      0x00, 0xb8, 0xfe, 0xff, 0x3a, 0x00, 
      0x00, 0xf6, 0x55, 0x55, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x07, 
      0xc0, 0xfa, 0x01, 0x00, 0xaf, 0x07, 
      0x60, 0x7d, 0x0e, 0x40, 0x56, 0x0f, 
      0xa0, 0x3e, 0x38, 0x3c, 0xaf, 0x0e, 
      0x60, 0x7d, 0x60, 0x3a, 0x5c, 0x0f, 
      0xa0, 0x3e, 0xc0, 0x3e, 0xbd, 0x0e, 
      0x60, 0x7f, 0x80, 0x3f, 0x5a, 0x0f, 
      0xa0, 0x3e, 0x00, 0x1f, 0xbd, 0x0e, 
      0x60, 0xfd, 0x01, 0x03, 0x5a, 0x0f, 
      0xc0, 0x7a, 0xce, 0x01, 0xad, 0x06, 
      0x40, 0x3d, 0x78, 0x80, 0x7a, 0x07, 
      0x80, 0xc3, 0x01, 0x80, 0x87, 0x03, 
      0x00, 0xc1, 0x03, 0xe6, 0x07, 0x01, 
      0x00, 0xc1, 0x87, 0xfb, 0x83, 0x01, 
      0x00, 0xa1, 0x47, 0xfd, 0x43, 0x01, 
      0x00, 0xd2, 0xc6, 0x7a, 0xa6, 0x00, 
      0x00, 0x7c, 0x47, 0x9d, 0x7f, 0x00, 
      0x00, 0xc0, 0xc6, 0xc6, 0x07, 0x00, 
      0x00, 0x40, 0x8d, 0x61, 0x07, 0x00, 
      0x00, 0xa0, 0x1a, 0xb0, 0x07, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x07, 0x00, 
      0x00, 0xa0, 0x3e, 0xe8, 0x07, 0x00, 
      0x00, 0x60, 0xfd, 0xbf, 0x03, 0x00, 
      0x00, 0xb0, 0xfe, 0xbf, 0x1f, 0x00, 
      0x00, 0x7c, 0xfd, 0x3f, 0x7e, 0x00, 
      0x00, 0xbe, 0xfe, 0x3f, 0xfe, 0x00, 
      0x00, 0x7f, 0xfd, 0x3f, 0xfe, 0x01, 
      0x00, 0xcf, 0xf3, 0x1f, 0xf4, 0x01, 
      0x80, 0x07, 0xe8, 0x1f, 0xe8, 0x03, 
      0x80, 0x07, 0xf4, 0x1f, 0xfc, 0x03, 
      0x80, 0x07, 0xea, 0x3f, 0xea, 0x03, 
      0x00, 0x0f, 0xfd, 0x7f, 0xf6, 0x01, 
      0x00, 0xaf, 0xfe, 0xff, 0xff, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00}, 
    
    
    {
      /* Bitmap x=320 y=192 w=64 h=96 */
      0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 
      0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0a, 0x00, 0x00, 
      0x00, 0x00, 0x20, 0x0c, 0x00, 0x00, 
      0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 
      0x00, 0x00, 0xae, 0xea, 0x00, 0x00, 
      0x00, 0x00, 0x51, 0x15, 0x07, 0x00, 
      0x00, 0x40, 0xa8, 0x2a, 0x18, 0x00, 
      0x00, 0x50, 0x51, 0x15, 0x20, 0x00, 
      0x00, 0x00, 0xa8, 0x2a, 0x40, 0x00, 
      0x00, 0x1a, 0x53, 0x15, 0x80, 0x00, 
      0x00, 0x01, 0xa8, 0x2a, 0x80, 0x01, 
      0x00, 0x51, 0x51, 0x15, 0x00, 0x01, 
      0x80, 0x40, 0xa8, 0x2a, 0x80, 0x02, 
      0x80, 0x00, 0x50, 0x15, 0x00, 0x03, 
      0x80, 0x80, 0xff, 0xff, 0x83, 0x02, 
      0x80, 0x70, 0x00, 0x00, 0x1c, 0x03, 
      0x80, 0x08, 0x00, 0x00, 0xa0, 0x02, 
      0x80, 0x08, 0x00, 0x00, 0x20, 0x03, 
      0x80, 0x08, 0x3c, 0x78, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x80, 0x08, 0x7e, 0xfc, 0x20, 0x03, 
      0x80, 0x08, 0x7e, 0xfc, 0xa0, 0x02, 
      0x00, 0x09, 0x7e, 0xfc, 0x60, 0x01, 
      0x00, 0x09, 0x7e, 0xfc, 0xa0, 0x01, 
      0x00, 0x12, 0x7e, 0xfc, 0xd0, 0x00, 
      0x00, 0x2c, 0x7e, 0xfc, 0x68, 0x00, 
      0x00, 0x58, 0x3c, 0x78, 0x34, 0x00, 
      0x00, 0xb8, 0x01, 0x00, 0x3b, 0x00, 
      0x00, 0xf6, 0xff, 0xff, 0xdf, 0x00, 
      0x80, 0xeb, 0xff, 0xff, 0xaf, 0x03, 
      0x40, 0xd5, 0xfe, 0xff, 0x56, 0x07, 
      0xc0, 0xea, 0x00, 0x00, 0xaf, 0x07, 
      0x60, 0xf5, 0x00, 0x40, 0x56, 0x0f, 
      0xa0, 0xfa, 0x00, 0x3c, 0xaf, 0x0e, 
      0x60, 0x7d, 0x00, 0x3a, 0x5e, 0x0f, 
      0xa0, 0x7e, 0x00, 0x3e, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x3e, 0x5a, 0x0f, 
      0xa0, 0x7e, 0x00, 0x1c, 0xbd, 0x0e, 
      0x60, 0x3d, 0x00, 0x00, 0x5a, 0x0f, 
      0xc0, 0x7a, 0x00, 0x00, 0xad, 0x06, 
      0x40, 0x3d, 0xe0, 0x8f, 0x7a, 0x07, 
      0x80, 0xc3, 0xbf, 0xfa, 0x87, 0x03, 
      0x00, 0xe1, 0x7f, 0xfd, 0x07, 0x01, 
      0x00, 0xc1, 0xbf, 0xfa, 0x83, 0x01, 
      0x00, 0xa1, 0x7f, 0xfd, 0x43, 0x01, 
      0x00, 0xd2, 0xe0, 0x4f, 0xa7, 0x00, 
      0x00, 0xfc, 0x03, 0xa0, 0x7f, 0x00, 
      0x00, 0xc0, 0x07, 0xd0, 0x07, 0x00, 
      0x00, 0x40, 0x0d, 0x68, 0x07, 0x00, 
      0x00, 0xa0, 0x5a, 0xb5, 0x0f, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xa0, 0x3e, 0xa8, 0x0e, 0x00, 
      0x00, 0x60, 0xfd, 0x5f, 0x0f, 0x00, 
      0x00, 0xb0, 0xfe, 0xbf, 0x1e, 0x00, 
      0x00, 0x7c, 0xfd, 0x5f, 0x7f, 0x00, 
      0x00, 0xbe, 0xfe, 0xbf, 0xfe, 0x00, 
      0x00, 0x7f, 0xfd, 0x7f, 0xff, 0x01, 
      0x00, 0xcf, 0xf3, 0xcf, 0xe7, 0x01, 
      0x80, 0x07, 0xe8, 0x0f, 0xc0, 0x03, 
      0x80, 0x07, 0xf4, 0x0f, 0xe0, 0x03, 
      0x80, 0x07, 0xea, 0x1f, 0xd0, 0x03, 
      0x00, 0x0f, 0xfd, 0x3f, 0xe8, 0x01, 
      0x00, 0xaf, 0xfe, 0x7f, 0xf5, 0x01, 
      0x00, 0xfe, 0xff, 0xff, 0xff, 0x00, 
      0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 
      0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 
      0x00, 0x80, 0xff, 0xff, 0x03, 0x00},     
  }  
};



unsigned char big_mask[SIZE_OF_BIG] = 
{
  /* Bitmap x=0 y=0 w=112 h=144 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
  0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
  0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
  0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
  0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
  0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 
  0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x1e, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x78, 0x00, 
  0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 
  0x80, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x01, 
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 
  0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 
  0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 
  0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 
  0xc0, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 
  0xc0, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00}; 


unsigned char big_bits[MAX_PLAYER][SIZE_OF_BIG] = 
{
  {
    /* Bitmap x=112 y=0 w=112 h=144 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 
    0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
    0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
    0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xfe, 0x00, 
    0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x1f, 0x00, 
    0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x60, 0x66, 0x03, 0x00, 
    0x00, 0xc0, 0x1f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x70, 0x00, 0x00, 
    0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x30, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x38, 0xc0, 0x01, 0x00, 
    0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x38, 0xc0, 0x01, 0x00, 
    0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xcc, 0x30, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xee, 0x70, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x67, 0x66, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x03, 0x06, 0xe0, 0xff, 
    0xff, 0x07, 0x00, 0xc0, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x01, 0x06, 0xfc, 0xff, 
    0xff, 0x3f, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x01, 0x80, 0x3f, 0x00, 
    0x00, 0xfc, 0x01, 0x80, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x00, 0xe0, 0x07, 0x00, 
    0x00, 0xe0, 0x07, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x00, 0xf8, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0x00, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x00, 0x3e, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0x80, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x80, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x01, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xc0, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x83, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xe0, 0x00, 0xf0, 0x03, 
    0xc0, 0x0f, 0x00, 0x47, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xf8, 0x07, 
    0xe0, 0x1f, 0x00, 0x86, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0x46, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0x86, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x06, 0x00, 0x00, 
    0x00, 0x1e, 0x7e, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x7f, 0x78, 0x00, 
    0x00, 0x3f, 0x7f, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0xfe, 0xfc, 0x00, 
    0x80, 0x73, 0x7b, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0xcf, 0xce, 0x01, 
    0xc0, 0xe1, 0x71, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x86, 0x87, 0x03, 
    0xe0, 0xc0, 0x69, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x87, 0x03, 0x07, 
    0x60, 0x80, 0x71, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x86, 0x01, 0x06, 
    0x60, 0x00, 0x68, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0x70, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x06, 0x00, 0x06, 
    0x60, 0x00, 0x68, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0x70, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xa6, 0x06, 0x00, 0x07, 
    0x60, 0x00, 0x68, 0x60, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0x46, 0x07, 0x80, 0x06, 
    0xe0, 0x00, 0xf4, 0xe0, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xa7, 0x0f, 0x40, 0x07, 
    0xc0, 0x01, 0xfe, 0xc0, 0x01, 0xf8, 0x07, 
    0xe0, 0x1f, 0x80, 0x53, 0x3f, 0xa0, 0x03, 
    0x80, 0x03, 0xff, 0x81, 0x03, 0xf0, 0x03, 
    0xc0, 0x0f, 0xc0, 0xa9, 0xff, 0xd5, 0x01, 
    0x00, 0xff, 0xf7, 0x01, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xd4, 0xef, 0xff, 0x00, 
    0x00, 0xfe, 0xe9, 0x03, 0x3e, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0xea, 0x87, 0x7f, 0x00, 
    0x00, 0x18, 0xd0, 0x07, 0xf8, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0xf5, 0x03, 0x1c, 0x00, 
    0x00, 0x18, 0xa0, 0x0f, 0xe0, 0x03, 0x00, 
    0x00, 0xc0, 0x87, 0xfa, 0x01, 0x1a, 0x00, 
    0x00, 0x18, 0x40, 0x5f, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0x41, 0xfd, 0x00, 0x1d, 0x00, 
    0x00, 0x38, 0x80, 0xbe, 0x00, 0xfe, 0xff, 
    0xff, 0x7f, 0xa0, 0x7e, 0x00, 0x1e, 0x00, 
    0x00, 0x30, 0x00, 0x7d, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x50, 0x3f, 0x00, 0x0d, 0x00, 
    0x00, 0x30, 0x00, 0xfa, 0x0a, 0x00, 0x00, 
    0x00, 0x00, 0xaa, 0x1f, 0x80, 0x0e, 0x00, 
    0x00, 0x70, 0x00, 0xf4, 0x17, 0x00, 0x00, 
    0x00, 0x40, 0xd5, 0x0f, 0x00, 0x0f, 0x00, 
    0x00, 0x60, 0x00, 0xe8, 0xaf, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xfa, 0x03, 0x80, 0x06, 0x00, 
    0x00, 0xe0, 0x00, 0x00, 0x7f, 0x55, 0x55, 
    0x55, 0x55, 0xfd, 0x00, 0x40, 0x07, 0x00, 
    0x00, 0xc0, 0x00, 0x00, 0xfe, 0xab, 0xaa, 
    0xaa, 0xea, 0x7f, 0x00, 0xa0, 0x03, 0x00, 
    0x00, 0xc0, 0x01, 0x00, 0xfc, 0xff, 0xff, 
    0xff, 0xff, 0x3f, 0x00, 0xd0, 0x03, 0x00, 
    0x00, 0x80, 0x03, 0x00, 0xf8, 0xff, 0xff, 
    0xff, 0xff, 0x1f, 0x00, 0xe8, 0x01, 0x00, 
    0x00, 0x00, 0x07, 0x00, 0x78, 0xff, 0xff, 
    0xff, 0xff, 0x1e, 0x00, 0xf4, 0x00, 0x00, 
    0x00, 0x00, 0x0e, 0x00, 0x78, 0xfc, 0xff, 
    0xff, 0x3f, 0x1f, 0x00, 0x7a, 0x00, 0x00, 
    0x00, 0x00, 0x1c, 0x00, 0x78, 0x00, 0x00, 
    0x00, 0x00, 0x1e, 0x00, 0x3d, 0x00, 0x00, 
    0x00, 0x00, 0x38, 0x00, 0x78, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0x80, 0x1e, 0x00, 0x00, 
    0x00, 0x00, 0x70, 0x00, 0x78, 0x00, 0x00, 
    0x00, 0x30, 0x1e, 0x40, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x00, 0x7c, 0x00, 0x00, 
    0x00, 0x38, 0x1f, 0xa8, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x03, 0x3a, 0x00, 0x00, 
    0xe0, 0x1d, 0x5e, 0xd5, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x4f, 0x3d, 0x00, 0x00, 
    0xf8, 0x0f, 0xbd, 0xfa, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xbe, 0x1e, 0x00, 0x00, 
    0xc8, 0x07, 0x7a, 0x7d, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
    0xcc, 0x0f, 0xf5, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 
    0xfc, 0x0f, 0xea, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 
    0xfc, 0x0f, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xfc, 0x0f, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xf8, 0x07, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xf8, 0x07, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xe0, 0x01, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xfc, 
    0x3f, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xfe, 
    0x7f, 0x00, 0xd5, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 
    0xe0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 
    0xe0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 
    0xe0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x07, 
    0xe0, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0xfe, 
    0x7f, 0x40, 0x1d, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xfc, 
    0x3f, 0xa0, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xec, 0x03, 0x00, 
    0x00, 0xd0, 0x37, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x8c, 0x07, 0x00, 
    0x00, 0xe8, 0x39, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00, 
    0x00, 0x74, 0x70, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x1c, 0x00, 
    0x00, 0x3a, 0x68, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x38, 0x00, 
    0x00, 0x1d, 0x70, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x70, 0x00, 
    0x80, 0x0e, 0x68, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x55, 
    0x55, 0x07, 0xd0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0xab, 
    0xaa, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xa0, 0xff, 
    0xff, 0x01, 0xd0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0x40, 0xff, 
    0xff, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0x03, 
    0xc0, 0x00, 0xd0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x40, 0x03, 
    0xc0, 0x00, 0xa0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0xff, 
    0xff, 0x01, 0xd0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xd0, 0xff, 
    0xff, 0x01, 0xa0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0xff, 
    0xff, 0x01, 0xc0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x01, 0xd0, 0xff, 
    0xff, 0x01, 0xa0, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0x01, 0xe8, 0xff, 
    0xff, 0x03, 0xc0, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0x01, 0xd0, 0xff, 
    0xff, 0x03, 0xa0, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x01, 0xe8, 0xff, 
    0xff, 0x03, 0xc0, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0x01, 0xd0, 0xff, 
    0xff, 0x03, 0xa0, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0x03, 0xe8, 0xff, 
    0xff, 0x07, 0xc0, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0x0f, 0xf0, 0xff, 
    0xff, 0x0f, 0xf0, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x3f, 0xfe, 0x9f, 0xff, 
    0xff, 0xf9, 0x7f, 0xfc, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0xf8, 0x4f, 0xff, 
    0xff, 0xf0, 0x1f, 0xf8, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xa0, 0xff, 
    0xff, 0x00, 0x00, 0xf4, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xd0, 0xff, 
    0xff, 0x01, 0x00, 0xfa, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xe8, 0xff, 
    0xff, 0x03, 0x00, 0xfd, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xf4, 0xff, 
    0xff, 0x0f, 0x80, 0xfa, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x3f, 0x80, 0xfa, 0xff, 
    0xff, 0x1f, 0x50, 0xfd, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x7f, 0x55, 0xfd, 0xff, 
    0xff, 0xbf, 0xaa, 0xfe, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
    0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00}, 
  
  
  {
    /* Bitmap x=224 y=0 w=112 h=144 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 
    0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
    0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
    0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
    0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 
    0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 
    0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0xd5, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf0, 0xaa, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x78, 0x41, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xbc, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x7e, 0x40, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xbf, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x7f, 0x40, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xbf, 0xa0, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x7f, 0xd5, 0x3f, 0x00, 
    0x00, 0xfc, 0xff, 0xff, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xff, 0xea, 0x07, 0x00, 
    0x00, 0xe0, 0xff, 0xff, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0xff, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xff, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xff, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xff, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xff, 0x00, 0xf0, 0x03, 
    0xc0, 0x0f, 0x00, 0xff, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x7f, 0x00, 0xf8, 0x07, 
    0xe0, 0x1f, 0x00, 0xfe, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x7f, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xfe, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x7f, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xfe, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x07, 0x00, 0x00, 
    0x00, 0x1e, 0xfe, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x7f, 0x78, 0x00, 
    0x00, 0x3f, 0xff, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0xff, 0xfc, 0x00, 
    0x80, 0x73, 0xfb, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0xcf, 0xce, 0x01, 
    0xc0, 0xe1, 0xf1, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x87, 0x87, 0x03, 
    0xe0, 0xc0, 0xe9, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x87, 0x03, 0x07, 
    0x60, 0x80, 0xf1, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x87, 0x01, 0x06, 
    0x60, 0x00, 0xe8, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0xf0, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0xe8, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0xf0, 0x7f, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xfe, 0x07, 0x00, 0x07, 
    0x60, 0x00, 0xe8, 0x7f, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xfe, 0x07, 0x80, 0x06, 
    0xe0, 0x00, 0xf4, 0xff, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xff, 0x0f, 0x40, 0x07, 
    0xc0, 0x01, 0xfe, 0xff, 0x01, 0xf8, 0x07, 
    0xe0, 0x1f, 0x80, 0xff, 0x3f, 0xa0, 0x03, 
    0x80, 0x03, 0xff, 0xff, 0x03, 0xf0, 0x03, 
    0xc0, 0x0f, 0xc0, 0xff, 0xff, 0xd5, 0x01, 
    0x00, 0xff, 0xb7, 0xff, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xff, 0xed, 0xff, 0x00, 
    0x00, 0xfe, 0x69, 0xff, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xff, 0x86, 0x7f, 0x00, 
    0x00, 0x18, 0xd0, 0xfe, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x7f, 0x03, 0x1c, 0x00, 
    0x00, 0x18, 0xa0, 0xfd, 0xff, 0x03, 0x00, 
    0x00, 0xc0, 0xff, 0xbf, 0x01, 0x1a, 0x00, 
    0x00, 0x18, 0x40, 0xfb, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xdf, 0x00, 0x1d, 0x00, 
    0x00, 0x38, 0x80, 0xf6, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x6f, 0x00, 0x1e, 0x00, 
    0x00, 0x30, 0x00, 0xed, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x37, 0x00, 0x0d, 0x00, 
    0x00, 0x30, 0x00, 0xda, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x1b, 0x80, 0x0e, 0x00, 
    0x00, 0x70, 0x00, 0xb4, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x0f, 0x00, 0x0f, 0x00, 
    0x00, 0x60, 0x00, 0xe8, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x03, 0x80, 0x06, 0x00, 
    0x00, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x00, 0x40, 0x07, 0x00, 
    0x00, 0xc0, 0x00, 0x00, 0xe6, 0xff, 0xff, 
    0xff, 0xff, 0x67, 0x00, 0xa0, 0x03, 0x00, 
    0x00, 0xc0, 0x01, 0x00, 0x9c, 0xff, 0xff, 
    0xff, 0xff, 0x39, 0x00, 0xd0, 0x03, 0x00, 
    0x00, 0x80, 0x03, 0x00, 0x78, 0xf8, 0xff, 
    0xff, 0x1f, 0x1e, 0x00, 0xe8, 0x01, 0x00, 
    0x00, 0x00, 0x07, 0x00, 0xf8, 0x07, 0x00, 
    0x00, 0xe0, 0x1f, 0x00, 0xf4, 0x00, 0x00, 
    0x00, 0x00, 0x0e, 0x00, 0xf8, 0xff, 0xff, 
    0xff, 0xff, 0x1f, 0x00, 0x7a, 0x00, 0x00, 
    0x00, 0x00, 0x1c, 0x00, 0xf8, 0xff, 0xff, 
    0xff, 0xff, 0x1f, 0x00, 0x3d, 0x00, 0x00, 
    0x00, 0x00, 0x38, 0x00, 0xf8, 0xff, 0xff, 
    0xff, 0x87, 0x1f, 0x80, 0x1e, 0x00, 0x00, 
    0x00, 0x00, 0x70, 0x00, 0xf8, 0xff, 0xff, 
    0xff, 0xb3, 0x1f, 0x40, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x00, 0xfc, 0xff, 0xff, 
    0x0f, 0xb8, 0x1f, 0xa8, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x03, 0xfa, 0xff, 0xff, 
    0xe3, 0x9d, 0x5f, 0xd5, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x4f, 0xfd, 0xff, 0xff, 
    0xfb, 0xcf, 0xbf, 0xfa, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xbe, 0xfe, 0xff, 0xff, 
    0xc9, 0xe7, 0x7f, 0x7d, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
    0xcd, 0xef, 0xff, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
    0xfd, 0xef, 0xff, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xfd, 0xef, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xfd, 0xef, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xf9, 0xe7, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xfb, 0xf7, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xe3, 0xf1, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0x0f, 0xfc, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 
    0xc0, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x01, 
    0x80, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xf9, 
    0x9f, 0x00, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xf9, 
    0x9f, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xf9, 
    0x9f, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0xf9, 
    0x9f, 0x00, 0xe8, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xf9, 
    0x9f, 0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xf9, 
    0x9f, 0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xf9, 
    0x9f, 0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf9, 
    0x9f, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 
    0x80, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x03, 
    0xc0, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xec, 0xff, 0xff, 
    0xff, 0xff, 0x37, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 
    0xff, 0xff, 0x39, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xfe, 0xff, 
    0xff, 0x7f, 0x70, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xfc, 0xff, 
    0xff, 0x3f, 0x68, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xf8, 0xff, 
    0xff, 0x1f, 0x70, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xf0, 0xff, 
    0xff, 0x0f, 0x68, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0xff, 
    0xff, 0x07, 0xd0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0xff, 
    0xff, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xa0, 0xff, 
    0xff, 0x01, 0xd0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0x40, 0xff, 
    0xff, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0x03, 
    0xc0, 0x00, 0xd0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x40, 0x03, 
    0xc0, 0x00, 0xa0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0xff, 
    0xff, 0x01, 0xd0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xd0, 0xff, 
    0xff, 0x01, 0xa0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0xff, 
    0xff, 0x01, 0xc0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x01, 0xd0, 0xff, 
    0xff, 0x01, 0xa0, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0x01, 0xe8, 0xff, 
    0xff, 0x03, 0xc0, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0x01, 0xd0, 0xff, 
    0xff, 0x03, 0xa0, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x01, 0xe8, 0xff, 
    0xff, 0x03, 0xc0, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0x01, 0xd0, 0xff, 
    0xff, 0x03, 0xa0, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0x03, 0xe8, 0xff, 
    0xff, 0x07, 0xc0, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0x0f, 0xf0, 0xff, 
    0xff, 0x0f, 0xf0, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x3f, 0xfe, 0x9f, 0xff, 
    0xff, 0xf9, 0x7f, 0xfc, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0xf8, 0x4f, 0xff, 
    0xff, 0xf0, 0x1f, 0xf8, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xa0, 0xff, 
    0xff, 0x00, 0x00, 0xf4, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xd0, 0xff, 
    0xff, 0x01, 0x00, 0xfa, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xe8, 0xff, 
    0xff, 0x03, 0x00, 0xfd, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xf4, 0xff, 
    0xff, 0x0f, 0x80, 0xfa, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x3f, 0x80, 0xfa, 0xff, 
    0xff, 0x1f, 0x50, 0xfd, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x7f, 0x55, 0xfd, 0xff, 
    0xff, 0xbf, 0xaa, 0xfe, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
    0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00}, 
  
  
  {
    /* Bitmap x=336 y=0 w=112 h=144 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 
    0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
    0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
    0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x55, 
    0x55, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xbf, 0xaa, 
    0xaa, 0xfa, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x57, 0x55, 
    0x55, 0xd5, 0x1f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xaa, 0xaa, 
    0xaa, 0xaa, 0x7e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x5f, 0x55, 0x55, 
    0x55, 0x55, 0xf5, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0xab, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xea, 0x03, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x55, 0x55, 0x55, 
    0x55, 0x55, 0x55, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf0, 0x82, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xaa, 0x0e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x78, 0x01, 0x55, 0x55, 
    0x55, 0x55, 0x55, 0x1d, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xbc, 0x80, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xaa, 0x3a, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x5e, 0x00, 0x55, 0x55, 
    0x55, 0x55, 0x55, 0x75, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x2f, 0x80, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xaa, 0xea, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x57, 0x40, 0xf5, 0xff, 
    0xff, 0x57, 0x55, 0xd5, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x2b, 0xa0, 0xfe, 0xff, 
    0xff, 0xbf, 0xaa, 0xaa, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x55, 0xd0, 0x3f, 0x00, 
    0x00, 0xfc, 0x55, 0xd5, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xaa, 0xea, 0x07, 0x00, 
    0x00, 0xe0, 0xaf, 0xaa, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x55, 0xfd, 0x00, 0x00, 
    0x00, 0x00, 0x5f, 0x55, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xaa, 0x3e, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xaa, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xd5, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xd5, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xea, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xab, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xd5, 0x00, 0xf0, 0x03, 
    0xc0, 0x0f, 0x00, 0xd7, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x6a, 0x00, 0xf8, 0x07, 
    0xe0, 0x1f, 0x00, 0xee, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x75, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xd6, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x6a, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xee, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x75, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xd6, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x6a, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xee, 0x07, 0x00, 0x00, 
    0x00, 0x1e, 0x7e, 0x75, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xd6, 0x7f, 0x78, 0x00, 
    0x00, 0x3f, 0xff, 0x6a, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xee, 0xff, 0xfc, 0x00, 
    0x80, 0x73, 0x7b, 0x75, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xd6, 0xcf, 0xce, 0x01, 
    0xc0, 0xe1, 0xf1, 0x6a, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xee, 0x87, 0x87, 0x03, 
    0xe0, 0xc0, 0x69, 0x75, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xd6, 0x87, 0x03, 0x07, 
    0x60, 0x80, 0xf1, 0x6a, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xee, 0x87, 0x01, 0x06, 
    0x60, 0x00, 0x68, 0x75, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xd6, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0xf0, 0x6a, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xee, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0x68, 0x75, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xd6, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0xf0, 0x6a, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xee, 0x07, 0x00, 0x07, 
    0x60, 0x00, 0x68, 0x75, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xf6, 0x07, 0x80, 0x06, 
    0xe0, 0x00, 0xf4, 0xea, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xef, 0x0f, 0x40, 0x07, 
    0xc0, 0x01, 0xfe, 0xd5, 0x01, 0xf8, 0x07, 
    0xe0, 0x1f, 0x80, 0xf7, 0x3f, 0xa0, 0x03, 
    0x80, 0x03, 0xff, 0xab, 0x03, 0xf0, 0x03, 
    0xc0, 0x0f, 0xc0, 0xfb, 0xff, 0xd5, 0x01, 
    0x00, 0xff, 0xf7, 0x55, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xfd, 0xef, 0xff, 0x00, 
    0x00, 0xfe, 0xe9, 0xab, 0x3e, 0x00, 0x00, 
    0x00, 0x00, 0xfc, 0xfe, 0x87, 0x7f, 0x00, 
    0x00, 0x18, 0xd0, 0x57, 0xfd, 0x00, 0x00, 
    0x00, 0x00, 0x5f, 0xff, 0x03, 0x1c, 0x00, 
    0x00, 0x18, 0xa0, 0xaf, 0xea, 0x03, 0x00, 
    0x00, 0xc0, 0xaf, 0xff, 0x01, 0x1a, 0x00, 
    0x00, 0x18, 0x40, 0x7f, 0xd5, 0xff, 0xff, 
    0xff, 0xff, 0xd5, 0xff, 0x00, 0x1d, 0x00, 
    0x00, 0x38, 0x80, 0xfe, 0xaa, 0xfe, 0xff, 
    0xff, 0xff, 0xea, 0x7f, 0x00, 0x1e, 0x00, 
    0x00, 0x30, 0x00, 0xfd, 0x55, 0x55, 0x55, 
    0x55, 0x55, 0xfd, 0x3f, 0x00, 0x0d, 0x00, 
    0x00, 0x30, 0x00, 0xfa, 0xaf, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xfe, 0x1f, 0x80, 0x0e, 0x00, 
    0x00, 0x70, 0x00, 0xf4, 0x5f, 0x55, 0x55, 
    0x55, 0xd5, 0xff, 0x0f, 0x00, 0x0f, 0x00, 
    0x00, 0x60, 0x00, 0xe8, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x03, 0x80, 0x06, 0x00, 
    0x00, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x00, 0x40, 0x07, 0x00, 
    0x00, 0xc0, 0x00, 0x00, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0x7f, 0x00, 0xa0, 0x03, 0x00, 
    0x00, 0xc0, 0x01, 0x00, 0xfc, 0xff, 0xff, 
    0xff, 0xff, 0x3f, 0x00, 0xd0, 0x03, 0x00, 
    0x00, 0x80, 0x03, 0x00, 0xf8, 0xff, 0xff, 
    0xff, 0xff, 0x1f, 0x00, 0xe8, 0x01, 0x00, 
    0x00, 0x00, 0x07, 0x00, 0x78, 0xff, 0xff, 
    0xff, 0xff, 0x1f, 0x00, 0xf4, 0x00, 0x00, 
    0x00, 0x00, 0x0e, 0x00, 0xf8, 0xfe, 0xff, 
    0xff, 0xbf, 0x1f, 0x00, 0x7a, 0x00, 0x00, 
    0x00, 0x00, 0x1c, 0x00, 0x78, 0x55, 0x55, 
    0x55, 0x05, 0x1f, 0x00, 0x3d, 0x00, 0x00, 
    0x00, 0x00, 0x38, 0x00, 0xf8, 0xaa, 0xaa, 
    0xaa, 0x22, 0x1f, 0x80, 0x1e, 0x00, 0x00, 
    0x00, 0x00, 0x70, 0x00, 0x78, 0x55, 0x55, 
    0x55, 0x71, 0x1f, 0x40, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x00, 0xfc, 0xaa, 0xaa, 
    0x02, 0x38, 0x1f, 0xa8, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x03, 0x7a, 0x55, 0x55, 
    0xf1, 0x1d, 0x5f, 0xd5, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x4f, 0xbd, 0xaa, 0xaa, 
    0xf8, 0x8f, 0xbf, 0xfa, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xbe, 0x5e, 0x55, 0x55, 
    0xcd, 0x47, 0x7f, 0x7d, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0xaf, 0xaa, 0xaa, 
    0xcc, 0xaf, 0xff, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x57, 0x55, 0x55, 
    0xfd, 0x4f, 0xff, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xaa, 0xaa, 
    0xfc, 0xaf, 0xfe, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0x55, 0x55, 
    0xfd, 0x4f, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xaa, 0xaa, 
    0xf8, 0xaf, 0xfe, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0x55, 0x55, 
    0xf9, 0x47, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xaa, 0xaa, 
    0xe2, 0xa3, 0xfe, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0x55, 0x55, 
    0x05, 0x50, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xfe, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0x55, 0x55, 
    0x55, 0x55, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xaa, 0xaa, 
    0xaa, 0xaa, 0xfe, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0x55, 0xfd, 
    0x7f, 0x55, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xaa, 0xfe, 
    0xff, 0xaa, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 
    0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 
    0xe0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 
    0xe0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 
    0xe0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x07, 
    0xe0, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x78, 0x55, 0xff, 
    0x7f, 0xd5, 0x1f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xaa, 0xfe, 
    0xbf, 0xea, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xec, 0x57, 0x55, 
    0x55, 0xf5, 0x37, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x8c, 0xaf, 0xaa, 
    0xaa, 0xfa, 0x39, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x5e, 0x55, 
    0x55, 0x7d, 0x70, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xbc, 0xaa, 
    0xaa, 0x3e, 0x68, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x78, 0x55, 
    0x55, 0x1f, 0x70, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xf0, 0xaa, 
    0xea, 0x0f, 0x68, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0xff, 
    0xff, 0x07, 0xd0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0xff, 
    0xff, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0xa0, 0xff, 
    0xff, 0x01, 0xd0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0x40, 0xff, 
    0xff, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0x03, 
    0xc0, 0x00, 0xd0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x40, 0x03, 
    0xc0, 0x00, 0xa0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0xff, 
    0xff, 0x01, 0xd0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xd0, 0xff, 
    0xff, 0x01, 0xa0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0xa0, 0xff, 
    0xff, 0x01, 0xc0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x01, 0xd0, 0xff, 
    0xff, 0x01, 0xa0, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0x01, 0xe8, 0xff, 
    0xff, 0x03, 0xc0, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0x01, 0xd0, 0xff, 
    0xff, 0x03, 0xa0, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x01, 0xe8, 0xff, 
    0xff, 0x03, 0xc0, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0x01, 0xd0, 0xff, 
    0xff, 0x03, 0xa0, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0x03, 0xe8, 0xff, 
    0xff, 0x07, 0xc0, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0x0f, 0xf0, 0xff, 
    0xff, 0x0f, 0xf0, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x3f, 0xfe, 0x9f, 0xff, 
    0xff, 0xf9, 0x7f, 0xfc, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0xf8, 0x4f, 0xff, 
    0xff, 0xf0, 0x1f, 0xf8, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xa0, 0xff, 
    0xff, 0x00, 0x00, 0xf4, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xd0, 0xff, 
    0xff, 0x01, 0x00, 0xfa, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xe8, 0xff, 
    0xff, 0x03, 0x00, 0xfd, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xf4, 0xff, 
    0xff, 0x0f, 0x80, 0xfa, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x3f, 0x80, 0xfa, 0xff, 
    0xff, 0x1f, 0x50, 0xfd, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x7f, 0x55, 0xfd, 0xff, 
    0xff, 0xbf, 0xaa, 0xfe, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
    0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00}, 
  
  
  {
    /* Bitmap x=448 y=0 w=112 h=144 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 
    0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 
    0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
    0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
    0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xfe, 0x55, 
    0x55, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0xbf, 0xaa, 
    0xaa, 0xfa, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x60, 0x66, 0x43, 0x55, 
    0x55, 0xc5, 0x1f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x70, 0xa0, 0xaa, 
    0xaa, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x30, 0x40, 0x55, 
    0x55, 0x05, 0xf0, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0xaa, 0x02, 0xc0, 0x03, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x38, 0xc0, 0x41, 0x55, 
    0x55, 0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x38, 0xc0, 0xa1, 0xaa, 
    0xaa, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x55, 
    0x55, 0x05, 0x00, 0x1c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xcc, 0x30, 0xa0, 0xaa, 
    0xaa, 0x02, 0x00, 0x38, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xee, 0x70, 0x40, 0x55, 
    0x55, 0x05, 0x00, 0x70, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x67, 0x66, 0xa0, 0xaa, 
    0xaa, 0x02, 0x00, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x03, 0x06, 0xe0, 0xff, 
    0xff, 0x07, 0x00, 0xc0, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x01, 0x06, 0xfc, 0xff, 
    0xff, 0x3f, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x01, 0x80, 0x3f, 0x00, 
    0x00, 0xfc, 0x01, 0x80, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x00, 0xe0, 0x07, 0x00, 
    0x00, 0xe0, 0x07, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x00, 0xf8, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0x00, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x00, 0x3e, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0x80, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x80, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0x01, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xc0, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x83, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0xe0, 0x00, 0xf0, 0x03, 
    0xc0, 0x0f, 0x00, 0x47, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xf8, 0x07, 
    0xe0, 0x1f, 0x00, 0x86, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0x46, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0x86, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x06, 0x00, 0x00, 
    0x00, 0x1e, 0x7e, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x7f, 0x78, 0x00, 
    0x00, 0x3f, 0x7f, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0xfe, 0xfc, 0x00, 
    0x80, 0x73, 0x7b, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0xcf, 0xce, 0x01, 
    0xc0, 0xe1, 0x71, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x86, 0x87, 0x03, 
    0xe0, 0xc0, 0x69, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x87, 0x03, 0x07, 
    0x60, 0x80, 0x71, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x86, 0x01, 0x06, 
    0x60, 0x00, 0x68, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0x70, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x86, 0x06, 0x00, 0x06, 
    0x60, 0x00, 0x68, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0x46, 0x07, 0x00, 0x06, 
    0x60, 0x00, 0x70, 0x60, 0x00, 0xfe, 0x1f, 
    0xf8, 0x7f, 0x00, 0xa6, 0x06, 0x00, 0x07, 
    0x60, 0x00, 0x68, 0x60, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0x46, 0x07, 0x80, 0x06, 
    0xe0, 0x00, 0xf4, 0xe0, 0x00, 0xfc, 0x0f, 
    0xf0, 0x3f, 0x00, 0xa7, 0x0f, 0x40, 0x07, 
    0xc0, 0x01, 0xfe, 0xc0, 0x01, 0xf8, 0x07, 
    0xe0, 0x1f, 0x80, 0x53, 0x3f, 0xa0, 0x03, 
    0x80, 0x03, 0xff, 0x81, 0x03, 0xf0, 0x03, 
    0xc0, 0x0f, 0xc0, 0xa9, 0xff, 0xd5, 0x01, 
    0x00, 0xff, 0xff, 0x01, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xf0, 0xd4, 0xff, 0xff, 0x00, 
    0x00, 0xfe, 0xfb, 0x03, 0x3e, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0xea, 0xaf, 0x7f, 0x00, 
    0x00, 0x58, 0xf5, 0x07, 0xf8, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0xf5, 0x57, 0x1d, 0x00, 
    0x00, 0xb8, 0xea, 0x0f, 0xe0, 0x03, 0x00, 
    0x00, 0xc0, 0x87, 0xfa, 0xab, 0x1e, 0x00, 
    0x00, 0x58, 0xd5, 0x5f, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0x41, 0xfd, 0x55, 0x1f, 0x00, 
    0x00, 0xb8, 0xaa, 0xbf, 0x00, 0xfe, 0xff, 
    0xff, 0x7f, 0xa0, 0xfe, 0xaa, 0x1f, 0x00, 
    0x00, 0x70, 0x55, 0x7f, 0x01, 0x40, 0x55, 
    0x55, 0x05, 0x50, 0x7f, 0x55, 0x0f, 0x00, 
    0x00, 0xb0, 0xaa, 0xfe, 0x0a, 0xa0, 0xaa, 
    0xaa, 0x0a, 0xaa, 0xbf, 0xaa, 0x0f, 0x00, 
    0x00, 0x70, 0x55, 0xfd, 0x17, 0x40, 0x55, 
    0x55, 0x45, 0xd5, 0x5f, 0xd5, 0x0f, 0x00, 
    0x00, 0xe0, 0xaa, 0xfa, 0xaf, 0xea, 0xff, 
    0xff, 0xbf, 0xfa, 0xab, 0xaa, 0x07, 0x00, 
    0x00, 0xe0, 0x55, 0x55, 0x7f, 0xb5, 0xaa, 
    0xaa, 0x5a, 0xfd, 0x55, 0xd5, 0x07, 0x00, 
    0x00, 0xc0, 0xaa, 0xaa, 0xfe, 0xeb, 0xff, 
    0xff, 0xff, 0xff, 0xaa, 0xea, 0x03, 0x00, 
    0x00, 0xc0, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0xf5, 0x03, 0x00, 
    0x00, 0x80, 0xab, 0xaa, 0xfa, 0xff, 0xff, 
    0xff, 0xff, 0xbf, 0xaa, 0xfa, 0x01, 0x00, 
    0x00, 0x00, 0x57, 0x55, 0x7d, 0xff, 0xff, 
    0xff, 0xff, 0x5e, 0x55, 0xfd, 0x00, 0x00, 
    0x00, 0x00, 0xae, 0xaa, 0x7a, 0xfc, 0xff, 
    0xff, 0x3f, 0xbf, 0xaa, 0x7e, 0x00, 0x00, 
    0x00, 0x00, 0x5c, 0x55, 0x7d, 0x00, 0x00, 
    0x00, 0x00, 0x5e, 0x55, 0x3f, 0x00, 0x00, 
    0x00, 0x00, 0xb8, 0xaa, 0x7a, 0x00, 0x00, 
    0x00, 0x00, 0xbf, 0xaa, 0x1f, 0x00, 0x00, 
    0x00, 0x00, 0x70, 0x55, 0x7d, 0x00, 0x00, 
    0x00, 0x30, 0x5e, 0xd5, 0x0f, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0xaa, 0x7e, 0x00, 0x00, 
    0x00, 0x38, 0xbf, 0xfa, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x57, 0x3f, 0x00, 0x00, 
    0xe0, 0x1d, 0xfe, 0xff, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xef, 0x3f, 0x00, 0x00, 
    0xf8, 0x0f, 0xfd, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x1f, 0x00, 0x00, 
    0xc8, 0x07, 0xfa, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 
    0xcc, 0x0f, 0xf5, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 
    0xfc, 0x0f, 0xea, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 
    0xfc, 0x0f, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xfc, 0x0f, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xf8, 0x07, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xf8, 0x07, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0xe0, 0x01, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xd4, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xfc, 
    0x3f, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xfe, 
    0x7f, 0x00, 0xd5, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x57, 
    0xf5, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xaf, 
    0xea, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x57, 
    0xf5, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xaf, 
    0xea, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x57, 
    0xf5, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xaf, 
    0xea, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x57, 
    0xf5, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xaf, 
    0xea, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0xfe, 
    0x7f, 0x40, 0x1d, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xfc, 
    0x3f, 0xa0, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x00, 
    0x00, 0xd0, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xac, 0x07, 0x00, 
    0x00, 0xe8, 0x3b, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x5e, 0x0f, 0x00, 
    0x00, 0x74, 0x7d, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xae, 0x1e, 0x00, 
    0x00, 0xba, 0x7a, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x56, 0x3d, 0x00, 
    0x00, 0x5d, 0x7d, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xae, 0x7a, 0x00, 
    0x80, 0xae, 0x7a, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x57, 0xf5, 0x55, 
    0x55, 0x57, 0xf5, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xab, 0xea, 0xab, 
    0xaa, 0xab, 0xfa, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x57, 0xf5, 0xff, 
    0xff, 0x55, 0xf5, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xab, 0xea, 0xff, 
    0xff, 0xaa, 0xfa, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0xf5, 0x03, 
    0xc0, 0x55, 0xf5, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xea, 0x03, 
    0xc0, 0xaa, 0xfa, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0xf5, 0xff, 
    0xff, 0x55, 0xf5, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xab, 0xfa, 0xff, 
    0xff, 0xab, 0xea, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x55, 0xf5, 0xff, 
    0xff, 0x55, 0xf5, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0xab, 0xfa, 0xff, 
    0xff, 0xab, 0xea, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0x55, 0xfd, 0xff, 
    0xff, 0x57, 0xf5, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0xab, 0xfa, 0xff, 
    0xff, 0xab, 0xea, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x55, 0xfd, 0xff, 
    0xff, 0x57, 0xf5, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0xab, 0xfa, 0xff, 
    0xff, 0xab, 0xea, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0x57, 0xfd, 0xff, 
    0xff, 0x57, 0xf5, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xff, 0xaf, 0xfa, 0xff, 
    0xff, 0xaf, 0xfa, 0xff, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x3f, 0xfe, 0x9f, 0xff, 
    0xff, 0xf9, 0x7f, 0xfc, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0xf8, 0x4f, 0xff, 
    0xff, 0xf0, 0x1f, 0xf8, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x80, 0xff, 
    0xff, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0x40, 0xff, 
    0xff, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xa0, 0xff, 
    0xff, 0x00, 0x00, 0xf4, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xe0, 0x0f, 0x00, 0xd0, 0xff, 
    0xff, 0x01, 0x00, 0xfa, 0x07, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xe8, 0xff, 
    0xff, 0x03, 0x00, 0xfd, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x1f, 0x00, 0xf4, 0xff, 
    0xff, 0x0f, 0x80, 0xfa, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x3f, 0x80, 0xfa, 0xff, 
    0xff, 0x1f, 0x50, 0xfd, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x7f, 0x55, 0xfd, 0xff, 
    0xff, 0xbf, 0xaa, 0xfe, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
    0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
    0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00}, 
};
