/*
 * Programm XBLAST V1.04 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 16th 1993
 * started August 1993
 *
 * File: mytypes.h
 * types declarations
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 *  PFV Pointer to void functions
 */

typedef void (*PFV)();



/*
 *  PFV Pointer to void functions
 */

typedef struct {
  int y,x;
} BMPosition;



/*
 * Extra Probabilities
 */

typedef struct 
{
  int bomb;
  int range;
  int ill;
  int invinc;
  int evil;
} BMExtraProb;



/*
 *  Leveldata Struct
 */

typedef struct 
{
  char *name;
  PFV init_func;
  PFV revive_func;
  PFV game_func;
  PFV extra_func;
  PFV key_func;
  BMPosition position[MAX_PLAYER];
  int range,bombs,bomb_dir;  
  BMExtraProb prob;
  int blocks[MAX_BLOCK];
  int shadow;
  int maze[MAZE_W][MAZE_H];
} BMLevelData;  



/*
 * BMPlayer 
 */

typedef struct
{
  int y,x;
  int anime;
  int d_soll,d_ist,d_look;
  int invincible;
  int dying;
  int stunned;
  int illness;
  int illtime;
  int lives;
  int score;
  int range;
  int bombs;
  int remote_control;
  int kick;
  char *name;
  int victories;
} BMPlayer;

  /* types */



typedef struct {
  int type;
  int ysort;
  int x,y;
  int mode;
  int player,anime;
} PlayerSprite;

typedef struct {
  int type;
  int ysort;
  int x,y;
  int mode;
  int anime;
} ExplosionSprite;

typedef struct {
  int type;
  int ysort;
  int x,y;
  int mode;
} AnySprite;

typedef union {
  int             type ;
  AnySprite       any;
  PlayerSprite    player;
  ExplosionSprite expl;
} Sprite;
    


typedef struct explosion {
  int player;
  int range;
  int x,y;
  int dx,dy;  /* small deviations from x and y */
  int dir;    /* Direction */
  int count;
  int blink;
  struct explosion *next;
} Explosion;


typedef struct {
  double x,y;
} BMPoint;


/*
 * Game Statistics
 */

typedef struct {
  int total;
  int draws;
  int timeouts;
} BMGameStat;











