/*
 * Programm XBLAST V1.04 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 16th 1994
 * started August 1993
 *
 * File: include.h
 * constants and macros for all files.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 1; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

  /* constants */
#if 0
#define DOUBLE_SPEED
#endif

#define MAX_PLAYER 4
#define MAX_PS 4

#define LEVEL_MAX 10


#define MAX_ANIME 16
#define WINNER_ANIME 15

#ifdef DOUBLE_SPEED
#define STEP_HORI 16
#define STEP_VERT 12
#else
#define STEP_HORI 8
#define STEP_VERT 6
#endif
#define DEFAULT_DELAY 5


#define MAX_EXPLOSION 18



#define SIZE_OF_SPRITE 414
#define SIZE_OF_WINNER 552
#define SIZE_OF_BLOCK  384
#define SIZE_OF_LED 32
#define SIZE_OF_BIG 2016

#define SIZE_OF_X 16


#define BLOCK_WIDTH 64 
#define BLOCK_HEIGHT 48
#define CHARW 3
#define CHARH 5
#define CHAR_ANIME 7

#define MAZE_W 15
#define MAZE_H 13

#if 0
#define MAZE_X (MAZE_W-2)
#define MAZE_Y (MAZE_H-2)
#endif


#define SPRITE_UP    ( 0 )
#define SPRITE_DOWN  (PIXH - 3 *BLOCK_HEIGHT)
#define SPRITE_LEFT   BLOCK_WIDTH
#define SPRITE_RIGHT (PIXW - 2 * BLOCK_WIDTH)

  /* Blocktypen */


#define BTFree      0
#define BTShadow    1
#define BTBlock     2
#define BTBlockRise 3
#define BTExtra     4
#define BTExtraOpen 5
#define BTBomb      6
#define BTRange     7
#define BTSick      8
#define BTSpecial   9
#define BTEvil      10 /* No Real Block, */

#define MAX_BLOCK 10

#define Healthy 0
#define IllBomb 1
#define IllSlow 2
#define IllRun 3
#define IllMini 4
#define IllEmpty 5
#define MAX_ILL 5


#define ILL_X 32
#define ILL_Y 32
#define ILLTIME 256
#define BOMB_PROB 32

  /* Scorebitmaps */

#define SBVoid      0
#define SBTextLeft  1
#define SBTextMid   2
#define SBTextRight 3
#define SBDead      4
#define SBSick      8
#define SBPlayer    12
#define SBLives     (SBPlayer + MAX_PLAYER)

#define MAX_SCORE_TILES (SBLives + 1)

#define MAX_EXTRA   2

  /* SpriteTypen */

#define STPlayer 0
#define STExplosion 1

  /* ExitMasks fuer wait_event */

#define EMKey    (01<<0)
#define EMExpose (01<<1)

  /* Walk-Directions */

#define GoStop (-1)
#define GoUp    0
#define GoLeft  1
#define GoDown  2
#define GoRight 3

  /* extras */

#define EXNone 0




  /* Makros */



#define MAX(a,b) ( (a)>=(b) ? (a) : (b) )
#define MIN(a,b) ( (a)<=(b) ? (a) : (b) )
#define ABS(a)   ( (a)>=0 ? (a) : (-(a)) )














