  global GraphWindows
  set n [Unique]
  set win .graph$n
  set GraphWindows [linsert $GraphWindows 0 $win]

  LinkWindow $head.graph $win
  LinkWindow $win.head $head

# catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  bind $win <Visibility> {[WindowLink %W.graphview] Visible [string compare %s FullyObscured]}
  bind $win <Map> {[WindowLink %W.graphview] Visible 1}
  bind $win <Unmap> {[WindowLink %W.graphview] Visible 0}

  wm title $win {SimCity Graph}
  wm iconname $win {SimCity Graph}
  wm group $win $head
  wm geometry $win 550x200+440-5
  wm positionfrom $win user
# wm withdraw $win
  wm maxsize $win 2000 2000
  wm minsize $win 150 85
  wm protocol $win WM_DELETE_WINDOW "DeleteWindow graph GraphWindows $win"


  frame $win.centerframe\
    -borderwidth 2\
    -relief raised

  graphview $win.centerframe.graph\
    -font [Font $win Small]
  LinkWindow $win.centerframe.graph.pallet $win.leftframe
  LinkWindow $win.graphview $win.centerframe.graph

  pack append $win.centerframe\
    $win.centerframe.graph {top frame center fill expand}

  frame $win.leftframe\
    -borderwidth 2\
    -relief raised

  frame $win.leftframe.left\
    -borderwidth 0

  button $win.leftframe.left.res\
    -bitmap "@images/grres.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphPallet $win 0"

  button $win.leftframe.left.com\
    -bitmap "@images/grcom.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphPallet $win 1"

  button $win.leftframe.left.ind\
    -bitmap "@images/grind.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphPallet $win 2"

  pack append $win.leftframe.left\
    $win.leftframe.left.res	{top frame center padx 2 pady 2} \
    $win.leftframe.left.com	{top frame center padx 2 pady 2} \
    $win.leftframe.left.ind	{top frame center padx 2 pady 2}

  frame $win.leftframe.right\
    -borderwidth 0

  button $win.leftframe.right.money\
    -bitmap "@images/grmony.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphPallet $win 3"

  button $win.leftframe.right.crime\
    -bitmap "@images/grcrim.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphPallet $win 4"

  button $win.leftframe.right.pollution\
    -bitmap "@images/grpoll.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphPallet $win 5"

  pack append $win.leftframe.right\
    $win.leftframe.right.money		{top frame center padx 2 pady 2} \
    $win.leftframe.right.crime		{top frame center padx 2 pady 2} \
    $win.leftframe.right.pollution	{top frame center padx 2 pady 2}

  frame $win.leftframe.year\
    -borderwidth 0

  button $win.leftframe.year.year10\
    -bitmap "@images/gr10.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphYearPallet $win 0"

  button $win.leftframe.year.year120\
    -bitmap "@images/gr120.xpm"\
    -borderwidth 0\
    -relief flat\
    -padx 0\
    -pady 0\
    -text {}\
    -command "GraphYearPallet $win 1"

  pack append $win.leftframe.year\
    $win.leftframe.year.year10	{top frame center} \
    $win.leftframe.year.year120	{top frame center} \

  pack append $win.leftframe\
    $win.leftframe.year		{top frame center padx 2 pady 2} \
    $win.leftframe.left		{left frame center} \
    $win.leftframe.right	{right frame center} \


  frame $win.bottomframe\
    -borderwidth 0

  button $win.bottomframe.button\
    -text {Dismiss}\
    -command "wm withdraw $win"

  pack append $win.bottomframe\
    $win.bottomframe.button   {top frame center expand fillx}

  pack append $win\
    $win.bottomframe	{bottom frame center fillx}\
    $win.leftframe	{left frame center filly} \
    $win.centerframe	{right frame center expand fill}

  InitGraph $win

  update idletasks
  return $win
