
#include <global.h>
#include <object.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <skills.h>
#include <spells.h>


/* Don't change the order here w/o changing the skills.h file */

skill skills[] = {
    { "stealing", 0, 0 }, 
    { "lockpicking", 0, 0 }, 
    { "hiding", 0, 0 }, 
    { "smithery", 0, 0 }, 
    { "bowyer", 0, 0 }, 
    { "jewelery", 0, 0 }, 
    { "alchemy", 0, 0 }, 
    { "thaumaturgy", 0, 0 }, 
    { "literacy", 0, 0 }, 
    { "bargaining", 0, 0 },
    { "jumping", 0, 0 }
#if 0
    { "swordsmanship" },
    { "herblore" },
#endif
};

/* Initial coding: 6 Sep 1994, Nick Williams (njw@cs.city.ac.uk) */

/* Generalized code + added hiding and lockpicking skills, */
/* March 3, 1995, brian thomas (thomas@nomad.astro.psu.edu) */

/* 
 * When stealing: dependent on the intelligence/wisdom of whom you're
 * stealing from (op in attempt_steal), offset by your dexterity and
 * skill at stealing. They may notice your attempt, whether successful
 * or not. 
 */
int
attempt_steal(object* op, object* who)
{
    object* success = 0;	/* did we get anything? */
    int alarmed = 0;		/* was the thief caught? */
    object* tmp;
    object* next;

    if (op->type == PLAYER || QUERY_FLAG(op, FLAG_MONSTER)) {
	/* Go thru their inventory, stealing */
	for(tmp = op->inv; tmp != NULL; tmp = next) {
	    next = tmp->below;
	    /* you can't steal worn items, or innate abilities */
	    if (QUERY_FLAG(tmp, FLAG_APPLIED) || tmp->type == ABILITY) {
		continue;
	    }
	    /* Okay, try stealing this item. Dependent on dexterity of thief */
	    /* NYI: Also, dependent on value of thievery skill */
	    /* The current calculation gives a random number around 15 */
	    if ((RANDOM()%30+RANDOM()%30)/2 < (who->stats.Dex)) {
		pick_up(who, tmp);
		/* If you steal something heavy off them, they're bound to notice */
		if (tmp->weight > (200*(RANDOM()%who->stats.Dex)-(RANDOM()*5+1))) {
		    alarmed = 1;
		}
		success = tmp;
		break;
	    }
	}
    }
    if (alarmed || RANDOM()%25 > who->stats.Dex) {
	/* play_sound("stop! thief!"); kindofthing */
	if (op->type != PLAYER) {
	    /* The unaggressives look after themselves 8) */
	    CLEAR_FLAG(op, FLAG_UNAGGRESSIVE);
	    npc_call_help(op);
	} else {
	    char buf[MAX_BUF];
	    /* Notify the other player */
	    if (success && who->stats.Int > RANDOM()%20) {
		sprintf(buf, "Your %s has gone missing!", query_name(success));
	    } else {
		sprintf(buf, "Your pack feels strangely lighter.");
	    }
	    new_draw_info(NDI_UNIQUE, 0,op,buf);
	    if (!success) {
		if (who->invisible) {
		    sprintf(buf, "you feel itchy fingers getting at your pack.");
		} else {
		    sprintf(buf, "%s looks very shifty.", query_name(who));
		}
		new_draw_info(NDI_UNIQUE, 0,op,buf);
	    }
	}
    }
    return success? 1:0;
}

void steal(object* op, int dir)
{
    object *tmp, *next;
    int x = op->x + freearr_x[dir];
    int y = op->y + freearr_y[dir];
 
    if(dir == 0) {
	/* Can't steal from ourself! */
	return;
    }

    if(wall(op->map,x,y)) {
	return;
    }

    /* Find the topmost object at this spot */
    for(tmp = get_map_ob(op->map,x,y);
	tmp != NULL && tmp->above != NULL;
        tmp = tmp->above);

    /* For all the stacked objects at this point, attempt a steal */
    for(; tmp != NULL; tmp = next) {
      next = tmp->below;
      if (attempt_steal(tmp, op)) {
	  /* Break out here, coz one success is enough */
	  return;
      }
    }
}

/* Implementation by bt. (thomas@nomad.astro.psu.edu) */

void pick_lock(object *pl, int dir)
{
    char buf[MAX_BUF];
    object *tmp; 
    int x = pl->x + freearr_x[dir];
    int y = pl->y + freearr_y[dir];

    if(dir == 0) {
        /* No door/locks on you to pick */
        return;
    }

/* For all the stacked objects at this point find a door*/

    sprintf(buf, "There is no lock there.");

    for(tmp=get_map_ob(pl->map,x,y); tmp; tmp=tmp->above) {
      if(!tmp) continue;
      switch(tmp->type) { 
        case DOOR:
            if (attempt_pick_lock(tmp, pl))
                sprintf(buf, "you pick the lock.");
            else 
                sprintf(buf, "you fail to pick the lock.");
	    break;
        case LOCKED_DOOR: 
            sprintf(buf, "you can't pick that lock!");
	    break;
   	default: 
	    break;
      }
    }
    new_draw_info(NDI_UNIQUE, 0,pl,buf);
}      

int attempt_pick_lock ( object *door, object *pl)
{
    int bonus = (pl->level /5), difficulty= pl->map->difficulty ? 
	pl->map->difficulty : 0;
    int success = 0, number;        /* did we get anything? */

  /* Try to pick the lock on this item (doors only for now). 
   * Dependent on dexterity/level of the player and  
   * the map level difficulty. 
   */

    number = (RANDOM()%30+RANDOM()%30)/2; 
    if (number < ((pl->stats.Dex + bonus) - difficulty)) { 
      remove_door(door);
      success = 1;
    } else if (door->inv && door->inv->type==RUNE) {  /* set off any traps? */ 
		spring_trap(door->inv,pl); 	       
    } 
    return success;
}

/* HIDE PLAYER CODE . RIght now, player becomes 'invisible' for
 * a short while (success and duration dependant on player level,
 * dexterity, charisma, level and map difficulty
 * Players have a good chance of becomeing 'unhidden' if they move
 * and like invisiblity will be come visible if they attack
 * Implemented by b.t. (thomas@nomad.astro.psu.edu)
 */ 

void hide(object *pl) {
  char buf[MAX_BUF];
  int level=(pl->level); 

  if(pl->type!=PLAYER) return;  /* only players may hide right now */ 

/* the preliminaries -- Can we really hide now? */
/* this keeps players from using invisibilty spells and hiding */

  if (QUERY_FLAG(pl, FLAG_MAKE_INVIS)) {
        sprintf(buf,"You don't need to hide while invisible!");
        new_draw_info(NDI_UNIQUE, 0,pl,buf);
        return;
  } else if (!pl->hide && pl->invisible>0) { 
        sprintf(buf,"Your attempt to hide breaks the invisibility spell!"); 
        pl->invisible= 0;
        pl->contr->tmp_invis=0;
	if(QUERY_FLAG(pl, FLAG_UNDEAD)) CLEAR_FLAG(pl, FLAG_UNDEAD);
        new_draw_info(NDI_UNIQUE, 0,pl,buf);
	update_object(pl);
        return;
  } 
 
  if(pl->hide && pl->invisible>30*level) {
       sprintf(buf, "You are as well hidden as you can get."); 
       new_draw_info(NDI_UNIQUE, 0,pl,buf);
       return;
  }
  
  if(attempt_hide(pl)) { 
     sprintf(buf, "You hide in the shadows.");
     update_object(pl);
  } else
     sprintf(buf, "You fail to hide.");

  new_draw_info(NDI_UNIQUE, 0,pl,buf);
}

int attempt_hide(object *pl) {
  int level=(pl->level)/5, difficulty=pl->map->difficulty;
  int number,dexterity=pl->stats.Dex;
  int success = 0,charisma=(pl->stats.Cha)/2;        

/*  Hiding success and duration dependant on player level,
 *  dexterity, charisma, level and map difficulty
 */

    number = (RANDOM()%40+RANDOM()%40)/2;
    if (number < (dexterity + level - difficulty - charisma)) {
	success = 1;
	pl->invisible+= 100 + level*dexterity;  /* set the level of 'hiddeness' */
	pl->contr->tmp_invis=1;
	pl->hide=1;
    }
    return success;
}

void
jump(object *pl, int dir) 
{
 char buf[MAX_BUF];
 int spaces=0,stats=((pl->stats.Str)
	*(pl->stats.Str)*(pl->stats.Str)*(pl->stats.Dex));

 	if(pl->type!=PLAYER) return;  /* only players may jump right now */

 	if(pl->carrying!=0)		/* don't want div by zero !! */	 
	     spaces=(int) (stats/pl->carrying);
 	else
		spaces=2;	/* pl has no objects - gets the far jump */ 

 	if(spaces>2)
		 spaces = 2;
 	else if(spaces==0) {
		sprintf(buf, "You are carrying too much weight to jump.");
  		new_draw_info(NDI_UNIQUE, 0,pl,buf);
		return;
 	}
 	(void) attempt_jump(pl,dir,spaces);
	return;
}

int attempt_jump (object *pl, int dir, int spaces) {
  char buf[MAX_BUF];
  object *tmp;
  int i,dx=freearr_x[dir],dy=freearr_y[dir];

 /* Jump loop. Go through spaces opject wants to jump. Halt the
  * jump if a wall or creature is in the way. We set FLAG_FLYING
  * temporarily to allow player to aviod exits/archs that are not 
  * fly_on, fly_off. This will also prevent pickup of objects 
  * while jumping over them.  
  */ 

  remove_ob(pl);
  SET_FLAG(pl,FLAG_FLYING);
  for(i=0;i<=spaces;i++) { 
      for(tmp=get_map_ob(pl->map,pl->x+dx,pl->y+dy);
        tmp;tmp=tmp->above) { 
	   if(wall(tmp->map,tmp->x,tmp->y)) {           /* Jump into wall*/ 
	     sprintf(buf, "Your jump is blocked.");
             new_draw_info(NDI_UNIQUE, 0,pl,buf);
	     (void) stop_jump(pl,i,spaces);
	     return 0;
	   } 
	   if(QUERY_FLAG(tmp,FLAG_MONSTER)          /* Jump into creature */ 
	            || tmp->type==PLAYER ) {   
	     sprintf(buf, "You jump into%s%s.", 
	       tmp->type == PLAYER ? " " : " the ", tmp->name);
             new_draw_info(NDI_UNIQUE, 0,pl,buf);
	     if(tmp->type!=PLAYER || pl->contr->party_number==-1 ||
		 pl->contr->party_number!=tmp->contr->party_number) 
 	     		(void) attack_ob(tmp,pl);    /* pl makes an attack */ 
	     (void) stop_jump(pl,i,spaces);
	     return 0;
	   }
	   if(tmp->type==EXIT			     /* pl jump through exit */ 
		&& QUERY_FLAG(tmp, FLAG_FLY_ON)) { 
             pl->x+=dx,pl->y+=dy;
	     (void) stop_jump(pl,i,spaces);
	     return 0;
	   }
      }
      if(out_of_map(pl->map,pl->x+dx,pl->y+dy)) {
  		(void) stop_jump(pl,i,spaces);
		return 1;
      } else  
        pl->x+=dx,pl->y+=dy;
  }
  (void) stop_jump(pl,i,spaces);
  return 1;
}
/* End of jump. Clear flags, restore the map, and 
 * freeze the player a while to simulate the exahustion
 * of jumping.
 */

int stop_jump(object *pl, int dist, int spaces) {
 int load=dist/(pl->speed*spaces); 

  CLEAR_FLAG(pl,FLAG_FLYING);
  insert_ob_in_map(pl,pl->map);
  draw(pl);  
  pl->speed_left= (int) -FABS((load*5)+1);
  return 0;
}

/* this code is supposed to allow players to identify classes of
 * objects with the various "auto-ident" skills. Player must have
 * unidentified objects of the right type in order for the skill
 * to work. While multiple classes of objects may be identified, 
 * this code is kind of yucky -- it would be nice to make it a bit
 * more generalized. Right now, skills are embedded in this routine.  
 * by b.t. (thomas@nomad.astro.psu.edu) 
 */

void skill_ident(object *pl) {
  char buf[MAX_BUF];
  int success=0;

	if(!pl->contr->chosen_skill) 	/* should'nt happen.... */ 
		return;

	if(pl->type != PLAYER) return; 	/* only players will skill-identify */

    	sprintf(buf, "You look at the objects you are carrying...");
    	new_draw_info(NDI_UNIQUE, 0,pl,buf);   

	switch (pl->contr->chosen_skill) {
	   case SK_SMITH: 
	      	if(do_skill_ident(pl,WEAPON) || do_skill_ident(pl,ARMOUR)
		    || do_skill_ident(pl,BRACERS) || do_skill_ident(pl,CLOAK)
		    || do_skill_ident(pl,BOOTS) || do_skill_ident(pl,SHIELD)
		    || do_skill_ident(pl,GIRDLE)
		    || do_skill_ident(pl,HELMET) || do_skill_ident(pl,GLOVES))
               		if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                		draw_inventory(pl); 
				success=1;
			}
		break;
	   case SK_BOWYER:
		if(do_skill_ident(pl,BOW) || do_skill_ident(pl,ARROW))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
                break;
	   case SK_ALCHEMY:
                if(do_skill_ident(pl,POTION) || do_skill_ident(pl,POISON)
		    || do_skill_ident(pl,AMULET) || do_skill_ident(pl,CONTAINER))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
		break;
           case SK_JEWELER:
                if(do_skill_ident(pl,GEM))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
                break; 
	   case SK_LITERACY:
                if(do_skill_ident(pl,SPELLBOOK) || do_skill_ident(pl,SCROLL)) 
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
		break;
           case SK_THAUMATURGY:
                if(do_skill_ident(pl,WAND) || do_skill_ident(pl,ROD) 
		    || do_skill_ident(pl,HORN))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
                break;
	   default:
		success=0;
		break;
	} 
	if(!success) {
		sprintf(buf,"...and find nothing you can identify.");
    		new_draw_info(NDI_UNIQUE, 0,pl,buf);
	}
}
 
int do_skill_ident(object *pl, int obj_class) {
  object *tmp;
  int success=0;

/* check the player inventory */
    for(tmp=pl->inv;tmp;tmp=tmp->below)
	if(!QUERY_FLAG(tmp,FLAG_IDENTIFIED) 
	   && need_identify(tmp) 
	   && !tmp->invisible && tmp->type==obj_class) { 
		identify(tmp);
     		if (pl->type==PLAYER) {
        	    new_draw_info_format(NDI_UNIQUE, 0, pl,
                      "You have %s.", long_desc(tmp));
        	    if (tmp->msg) {
          		new_draw_info(NDI_UNIQUE, 0,pl, "The item has a story:");
          		new_draw_info(NDI_UNIQUE, 0,pl, tmp->msg);
        	    }
        	    if (pl->contr->eric_server > 0)
            		esrv_send_item(pl, tmp);
        	}   
	        success = 1;
        }
    return success;
}  
/* Learn skill. This inserts the requested skill in the player's
 * inventory. The 'slaying' feild of the scroll should have the 
 * exact name of the requested archetype (there should be a better way!?)
 * -bt. thomas@nomad.astro.psu.edu
 */

int
learn_skill (object *pl, object *scroll) {
object *tmp,*tmp2;
int i=0;
archetype *skill;

     if((skill=find_archetype(scroll->slaying))==NULL)
           return 8;
     tmp=arch_to_object(skill);
     if(tmp->level>pl->level) return 2;
/* check if player already has it */
     for(tmp2=pl->inv;tmp2;tmp2=tmp2->below) 
	if(!strcmp(tmp2->name,tmp->name)) i++;
     if(i>0) return 0;
/* Everything is cool. Give'em the skill */
     tmp->x=pl->x,tmp->y=pl->y;
     insert_ob_in_ob(tmp,pl);
     if (pl->contr->eric_server > 0)
         esrv_send_item(pl, tmp);
     return 1;
} 
