/*
 * static char *rcsid_structs_h =
 *   "$Id: structs.h,v 1.47 1995/04/15 04:34:52 master Exp master $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1994 Mark Wedel
    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to master@rahul.net
*/

#ifndef STRUCTS_H
#define STRUCTS_H

/* Type defines for specific signed/unsigned variables of a certain number
 * of bits.  Not really used anyplace, but if a certain number of bits
 * is required, these type defines should then be used.  This will make
 * porting to systems that have different sized data types easier.
 *
 * Note: The type defines should just mean that the data type has at
 * least that many bits.  if a uint16 is actually 32 bits, no big deal,
 * it is just a waste of space.
 *
 * Note2:  When using something that is normally stored in a character
 * (ie strings), don't use the uint8/sint8 typdefs, use 'char' instead.
 * The signedness for char is probably not universal, and using char
 * will probably be more portable than sint8/unit8
 */
 
typedef unsigned int	uint32;
typedef signed int	sint32;
typedef unsigned short	uint16;
typedef signed short	sint16;
typedef unsigned char	uint8;
typedef signed char	sint8;

typedef struct sockets {
  struct sockets *next;
  int fd;
  int listen_lev;
  int protocol;		/* Set by protocol command			*/
  char name[9];		/* Username on remote side, terminated by '\0'	*/
  char host[17];	/* 129.250.82.2 format, terminated by '\0'	*/
  LogLevel debug;	/* If 0, no debug will be written (not even errors) */
  unsigned wiz:1;	/* If true, privilegied command can be done	*/
  unsigned use_pix:1;	/* If true, use pixmaps when adding player      */
  unsigned color_pix:1;	/* If true, use color pixmaps when adding player */
  unsigned split:1;	/* If true, use split windows when adding player*/
  unsigned quit:1;	/* If true, the socket will be closed, and exit */
  int sync;		/* Ticks between each sync.  1 = always, 0 = never */
} sockets;

typedef struct liv { /* Mostly used by "alive" objects */
  signed char Str,Dex,Con,Wis,Cha,Int;
  signed char wc,ac;    /* Weapon Class and Armour Class */
  signed short hp;      /* Hit Points. */
  signed short maxhp;
  signed short sp;      /* Spell points.  Used to cast spells. */
  signed short maxsp;	/* Max spell points. */
  signed long exp;      /* Experience.  Killers gain 1/10. */
  signed short food;    /* How much food in stomach.  0 = starved. */
  sint16 dam;		/* How much damage this object does when hitting */
  signed char luck;	/* Affects thaco and ac from time to time */
} living;

#if 0
typedef struct face_struct {
    unsigned short number;
    unsigned char fg, bg;
} Face;
#endif

/* New face structure - this enforces the notion that data is face by
 * face only - you can not change the color of an item - you need to instead
 * create a new face with that color.
 */
typedef struct new_face_struct {
    uint16	number;		/* This is the image id.  IT should be the */
				/* same value as its position in the array */
    uint8	fg, bg;
    char	*name;
    uint8	visibility;
} New_Face;

typedef struct map_look_struct {
    New_Face *face;
    unsigned short flags;
} MapLook;

typedef struct obj {
/* These variables are not changed by copy_object(): */
  struct pl *contr;    /* Pointer to the player which control this object */
  struct obj *next;    /* Pointer to the next object in the free/used list */
  struct obj *prev;    /* Pointer to the previous object in the free/used list*/
  struct obj *active_next;	/* Next & previous object in the 'active' */
  struct obj *active_prev;	/* List.  This is used in process_events */
				/* so that the entire object list does not */
				/* need to be gone through. */
  struct obj *below;   /* Pointer to the object stacked below this one */
  struct obj *above;   /* Pointer to the object stacked above this one */
	         /* Note: stacked in the *same* environment*/
  struct obj *inv;     /* Pointer to the first object in the inventory */
  struct obj *container; /* Current container being used */
  struct obj *env;     /* Pointer to the object which is the environment */
  struct obj *more;    /* Pointer to the rest of a large body of objects */
  struct obj *head;    /* Points to the main object of a large body */
  struct mapdef *map;  /* Pointer to the map in which this object is present */
  unsigned short count;         /* Which nr. of object created this is. */
  unsigned short refcount;	/* How many objects points to this object */

/* These get an extra add_refcount(), after having been copied by memcpy() */
  char *name;			/* The name of the object, obviously... */
  char *title;			/* Of foo, etc */
  char *race;			/* human, goblin, dragon, etc */
  char *slaying;		/* Which race to do double damage to */
  char *msg;			/* If this is a book/sign/magic mouth/etc */
				/* If this is an exit, this is the filename */
/* These variables are copied by memcpy() in copy_object(): */
  sint16 x,y;			/* Position in the map for this object */
  sint16 ox,oy;			/* For debugging: Where it was last inserted */
  float speed;                  /* The overall speed of this object */
  float speed_left;             /* How much speed is left to spend this round */
  unsigned long nrof;
  New_Face *face;			/* Face with colors */
  signed char direction;        /* Means the object is moving that way. */
  sint8 facing;			/* Object is oriented/facing that way. */
  uint8 type;           /* PLAYER, BULLET, etc */
  unsigned int immune;          /* Attacks which the object is immune against */
  unsigned int protected;	/* Attacks which does half damage */
  unsigned int attacktype;      /* Same bitmask as immune/protected */
  unsigned int vulnerable;	/* Attacks which does double damage */
  uint32 path_attuned;		/* Paths the object is attuned to */
  uint32 path_repelled;		/* Paths the object is repelled from */
  uint32 path_denied; 		/* Paths the object is denied access to */
  uint16 material;       	/* What materials this object consist of */
  signed char magic;            /* Any magical bonuses to this item */
  signed char thrownthaco;      /* How precise the throw is */
  unsigned char state;          /* How the object was last drawn (animation) */
  signed long value;            /* How much money it is worth (or contains) */
  signed short level;
  signed short last_heal;       /* Last healed. Depends on constitution */
  signed short last_sp;         /* As last_heal, but for spell points */
  signed short last_eat;	/* How long since we last ate */
  uint32 hide;			/* The player is hidden, not invisible */
  signed short invisible;	/* How much longer the object will be invis */
  signed char armour;		/* How many % is subtracted from phys. damage */
  unsigned char pick_up;        /* See crossfire.doc */
  struct obj *owner;   /* Pointer to the object which controls this one */
  struct obj *enemy;   /* Monster/player to follow even if not closest */
  struct archt *arch;           /* Pointer to archetype */
  struct archt *other_arch;	/* Pointer used for various things */
  signed long weight;           /* Attributes of the object */
  signed long carrying;         /* How much weight this object contains */
  uint32 flags[3];		/* various flags */
  unsigned short ownercount;	/* What count the owner had (in case owner */
				/* has been freed) */
#if 0
  unsigned short thrown;        /* How much further the object will fly */
#endif
/* Some debug variables: */
  unsigned short run_away;	/* Monster runs away if it's hp goes below \
				   this percentage. */
#ifdef NPC_PROG
  unsigned short npc_status;	/* What the NPC is doing right now */
  unsigned short npc_program;	/* Helps find out what the NPC will do next */
#endif

/* changes made by kholland@sunlab.cit.cornell.edu */
/* allows different movement patterns for attackers */
  signed long move_status;      /* What stage in attack mode */
  unsigned short move_type;     /* What kind of attack movement */

  signed long weight_limit;     /* Weight-limit of object */
  unsigned char can_apply;      /* See crossfire.doc */
  unsigned char will_apply;     /* See crossfire.doc */
  unsigned char anim_speed, last_anim; /* ticks between animation-frames */
  living stats;

#ifdef CASTING_TIME
  signed short casting;         /* time left before spell goes off */
  struct spell_struct *spell;
  unsigned int spelltype;
  unsigned short spell_state;
  unsigned short start_holding;
  char *spellarg;
#endif

/* This modification will allow variable experience requirements 
   for advancement (eanders@cmu.edu) */
  double expmul;        /* needed experience = (calc_exp*expmul) */
} object;

typedef struct oblnk { /* Used to link together several objects */
  object *ob;
  struct oblnk *next;
  int id;
} objectlink;

typedef struct oblinkpt { /* Used to link together several object links */
  struct oblnk *link;
  long value;		/* Used as connected value in buttons/gates */
  struct oblinkpt *next;
} oblinkpt;

/*
 * So far only used when dealing with artifacts.
 */
typedef struct linked_char {
  char *name;
  struct linked_char *next;
} linked_char;

/*
 * An obwin structure contains a window with scrollbar, where the user
 * can click on items and move the scrollbar.
 */

typedef struct obwinstruct {
  unsigned inventory:1;	/* True, if it's an inventory */
  int x,y;		/* If it's not an inventory, this is the coordinates */
  struct mapdef *map;	/* If it's not an inventory, this is the map */
  object *ob;		/* If it is an inventory, this is the environment */
  char format[16];	/* sprintf-format for text (object-names/weight) */
  Window win;
  GC gc_text,gc_icon;
  XSizeHints hint;
  signed short chars;		/* How wide the text-field is */
  signed short scroll;		/* How many items scrolled down */
  signed short last_scroll;	/* Where it was when last drawn */
  signed short nrofdrawn;	/* How many items drawn.  Delete extras */
  unsigned short barlength;	/* Height of scrollbar in pixels */
  signed short size;		/* How many items there is room to display */
  Fontindex *faces;		/* [size] */
  char **names;			/* [size][chars+1] */
  unsigned short scrollsize;	/* How large the last drawn scrollbar was */
  unsigned short scrollstart;	/* Where the scrollbar starts */
} obwin;

/*
 * I'll clean up the player structure before v1.0 release...
 * Yeah, I know, it's really messy now...
*/

#ifdef SAVE_WINDOW_POSITIONS   /* structure for storing window sizes */
typedef struct {
  int x,y;                     /* window x,y to parent */
  int wx,wy;                   /* window x,y to root */
  unsigned int w,h;
} save_win_pos;
#endif /* SAVE_WINDOW_POSITIONS */

#define KEYF_DEFAULT	0x01	/* Default bind */
#define KEYF_USER	0x02	/* User defined */
#define KEYF_WIZ	0x04	/* Wizard only command */
#define KEYF_NORMAL	0x08	/* Used in normal mode */
#define KEYF_FIRE	0x10	/* Used in fire mode */
#define KEYF_RUN	0x20	/* Used in run mode */
#define KEYF_EDIT	0x40	/* Line editor */

typedef int (*CommFunc)(object *op, char *params);

typedef struct __Key_s {	/* player's structure */
  unsigned char flags;
  KeyCode keycode;
  KeySym keysym;
  CommFunc func;
  char *params;
  struct __Key_s *next;
} Key_s;

typedef struct {		/* global list's structure */
  char *name;
  CommFunc func;
  float	time;			/* How long it takes to execute this command */
} CommArray_s;

#define NUM_OUTPUT_BUFS	5
typedef struct {
  char *buf;			/* Actual string pointer */
  uint32 first_update;		/* First time this message was stored  */
  uint16 count;			/* How many times we got this message */
} Output_Buf;


typedef enum inventory_show {
  show_all = 0, show_applied = 1, show_unapplied = 2, show_unpaid = 3,
  show_cursed = 4, show_magical = 5, show_nonmagical = 6
} inventory_show;

typedef enum rangetype {
  range_bottom = -1, range_none = 0, range_bow = 1, range_magic = 2,
  range_wand = 3, range_rod = 4, range_scroll = 5, range_horn = 6,
  range_skill = 7,
#ifdef ALLOW_SKILLS
  range_size = 8
#else
  range_size = 7
#endif
} rangetype;

typedef struct pl {
  struct pl *next;	      /* Pointer to next player, NULL if this is last */
  char maplevel[MAX_BUF];     /* On which level is the player? */
  struct mapdef *loading;     /* When entering a map in progress of loading */
  int new_x,new_y;            /* After entering a map being loaded */
  int removed;                /* Flag telling if ob is to be inserted */
  int key_state;              /* 1=define push key, 2=define directions */
  sint16 known_spells[NROFREALSPELLS]; /* Spells known by the player */
  uint16 nrofknownspells; 	/* Index in the above array */
  unsigned known_spell:1;     /* True if you know the spell of the wand */
  unsigned last_known_spell:1;/* What was last updated with draw_stats() */
  rangetype shoottype;	      /* Which range-attack is being used by player */
  rangetype last_shoot;	      /* What was last updated with draw_stats() */
  sint16 chosen_skill;  	/* Skill readied for use by the player */
  sint16 chosen_spell;		/* Type of readied spell */
  sint16 last_spell;		/* What spell draw_stats() last displayed */
  sint16 chosen_item_spell;	/* Type of spell that the item fires */
  uint16 count;       /* Any numbers typed before a command */
  uint16 count_left;  /* How many instances of prev_cmd are left */
			      /* to execute */
  unsigned char prev_cmd;     /* Previous command executed */
  unsigned char prev_fire_on;
  unsigned char prev_keycode; /* Previous command executed */
  unsigned char key_down;     /* Last move-key still held down */
  KeySym prev_keysym;	      /* Previous command executed */
  uint16 mode;			/* Mode of player for pickup. */
  signed char digestion;      /* Any bonuses/penalties to digestion */
  signed char gen_hp;         /* Bonuses to regeneration speed of hp */
  signed char gen_sp;         /* Bonuses to regeneration speed of sp */
  uint8 berzerk;      /* Affects usage of CTRL-direction */
  uint32 split_window:1;    /* info-window will be separate */
  uint32 braced:1;          /* Will not move if braced, only attack */
  uint32 tmp_invis:1;       /* Will invis go away when we attack ? */
  uint32 do_los:1;	      /* If true, update_los() in draw(), and clear */
#ifdef EXPLORE_MODE
  uint32 explore:1;         /* if True, player is in explore mode */
#endif
  uint32 infofull:1;		/* True if info structure has been fileed up */
  uint32 keyboard_flush:1;	/* True if keyboard events should be flushed each time */
  unsigned char state,infoline,infopos;
  unsigned char writing;   /* When true, the player is writing text */
		     /* to be displayed */
  unsigned char listening; /* Which priority will be used in info_all */

  unsigned char fire_on;
  unsigned char run_on;
  unsigned char idle;      /* How long this player has been idle */
  unsigned char has_hit;   /* If set, weapon_sp instead of speed will count */
  float weapon_sp;         /* Penalties to speed when fighting w speed >ws/10*/
  float last_weapon_sp;    /* Last turn */
  signed char last_armour; /* Last turn */

  object *menu;		/* list of shop objects for inventory */
#ifdef OBWIN
  obwin *inv,*look;        /* Inventory and look windows */
#else
  inventory_show show_what;	  /* Only show applied items in inventory */
  signed short scroll_inv;	  /* How many items we have scrolled down */
  signed short scroll_look; 	  /* The same, but for the look-window */
  signed short last_scroll_inv;   /* where it was when last drawn */
  signed short last_scroll_look;  /* ditto for look-window */
  signed short nrofdrawn_inv;	  /* How many items drawn. Delete extras */
  signed short nrofdrawn_look;    /* ditto for the look-window */
  signed short inv_chars;         /* How wide the text-field is */
  signed short look_chars;        /* How wide the text-field is */
  char format_inv[16];            /* printf-format for text in inv. window */
  char format_look[16];           /* printf-format for text in look window */
  unsigned short barlength_inv;   /* height of scrollbar in pixels */
  unsigned short barlength_look;  /* ditto, for the look-window */
  signed short inv_size;          /* How many items are displayed */
  signed short look_size;         /* Ditto, for the look-window */
  unsigned short scrollsize_inv;  /* How large the last drawn scrollbar was */
  unsigned short scrollsize_look; /* How large the last drawn scrollbar was */
  unsigned short scrollstart_inv; /* Where the scrollbar starts */
  unsigned short scrollstart_look;/* ditto */
#endif
  unsigned short scrollsize_hp;   /* How large the last scrollbar was */
  unsigned short scrollhp_alert;  /* Was the last scrollbar red */
  unsigned short scrollsize_sp;   /* How large the last scrollbar was */
  unsigned short scrollsp_alert;  /* Was the last scrollbar red */
  unsigned short scrollsize_food; /* How large the last scrollbar was */
  unsigned short scrollfood_alert;  /* Was the last scrollbar red */
  short shootstrength;     /* Strength of spell */
  object *golem;           /* Which golem is controlled */
  living orig_stats;       /* Can be less in case of poisoning */
  living last_stats;       /* Last stats drawn with draw_stats() */
  float last_speed;
  signed long last_value;  /* Same usage as last_stats */
  long last_weight;
/* These are used for avoiding to draw the same thing twice: */
  Fontindex look_face[MAX_LOOK_SIZE];
  Fontindex inv_face[MAX_INV_SIZE];

  /* CF 0.91.4:  look_name and inv_name are only really used to determine if
   * the objects name/weight should be redrawn.  So instead of
   * allocating fixed storage, we use add_string and free_string
   * instead.  For the inventory, the name returned by query_name
   * is stored.  This is because if we use the formatted name
   * (like what is used for the look_name array), the various icons
   * will not be updated properly.
   */
  char *look_name[MAX_LOOK_SIZE]; /* Lots of space wasted, must fix */
  char *inv_name[MAX_INV_SIZE];   /* this in the future... */
  char font_str[255];
  uint32 freeze_look:1;		 /* To avoid drawing sometimes */
  uint32	freeze_inv:1;
  int viewmap; /* Locks any map-drawings */
  int mapres;  /* resolution of drawn map */
  int mapxmin, mapymin; /* min x and y drawn in map view */
/* Pixels to be erazed */
  int mapdelx[32],mapdely[32];
#ifdef USE_SWAP_STATS
  int Swap_First;
#endif
  
  Display *gdisp;
/* Should be kept here so that all windows can use it... */
  Pixmap pixmap;	/* Used when windows are iconified */
  Pixmap *pixmaps;	/* Contains the font in pixmap-format (if needed) */
  Pixmap *masks;	/* Contains the bitmasks for the pixmaps -- */
			/* Right now only used with the color Pixmaps (XPM) */
  Pixmap xpm_pixmap;	/* Object drawn on this, and then copied onto
			 * game window.
			 */

  int use_pixmaps;	/* If set, use pixmaps instead of fonts */
  int color_pixmaps;	/* if set, use color pixmaps (XPM) */
  XEvent gevent;
  KeySym gkey;
  Window win_root,win_game,win_stats,win_info,win_inv,win_look,win_message;
  GC gc_root,gc_game,gc_stats,gc_info,gc_inv_text,gc_inv_icon,
  gc_look_text,gc_look_icon,gc_message, gc_xpm_floor, gc_xpm_object;
#ifdef SHOW_INV_ICON
  GC gc_inv_status_icon;
#endif
  XSizeHints gamehint,stathint,roothint,infohint,invhint,lookhint,messagehint;
  long gscreen;
  unsigned long gforeground,gbackground;
  Font font, game_font;
  object *ob;            /* The object representing the player */
  object *last_used;     /* Pointer to object last picked or applied */
  long last_used_id;     /* Safety measures to be sure it's the same */
  New_Face *drawn[WINRIGHT-WINLEFT+1][WINLOWER-WINUPPER+1]; /* Last displayed */
#ifdef Xpm_Pix
  /* Floor the player is standing on */
  New_Face *floor[WINRIGHT-WINLEFT+1][WINLOWER-WINUPPER+1];
#ifdef DOUBLE_FLOOR
  New_Face *floor2[WINRIGHT-WINLEFT+1][WINLOWER-WINUPPER+1];
#endif
#endif
  char blocked_los[WINRIGHT-WINLEFT+1][WINLOWER-WINUPPER+1];
  char *name;   	 /* What display the player has */
  char *username;	 /* Username supplied by client */
  char title[MAX_NAME];
  
/* Eneq(@csd.uu.se): Since there is no direct link between characters title and
   his level I figure that it doesn't matter what title he has so I have made
   it possible for him/her to define this in the resources. */
  
  char own_title[MAX_NAME];
  
  signed char levhp[11]; /* What the player gained on that level */
  signed char levsp[11];
  signed char last_level;

  KeySym commandkeysym, firekeysym[2], runkeysym[2];
  KeyCode commandkey, firekey[2], runkey[2];
  Key_s *keys[COMMAND_HASH_SIZE];
   
  char no_echo;           /* If true, the player is typing a password. */
  uint32 name_changed:1;      /* If true, the player has set a name. */
  char killer[BIG_NAME];  /* Who killed this player. */
  char last_cmd;
/*  Visual *vis;	Value does not need to be stored */
  Colormap colormap;
  int peaceful;
/*  long depth;		Value only needed temporarily - don't store */
/*  XColor exactcolor;  " */
  XColor discolor[NUM_COLORS];
  int iscolor:1;

  char scroll;		/* Will the text-window scroll or wrap? */
  char write_buf[MAX_BUF];
  char **info;
  unsigned char infolines,infochars; /* How big the info-array is */
  char password[16]; /* 2 (seed) + 11 (crypted) + 1 (EOS) + 2 (safety) = 16 */
#ifdef SAVE_INTERVAL
  time_t last_save_time;
#endif /* SAVE_INTERVAL */
#ifdef AUTOSAVE
  long last_save_tick;
#endif
#ifdef SIMPLE_PARTY_SYSTEM
  short party_number;
  short party_number_to_join; /* used when player wants to join a party
				 but we will have to get password first
				 so we have to remember which party to
				 join */
#endif /* SIMPLE_PARTY_SYSTEM */
#ifdef SAVE_WINDOW_POSITIONS
  short valid_save_positions;
  save_win_pos win_pos[6];
#endif
#ifdef SOUND_EFFECTS
  int rplay_fd;    /* Connexion with the rplayd daemon (disabled if <= 0) */
  int play_count;  /* Counter to avoid sound-lag */
#endif
#ifdef SEARCH_ITEMS
  char search_str[MAX_BUF];
#endif /* SEARCH_ITEMS */
  int sync;	/* Ticks between each sync.  1 = always, 0 = never */
  int cur_sync;	/* Counter from 1 to sync */

#ifdef SPELL_ENCUMBRANCE
  short encumbrance;  /*  How much our player is encumbered  */
#endif
  uint32 eric_server;
  Output_Buf	outputs[NUM_OUTPUT_BUFS];
  uint16	outputs_sync;	/* How often to print, no matter what */
  uint16	outputs_count;	/* Print if this count is exceeded */
} player;
  
/*
 * The score structure is used when treating new high-scores
 */

typedef struct scr {
  char name[BIG_NAME];      /* name + title */
  char killer[BIG_NAME];    /* name (+ title) or "quit" */
  long exp;                 /* Experience */
  char maplevel[BIG_NAME];  /* Killed on what level */
  int maxhp,maxsp;          /* Max hp and sp when killed */
  int position;             /* Position in the highscore list */
} score;

/*
 * When parsing a message-struct, the msglang struct is used
 * to contain the values.
 * This struct will be expanded as new features are added.
 * When things are stable, it will be parsed only once.
 */

typedef struct _msglang {
  char **messages;	/* An array of messages */
  char ***keywords;	/* For each message, an array of strings to match */
} msglang;

/*
 * The mapstruct is allocated each time a new map is opened.
 * It contains pointers (very indirectly) to all objects on the map.
 */

#define mapx map_object->x
#define mapy map_object->y

typedef struct mapdef {
  struct mapdef *next;	/* Next map, linked list */
  object *where;	/* What object were used to enter this map */
  char path[MAX_BUF];	/* Filename of the map */
  char *tmpname;	/* Name of temporary file */
  long reset_time;	/* When < sec since 1970, load original instead */
  sint32 timeout;		/* When it reaches 0, the map will be swapped out */
  uint32 need_refresh:1;	/* Something went wrong, need sanity check */
#if defined(UNIQUE_ITEMS) && defined(LOCK_ITEMS)
  sint32 lock_items;       /* The number of lockfile or 0 if not locked */
#endif
  sint16 players;		/* How many plares are on this level right now */
  uint32 in_memory;	/* If not true, the map has been freed and must
		         * be loaded before used.  The map,omap and map_ob
		         * arrays will be allocated when the map is loaded */
  uint32 encounter:1;	/* True if this is a randomly generated map */
  uint8 compressed;  /* Compression method used */
  MapLook *map;
  MapLook *floor;
#ifdef DOUBLE_FLOOR  
  MapLook *floor2;
#endif
  object **map_ob;	/* What object lies on the floor */
  uint16 difficulty;	/* What level the player should be to play here */
  objectlink *pending;  /* Objects waiting for the map to be loaded */
  object *map_object;   /* Map object in new map format */
  oblinkpt *buttons;	/* Linked list of linked lists of buttons */
} mapstruct;

/*
 * The archetype structure is a set of rules on how to generate and manipulate
 * objects which point to archetypes.
 */

typedef struct archt {
  char *name;           /* More definite name, like "generate_kobold" */
  struct archt *next;	/* Next archetype in a linked list */
  struct archt *head;   /* The main part of a linked object */
  struct archt *more; /* Next part of a linked object */
  struct treasureliststruct *randomitems; /* Items to be generated */
  object clone;		/* An object from which to do copy_object() */
  unsigned long editable;         /* editable flags (mainly for editor) */
  long used_by;		/* A count of how many objects use this archetype */
  unsigned char animations;	    /* How many different faces to animate */
  Fontindex *faces;     /* The different animations */
  char *arch_pointer;   /* Did this archetype deviate from another? */
} archetype;

/*
 * treasure is one element in a linked list, which together consist of a
 * complete treasure-list.  Any arch can point to a treasure-list
 * to get generated standard treasure when an archetype of that type
 * is generated (from a generator)
*/

typedef struct treasurestruct {
  struct archt *item;		    /* Which item this link can be */
  char *name;			    /* If non null, name of list to use
				       instead */
  struct treasurestruct *next;	    /* Next treasure-item in a linked list */
  struct treasurestruct *next_yes;  /* If this item was generated, use */
				    /* this link instead of ->next */
  struct treasurestruct *next_no;   /* If this item was not generated, */
				    /* then continue here */
  uint8 chance;			    /* Percent chance for this item */
  uint8 magic;			    /* Max magic bonus to item */
				    /* If the entry is a list transition,
				     * 'magic' contains the difficulty
				     * required to go to the new list
 				     */
  uint16 nrof;			    /* random 1 to nrof items are generated */
} treasure;

typedef struct treasureliststruct {
  char *name;				/* Usually monster-name/combination */
  sint16 total_chance;			/* If non-zero, only 1 item on this
					 * list should be generated.  The
					 * total_chance contains the sum of
					 * the chance for this list.
					 */
  struct treasureliststruct *next;	/* Next treasure-item in linked list */
  struct treasurestruct *items;		/* Items in this list, linked */
} treasurelist;


typedef enum SpellTypeFrom {
  spellNormal, spellWand, spellRod, spellHorn, spellScroll, spellPotion
} SpellTypeFrom;

typedef struct skill_struct {
    char *name;		/* how to describe it to player */
    float time;		/* How many ticks it takes to use the skill */
    short level;	/* base level required to learn this skill */
      /* Cost? */
      /* constraints ? */
} skill;


typedef struct spell_struct {
  char name[BIG_NAME];
  short level;           /* Level required to cast this spell */
  short sp;              /* Spellpoint-cost to cast it */
  short charges;         /* If it can be used in wands, max # of charges */
  float time;            /* How many ticks it takes to cast the spell */
  short scrolls;         /* If it can be used from scrolls, max # of scrolls */
  short scroll_chance;   /* 1-10 probability of finding this as scroll */
  short books;           /* 1-10 probability of finding this as spellbook */
  unsigned range:1;      /* True if this is a range attack spell */
  unsigned defensive:1;  /* True if it is a defensive spell */
  unsigned cleric:1;     /* True if it is a cleric-spell (wis-chance failure)*/
  unsigned onself:1;     /* Should monsters cast this spell on themselves */
  uint32 path;           /* Path this spell belongs to */
  char *archname;	 /* Pointer to archetype used by spell */
} spell;

typedef struct
{
  sint16 bdam;  /*  base damage  */
  sint16 bdur;  /*  base duration  */
  sint16 ldam;  /*  damage adjustment for level  */
  sint16 ldur;  /*  duration adjustment for level  */
  sint16 spl;
} spell_parameters;

typedef struct att_msg_str {
  char *msg1;
  char *msg2;
} att_msg;

typedef struct artifactstruct {
	object	*item;
	uint16	chance;
	uint8	difficulty;
	struct artifactstruct *next;
	linked_char *allowed;
} artifact;

typedef struct artifactliststruct {
	uint8	type;		/* Object type that this list represents */
	uint16	total_chance;	/* sum of chance for are artifacts on this list */
	struct artifactliststruct *next;
	struct artifactstruct *items;
} artifactlist;

/* Always define this structure - some prototypes in sproto.h use this
 * structure, and errors will result if the SIMPLE_PARTY_SYSTEM is not
 * selected.  Keeping it defined doesn't really harm anything anyways.
 */
/*#ifdef SIMPLE_PARTY_SYSTEM*/

typedef struct party_struct {
  sint16 partyid;
  char * partyleader;
  char passwd[9];
  struct party_struct *next;
  char *partyname;
} partylist;

/*#endif *//* SIMPLE_PARTY_SYSTEM */
/*
 * Used in shstr.c, libproto.h necessitates this dummy. For the real
 * contents of a shared_string, look in shstr.h
 */
typedef int shared_string;

/*
 * Some function types
 */
typedef void (*type_func_int)(int);
typedef void (*type_func_void)(void);
typedef void (*type_func_map)(mapstruct *);
typedef void (*type_func_map_char)(mapstruct *, char *);
typedef void (*type_func_int_map_char)(int, mapstruct *, char *);
typedef void (*type_func_ob)(object *);
typedef void (*type_func_ob_char)(object *, char *);
typedef void (*type_func_ob_cchar)(object *, const char *);
typedef void (*type_func_int_int_ob_cchar)(int, int, object *, const char *);
typedef void (*type_func_ob_ob)(object *, object *);
typedef void (*type_func_ob_int)(object *, int);
typedef int (*type_int_func_ob_ob)(object *, object *);
typedef void (*type_func_char_int)(char *, int);
typedef void (*type_func_int_ob_ob)(int, object *, object *);

#endif /* STRUCTS_H */

