/*
 * static char *rcsid_config_h =
 *   "$Id: config.h,v 1.37 1994/12/30 06:32:58 master Exp master $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1994 Mark Wedel
    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to master@rahul.net
*/

/* This file contains various #defines that select various options.
 * Some may not be desirable, and some just may not work.
 *
 * There are some options that are not selectable in this file which
 * may not always be undesirable.  An example would be certain
 * treasures that you may not want to have available.  To remove the
 * activation code would make these items worthless - instead remove
 * these from the treasure file.  Some things to look for are:
 *
 * prepare_weapon, improve_*: Allow characters to enchant their own
 *	weapons
 * ench_armour: Allow characters to enchant their armor.
 */


/* Uncommenting the following line allows the new skill code to be used
 * (look at skills.h to see some of the skill names.)  Allowing skills
 * can really change the balance of the game, and thus might be undesirable.
 * A few notes:  The following toggle just makes it so that the player can
 * not use skills (hopefully it will work).  But the skills will still exist,
 * so skills could still be gained with this selected.  In fact, some races
 * start with skills.
 */

/* #define ALLOW_SKILLS */

/* Following uses a new weapon improvement system.  This makes it more
 * difficult to get a super weapon, and makes it more likely that
 * players will create weapons that help certain areas (damage, sp, etc)
 * See the doc/SurvivalGuide for exact information on how the new method
 * works.
 */

#define NEW_IMPROVE_WEAPON


/* This is a modification to the cone spells.  If a cone spell hits
 * a monster, the spell stops progressing (same is true for parties
 * of players).  This weakens the cones spells a bit.  If it is not
 * define, you get the old behaviour (cone spells cover every square
 * up to their range in a 90 degree arc.
 */

/*
#define NO_CONE_PROPOGATE
*/

/* SHOW_INV_ICON: this draws another icon next to the object image in
 * the players inventory.  This icon shows the status of the object, such
 * as cursed, magic, equipped, etc.  Right now, these icons are just words.
 * Someday, hopefully better images will be done for thse.
 * This does cut down the number of characters that can be printed for
 * the item name (because this image takes up some space), so it might not
 * always be diserable.  If you don't want this feature, comment the
 * define out.
 */

/*#define SHOW_INV_ICON*/

/*
 * BANFILE
 * A file which contains users or sites which are banned from playing.
 * wildcards can be used in the file.  Valid entries are put on seperate lines.
 * example entries:
 * "joeblow@*.*.abc.edu"   ban joeblow at the given site : note only works if
 *                         user is using a client, as telnet does not report
 *                         userid.
 * "*@*.*.abc.edu"         ban the entire site...works both with telnet and
 *                         client.
 *
 * Note - banning by user name should not be used - the client
 * (including the newclient) can easily be changed to use any
 * username.  Also, with the new client, numeric host id is
 * used (ie, 192.15.4.6).  So to ban sites, you need to find out their
 * numeric IP address - not hard, 'who reports this
 *
 * From Tyler Van Gorder <tvangod@ecst.csuchico.edu>
 */

#ifndef BANFILE
#define BANFILE         "ban_file"
#endif

/* RANDOM_ENCOUNTERS determines if random encounter maps should be
 * done.  What this means is that if you are in natural terrain
 * (grass, brush, trees, jungle, etc), there is a chance as you step into
 * that terrain that a 3x3 area will become a random encounter.  You
 * automatically enter this encounter map, monsters are placed in it,
 * and you remain in it until you get to the outside of the encounter
 * map.  Reasons for having it active might be to make things a little
 * more interesting (players can no longer be absolutely safe bringing
 * stuff back to town), and it gives low level characters a place to beat
 * up an endless supply of some monsters.  Reasons for disabling is because
 * they might just be a nuisance, or you just don't like them
 */

/*#define RANDOM_ENCOUNTERS*/

/* casting times for spells, if you have this defined then it takes a
 * specific amount of time for a spell to go off. You may attack or
 * be hit during this time, and this will cause you to lose the spell.
 * I commented this out on my copy - I don't like the 'double clutch'
 * needed to cast it (first direction key starts casting, the
 * next actually puts the spell into effect.)  It could perhaps
 * be changed so that the initial direction is where it goes, and it
 * is cast automatically in that direction (so only 1 key is needed.)
 * But this could be undesirable as various things move while you cast it.
 */

/*#define CASTING_TIME*/

/* FULL_RING_DESCRIPTION has crossfire prints out the abilities of
 * rings or amulets in the appropriate windows.  So instead of just
 * have 'ring' get printed in your inventory, ring (Cha+1) or
 * amulet (reflect missiled), etc, will be printed out.  This also applies
 * to items laying on the ground.
 * No more information will be gathered than if you left click the
 * item (so, if the item is not identified, you will see nothing
 * except the item name.)  Tastes may vary on using this option.  It
 * can make the name excessively long, especially for unpaid items,
 * causing the (unpaid) to be cut off.  On the other hand, it can save
 * a lot of time, especially if you have several rings, or are looking
 * for one in a shop with lots of rings.
 */

#define FULL_RING_DESCRIPTION

/* SHOP_LISTINGS allows you to get a quick listing of what the shop has
 * in stock (unfortunately, it is still up to you to find the item.)
 * To get the listing, a 'menu' sign must be in the store, and then
 * must be A)pplied.  There probably isn't much reason not to define
 * this, as searching through the shop to find the item you want should
 * not be part of the game (IMHO). As time passes, more and more shops
 * will actually have signs put in them.  At some time, this should
 * probably become a standard part of the game.
 * Mark Wedel (master@rahul.net)
 * 
 * CF 0.91.2 - now standard part of game
 * #define SHOP_LISTINGS
 */

/* if EXPLORE_MODE is defined, it allows players to enter explore mode,
 * where they can not die.  Unlike other games (nethack for instance) explore
 * modes, the only thing Crossfire explore mode does is prevent death.
 * Characters in explore mode will not be able to go on the scoreboard.  Also,
 * once explore mode is entered, there is no return.  Explore mode can
 * only be entered if the person doing so is the only player in the
 * game, and once done, that person can not add new players to the
 * game.  To get into explore mode, type 'explore
 * Explore mode code added by Mark Wedel (master@rahul.net)
 * It's a good idea to turn off EXPLORE_MODE if you will only be running
 * on server, since it would block new players.
 */

/* #define EXPLORE_MODE */

/****************************************************************************/
/* Patch: NOT_PERMADEATH                Author: Charles Henrich             */
/* Email: henrich@crh.cl.msu.edu        Date  : April 9, 1993               */
/*                                                                          */
/* Purpose: This patch changes death from being a permanent, very painful   */
/*          thing, to a painful, but survivable thing.  More mudlike in     */
/*          nature.  With this patch defined, when a player dies, they will */
/*          permanently lose one point off of a random stat, as well as     */
/*          losing 20% of their experience points.  Then they are whisked   */
/*          to the start map.  Although this sounds very nice here, it is   */
/*          still REAL painful to die, 20% of a million is alot!            */
/*                                                                          */
/****************************************************************************/
/* Note from Frank: This really makes the game easier, and takes away
 * a lot of the nerve, but people have different tastes...
 * Note from Mark:  It can make the game much less frustrating.  Especially
 * if people are coming in through remote sites, and might get killed
 * by lag.  Also, removes a lot of incentive for one player to kill another.
 * Note: Resurrection/reincarnation/raise dead spells are meaningless
 * if NOT_PERMADEATH is set.
 */

#define NOT_PERMADEATH

/* define RESURECTION if you want to let players bring other players
 * back to life via some spells.  If RESURRECTION is undefined, then a
 * death is permanent.  NOTE: RESURRECTION (either defined or undefined)
 * has no meaning if NOT_PERMADEATH is defined.  SAVE_PLAYER also needs
 * to be defined for this to have any use
 */
#define RESURRECTION

/*
 * Enables the 'search-item command; a method to find equipment
 * in shops. 
 * This is somewhat useful is FULL_RING_DESCRIPTION is enabled (above.)
 * It matches by substrings of the name of the item as it appears in
 * the look window.  Therefor, if FULL_RING_DESCRIPTION is not enabled,
 * you can never match by ring abilities, as these are then not
 * displayed in the look window.
 * Seems like it now works, and doesn't cause the game to hang.
 */

#define SEARCH_ITEMS

/*
 *  Enables party system.  Note - this has been mostly re-written for
 * version 0.91.2
 */

#define SIMPLE_PARTY_SYSTEM

/*
 * If defined, some buttons for walking pops up.  They're mostly
 * useless though.
 */

/* #define USE_BUTTONS */

/*
 * If SECURE is defined, crossfire will not accept enviromental variables
 * as changes to the LIBDIR and other defines pointing to specific
 * directories.
 */

#define SECURE 

/*
 * SERVER:
 * Leave this in if you want the magic server stuff.  eanders@cmu.edu
 * It is now also able to accept new players via socket without
 * the -server switch.
 * LOGFILE specifies which file to log to when playing with the
 * -server option as well.
 * NO_ADD:
 * If you want players to only be able to join the game by using the
 * client, and not by having other players type "'add <display>", then
 * define this.  Note that in the near future, the highscorelist will
 * depend on the username when making sure that one player can only
 * have one entry pr. class, and it's only possible to determine
 * username if they use the client.
 * ONE_PLAYER_PR_UID:
 * A user can only play one player in a single crossfire at any given time.
 * Rumor has it the ONE_PLAYER_PR_UID causes some problems even with multiple
 * user ids.
 */

#define SERVER
#ifdef SERVER
#define PORT 13326 /* Crossfire => 1cfe => 13326 (huh?) CrossFirE :)*/
#endif
#ifndef LOGFILE
#define LOGFILE "/tmp/cross.log"
#endif
/*#define NO_ADD*/
/* #define ONE_PLAYER_PR_UID */

/*
 * DMFILE
 * A file containing valid names that can be dm, one on each line.
 * ie, something like:
 *
 * master
 * root
 * crossfire
 *
 * Thus, a global password is no longer required.  This file is located
 * in the lib directory.
 * 
 */

#ifndef DMFILE
#define DMFILE "dm_file"
#endif

/*
 * Where to send error-reports.  If you're hacking at the source, define
 * this as your mail-address.
 */

#ifndef DM_MAIL
/* #define DM_MAIL "master@rahul.net" */
#endif

/*
 * If undefined, malloc is always used.
 * There is still a calloc() call in player.c which is not affected by this
 * definition due to a bug which hasn't been found yet.
 */
/* #define USE_CALLOC */

/*
 * If defined, two FLOOR_TYPE items can be put atop each other and
 * will be drawn correctly (i.e. a tower on top of cobblestones) -- only
 * if you use colour pixmaps of course.
 * If undefined, you will only get the topmost floor item drawn.
 * The cost is low in memory and speed and it looks a lot better, so
 * you may want to define it.
 * schmid@fb3-s7.math.tu-berlin.de
 */

#if defined(Xpm_Pix)
#define DOUBLE_FLOOR
#endif


/*
 * SWAP_STATS is fixed now - rgg.
 *
 * Swap stats allows players to swap the values for their stats around
 * in the "Roll again" phase of the character selection.  This should
 * hopefully make character selection quicker, allowing for quicker
 * game start ups. 
 * Bugs:    c.blackwood@rdt.monash.edu.au
 */ 

#define	USE_SWAP_STATS

/*
 *   Cool soda hack to sort rolled stats.
 */

#define SORT_ROLLED_STATS


/*
 * CHRFONT (Character-Font), if defined, enables the player to draw
 * themselves in their own font and include this in the game.
 * It is, as default, disabled, since it slows the game down.
 * Especially when you have a black/white screen, it slows the
 * game down heavily.
 * It also doesn't work with pixmaps (yet)
 */

/* #define	CHRFONT */ /* Not working ++kivinen 05:52 Jan 30 1994 */

/*
 * You can restrict playing in certain times by creating a PERMIT_FILE
 * in LIBDIR. here is a sample:
 * -----
Mon 8-12
Mon 13-16
Tue 8-16
Wed 8-16
Thu 8-16
Fri 8-12
msg
Playing is forbidden during working hours.
 * -----
 * Unfortunately IBMR2 isn't supported by PERM_FILE yet.
 */

#ifndef _IBMR2
#define PERM_FILE "forbid"
#endif

/*
 * random() is much better than rand().  If you have random(), use it instead.
 */

#if defined (sgi) || defined (hpux) || defined(linux)
#define RANDOM() rand()
#define SRANDOM(xyz) srand(xyz)
#else
#if defined(SYSV) || defined(SVR4)
#define RANDOM() lrand48()
#define SRANDOM(xyz) srand48(xyz)
#else
#define RANDOM() random()
#define SRANDOM(xyz) srandom(xyz)
#endif
#endif

/*
 * If you feel the game is too fast or too slow, change MAX_TIME.
 * You can experiment with the 'speed <new_max_time> command first.
 * The length of a tick is MAX_TIME microseconds.  During a tick,
 * players, monsters, or items with speed 1 can do one thing.
 */

#define MAX_TIME	120000	/* How slow the game will go */

/*
 * MAP_MAXTIMEOUT tells the maximum of ticks until a map is swapped out
 * after a player has left it.  If it is set to 0, maps are
 * swapped out the instant the last player leaves it.
 * If you are low on memory, you should set this to 0.
 * Note that depending on the map timeout variable, the number of
 * objects can get quite high.  This is because depending on the maps,
 * a player could be having the objects of several maps in memory
 * (the map he is in right now, and the ones he left recently.)
 * Each map has it's own TIMEOUT value and value field and it is
 * defaulted to 300
 */

#define MAP_MAXTIMEOUT	1000	/* How many ticks till maps are swapped out */

/*
 * MAP_RESET tells whether map is reset after some time.  If it is defined,
 * the game uses weight variable of map object to tell, after how many seconds
 * the map will be reset.  If MAP_RESET is undefined, maps will never reset.
 *
 * MAP_MAXRESET is the maximum time a map can have before being reset.  It
 * will override the time value set in the map, if that time is longer than
 * MAP_MAXRESET.  This value is in seconds.  If you are low on space on the
 * TMPDIR device, set this value to somethign small.  The default
 * value in the map object is 7200 (2 hours)
 * I personally like 1 hour myself, for solo play.  It is long enough that
 * maps won't be resetting as a solve a quest, but short enough that some
 * maps (like shops and inns) will be reset during the time I play.
 * Comment out MAP_MAXRESET time if you always want to use the value
 * in the map archetype.
 */

#define MAP_RESET
#define MAP_MAXRESET	7200

/*
 * MAX_OBJECTS is no hard limit.  If this limit is exceeded, crossfire
 * will look for maps which are already scheldued for swapping, and
 * promptly swap them out before new maps are being loaded.
 * If playing only by yourself, this number can probably be as low as
 * 3000.  If in server mode, probably figure about 1000-2000 objects per
 * active player (if they typically play on different maps), for some guess
 * on how many to define.  If it is too low, maps just get swapped out
 * immediately, causing a performance hit.  If it is too high, the program
 * consumes more memory.  If you have gobs of free memory, a high number
 * might not be a bad idea.
 */

#define MAX_OBJECTS	6000

/*
 * You must change LIBDIR to where you want your maps, highscore and
 * archetype file to be.  It's enough to change it in the Imakefile though.
 * The other files will be put in LIBDIR/MAPDIR, LIBDIR/PLAYERDIR, etc.
 * Remember to create the directory and move the needed files there.
 * Note: By default, what is set in config/crosssite.def (as CTop/lib)
 * will be used instead of the value below.  If you want to force the value
 * below to be used, uncomment the #undef line.
 */

/* #undef LIBDIR */
#ifndef LIBDIR
#define LIBDIR "/home/a/tars/lib"
#endif

/*
 * If you want the players to be able to save their characters between
 * games, define SAVE_PLAYER and set PLAYERDIR to the directories
 * where the player-files will be put.
 * Remember to create the directory (make install might do that though).
 * (In the future it should be possible by a define to say that save-files
 * should be kept in each players' directory, though this isn't completely
 * in the spirit of the game (it's multiplayer))
 * If SAVE_HOMEDIR is defined, the players will be saved in the homedir
 * of the _invoking_ player instead of in LIBDIR/PLAYERDIR.
 * If LOCK_PLAYER is defined, a player will be unable to enter more
 * than one game of crossfire at the same time (stops some possible cheating).
 * If you intend to run a central server, and not allow the players to
 * start their own crossfire, you won't need to define this.
 * If USE_CHECKSUM is defined, a checksum will be calculated each time
 * a player saves a character.
 * If ENABLE_CHECKSUM is defined, the players will get the cheat-flag set
 * if the checksums don't match.  If your player-files don't have checksums,
 * you'll want to leave "USE_CHECKSUM" defined for a while so they all
 * get checksums, and then define "ENABLE_CHECKSUM" to utilize this.
 */

/* CF 0.91.6 - SAVE_PLAYER now standard part of game */
/*#define SAVE_PLAYER*/

/* #define SAVE_HOMEDIR */
/* #define LOCK_PLAYER */
#define USE_CHECKSUM
/* #define ENABLE_CHECKSUM */ /* Will be default in distant future versions */

#ifndef PLAYERDIR
#define PLAYERDIR "players"
#endif

/*
 * If you have defined SAVE_PLAYER, you might want to change this, too.
 * This is the access rights for the players savefiles.
 * I think it is usefull to restrict access to the savefiles for the
 * game admin. So if you make crossfire set-uid, use 0600.
 * If you are running the game set-gid (to a games-group, for instance),
 * you must remember to make it writeable for the group (ie 0660).
 * Kjetil W. J{\o}rgensen, jorgens@pvv.unit.no
 * (Note: something should probably be done with lock-file permission)
 */
#define	SAVE_MODE	0660

/*
 * If you want use banks and inns where players can store their items
 * between games, you should define UNIQUE_ITEMS. Those objects are saved
 * to ITEMS_DIR. This flag allows also the real artifacts (i.e. one item in
 * the whole game). The graveyards also works better if this is defined.
 * If anyone can start their own server, you should also define LOCK_ITEMS
 * to avoid loosing the items and other conflicts.  [Tero.Haatanen@lut.fi]
 */

#define UNIQUE_ITEMS
#ifdef UNIQUE_ITEMS
#define ITEMS_DIR "unique-items"
#define LOCK_ITEMS
#endif

/*
 * Allow players to save their window postions with the 'X' command.
 * This only works in split window mode. If you have trouble with your
 * window manager when restoring saved positions (the windows shift
 * around slightly) try:
 * #define FUNNY_WINDOW_MANAGER
 * This bug seems to happen when using tvtwm (this has been tested to
 * work correctly on olvwm and mwm).
 */

#define SAVE_WINDOW_POSITIONS

/* NOTE ON SAVE_INTERVAL and AUTOSAVE:  Only one of these two really
 * needs to be selected.  You can set both, and things will work fine,
 * however, it just means that a lot more saving will be done, which
 * can slow things down some.
 */

/* How often (in seconds) the player is saved if he drops things.  If it is
 * set to 0, the player will be saved for every item he drops.  Otherwise,
 * if the player drops and item, and the last time he was saved
 * due to item drop is longer
 * the SAVE_INTERVAL seconds, he is then saved.  Depending on your playing
 * environment, you may want to set this to a higher value, so that
 * you are not spending too much time saving the characters.
 * This option should now work (Crossfire 0.90.5)
 */

/*#define SAVE_INTERVAL 300*/

/*
 * AUTOSAVE saves the player every AUTOSAVE ticks.  A value of
 * 5000 with MAX_TIME set at 120,000 means that the player will be
 * saved every 10 minutes.  Some effort should probably be made to
 * spread out these saves, but that might be more effort than it is
 * worth (Depending on the spacing, if enough players log on, the spacing
 * may not be large enough to save all of them.)  As it is now, it will
 * just set the base tick of when they log on, which should keep the
 * saves pretty well spread out (in a fairly random fashion.)
 */

#define AUTOSAVE 5000

/* Often, emergency save fails because the memory corruption that caused
 * the crash has trashed the characters too. Define NO_EMERGENCY_SAVE
 * to disable emergency saves.  This actually does
 * prevent emergency saves now (Version 0.90.5).
 */

#define NO_EMERGENCY_SAVE

/* By selecting the following, whenever a player does a backup save (with
 * the 'save command), the player will be saved at home (EMERGENCY_MAP_*
 * information that is specified later).  IF this is not set, the player
 * will be saved at his present location.
 */

/*#define BACKUP_SAVE_AT_HOME*/

/*
 * Define the following if you wish to allow players to set their title
 * and to save it on the disk (if SAVE_PLAYER is defined).
 */

#define SET_TITLE


/*
 * The following is only interesting if you run crossfire seteuid-flagged.
 * XOpenDisplay may want to read the .Xauthority file of the person who
 * runs the program. This can only be allowed if the system allows free
 * changing of the uid back and forth between invocation time uid
 * and the setuid uid. Otherwise we can't change euid back to suid after
 * setting it to invoking uid to read the xauth file. So far, only
 * POSIX-compatible systems and System-V derivates allow a process to
 * reset to a previous uid.
 * If this flag is left undefined, crossfire will not set uid back to
 * that of the invoking process while opening the first display connection.
 * In this case, you'll have to do xhost +machine before running crossfire,
 * 'machine' being the machine you run the program on.
 *    //magnuz@cd.chalmers.se
 */
/* #define HAVE_SAVE_UID */
#if (defined(hpux) || defined(sysv)) && !defined(HAVE_SAVE_UID)
#  define HAVE_SAVE_UID
#endif

/*
 * If you want to have a Message Of The Day file, define MOTD to be
 * the file with the message.  If the file doesn't exist or if it
 * is empty, no message will be displayed.
 * (It resides in the LIBDIR directory)
 */

#ifndef MOTD
#define MOTD "motd"
#endif

/*
 * If you want to take the game down while installing new versions, or
 * for other reasons, put a message into the SHUTDOWN_FILE file.
 * Remember to delete it when you open the game again.
 * (It resides in the LIBDIR directory)
 */

#ifndef SHUTDOWN_FILE
#define SHUTDOWN_FILE "shutdown"
#endif

/*
 * Your tmp-directory should be large enough to hold the uncompressed
 * map-files for all who are playing.
 * It ought to be locally mounted, since the function used to generate
 * unique temporary filenames isn't guaranteed to work over NFS or AFS
 * On the other hand, if you know that only one crossfire server will be
 * running using this temporary directory, it is likely to be safe to use
 * something that is NFS mounted (but performance may suffer as NFS is
 * slower than local disk)
 */

#define TMPDIR "/tmp"

/*
 * This doesn't work yet, leave NO_LOG commented away.
 * If you want to save ram, and want absolutely _no_ output from the
 * game, even if something went very wrong, you can define NO_LOG.
 * If your system doesn't understand ANSI-C var-args, you can try
 * to define this to make it compile.
 */

/* #define NO_LOG */

/*
 * If you want to regenerate the spoiler.ps file, you have to recompile
 * the game with DUMP_SWITCHES defined.  If defined, it turns on the
 * -m -m2 -m3 -m4 switches.
 */

#define DUMP_SWITCHES

/*
 * If you compress your files to save space, please define at least uncompress
 * If you change to some compression program not using ".Z" or ".gz", please
 * define COMPRESS_SUFFIX.  Note though that ".Z" and ".gz" is checked anyway.
 * The program has support built in to handle gzip and compress
 * files, however, the gzip, gunzip, compress and uncompress programs all
 * need to be in the PATH environmental variable for this to work.
 * COMPRESS is the program name to compress the file, UNCOMPRESS to
 * uncompress the file.  if COMPRESS_SUFFIX is not defined, COMPRESS
 * and UNCOMPRESS have no meaning.
 */

#ifndef COMPRESS_SUFFIX
/* #define COMPRESS_SUFFIX ".Z" */
#endif

/* #define COMPRESS <whatever> */
/* #define UNCOMPRESS <whatever> */

#ifndef COMPRESS
#  if defined (linux) || defined(SVR4)
#    define COMPRESS	"/usr/bin/compress"
#  else
#    if defined(sgi)
#      define COMPRESS	"/usr/bsd/compress"
#    else
#      if defined(ultrix) || defined(BSD) || defined(_BSD)
#        define COMPRESS	"/usr/ucb/compress"
#      else
#        define COMPRESS	"/local/bin/compress"
#      endif
#    endif
#  endif
#endif
#ifndef UNCOMPRESS
#  if defined (linux) || defined(SVR4)
#    define UNCOMPRESS	"/usr/bin/uncompress"
#  else
#    if defined(sgi)
#      define UNCOMPRESS	"/usr/bsd/uncompress"
#    else
#      if defined(ultrix) || defined(BSD) || defined(_BSD)
#        define UNCOMPRESS	"/usr/ucb/uncompress"
#      else
#        define UNCOMPRESS	"/local/bin/uncompress"
#      endif
#    endif
#  endif
#endif


#define EMERGENCY_MAPPATH "/city/city"
#define EMERGENCY_X 15
#define EMERGENCY_Y 19

/*
 *  It shouldn't be neccessary to change the following constants, but you
 *  are free at have a look at them 8)
 */

/*
 * These defines tells where, relative to LIBDIR, the maps, the map-index,
 * archetypes highscore and treaures files and directories can be found.
 */

#define MAPDIR		"maps"
#define ARCHETYPES	"archetypes"
#define HIGHSCORE	"highscore"
#define TREASURES	"treasures"

#ifdef SOUND_EFFECTS
#  define SOUNDS_LIST	"sounds"
#endif

#define DEBUG_TIME		/* Enable the 'time command, and it's logs */
#define MAX_ERRORS	25	/* Bail out if more are received during tick */
#define STARTMAX        500     /* How big array of objects to start with */
#define OBJ_EXPAND      100     /* How big steps to use when expanding array */

#define HIGHSCORE_LENGTH 10	/* How many entries there are room for */

#define ARCHTABLE 2459		/* Used when hashing archetypes */
#define MAXSTRING 20

#define COMMAND_HASH_SIZE 107	/* If you change this, delete all characters :) */

#ifndef DEBUG
/* #define DEBUG */		/* You don't really want to define DEBUG... */
#endif


/*
 * This option creates more core files.  In some areas, there are certain
 * checks done to try and make the program more stable (ie, check
 * parameter for null, return if it is).  These checks are being done
 * for things that should not happen (ie, being supplied a null parameter).
 * What MANY_CORES does, is if one of these checks is true, it will
 * dump core at that time, allowing for fairly easy tracking down of the
 * problem.  Better to fix problems than create thousands of checks.
 */
#define MANY_CORES

/* To make loading of the XPM files more efficient, a monstage
 * of them is created.  This way, only a few XCreatePixmap...
 * calls need to be made instead of 2000+.  The values below
 * indicate the number of pixmaps wide and high the montage
 * should be.  Very large numbers have the disadvantage of
 * not being especially efficient on space, and also require more
 * server memory.  The server memory could be a problem for
 * X Terminals.
 */

#define XPM_MONTAGE_X 25
#define XPM_MONTAGE_Y 20

/*  SPELLPOINT_LEVEL_DEPEND  --  Causes the spellpoint cost
 *  of spells to vary with their power.  Spells that become very
 *  powerful at high level cost more.  The damage/time of
 *  characters increases though.
 */

#define SPELLPOINT_LEVEL_DEPEND


/* SPELL_ENCUMBRANCE -- If you're carrying a weapon or wearing heavy armour,
  you have a chance of fumbling your spellcasting with this on.  Formula is:
  encumbrance = 3*weapon_weight + armour_weight

  failure if roll from 1-200 is less than encumbrance + sp->level -
  op->level - 35
*/

#define SPELL_ENCUMBRANCE

/* SPELL_FAILURE_EFFECTS only has meaing if SPELL_ENCUMBRANCE is defined.
 * What it does, is that when the player fails a spell, various effects
 * will happen (player is paralyzed, confused, wonder spell is cast, etc.)
 * I disabled it because I think it would make life much too hazardous
 * for low level casters.  They either need to wear light armor (which
 * means that they will get pounded on by monsters), or will get
 * confused/paralyzed/other effects often.  High level casters would
 * be mostly unaffected, since they would be casting spells that are
 * below their level.
 */

/* #define SPELL_FAILURE_EFFECTS */

/* CHECK_ACTIVE_MAPS is in certain functions to determine how often
 * the process_active maps function should be called.  In general, a simple
 * count variable is used (ie, every CHECK_ACTIVE_MAPS objects loaded/saved
 * or pixmaps built, call the function.  The process_maps function will
 * return without doing any processing if not enough time has elapsed.
 * In general, a too low value for CHECK_ACTIVE_MAPS will cause some
 * loss in performance, a too high value will mean that the function is
 * not called enough, causing uneven movement.
 * If CHECK_ACTIVE_MAPS is 0, then the function is never called.
 * Also see PROCESS_WHILE_LOADING below.
 */

#define CHECK_ACTIVE_MAPS 25

/* This option will cause process_maps to be called while maps are
 * being loaded and saved.  This has the advantage that other
 * players (the one that did not enter a new map) can do whatever they
 * want while the map is loading, and are not frozen.  Same is true
 * when a map is being frozen.
 *
 * If you are on a sufficiently fast machine, the map loading and
 * saving time may be small enough, that the players don't notice
 * anything, so setting this might not be desirable.
 *
 * Also, there used to be bugs associated with this - players entering maps
 * to find that all the exits are closed, appearing the middle the
 * ocean as the exit a map, etc.  Hopefully, I have fixed those bugs,
 * but it is difficult to be sure.  If you set this, and find those
 * things happening, turn this option off, and please let me know.
 *
 * Apparantly, there are still some bugs associated with this option, so
 * it is better to leave commented out.
 *
 * Mark Wedel (master@rahul.net)
 */
/*#define PROCESS_WHILE_LOADING*/
