/* Client interface main routine.
 * This file handles the reading of the command line arguments
 * and setting up the basic connection.
 */

#include <client.h>
#include <tcplib.h>


/* actually declare the globals */

char *server="localhost",*client_libdir=NULL, *client_archfile=NULL;
int port_num=EPORT;
FILE *fpin,*fpout;
int fdin, fdout, basenrofpixmaps, pending_images=0,maxfiledescriptor,
	pending_archs=0;
char init_load_image=FALSE, init_load_arch=FALSE, save_new_data=FALSE;
Client_Player cpl;
TcpSocket conns[2];

struct CmdMapping {
  char *cmdname;
  void (*cmdproc)(ArgList);
};

void FooCmd(ArgList msg)
{
  printf("Foo: %s\n",ArgList_getString(msg,2));
}
void EatMeCmd(ArgList msg)
{
}

struct CmdMapping commands[] = {
  { "map", MapCmd },
  { "map_scroll", map_scrollCmd },
  { "item", ItemCmd },
  { "drawinfo", DrawInfoCmd },
  { "stats", StatsCmd },
  { "pixmap", PixMapCmd },
  { "bitmap", BitMapCmd },
/*  { "write_ch", write_chCmd },*/
  { "version", VersionCmd },

  { "player", PlayerCmd },

  { "foo", FooCmd },
  { "bar", EatMeCmd },

  { "addme_failed", PrintMsg },
  { "addme_success", PrintMsg },

  { "query", handle_query},
};

#define NCOMMANDS (sizeof(commands)/sizeof(struct CmdMapping))

void DoClient(TcpSocket conn)
{
  ArgList msg;
  int i;
  char *cmd;

  msg = ArgList_receive(conn);
  if (ArgList_getLong(msg,0)!= STRINGCOMMAND) {
    printf("Bad message from server (%ld)\n",ArgList_getLong(msg,0));
    exit(1);
  }
  cmd = ArgList_getString(msg,1);
  printf("Command:%s\n",cmd);
  for(i=0;i < NCOMMANDS;i++) {
    if (strcmp(cmd,commands[i].cmdname)==0) {
      commands[i].cmdproc(msg);
      break;
    }
  }
  if (i == NCOMMANDS) {
    printf("Bad command from server (%s)\n",cmd);
    exit(1);
  }
}


/* This is the loop that the client goes through once all the
 * initialization is done.  Basically, it checks for input and
 * processes X events (calls function to do that.)
 * The time for command_loop is fairly arbitrary - it can be most
 * any value.  If it is very low, however, as it will be doing a lot
 * of checks to see if there is data instead of blocking on input.
 *
 * check_x_events takes all the events that are waiting.
 */

void event_loop()
{
    while (1) {
	WaitForInput(conns, 1, MAX_TIME/1000);
	if (HasInput(conns[0]))
	    DoClient(conns[0]);
	check_x_events();
    }

}


int main(int argc, char *argv[])
{


    /* This needs to be done first.  In addition to being quite quick,
     * it also sets up some paths (client_libdir) that are needed by
     * the other functions.
     */

    init_client_vars();
    
    /* Call this very early.  It should parse all command
     * line arguments and set the pertinent ones up in
     * globals.  Also call it early so that if it can't set up
     * the windowing system, we get an error before trying to
     * to connect to the server.  And command line options will
     * likely change on the server we connect to.
     */
    if (init_windows(argc, argv)) {	/* x11.c */
	fprintf(stderr,"Failure to init windows.\n");
	exit(1);
    }
    conns[0] = GetConnection(server, port_num);
    SendVersion(conns[0]);
    if (display_usebitmaps()) 
	SendSetFaceMode(conns[0],1); /* Yeah! arbitrary constants! ;>*/
    if (display_noimages())
	SendSetFaceMode(conns[0],0);

/*    SendKeyConversion(conns[0]);*/
    SendAddMe(conns[0]);

    event_loop();

    exit(0);
}
