/*
 * static char *rcsid_time_c =
 *    "$Id: time.c,v 1.3 1993/04/12 18:58:10 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

/*
 * Routines that is executed from objects based on their speed have been
 * collected in this file.
 */

#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif

void remove_door(object *op) {
  int i;
  object *tmp;
  for(i=1;i<9;i+=2)
    if((tmp=present(DOOR,op->map,op->x+freearr_x[i],op->y+freearr_y[i]))!=NULL)
      tmp->speed=0.1,tmp->speed_left= -0.2;
  remove_ob(op);
  free_object(op);
}

void remove_door2(object *op) {
  int i;
  object *tmp;
  for(i=1;i<9;i+=2) {
    tmp=present(LOCKED_DOOR,op->map,op->x+freearr_x[i],op->y+freearr_y[i]);
    if(tmp && tmp->slaying == op->slaying) /* same key both doors */
      tmp->speed=0.1,tmp->speed_left= -0.2;
  }
  remove_ob(op);
  free_object(op);
}

void generate_monster(object *gen) {
  int i;
  object *op,*head=NULL,*prev=NULL;
  archetype *at=gen->other_arch;

  if(GENERATE_SPEED(gen)&&RANDOM()%GENERATE_SPEED(gen))
    return;
  if(gen->other_arch==NULL) {
    LOG(llevError,"Generator without other_arch: %s\n",gen->name);
    return;
  }
  i=find_free_spot(at,gen->map,gen->x,gen->y,1,9);
  if(!i) return;
  while(at!=NULL) {
    op=arch_to_object(at);
    op->x=gen->x+freearr_x[i]+at->clone.x;
    op->y=gen->y+freearr_y[i]+at->clone.y;
    if(head!=NULL)
      op->head=head,prev->more=op;
    insert_ob_in_map(op,gen->map);
    if(op->arch->randomitems!=NULL)
      create_treasure(op->arch->randomitems,op,GT_INVENTORY,
                      gen->map->difficulty);
    if(head==NULL)
      head=op;
    prev=op;
    at=at->more;
  }
  if(gen->stats.food&&!--(gen->stats.food)) {
    remove_ob(gen);
    free_object(gen);
  }
}

void remove_force(object *op) {
  if(op->env==NULL) {
    remove_ob(op);
    free_object(op);
    return;
  }
  UNSET_APPLIED(op);
  change_abil(op->env,op);
  fix_player(op->env);
  remove_ob(op);
  free_object(op);
}

void remove_confusion(object *op) {
  if(--op->stats.food > 0)
    return;
  if(op->env!=NULL)
    UNSET_CONFUSED(op->env);
  remove_ob(op);
  free_object(op);
}

void execute_wor(object *op) {
  object *wor=op;
  while(op!=NULL&&op->type!=PLAYER)
    op=op->env;
  if(op!=NULL) {
    if(blocks_magic(op->map,op->x,op->y))
      draw_info(op,"You feel something fizzle inside you.");
    else
      enter_exit(op,wor);
  }
  remove_ob(wor);
  free_object(wor);
}

void poison_more(object *op) {
  if(op->env==NULL||!IS_ALIVE(op->env)||op->env->stats.hp<0) {
    remove_ob(op);
    free_object(op);
    return;
  }
  if(op->stats.food==1) {
    if(op->env->type==PLAYER) {
      UNSET_APPLIED(op);
      fix_player(op->env);
      draw_info(op->env,"You feel much better now.");
    }
    remove_ob(op);
    free_object(op);
    return;
  }
  if(op->env->type==PLAYER) {
    op->env->stats.food--;
    draw_info(op->env,"You feel very sick...");
    draw_stats(op->env);
  }
  (void)hit_player(op->env,
                   RANDOM()%(op->stats.dam*op->env->stats.maxhp/100+1)+1,
                   op,AT_PHYSICAL);
}

void move_gate(object *op) { /* 1 = going down, 0 = goind up */
  object *tmp;
  if(op->stats.wc<0||op->stats.wc>op->arch->animations-1) {
    LOG(llevError,"Gate error: animation was %d\n",op->stats.wc);
    dump_object(op);
    LOG(llevError,"%s\n",errmsg);
    op->stats.wc=0;
  }
  if(op->value) { /* We're going down */
    if(--op->stats.wc<=0) { /* Reached bottom, let's stop */
      op->stats.wc=0;
      if(op->arch->clone.speed)
        op->value=0;
      else
        op->speed=0;
      UNSET_NO_PASS(op);
      UNSET_BLOCKSVIEW(op);
      update_all_los(op->map);
    }
    if(op->stats.wc<=(op->arch->animations-1)/2+1) {
      UNSET_NO_PASS(op);
      UNSET_BLOCKSVIEW(op);
      update_all_los(op->map);
    }
    op->face.number=op->arch->faces[op->stats.wc];
    update_object(op);
    return;
  }
  /* We're going up */
  if((unsigned char) op->stats.wc==(op->arch->animations-1)&&op->above==NULL) {
    if(op->arch->clone.speed)
      op->value=1;
    else
      op->speed=0; /* Reached top, let's stop */
    return;
  }
  if(op->stats.food) {    /* The gate is going temporarily down */
    if(--op->stats.wc<=0) /* Gone all the way down? */
      op->stats.food=0,   /* Then let's try again */
      op->stats.wc=0;
  } else {                /* The gate is still going up */
    if((unsigned char) ++op->stats.wc>(op->arch->animations-1))
      op->stats.wc=(signed char)op->arch->animations-1;
    if((unsigned char) op->stats.wc>=op->arch->animations/2) {
      /* Halfway or further, check blocks */
      for(tmp=op->above;tmp!=NULL&&tmp->above!=NULL;tmp=tmp->above); /* top */
      if(tmp!=NULL) {
        if(IS_ALIVE(tmp)) {
          hit_player(tmp,RANDOM()%(op->stats.dam+1)+1,op,AT_PHYSICAL);
          if(tmp->type==PLAYER) {
            char buf[MAX_BUF];
            sprintf(buf,"You are crushed by the %s!",op->name);
            draw_info(tmp,buf);
          }
        } else if(!(tmp->speed&&tmp->direction)) {
          /* If it has speed, it should move itself, otherwise: */
          int i=find_free_spot(tmp->arch,op->map,op->x,op->y,1,9);
          remove_ob(tmp);
          tmp->x+=freearr_x[i],tmp->y+=freearr_y[i];
          insert_ob_in_map(tmp,op->map);
        }
      }
      if(op->above!=NULL)   /* Still something in the way? */
        op->stats.food=1;   /* Then let's go down and gather some speed 8) */
      else {
        SET_NO_PASS(op);    /* The coast is clear, block the way */
        if(!op->arch->clone.stats.ac)
          SET_BLOCKSVIEW(op);
        update_all_los(op->map);
      }
    }
  }
  op->face.number=op->arch->faces[(unsigned char)op->stats.wc];
  update_object(op);
}

/*  hp      : how long door is open/closed
 *  maxhp   : initial value for hp
 *  sp      : 1 = open, 0 = close
 */
void move_timed_gate(object *op)
{
  int v = op->value;

  if (op->stats.sp) {
    move_gate(op);
    if (op->value != v)   /* change direction ? */
      op->stats.sp = 0;
    return;
  } 
  if (--op->stats.hp <= 0) { /* keep gate down */
    move_gate(op);
    if (op->value != v)   /* ready ? */
      op->speed = 0;
  }
}

void animate_trigger (object *op)
{
  if((unsigned char)++op->stats.wc >= op->arch->animations-1) {
    op->stats.wc = 0;
    check_trigger(op);
  }
  op->face.number=op->arch->faces[op->stats.wc];
  update_object(op);
}

void move_hole(object *op) { /* 1 = opening, 0 = closing */
  if(op->value) { /* We're opening */
    if(--op->stats.wc<=0) { /* Opened, let's stop */
      op->stats.wc=0;
      op->speed=0;
      SET_WALK_ON(op);
      while(op->above!=NULL && apply(op->above,op))
        ;
    }
    op->face.number=op->arch->faces[op->stats.wc];
    update_object(op);
    return;
  }
  /* We're closing */
  UNSET_WALK_ON(op);
  if((unsigned char)++op->stats.wc>op->arch->animations-1)
    op->stats.wc=op->arch->animations-1;
  op->face.number=op->arch->faces[op->stats.wc];
  update_object(op);
  if((unsigned char) op->stats.wc==op->arch->animations-1) {
    op->speed=0; /* closed, let's stop */
    return;
  }
}


void stop_arrow(object *op,object *tmp) {
  if(wall(op->map,op->x,op->y))
    op->x-=DIRX(op),op->y-=DIRY(op);
  if(op->stats.food < 1)
    op->stats.food = 1;
  if(!(RANDOM()%op->stats.food)) {
    /* Small chance of breaking */
    free_object(op);
    return;
  }
  op->direction=0;
  UNSET_WALK_ON(op);
  UNSET_FLY_ON(op);
  UNSET_FLY(op);
  op->speed=0;
  op->stats.wc = 0;
  op->stats.dam=0;
  op->face=op->arch->clone.face;
  if(tmp!=NULL&&tmp->stats.hp>=0) {
    if(tmp->head != NULL)
      tmp = tmp->head;
    insert_ob_in_ob(op,tmp);
  } else
    insert_ob_in_map(op,op->map);
  op->owner=NULL; /* So that stopped arrows will be saved */
}

void move_arrow(object *op) {
  object *tmp;

  if(op->map==NULL) {
    LOG(llevError,"Arrow had no map.\n");
    remove_ob(op);
    free_object(op);
    return;
  }
  remove_ob(op);
  if(wall(op->map,op->x+DIRX(op),op->y+DIRY(op)))
    if(!REFLECTING(op) || !(RANDOM()%20)) {
    stop_arrow(op,NULL);
    return;
    } else {
      if(op->direction&1)
	op->direction=absdir(op->direction+4);
      else {
        int left= wall(op->map,op->x+freearr_x[absdir(op->direction-1)],
		       op->y+freearr_y[absdir(op->direction-1)]),
	right=wall(op->map,op->x+freearr_x[absdir(op->direction+1)],
		   op->y+freearr_y[absdir(op->direction+1)]);
        if(left==right)
          op->direction=absdir(op->direction+4);
        else if(left)
          op->direction=absdir(op->direction+2);
        else if(right)
          op->direction=absdir(op->direction-2);
      }
      if(wall(op->map,op->x+DIRX(op),op->y+DIRY(op)))
	{
	  int left= wall(op->map,op->x+freearr_x[absdir(op->direction-1)],
			 op->y+freearr_y[absdir(op->direction-1)]),
	  right=wall(op->map,op->x+freearr_x[absdir(op->direction+1)],
		     op->y+freearr_y[absdir(op->direction+1)]);
	  if(!left)
	    op->direction=absdir(op->direction-1);
	  else if(!right)
	    op->direction=absdir(op->direction+1);
	  else {		/* is this possible? */
	    stop_arrow(op,NULL);
	    return;
	  }
	}
      op->face.number=op->arch->faces[op->direction];
  }
  op->x+=DIRX(op),op->y+=DIRY(op);
  tmp=get_map_ob(op->map,op->x,op->y);
  while(tmp!=NULL&&!IS_ALIVE(tmp))
    tmp=tmp->above;
  if(tmp==NULL) {
    insert_ob_in_map(op,op->map);
    return;
  }
  if (REFL_MISSILE(tmp)){
    op->direction=absdir(op->direction+4),op->state=0;
    op->face.number+=4;
    if(op->face.number > op->arch->faces[8])
      op->face.number-=8;
    insert_ob_in_map(op,op->map);
    return;
  }
  if(attack_ob(tmp,op))
    stop_arrow(op,tmp);
  else
    if(op->direction)
      insert_ob_in_map(op,op->map);
    else
      stop_arrow(op,NULL);
}

#if 0
void stop_thrown(object *op,object *tmp) {
  if(wall(op->map,op->x,op->y))
    op->x-=DIRX(op),op->y-=DIRY(op);
  op->direction=0;
  UNSET_FLY(op);
  if(op->type!=BOMB)
    op->speed=0,op->speed_left= -2;
  insert_ob_in_map(op,op->map);
  if(tmp!=NULL&&tmp->stats.hp>=0) { /* Hack to get monster on top */
    remove_ob(tmp);
    insert_ob_in_map(tmp,tmp->map);
  }
}
#endif

#if 0 /* This routine is buggy, and removed for now */
void move_thrown(object *op) {
  object *tmp;
  int roll;
  char buf[MAX_BUF];

  remove_ob(op);
  if(op->thrown--<1) {
    stop_thrown(op,NULL);
    return;
  }
  op->x+=DIRX(op),op->y+=DIRY(op);
  if(out_of_map(op->map,op->x,op->y)) {
    LOG(llevError,"Thrown object out of map.\n");
    stop_thrown(op,NULL);
    remove_ob(op);
    free_object(op);
    return;
  }
  if(wall(op->map,op->x,op->y)) {
    stop_thrown(op,NULL);
    return;
  }
  tmp=get_map_ob(op->map,op->x,op->y);
  while(tmp!=NULL&&!IS_ALIVE(tmp))
    tmp=tmp->above;
  if(tmp==NULL) {
    insert_ob_in_map(op,op->map);
    return;
  }
  roll=RANDOM()%20+1;
  if(roll==20||tmp->stats.ac>=op->thrownthaco-roll) {
    sprintf(buf,"%s hits you with %s.",op->owner->name,op->name);
    draw_info(tmp,buf);
    sprintf(buf,"%s hits %s with %s.",op->owner->name,tmp->name,op->name);
    info_all(buf,10);
    hit_player(tmp,RANDOM()%(op->weight>50000?11:op->weight/5000+1),op->owner,
               AT_PHYSICAL);
    stop_thrown(op,tmp);
    return;
  } else
  if(op->thrownthaco-roll<5) {
    sprintf(buf,"%s's %s hits %s's armour.",op->owner->name,op->name,tmp->name);
    info_all(buf,10);
    stop_thrown(op,tmp);
    return;
  }
  insert_ob_in_map(op,op->map);
}
#endif

void change_object(object *op) { /* Doesn`t handle linked objs yet */
  object *tmp;
  int i,j;
  if(op->other_arch==NULL) {
    LOG(llevError,"Change object without other_arch error.\n");
    return;
  }
  remove_ob(op);
  for(i=0;i<NROFNEWOBJS(op);i++) {
    tmp=arch_to_object(op->other_arch);
    tmp->stats.hp=op->stats.hp; /* The only variable it keeps. */
    j=find_first_free_spot(tmp->arch,op->map,op->x,op->y);
    tmp->x=op->x+freearr_x[j],tmp->y=op->y+freearr_y[j];
    insert_ob_in_map(tmp,op->map);
  }
  free_object(op);
}

void move_teleporter(object *op) {
  if(op->above!=NULL) {
    if(EXIT_PATH(op)) {
      if(op->above->type==PLAYER)
        enter_exit(op->above,op);
      else
        return;
    }
    else if(EXIT_X(op)||EXIT_Y(op))
      transfer_ob(op->above,EXIT_X(op),EXIT_Y(op));
    else
      teleport(op,TELEPORTER);
  }
}

void move_firewall(object *op) {
  fire_arch(op,op->stats.sp?op->stats.sp:(RANDOM()%8)+1,op->other_arch,0);
}

void move_firechest(object *op) {
  fire_a_ball(op,(RANDOM()%8)+1,7);
}

int process_object(object *op) {
  if(IS_MONSTER(op))
    if(move_monster(op) || IS_FREED(op))
      return 1;
  if(ANIMATED(op) && op->anim_speed==0)
    animate_object(op);
  if(CHANGING(op)&&!op->state) {
    change_object(op);
    return 1;
  }
  if(IS_GENERATOR(op))
    generate_monster(op);
  if(IS_USED_UP(op)&&--op->stats.food<=0) {
    if(IS_APPLIED(op))
      remove_force(op);
    else {
      remove_ob(op);
      free_object(op);
    }
    return 1;
  }
  switch(op->type) {
  case FORCE:
    remove_force(op);
    return 1;
  case CONFUSION:
    remove_confusion(op);
    return 0;
  case POISONING:
    poison_more(op);
    return 0;
  case WORD_OF_RECALL:
    execute_wor(op);
    return 0;
  case BULLET:
    move_fired_arch(op);
    return 0;
  case MMISSILE:
    move_missile(op);
    return 0;
  case ARROW:
  case BOLT:
    move_arrow(op);
    return 0;
  case FBULLET:
    move_fired_arch(op);
    return 0;
  case FBALL:
  case POISONCLOUD:
    explosion(op);
    return 0;
  case LIGHTNING:
    move_bolt(op);
    return 0;
  case CONE:
    move_cone(op);
    return 0;
  case DOOR:
    remove_door(op);
    return 0;
  case LOCKED_DOOR:
    remove_door2(op);
    return 0;
  case TELEPORTER:
    move_teleporter(op);
    return 0;
  case BOMB:
    animate_bomb(op);
    return 0;
  case GOLEM:
    move_golem(op);
    return 0;
  case FIREWALL:
    move_firewall(op);
    if (op->stats.maxsp)
      animate_turning(op);
    return 0;
  case FIRECHEST:
    move_firechest(op);
    return 0;
  case GATE:
    move_gate(op);
    return 0;
  case TIMED_GATE:
    move_timed_gate(op);
    return 0;
  case TRIGGER:
  case TRIGGER_BUTTON:
  case TRIGGER_PEDESTAL:
  case TRIGGER_ALTAR:
    animate_trigger(op);
    return 0;
  case DIRECTOR:
    if (op->stats.maxsp)
      animate_turning(op);
    return 0;
  case HOLE:
    move_hole(op);
    return 0;
  case DEEP_SWAMP:
    deep_swamp(op, 0);
    return 0;
  case CANCELLATION:
    move_cancellation(op);
    return 0;
  }
  return 0;
}
