/*
 * static char *rcsid_swamp_c =
 *   "$Id: swamp.c,v 1.2 1993/04/02 22:22:24 frankj Exp $";
 */

#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif

void deep_swamp(object *op, int walk_on)
{
  object *above = op->above;
  object *nabove;
  char buf[MAX_BUF];

  while(above) {
    nabove = above->above;
    if (above->type==PLAYER) {
      if (above->stats.hp < 0) continue;
      if (IS_FLYING(above)) /* Must be present.  -Frank */
        break;
      if (op->stats.food == 0 || walk_on) {
	draw_info(above, "You are down to your knees in the swamp.");
	op->stats.food = 1;
	above->speed_left -= SLOW_PENALTY(op);
      } else {
	switch(op->stats.food) {
	case 1:
	  if (RANDOM()%3 == 0) {
	    draw_info(above, "You are down to your waist in the wet swamp.");
	    op->stats.food = 2;
	    above->speed_left -= SLOW_PENALTY(op);
	  }
	  break;
	case 2:
	  if (RANDOM()%3 == 0) {
	    draw_info(above, "You are down to your NECK in the dangerous swamp.");
	    op->stats.food = 3;
	    above->speed_left -= SLOW_PENALTY(op);
	  }
	  break;
	case 3:
	  if (RANDOM()%5 == 0) {
#if 0
	    object *lifesaver;
#endif
	    op->stats.food = 0;
	    sprintf(buf,"%s disappeared into a swamp.",above->name);
	    info_all(buf, 1);
	    info_flush();

#if 0
	    for (lifesaver = above->inv; 
		 lifesaver; 
		 lifesaver = lifesaver->below) {
	      if(lifesaver->type == op->stats.sp && 
		 lifesaver->stats.maxsp == op->map->level)
		  break;
	  
	    if (lifesaver) {
	      object *rop, *nop, *eop;
	      info_all("The swamp boils away!", 1);
	      info_flush();
	      eop = clone_arch(EXIT);
	      eop->x = above->x; eop->y = above->y;
	      EXIT_PATH(eop) = EXIT_PATH(lifesaver);
	      EXIT_X(eop) = EXIT_X(lifesaver);
	      EXIT_Y(eop) = EXIT_Y(lifesaver);
	      lifesaver->stats.maxsp = -1;
/*	      add_callout(lifesaver, 70, black_wizzard_lifesaver, (void *)1);*/
	      for (rop = op; rop; rop = nop) {
		nop = rop->above;
		if (rop != above) {
		  remove_ob(rop);
		  free_object(rop);
		}
	      }
	      insert_ob_in_map(eop, above->map);
	      remove_ob(above);
	      insert_ob_in_map(above, above->map);
	      return;
	    } else 
#endif
	    {
	      strcpy(above->contr->killer,"drowning in a swamp");
	      above->stats.hp = -1;
              if(save_life(above))
                op->stats.food=0;
	    }
	  }
	  break;
	}
      }
    } else if (!IS_ALIVE(above)) {
      if (RANDOM()%3 == 0) decrease_ob(above);
    }
    above = nabove;
  }
}
