/*
 * static char *rcsid_input_c =
 *   "$Id: input.c,v 1.8 1993/04/25 16:33:10 frankj Exp $";
 */
/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <input.h>
#include <version.h>
#include <main.h>
#include <spells.h>

#ifdef SET_TITLE
extern void redraw_title(object *pl);
#endif /* SET_TITLE */

void pick_up(object *op,object *alt) {
  object *tmp;
  char buf[MAX_BUF];
  int flag;

  if(IS_FLYING(op)&&!IS_WIZ(op)) {
    draw_info(op,"You are levitating, you can't reach the ground!");
    return;
  }
  if(alt!=NULL)
    if(!can_pick(op,alt)) {
      draw_info(op,"You can't take that!");
      return;
    } else
      tmp=alt;
  else if(op->below==NULL||!can_pick(op,op->below)) {
    draw_info(op,"There is nothing to pick up here.");
    return;
  } else
    tmp=op->below;

  if(WAS_WIZ(tmp)&&!WAS_WIZ(op)) {
    draw_info(op,"The object disappears in a puff of smoke!");
    draw_info(op,"It must have been an illusion.");
    remove_ob(tmp);
    free_object(tmp);
    return;
  }

/* Eneq(@csd.uu.se): Determine if the object is being picked up from a
   container or from the ground. */

  if (op->container&&tmp->env!=op->container) flag=1;
  else flag =0;


  if(WAS_WIZ(op))
    SET_WAS_WIZ(tmp);
  if(op->contr->count) {
    tmp=get_split_ob(tmp,op->contr->count);
    op->contr->count=0;
    if(tmp==NULL) {
      draw_info(op,errmsg);
      return;
    }
  }
  else
    remove_ob(tmp); /* Unlink it */
  if(IS_UNPAID(tmp))
    (void) sprintf(buf,"%s will cost you %s.",query_name(tmp),
                   query_cost_string(tmp,op,F_BUY));
  else
    (void) sprintf(buf,"You pick up %s.",query_name(tmp));
  draw_info(op,buf);
  op->contr->last_used=tmp;
  op->contr->last_used_id=tmp->count;

/* Eneq(@csd.uu.se): Fixed it so that if a container is active the object
   picked up will automatically go to the container */

  if(flag)
      insert_ob_in_ob(tmp, op->container);
  else insert_ob_in_ob(tmp,op);
  draw_inventory(op);

  /* Eneq(@csd.uu.se): Don't forget to draw the containers inv. */

  if (op->container)
      draw_look (op);
}

void drop(object *op,object *tmp) {
  char buf[MAX_BUF];
  object *floor=get_map_ob(op->map,op->x,op->y);

  while(tmp!=NULL&&tmp->invisible)
    tmp=tmp->below;
  if(tmp==NULL) {
    draw_info(op,"You don't have anything to drop.");
    return;
  } else if (NO_DROP(tmp)) {

      /* Eneq(@csd.uu.se): Objects with NO_DROP defined can't be dropped. */

      draw_info(op, "This item can't be dropped.");
      return;
  } else if (tmp==op->container) {
      draw_info (op, "You can't drop a container into itself.");
      return;
  } else if (op->container&&
             (op->container->carrying+
              (tmp->nrof?tmp->nrof*tmp->weight*(100-op->container->bonus)/100:
               (tmp->weight+tmp->carrying)*(100-op->container->bonus)/100))
             > op->container->weight_limit) {
      draw_info (op, "The container can't hold that much.");
      return;
  } else if (op->container&&tmp->type==CONTAINER&&tmp->carrying) {

/* Eneq(@csd.uu.se): If the object to be dropped is a container we instead
   move the contents of that container into the active container, this is
   only done if the object has something in it. */

      while (tmp->inv)
          drop (op, tmp->inv);
      draw_info (op, "You put the items into the container.");
      return;
  }


  if(op->contr->last_used==tmp&&op->contr->last_used_id==tmp->count) {
    object *n=NULL;
    if(tmp->below!=NULL)
      n=tmp->below;
    else if(tmp->above!=NULL)
      n=tmp->above;
    op->contr->last_used=n;
    if(n!=NULL)
      op->contr->last_used_id=n->count;
    else
      op->contr->last_used_id=0;
  }

  /* Small hack to avoid autojoining in apply_special(): */
  if(IS_APPLIED(tmp)) {
    int nrof = tmp->nrof,a;
    tmp->nrof = 0;
    a=apply_special(op,tmp);
    tmp->nrof = nrof;
    if(a)
      return;
  }

  if(op->contr->count) {
    tmp=get_split_ob(tmp,op->contr->count);
    op->contr->count=0;
    if(tmp==NULL) {
      draw_info(op,errmsg);
      return;
    }
  } else
    remove_ob(tmp);
  tmp->x=op->x,tmp->y=op->y;
  if(STARTEQUIP(tmp)) {
    (void) sprintf(buf,"You drop %s.",query_name(tmp));
    draw_info(op,buf);
    draw_info(op,"The gods who lent it to you retrieves it.");
    free_object(tmp);
    fix_player(op);
    return;
  }
  if (op->container) {
      (void) sprintf(buf,"You put %s in the container.",query_name(tmp));
      insert_ob_in_ob(tmp,op->container);
      draw_info(op,buf);
  } else {
    if(!IS_UNPAID(tmp)&&tmp->nrof?tmp->value*tmp->nrof:tmp->value>2000)
#if SAVE_INTERVAL
      if((op->contr->last_save_time+SAVE_INTERVAL)>=time(NULL))
	{
	  save_player(op,1);
	  op->contr->last_save_time=time(NULL);
	}
#else /* SAVE_INTERVAL */
      save_player(op,1); /* To avoid cheating */
#endif /* SAVE_INTERVAL */
    if(floor!=NULL&&floor->type==SHOP_FLOOR&&!IS_UNPAID(tmp)&&
       tmp->type!=GOLDCOIN&&tmp->type!=SILVERCOIN)
      sell_item(tmp,op);
    D_LOCK(op);
    insert_ob_in_map(tmp,op->map);
    remove_ob(op);
    insert_ob_in_map(op,op->map);
    D_UNLOCK(op);
  }
  draw_look(op);
  draw_inventory(op);
  fix_player(op); /* This is overkill, fix_player() is called somewhere */ 
                  /* in object.c */
}

/* Eneq(@csd.uu.se): Had to remove rotate_right and replace it with a version
   which doesn't use insert_ob_in_ob since I redid that to add things last in
   the inventory, or next to objects of it's own type. This one now works just
   like rotate_left but reversed :-) 
   [ And now handles invisible objects. Tero.Haatanen@lut.fi ] */

void rotate_right(object *op) {
  object *tmp;
  char buf[MAX_BUF];
  int items=0;

  for (tmp=op->inv;tmp;tmp=tmp->below)
    if (!tmp->invisible)
      items++;

  if(items==0) {
    draw_info(op,"You don't carry anything.");
    return;
  }
  if(items==1) {
    draw_info(op,"You only carry one thing.");
    return;
  }
  op->contr->last_used=NULL;
  op->contr->last_used_id=0;
  for (tmp=op->inv; tmp && tmp->below; tmp=tmp->below);
  while(tmp!=NULL&&tmp->invisible)
    tmp=tmp->above;
  /* tmp points now the last visible item in the inventory */
  tmp->above->below=tmp->below;
  if (tmp->below)
    tmp->below->above=tmp->above;
  tmp->above=NULL;
  tmp->below=op->inv;
  op->inv->above=tmp;
  op->inv=tmp;

  if(IS_WIZ(op))
    sprintf(buf,"The %s (%d) is now on top.",
            query_name(op->inv),op->inv->count);
  else
    sprintf(buf,"The %s is now on top.",query_name(op->inv));
  draw_info(op,buf);
  draw_inventory(op);
}

/*
 * [ Now rotete_left handles invisible objects too. Tero.Haatanen@lut.fi ]
 */

void rotate_left(object *op) {
  object *tmp,*tmp2;
  char buf[MAX_BUF];
  int items=0;

  for (tmp=op->inv;tmp;tmp=tmp->below)
    if (!tmp->invisible)
      items++;

  if(items==0) {
    draw_info(op,"You don't carry anything.");
    return;
  }
  if(items==1) {
    draw_info(op,"You only carry one thing.");
    return;
  }
  op->contr->last_used=NULL;
  op->contr->last_used_id=0;
  for (tmp=op->inv; tmp && tmp->below; tmp=tmp->below);
  for (tmp2=op->inv->below; tmp2 && tmp2->invisible; tmp2=tmp2->below);

  tmp2->above->below=NULL;
  tmp2->above=NULL;
  tmp->below=op->inv;
  op->inv->above=tmp;
  op->inv=tmp2;

  if(IS_WIZ(op))
    sprintf(buf,"The %s (%d) is now on top.",
            query_name(op->inv),op->inv->count);
  else
    sprintf(buf,"The %s is now on top.",query_name(op->inv));
  draw_info(op,buf);
  draw_inventory(op);
}

void apply_inventory(object *op) {
  char buf[MAX_BUF];
  object *inv;
  if(op->contr->last_used!=NULL) {
    inv=op->contr->last_used;
    if(IS_FREED(inv)||inv->count!=op->contr->last_used_id||
       inv->env==NULL||(inv->env!=op&&inv->env->env!=op)) {
      op->contr->last_used=NULL;
      op->contr->last_used_id=0;
      apply_inventory(op);
      return;
    }
  } else {
    inv= op->inv;
    while(inv&&inv->invisible)
      inv=inv->below;
  }
  if(inv) {
    if(!apply(op,inv)) {
      sprintf(buf,"I don't know how to apply the %s.",query_name(inv));
      draw_info(op,buf);
    }
  } else {
    draw_info(op, "You have nothing to apply!");
  }
}

void drop_inventory(object *op) {
  object *inv,*n=NULL;
  if(op->contr->last_used!=NULL) {
    inv=op->contr->last_used;
    if(IS_FREED(inv)||inv->count!=op->contr->last_used_id||
       inv->env==NULL||(inv->env!=op&&inv->env->env!=op)) {
      op->contr->last_used=NULL;
      op->contr->last_used_id=0;
      drop_inventory(op);
      return;
    }
    inv=op->contr->last_used;
    if(inv->below!=NULL)
      n=inv->below;
    else if(inv->above!=NULL)
      n=inv->above;
    if(n!=NULL) {
      op->contr->last_used=n;
      op->contr->last_used_id=n->count;
    }
  } else {
    inv=op->inv;
    while(inv&&inv->invisible)
      inv=inv->below;
  }
  if(inv)
    drop(op,inv);
  else
    draw_info(op,"You have nothing to drop!");
}


void examine_monster(object *op,object *tmp) {
  object *mon=tmp->head?tmp->head:tmp;
  archetype *at=tmp->arch;
  if(UNDEAD(mon))
    draw_info(op,"It is an undead force.");
  if(mon->level>op->level)
    draw_info(op,"It is likely more powerful than you.");
  else if(mon->level<op->level)
    draw_info(op,"It is likely less powerful than you.");
  else
    draw_info(op,"It is probably as powerful as you.");
  if(mon->attacktype&AT_ACID)
    draw_info(op,"You seem to smell an acrid odor.");
  if(tmp->type!=PLAYER)
    return;
  switch((mon->stats.hp+1)*4/(at->clone.stats.hp+1)) { /* From 1-4 */
  case 1:
    draw_info(op,"It is in a bad shape.");
    break;
  case 2:
    draw_info(op,"It is hurt.");
    break;
  case 3:
    draw_info(op,"It is somewhat hurt.");
    break;
  case 4:
    draw_info(op,"It is in excellent shape.");
    break;
  }
  if(present_in_ob(POISONING,mon)!=NULL)
    draw_info(op,"It looks very ill.");
}

char *long_desc(object *tmp) {
  static char buf[MAX_BUF],*cp;
  if(tmp==NULL)
    return "";
  buf[0]='\0';
  switch(tmp->type) {
  case RING:
  case WEAPON:
  case ARMOUR:
  case BRACERS:
  case HELMET:
  case SHIELD:
  case BOOTS:
  case GLOVES:
  case AMULET:
  case GIRDLE:
  case BOW:
    if(*(cp=describe_item(tmp))!='\0')
      sprintf(buf,"%s %s",query_name(tmp),cp);
    break;
  }
  if(buf[0]=='\0')
    sprintf(buf,"%s",query_name(tmp));

  return buf;
}

void examine(object *op, object *tmp) {
  char buf[MAX_BUF];
  if (tmp == NULL)
    return;
/* Eneq(csd.uu.se): If NO_PRETEXT is defined we should only print the name. */
  if (NO_PRETEXT(tmp))
    sprintf(buf, "%s.", long_desc(tmp));
  else
    sprintf(buf, "That is %s.", long_desc(tmp));
  draw_info(op,buf);
  buf[0]='\0';
  switch(tmp->type) {
  case SPELLBOOK:
    sprintf(buf,"%s is a %d level spell.",
            spells[tmp->stats.sp].name,spells[tmp->stats.sp].level);
    break;
  case BOOK:
    if(tmp->msg!=NULL)
      strcpy(buf,"Something is written in it.");
    break;
  case WAND:
    sprintf(buf,"It has %d charges left.",tmp->stats.food);
    break;
  }
  if(buf[0]!='\0')
    draw_info(op,buf);
  if(tmp->msg!=NULL&&tmp->type!=66&&tmp->type!=BOOK&&!WALK_ON(tmp)) {
    draw_info(op,"Something is written on it.");
    draw_info(op,tmp->msg);
  }
  if(tmp->material) {
    strcpy(buf,"It is made of: ");
    if(tmp->material&M_PAPER)
      strcat(buf,"paper ");
    if(tmp->material&M_IRON)
      strcat(buf,"iron ");
    if(tmp->material&M_GLASS)
      strcat(buf,"glass ");
    if(tmp->material&M_LEATHER)
      strcat(buf,"leather ");
    if(tmp->material&M_WOOD)
      strcat(buf,"wood ");
    if(tmp->material&M_ORGANIC)
      strcat(buf,"organics ");
    if(tmp->material&M_STONE)
      strcat(buf,"stone ");
    if(tmp->material&M_CLOTH)
      strcat(buf,"cloth ");
    draw_info(op,buf);
  }
  if(tmp->weight) {
    sprintf(buf,"%s weighs %3.3f kg.", tmp->nrof>1?"They":"It",
            (tmp->nrof?tmp->weight*tmp->nrof:tmp->weight)/1000.0);
    draw_info(op,buf);
  }
  if(tmp->value&&!STARTEQUIP(tmp)) {
    if(IS_UNPAID(tmp))
      sprintf(buf,"%s would cost you %s.",
              tmp->nrof>1?"They":"It",query_cost_string(tmp,op,F_BUY));
    else
      sprintf(buf,"You would get %s for %s.",
              query_cost_string(tmp,op,F_SELL), tmp->nrof>1?"them":"it");
    draw_info(op,buf);
  }
  if(IS_MONSTER(tmp))
    examine_monster(op,tmp);
  draw_info(op," "); /* Blank line */
}

/*
 * inventory prints object's inventory. If inv==NULL then print player's
 * inventory. 
 * [ Only items which are applied are showed. Tero.Haatanen@lut.fi ]
 */
void inventory(object *op,object *inv) {
  object *tmp;
  char buf[MAX_BUF], *in;
  int items = 0, length;

  if (inv==NULL && op==NULL) {
    draw_info(op, "Inventory of what object?");
    return;
  }
  tmp = inv ? inv->inv : op->inv;

  while (tmp) {
    if ((!tmp->invisible && 
	 (inv==NULL || IS_CONTAINER(inv) || IS_APPLIED(tmp))) || IS_WIZ(op))
      items++;
    tmp=tmp->below;
  }
  if (inv==NULL) { /* player's inventory */
    if (items==0) {
      draw_info(op,"You carry nothing.");
      return;
    } else {
      length = INFOCHARS-19;
      in = "";
      clear_win_info(op);
      draw_info(op,"Inventory:");
    }
  } else {
    if (items==0) 
      return;
    else { 
      length = INFOCHARS-21;
      in = "  ";
    }
  }
  for (tmp=inv?inv->inv:op->inv; tmp; tmp=tmp->below) {
    if(!IS_WIZ(op) && (tmp->invisible || (inv && !IS_CONTAINER(inv) && 
					  !IS_APPLIED(tmp))))
      continue;
    if(IS_WIZ(op))
      (void) sprintf(buf,"%s- %-*s (%5d) %-8s", in, length, query_name(tmp),
                     tmp->count,query_weight(tmp));
    else
      (void) sprintf(buf,"%s- %-*s %-8s", in, length+8, query_name(tmp),
                     query_weight(tmp));
    draw_info(op,buf);
  }
  if(!inv) {
    sprintf(buf,"%-*s %-8s",
	    INFOCHARS-9,"Total weight carried:",query_weight(op));
    draw_info(op,buf);
  }
}

/*
 * look_at prints items on the specifc square.
 * [ removed EARTHWALL check and added check for containers inventory.
 *   Tero.Haatanen@lut.fi ]
 */
void look_at(object *op,int dx,int dy) {
  object *tmp;
  char buf[MAX_BUF];
  int flag=0;

  if(op->above!=NULL) {
    remove_ob(op);
    insert_ob_in_map(op,op->map);
  }
  if(dx||dy) 
    for(tmp=get_map_ob(op->map,op->x+dx,op->y+dy);tmp!=NULL&&tmp->above!=NULL;
      tmp=tmp->above);
  else
    tmp=op->below;
  while(tmp && (IS_WIZ(op) ||(!tmp->invisible && tmp!=op))) {
    if(!flag) {
      if(dx||dy)
        draw_info(op,"There you see:");
      else {
        clear_win_info(op);
        draw_info(op,"You see:");
      }
      flag=1;
    }
    if(IS_WIZ(op))
      (void) sprintf(buf,"- %s (%d).",query_name(tmp),tmp->count);
    else
      (void) sprintf(buf,"- %s.",query_name(tmp));
    draw_info(op,buf);
    if((tmp->inv!=NULL || (tmp->head && tmp->head->inv)) && 
       ( (!dx&&!dy) || !IS_CONTAINER(tmp) || IS_WIZ(op)))
      inventory(op,tmp->head==NULL?tmp:tmp->head);
    if(IS_FLOOR(tmp)&&!IS_WIZ(op))	/* don't continue under the floor */
      break;
    tmp=tmp->below;
  }
  if(!flag)
    if(dx||dy)
      draw_info(op,"You see nothing there.");
    else
      draw_info(op,"You see nothing.");
}

void configure_keys(object *op,KeyCode k) {
  char buf[MAX_BUF];

  if(k!=0)
    op->contr->keys[op->contr->configure]=k;
  else
    op->contr->configure=K_QUIT;
  if(++op->contr->configure>K_RUN2) {
    op->contr->state=ST_PLAYING;
    draw_info(op,"Done configuring cursor-keys.");
    return;
  }
  sprintf(buf,"Press key to %s.",key_text[op->contr->configure]);
  draw_info(op,buf);
}

void malloc_info(object *op) {
  int ob_used=count_used(),ob_free=count_free(),players,nrofmaps;
  int nrm=0,mapmem=0,anr,anims,sum_alloc=0,sum_used=0,i,j,tlnr;
  treasurelist *tl;
  player *pl;
  mapstruct *m;
  archetype *at;
  for(tl=first_treasurelist,tlnr=0;tl!=NULL;tl=tl->next,tlnr++);
  for(at=first_archetype,anr=0,anims=0;at!=NULL;
      at=at->more==NULL?at->next:at->more,anr++)
    if(at->faces!=NULL)
      anims+=at->animations+1;
  for(pl=first_player,players=0;pl!=NULL;pl=pl->next,players++);
  for(m=first_map,nrofmaps=0;m!=NULL;m=m->next,nrofmaps++)
    if(m->in_memory == MAP_IN_MEMORY)
      mapmem+=m->mapx*m->mapy*(sizeof(object *)+sizeof(unsigned char *)*2),
      nrm++;
  sprintf(errmsg,"Sizeof: object=%d  player=%d  map=%d",
          sizeof(object),sizeof(player),sizeof(mapstruct));
  draw_info(op,errmsg);
  sprintf(errmsg,"%4d used objects:    %8d",ob_used,i=(ob_used*sizeof(object)));
  draw_info(op,errmsg);
  sum_used+=i;  sum_alloc+=i;
  sprintf(errmsg,"%4d free objects:    %8d",ob_free,i=(ob_free*sizeof(object)));
  draw_info(op,errmsg);
  sum_alloc+=i;
  sprintf(errmsg,"%4d players:         %8d",players,i=(players*sizeof(player)));
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  for(pl=first_player,i=0;pl!=NULL;pl=pl->next)
    i+=pl->infolines*pl->infochars*sizeof(char)+
       pl->inv_chars*pl->inv_size*sizeof(char)+
       pl->look_chars*pl->look_size*sizeof(char);
  sprintf(errmsg,"%4d player windows:  %8d",players*3,i);
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  for(pl=first_player,i=0,j=0;pl!=NULL;pl=pl->next)
    if(pl->pixmaps!=NULL)
      i+=nrofpixmaps*sizeof(Pixmap), j++;
  sprintf(errmsg,"%4d pixmap sets:     %8d",j,i);
  draw_info(op,errmsg),
  sum_alloc+=i; sum_used+=i;
  sprintf(errmsg,"%4d maps allocated:  %8d",nrofmaps,
          i=(nrofmaps*sizeof(mapstruct)));
  draw_info(op,errmsg);
  sum_alloc+=i;  sum_used+=nrm*sizeof(mapstruct);
  sprintf(errmsg,"%4d maps in memory:  %8d",nrm,mapmem);
  draw_info(op,errmsg);
  sum_alloc+=mapmem; sum_used+=mapmem;
  sprintf(errmsg,"%4d archetypes:      %8d",anr,i=(anr*sizeof(archetype)));
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  sprintf(errmsg,"%4d animations:      %8d",anims,i=(anims*sizeof(Fontindex)));
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  sprintf(errmsg,"%4d spells:          %8d",NROFREALSPELLS,
          i=(NROFREALSPELLS*sizeof(spell)));
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  sprintf(errmsg,"%4d treasurelists    %8d",tlnr,i=(tlnr*sizeof(treasurelist)));
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  sprintf(errmsg,"%4d treasures        %8d",nroftreasures,
          i=(nroftreasures*sizeof(treasure)));
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  sprintf(errmsg,"%4d old treasurelist %8d",NROF_T,
          i=(MAX_T*NROF_T*sizeof(old_treasure)));
  draw_info(op,errmsg);
  sum_alloc+=i; sum_used+=i;
  sprintf(errmsg,"Total space allocated:%8d",sum_alloc);
  draw_info(op,errmsg);
  sprintf(errmsg,"Total space used:     %8d",sum_used);
  draw_info(op,errmsg);
}

int count_pending(mapstruct *map) {
  objectlink *obl;
  int i;

  for(i=0, obl = map->pending; obl != NULL; obl = obl->next)
    i++;
  return i;
}

void current_map_info(object *op) {
    mapstruct *m = op->map;
    char buf[MAX_BUF];

    if (!m)
	return;

    sprintf (buf, "%s (%s)", m->map_object->name, m->path);
    draw_info (op,buf);
    if (IS_WIZ (op)) {
	sprintf (buf, "players:%d difficulty:%d size:%dx%d start:%dx%d", 
		 m->players, m->difficulty, 
		 m->mapx, m->mapy, 
		 EXIT_X(m->map_object), EXIT_Y(m->map_object));

	draw_info (op,buf);
    }
    print_message(op, m->map_object->msg, 2);
}


void map_info(object *op) {
  mapstruct *m;
  char buf[MAX_BUF];
  long sec = seconds();
  if(MAP_RESET != 0) {
    sprintf(buf,"Current time is: %2d:%2d:%2d.",
            (sec%86400)/3600,(sec%3600)/60,sec%60);
    draw_info(op,buf);
    draw_info(op,"              Name Pl Pl M TO Di Pe Reset");
  } else
    draw_info(op,"              Name Pl Pl M TO Di Pe");
  for(m=first_map;m!=NULL;m=m->next) {
    if(MAP_RESET == 0 && m->in_memory == MAP_SWAPPED)
      continue;
    if(MAP_RESET == 0)
      sprintf(buf,"%18s %2d %2d %1d %2d %2d %2d",
              m->path, m->players,players_on_map(m),
              m->in_memory,m->timeout,m->difficulty, count_pending(m));
    else
      sprintf(buf,"%18s %2d %2d %1d %2d %2d %2d %2d:%2d:%2d",
              m->path, m->players,players_on_map(m),
              m->in_memory,m->timeout,m->difficulty, count_pending(m),
              (m->reset_time%86400)/3600,(m->reset_time%3600)/60,
              m->reset_time%60);
    draw_info(op,buf);
  }
}

#ifdef SAVE_PLAYER

void receive_player_name(object *op,char k) {
  if(k!=13) {
    if((k==8||k==127)&&(op->contr->writing==1))
      return;
    if(k!=8&&k!=127&&!((k>='a'&&k<='z')||(k>='A'&&k<='Z'))&&k!='-'&&k!='_')
      return;
    write_ch(op,k);
    return;
  }
  if(op->contr->writing<=1)
    return;
  if(!check_name(op->contr,op->contr->write_buf+1)) {
      get_name(op);
      return;
  }
  if(op->name!=NULL)
    free_string(op->name);
  op->name=add_string(op->contr->write_buf+1);
  draw_info(op,op->contr->write_buf);
  op->contr->last_value= -1; /* Flag: redraw all stats */
  draw_stats(op);
  op->contr->name_changed=1;
  get_password(op);
}

void receive_player_password(object *op,char k) {
  if(k!=13) {
    if(k!=8&&k!=127&&(!((k>='a'&&k<='z')||(k>='A'&&k<='Z'))||
       op->contr->writing>8)) /* Max 8 characters in password */
      return;
    write_ch(op,k);
    return;
  }
  op->contr->no_echo=0;
  if(op->contr->writing<=1) {
    remove_lock(op->contr);
    get_name(op);
    return;
  }
  op->contr->writing=0;
  draw_info(op,"          "); /* To hide the password better */
  if(op->contr->state==ST_CONFIRM_PASSWORD) {
    if(!check_password(op->contr->write_buf+1,op->contr->password)) {
      draw_info(op,"The passwords did not match.");
      remove_lock(op->contr);
      get_name(op);
      return;
    }
    clear_win_info(op);
    display_motd(op);
    draw_info(op," ");
    draw_info(op,"Welcome, Brave New Warrior!");
    draw_info(op," ");
    Roll_Again(op);
    op->contr->state=ST_ROLL_STAT;
    return;
  }
  strcpy(op->contr->password,crypt_string(op->contr->write_buf+1,NULL));
  op->contr->state=ST_ROLL_STAT;
  check_login(op);
  return;
}

#endif

int parse_writing(object *op,char k) {
  char buf[MAX_BUF];

  if(k!=13) {
    write_ch(op,k);
    return 1;
  }
  if(op->contr->write_buf[0]=='\"') {
    char *cp;
    write_ch(op,'\"');
    op->contr->writing=0;
    (void) sprintf(buf,"%s says %s",op->name,op->contr->write_buf);
    info_map(op->map, buf);

    /* Remove the " */
    cp = strchr(op->contr->write_buf+1,'\"');
    if (cp != NULL)
      *cp = '\0';

    communicate(op,op->contr->write_buf+1);
    return 0;
  }
  if(op->contr->write_buf[0]=='>')
    return parse_string(op,op->contr->write_buf+1);
  return 0;
}

void draw_one_push_key(player *pl, int i) {
  char buf[MAX_BUF], *cp;
  cp=keycodetochar(pl->ob,pl->pushkeys[i]);
  sprintf(buf,"%2d %-8s %s", i,
          cp==NULL?"NoSymbol":cp,
          pl->pushkeys[i]==0?"Unused":pl->pushstring[i]);
  draw_info(pl->ob,buf);
}

void list_push_keys(player *pl) {
  int i;

  clear_win_info(pl->ob);
  draw_info(pl->ob,"Nr Key      String");
  for(i=0;i<NROFPUSHKEYS;i++)
    draw_one_push_key(pl,i);
}

void undefine_push_key(player *pl, char *cp) {
  int i,nr= -1;

  if(!sscanf(cp,"%d",&nr))
    for(i=0;i<NROFPUSHKEYS;i++)
      if(pl->pushkeys[i]&&!strcmp(cp,pl->pushstring[i])) {
        nr=i;
        break;
      }
  if(nr == -1) {
    draw_info(pl->ob,"There is no such key defined.");
    return;
  }
  draw_info(pl->ob,"Undefined:");
  draw_one_push_key(pl,nr);
  pl->pushkeys[nr]=0;
}

void fix_push_key(player *pl,KeyCode ks) {
  int i;
  for(i=0;i<NROFPUSHKEYS;i++)
    if(pl->pushkeys[i]==ks)
      break;
  if(pl->key_state==2) { /* undefine */
    if(i==NROFPUSHKEYS)
      draw_info(pl->ob,"That key had no previous definition.");
    else {
      pl->pushkeys[i]=0;
      draw_info(pl->ob,"Key is now undefined.");
    }
    pl->key_state=0;
    return;
  }
  if(i==NROFPUSHKEYS)
    for(i=0;i<NROFPUSHKEYS;i++)
      if(pl->pushkeys[i]==0)
        break;
  if(i==NROFPUSHKEYS)
    i=0;
  pl->pushkeys[i]=ks;
  strncpy(pl->pushstring[i],pl->buf,INFOCHARS);
  pl->key_state=0;
  draw_info(pl->ob,"OK.");
}

void set_pickup_mode(object *op,int i) {
  switch(op->contr->mode=i) {
    case 0:
      draw_info(op,"Mode: Don't pick up.");
      break;
    case 1:
      draw_info(op,"Mode: Pick up one item.");
      break;
    case 2:
      draw_info(op,"Mode: Pick up one item and stop.");
      break;
    case 3:
      draw_info(op,"Mode: Stop before picking up.");
      break;
    case 4:
      draw_info(op,"Mode: Pick up all items.");
      break;
    case 5:
      draw_info(op,"Mode: Pick up all items and stop.");
      break;
    }
}

#ifdef SIMPLE_PARTY_SYSTEM
void send_party_message(object *op,char *msg)
{
  player *pl;
  int no=op->contr->party_number;
  for(pl=first_player;pl!=NULL;pl=pl->next)
    if(pl->ob->contr->party_number==no && pl->ob!=op)
      draw_info(pl->ob,msg);
}
#endif /* SIMPLE_PARTY_SYSTEM */

int explore_mode() {
#ifdef EXPLORE_MODE
  player *pl;
  for (pl = first_player; pl != (player *) NULL; pl = pl->next)
    if (pl->explore)
      return 1;
#endif
  return 0;
}

void print_help(object *op) {
  if(op == NULL) {
    draw_info(op,"Commands:");
    draw_info(op,"  version       - Displays version.");
    draw_info(op,"  protocol <nr> - Change protcol.");
    draw_info(op,"  name <name>   - Specify your username.");
  } else {
    draw_info(op,"Commands: (type ' before them)");
#ifndef SAVE_PLAYER
    draw_info(op,"  name <name>   - Changes your name.");
#endif
    draw_info(op,"  cast <spell>  - Changes type of spell.");
    draw_info(op,"  pickup <mode> - Mode can be 0-5.  Try them.");
    draw_info(op,"  scroll        - Toggles scroll here.");
    draw_info(op,"  peaceful      - Toggles player attack.");
    draw_info(op,"  define [str]  - Defines/lists push-keys.");
    draw_info(op,"  undefine [nr] - Undo defines.");
#ifdef CHRFONT
    draw_info(op,"  chrfont [font]- Change character font.");
#endif
#ifdef PLAYER_COLORS /* allow players to choose their characters color */
    draw_info(op,"  color [?/clr] - Set character color.");
#endif /* PLAYER_COLORS */
#ifdef SIMPLE_PARTY_SYSTEM
    draw_info(op,"  party [args]  - Party system (party help).");
#endif /* SIMPLE_PARTY_SYSTEM */
#ifdef SET_TILE
    draw_info(op,"  title [new]   - Set title (title clear).");
#endif /* SET_TITLE */
#ifdef SAVE_PLAYER
    draw_info(op,"  save          - Save your character.");
#endif /* SAVE_PLAYER */
#ifdef SEARCH_ITEMS
    draw_info(op,"  search <item> - Automatically pick <item>.");
#endif /* SEARCH_ITEMS */
  }
  draw_info(op,"  quit          - Destroy char/leave game.");
  draw_info(op,"  who           - Lists all players.");
  draw_info(op,"  shout <text>  - Informate all players.");
  draw_info(op,"  tell <p> <ms> - Tell message to player");
  draw_info(op,"  bell <p>      - Bell a player");
  draw_info(op,"  listen <1-15> - Brief->verbose.");
  draw_info(op,"  wimpy <1-100> - Set wimpy mode.");
#ifdef EXPLORE_MODE
  if (!explore_mode())
#endif
  draw_info(op,"  add <display> - Adds a new player.");
  draw_info(op,"  hiscore       - Highscore-list.");
  draw_info(op,"  malloc        - Memory usage.");
  draw_info(op,"  maps          - Map usage.");
  draw_info(op,"  strings       - Info on string usage.");
  draw_info(op,"  archs         - Info on arch-hashing.");
  draw_info(op,"  time          - Tick time statistics.");
  draw_info(op,"  help          - Gives this info.");
  draw_info(op,"  dm            - Enters cheat mode.");
#ifdef EXPLORE_MODE
  draw_info(op,"  explore       - Enters explore (no die) mode.");
#endif 
  if(op == NULL ? active_socket->wiz : IS_WIZ(op)) {
    draw_info(op,"Cheat mode commands:");
    draw_info(op,"  nodm             - Leave dm-mode.");
    if(op != NULL) {
      draw_info(op,"  goto <map-level> - Teleport to map.");
      draw_info(op,"  summon <player>  - Teleport player.");
      draw_info(op,"  create <number> <archetype>");
    }
    draw_info(op,"  synchronize      - Toggle synchronizing.");
    draw_info(op,"  reset <map>      - Reset map.");
    draw_info(op,"  speed [speed]    - Changes speed.");
    draw_info(op,"  addexp <player> <experience>");
    draw_info(op,"  stats <player>   - Show vital stats.");
    draw_info(op,"  abil <player> <stat> <1-25>");
    draw_info(op,"  dump <object>    - Lists variables.");
    draw_info(op,"  inventory <obj>  - Lists inventory.");
    draw_info(op,"  patch <ob> <variable> <value>");
    draw_info(op,"  (You can change everything with patch)");
  }
  if(op == NULL || IS_WIZ(op))
    draw_info(op,"  debug <level> - Set debug level.");
}

/*
 * parse_string may be called from a player in the game or from a socket
 * (op is NULL if it's a socket).
 * It returnes 1 if it recognized the command, otherwise 0.
 */

int parse_string(object *op,char *str) {
  char buf[MAX_BUF];
  object *tmp;
  static int iii;
  static char thing[20],thing2[20];
  player *pl;
  char *p=strchr(str,' ');
  int buf_len=(p==NULL?strlen(str):p-str);
  if(op == NULL) {
    if(active_socket == (sockets *) NULL) {
      LOG(llevError,"parse_string without active socket: %s\n",str);
      return 0;
    }
  } else {
    op->contr->writing=0;
    if(!op->contr->no_echo) {
      strcpy(buf,">");
      strcat(buf,str);
      draw_info(op,buf);
    }
  }
  if(!strncmp(str,"help",buf_len)) {
    if(op != NULL)
      clear_win_info(op);
    print_help(op);
    return 1;
  }
  if (!strncmp(str, "chrfont", buf_len)) {
      XFontStruct *tmp_font;

      if (p!=NULL) {
          p++;
          if ((tmp_font=XLoadQueryFont(op->contr->gdisp, p)) != NULL) {
              strcpy (op->contr->font_str, p);
              XFreeFont(op->contr->gdisp, tmp_font);
          } else {
              LOG(llevError, "Crossfire: Couldn't load font %s.\n", p);
              draw_info (op, "Couldn't load font.");
          }
      } else draw_info(op, "What font?");
      return 1;
  }

  if(op != NULL) { /* Some commands are not accepted from sockets */
    if(!strncmp(str,"define",buf_len)) {
      if(p==NULL) {
        op->contr->writing=0;
        list_push_keys(op->contr);
        return 1;
      }
      p++;
      strcpy(op->contr->buf,p);
      op->contr->key_state=1;
      draw_info(op,"Push which key to redefine.");
      return 1;
    }
    if(!strncmp(str,"undefine",buf_len)) {
      if(p!=NULL) {
        p++;
        undefine_push_key(op->contr,p);
      } else {
        op->contr->key_state=2;
        draw_info(op,"Push which key to undefine.");
      }
      return 1;
    }
    if(!strncmp(str,"cast",buf_len)) {
      int i;
#ifdef SHOW_SP_USAGE
      char buf[MAX_BUF];
#endif /* SHOW_SP_USAGE */
      if(!op->contr->nrofknownspells&&!IS_WIZ(op)) {
        draw_info(op,"You don't know any spells.");
        return 1;
      }
      if(op->contr->golem!=NULL) {
        remove_friendly_object(op->contr->golem);
        remove_ob(op->contr->golem);
        free_object(op->contr->golem);
        op->contr->golem=NULL;
      }
      if(p!=NULL) {
        p++;
        if(IS_WIZ(op)) {
          for(i=0;i<NROFREALSPELLS;i++)
            if(!strncmp(p,spells[i].name,strlen(p))) {
              op->contr->shoottype=2;
              op->contr->chosen_spell=i;
              draw_stats(op);
              return 1;
            }
        } else {
          for(i=0;i<op->contr->nrofknownspells;i++)
            if(!strncmp(p,spells[op->contr->known_spells[i]].name,strlen(p))) {
              op->contr->shoottype=2;
              op->contr->chosen_spell=op->contr->known_spells[i];
              draw_stats(op);
              return 1;
            }
        }
      }
      draw_info(op,"Cast what spell?  Choose one of:");
#ifdef SHOW_SP_USAGE
      draw_info(op,"[sp] spell name");
#endif /* SHOW_SP_USAGE */
      if(IS_WIZ(op))
        for(i=0;i<NROFREALSPELLS;i++)
#ifdef SHOW_SP_USAGE
	  {
	    sprintf(buf,"[%2i] %s",spells[i].sp,
		    spells[i].name);
	    draw_info(op,buf);
	  }
#else /* SHOW_SP_USAGE */
          draw_info(op,spells[i].name);
#endif /* SHOW_SP_USAGE */
      else
        for(i=0;i<op->contr->nrofknownspells;i++)
#ifdef SHOW_SP_USAGE
	  {
	    sprintf(buf,"[%2i] %s",spells[op->contr->known_spells[i]].sp,
		    spells[op->contr->known_spells[i]].name);
	    draw_info(op,buf);
	  }
#else /* SHOW_SP_USAGE */
          draw_info(op,spells[op->contr->known_spells[i]].name);
#endif /* SHOW_SP_USAGE */
        return 1;
    }
#ifdef SIMPLE_PARTY_SYSTEM
    if(!strncmp(str,"party",buf_len)) {
      int no;
      char buf[MAX_BUF];
      if(p==NULL) {
	if(op->contr->party_number<=0) {
	  draw_info(op,"You are not a member of any party.");
	  draw_info(op,"For help try: party help");
	}
	else {
	  sprintf(buf,"You are a member of party number %d.",
		  op->contr->party_number);
	  draw_info(op,buf);
	}
	return 1;
      }
      p++;
      if(strcmp(p,"help")==0) {
	draw_info(op,"To join a party type: party <number>");
	draw_info(op,"  <number> is a number between 1 and 9999");
	draw_info(op,"To leave a party type: party leave");
	draw_info(op,"To talk to party members type: party say <msg>");
	draw_info(op,"To see who is in your party: party who");
	return 1;
      }
      if(strncmp(p,"say ",4)==0)
	{
	  if(op->contr->party_number<=0)
	    {
	      draw_info(op,"You are not a member of any party.");
	      return 1;
	    }
	  p+=4;
	  sprintf(buf,"%s says: %s",op->name,p);
	  send_party_message(op,buf);
	  draw_info(op,"Ok.");
	  return 1;
	}
      if(strcmp(p,"leave")==0) {
        if((no=op->contr->party_number)<=0)
        {
          draw_info(op,"You are not a member of any party.");
          return 1;
        }
        sprintf(buf,"You leave party number %d.",no);
        draw_info(op,buf);
	sprintf(buf,"%s leaves party number %d.",op->name,no);
	send_party_message(op,buf);
	op->contr->party_number=-1;
	return 1;
      }
      if(strcmp(p,"who")==0) {
	player *pl;
	int no=op->contr->party_number;
	if(no<=0) {
	  draw_info(op,"You are not a member of any party.");
	  return 1;
	}
	sprintf(buf,"Members of party number %i.",no);
	sprintf(buf,"Lvl Name",no);
	draw_info(op,buf);
	for(pl=first_player;pl!=NULL;pl=pl->next)
	  if(pl->ob->contr->party_number==no) {
#ifdef SET_TITLE
	    if(pl->ob->contr->own_title[0]!='\0')
	      sprintf(buf,"%3d %s the %s",
		      pl->ob->level,pl->ob->name,pl->ob->contr->own_title);
	    else
#endif /* SET_TITLE */
	      sprintf(buf,"%3d %s the %s",
		      pl->ob->level,pl->ob->name,pl->ob->contr->title);
	    draw_info(op,buf);
	  }
	return 1;
      }
      no=atoi(p);
      if(no<1 || no>9999)
	{
	  draw_info(op,"For help try: party help");
	  return 1;
	}
      if(op->contr->party_number==no)
	{
	  sprintf(buf,"You already are a member of party %d.",no);
	  draw_info(op,buf);
	  return 1;
	}
      if(op->contr->party_number>0)
	{
	  sprintf(buf,"%s leaves party number %d.",op->name,no);
	  send_party_message(op,buf);
	}
      op->contr->party_number=no;
      sprintf(buf,"You join party number %d.",no);
      draw_info(op,buf);
      sprintf(buf,"%s joins party number %d.",op->name,no);
      send_party_message(op,buf);
      return 1;
    }
#endif /* SIMPLE_PARTY_SYSTEM */
#ifdef PLAYER_COLORS /* allow players to choose their characters color */
    if(!strncmp(str,"color",buf_len)) {
      int i;
      char buf[MAX_BUF];
      if(p==NULL) {
	sprintf(buf,"Your current color is %s.",
		coloralias[op->face.fg]);
	draw_info(op,buf);
	return 1;
      }
      p++;
      for(i=0;i<11;i++)
	if(strcmp(coloralias[i],p)==0) {
	  op->face.fg=i;
	  sprintf(buf,"Color set to %s.",
		  coloralias[op->face.fg]);
	  draw_info(op,buf);
	  refresh(op);
	  return 1;
	}
      strcpy(buf,"Invalid color, try one of the following: ");
      for(i=10;i>=0;i--) {
	strcat(buf,coloralias[i]);
	switch(i) {
	case 0:
	  strcat(buf,".");
	  break;
	case 1:
	  strcat(buf," or ");
	  break;
	default:
	  strcat(buf,", ");
	  break;
	}
      }
      draw_info(op,buf);
      return 1;
    }
#endif /* PLAYER_COLORS */
#ifdef SET_TITLE
    if(!strncmp(str,"title",buf_len)) {
      char buf[MAX_BUF];
      if(p==NULL) {
	if(op->contr->own_title[0]=='\0')
	  sprintf(buf,"Your title is '%s'.",
		  op->contr->title);
	else
	  sprintf(buf,"Your title is '%s'.",
		  op->contr->own_title);
	draw_info(op,buf);
	return 1;
      }
      p++;
      if(strcmp(p,"clear")==0 || strcmp(p,"default")==0) {
	if(op->contr->own_title[0]=='\0')
	  draw_info(op,"Your title is the default title.");
	else
	  draw_info(op,"Title set to default.");
	op->contr->own_title[0]='\0';
	redraw_title(op);
	return 1;
      }
      if(strlen(p)>=MAX_NAME) {
	draw_info(op,"Title too long.");
	return 1;
      }
      strcpy(op->contr->own_title,p);
      redraw_title(op);
      return 1;
    }
#endif /* SET_TITLE */
#ifdef SAVE_PLAYER
    if(!strncmp(str,"save",buf_len)) {
      if(save_player(op,1))
	draw_info(op,"You have been saved.");
      else
	draw_info(op,"SAVE FAILED!");
      return 1;
    }
#endif /* SAVE_PLAYER */
#ifdef SEARCH_ITEMS
    if(!strncmp(str,"search",buf_len)) {
      char buf[MAX_BUF];
      if(p==NULL) {
	if(op->contr->search_str[0]=='\0') {
	  draw_info(op,"Example: search magic+1");
	  draw_info(op,"Would automatically pick up all");
	  draw_info(op,"items containing the word 'magic+1'.");
	  return 1;
	}
	  
	op->contr->search_str[0]='\0';
	draw_info(op,"Search mode turned off.");
	return 1;
      }
      p++;
      if(strlen(p)>=MAX_BUF) {
	draw_info(op,"Search string too long.");
	return 1;
      }
      strcpy(op->contr->search_str,p);
      sprintf(buf,"Searching for '%s'.",op->contr->search_str);
      draw_info(op,buf);
      return 1;
    }
#endif /* SEARCH_ITEMS */
    if(!strncmp(str,"peaceful",buf_len)) {
      if((op->contr->peaceful=!op->contr->peaceful))
        draw_info(op,"You will not attack other players.");
      else
        draw_info(op,"You will attack other players.");
      return 1;
    }
    if(!strncmp(str,"scroll",buf_len)) {
      if((op->contr->scroll=!op->contr->scroll)) {
	draw_info(op,"Scroll is enabled.");
	if (op->contr->infofull) {
		op->contr->infoline = op->contr->infolines - 1;
		draw_all_info(op);
	}
      }
      else {
	/* simply put, in scroll mode, infopos does not have to be equal
	 * to infoline.  However, infopos must equal infoline in wrap
	 * mode.  A simple infopos=infoline solves this, but if a redraw
	 * was needed, the redraw wouldn't look right, so we copy the
	 * info array to make things right.
	 * Mark Wedel (master@cats.ucsc.edu)
	 */
	int i;
	char	**info;
	if ((op->contr->infofull) &&
	   (op->contr->infoline != op->contr->infopos)){
		info = (char **) malloc(sizeof(char *) * op->contr->infolines);
		for (i=0; i<op->contr->infolines; i++) {
			info[i] = malloc(sizeof(char) * (op->contr->infochars+1));
			strncpy(info[i], op->contr->info[(i+op->contr->infopos) % op->contr->infolines],op->contr->infochars);
			info[i][op->contr->infochars] = '\0';
		}
		for (i=0; i<op->contr->infolines; i++)
			free(op->contr->info[i]);
		free(op->contr->info);
		op->contr->info = info;
		op->contr->infopos = op->contr->infoline;
		draw_all_info(op);
	}
        draw_info(op,"Scroll is disabled.");
      }
      return 1;
    }
    if(!strncmp(str,"berzerk",buf_len)) {
      if((op->contr->berzerk=!op->contr->berzerk))
        draw_info(op,"Berzerk is enabled.");
      else
        draw_info(op,"Berzerk is disabled.");
      return 1;
    }
    if(!strncmp(str,"strength",buf_len)) {
      int i;
      if(p==NULL||!sscanf(++p,"%d",&i)||
         (!IS_WIZ(op)&&(i<5||i>op->stats.maxsp))) {
        draw_info(op,"Set which strength?");
        return 1;
      }
      op->contr->shootstrength=i;
      draw_info(op,"OK.");
      return 1;
    }
    if(!strncmp(str,"pickup",buf_len)) {
      int i;
      if(p==NULL||!sscanf(++p,"%d",&i)||i<0||i>5) {
        draw_info(op,"Usage: pickup <0-5>.");
        return 1;
      }
      set_pickup_mode(op,i);
      return 1;
    }
    if(op->contr->no_echo) {
      op->contr->no_echo = 0;
      if (check_dmpasswd(str)) {
#if 0
        FILE *foo_wiz;
        if ((foo_wiz = fopen(DM_FILE, "w")) != NULL) {
#endif
          SET_WIZ(op);
          draw_info(op, "Ok, you are the Dungeon Master!");
          info_all("The Dungeon Master has arrived!",1);
          info_flush();
          SET_FLY(op);
          clear_los(op);
#if 0
          fclose(foo_wiz);
#endif
          return 1;
#if 0
        }
#endif
    }
    draw_info(op, "Sorry Pal, I don't think so.");
    return 1;
    }
  } else { /* if (<not socket>) */
    if(!strncmp(str,"version",buf_len)) {
      char buf[MAX_BUF], *cp;
      if((cp = strrchr(gargv[0],'/')) == NULL)
        cp = buf;
      else
        cp++;
      sprintf(buf,"%s %s%s",cp,VERSION,PATCH);
      draw_info(op,buf);
      return 1;
    }
    if(!strncmp(str,"protocol",buf_len)) {
      int i;
      if (p == NULL || !sscanf(++p,"%d",&i)) {
        draw_info(op,"Set what protocol?");
        return 1;
      }
      set_protocol(active_socket, i);
      return 1;
    }
    if(!strncmp(str,"set",buf_len)) {
      if (p == NULL) {
        draw_info(op, "Set what option?");
        return 1;
      }
      p++;
      if(!strcmp(p,"pixmaps")) {
        active_socket->use_pix = 1;
        draw_info(op, "OK.");
        return 1;
      }
      if(!strcmp(p,"split")) {
        active_socket->split = 1;
        draw_info(op, "OK.");
        return 1;
      }
      draw_info(op,"Unknown option.\n");
      return 1;
    }
    if(!strncmp(str,"unset",buf_len)) {
      if (p == NULL) {
        draw_info(op, "Unset what option?");
        return 1;
      }
      p++;
      if(!strcmp(p,"pixmaps")) {
        active_socket->use_pix = 0;
        draw_info(op, "OK.");
        return 1;
      }
      if(!strcmp(p,"split")) {
        active_socket->split = 0;
        draw_info(op, "OK.");
        return 1;
      }
      draw_info(op,"Unknown option.\n");
      return 1;
    }
  }

/*
 * Now follows non-dm-commands which are also acceptable from sockets
 */

  if(!strncmp(str,"name",buf_len)) {
    if(p==NULL) {
      draw_info(op,"Change name to what?");
      return 1;
    }
    if(op == NULL) {
      strncpy(active_socket->name,++p,8);
      active_socket->name[8]='\0';
      draw_info(NULL,"OK.");
      return 1;
    }
#ifdef SAVE_PLAYER
    draw_info(op,"You can't change your name.");
#else
    (void) sprintf(buf,"%s changes name to %s.",op->name,++p);
    free_string(op->name);
    op->name=add_string(p);
    op->contr->name_changed=1;
    info_all(buf,8);
    op->contr->last_value= -1;
    draw_stats(op);
#endif
    return 1;
  }
  if(!strncmp(str,"listen",buf_len)) {
    int i;
    if(p==NULL||!sscanf(++p,"%d", &i)) {
      draw_info(op,"Set listen to what?");
      return 1;
    }
    if(op == NULL)
      active_socket->listen_lev = i;
    else
      op->contr->listening=(char) i;
    (void) sprintf(buf,"Your verbose level is now %d.",i);
    draw_info(op,buf);
    return 1;
  }
  if(!strncmp(str,"wimpy",buf_len)) {
    int i;
    if (p==NULL || !sscanf(++p, "%d", &i)) {
      sprintf(buf, "Your current wimpy level is %d.", op->run_away);
      draw_info(op, buf);
      return 1;
    }
    sprintf(buf, "Your new wimpy level is %d.", i);
    draw_info(op, buf);
    op->run_away = i;
    return 1;
  }
  if(!strcmp(str,"quit")) {
    if(op == NULL) {
      draw_info(NULL,"Goodbye.");
      active_socket->quit = 1;
      return 1;
    }
    if(op->stats.exp&&!WAS_WIZ(op)) {
      draw_info(op,"This will delete your character!");
      draw_info(op,"Are you still sure you want to quit(y/n)?");
    } else
      draw_info(op,"Are you sure you want to quit(y/n)?");
    op->contr->state = ST_CONFIRM_QUIT;
    return 1;
  }
#ifdef EXPLORE_MODE
/* don't allow people to exit explore mode.  It otherwise becomes
really easy to abuse this. */
    if (!strncmp(str,"explore",buf_len)) {

/* I guess this is the best way to see if we are solo or not.  Actually,
are there any cases when first_player->next==NULL and we are not solo? */
      if ((first_player!=op->contr) || (first_player->next!=NULL)) {
	  draw_info(op,"You can not enter explore mode if you are in a party");
      }
      else if (op->contr->explore)
              draw_info(op, "There is no return from explore mode");
      else {
		op->contr->explore=1;
		draw_info(op, "You are now in explore mode");
      }
      return 1;
    }
#endif
  if(!strncmp(str,"dm",buf_len)) {
    if (op == NULL) {
      if(p==NULL) {
        draw_info(NULL,"Enter password as argument.");
        return 1;
      }
      if (check_dmpasswd(++p)) {
        draw_info(NULL, "Entering DM mode.");
        active_socket->wiz = 1;
        return 1;
      }
      draw_info(NULL, "Wrong password.");
      return 1;
    }
    if (WAS_WIZ(op)) {
      SET_WIZ(op);
      draw_info(op, "Entering DM mode.");
      info_all("The Dungeon Master has arrived.",1);
      info_flush();
      op->contr->no_echo = 0;
      SET_FLY(op);
        clear_los(op);
      return 1;
    }
    draw_info(op,"Password?");
    str[0] = '\0';
    write_ch(op,'>');
    op->contr->no_echo = 1; 
    return 1;
  }
  if(!strncmp(str,"add",buf_len)) {
    int i, pixtmp = use_pixmaps;
    long splittmp = default_split_window;
#ifdef EXPLORE_MODE
    if (explore_mode()) {
	draw_info(op,"You are not able to add new players in explore mode.");
	return 1;
    }
#endif
    if(p==NULL) {
      if(op != NULL)
        op->contr->writing=0;
      draw_info(op,"Add which display?");
      return 1;
    }
    if (active_socket != (sockets *) NULL)
    {
      use_pixmaps = (int) active_socket->use_pix;
      default_split_window = (long) active_socket->split;
    }
    i=add_player(++p,NULL);
    use_pixmaps = pixtmp;
    default_split_window = splittmp;
    /* This player can be freed during a add_player() */
    if(op == NULL || (op->type == PLAYER && !IS_FREED(op)))
      draw_info(op, i ? errmsg : "OK.");
    return 1;
  }
  if(!strncmp(str,"shout",buf_len)) {
    char buf[MAX_BUF];
    if (p == NULL) {
      draw_info(op,"Shout what?");
      return 1;
    }
    if (op == NULL) {
      strcpy(buf,active_socket->name);
      strcat(buf," shouts: ");
    } else {
      strcpy(buf,op->name);
      strcat(buf," shouts: ");
    }
    strncat(buf,++p,MAX_BUF - 30);
    buf[MAX_BUF - 1] = '\0';
    info_all(buf,1);
    info_flush();
    return 1;
  }
  if(!strncmp(str,"tell",buf_len)) {
    char buf[MAX_BUF],name[MAX_BUF],msg[MAX_BUF];
    player *pl;
#ifdef SERVER
    sockets *s;
#endif /* SERVER */
    if (p == NULL || sscanf(p,"%s %s",name,msg) != 2) {
      draw_info(op,"Tell whom what?");
      return 1;
    }
    if (op == NULL)
      sprintf(buf,"%s tells you: %s",active_socket->name,msg);
    else
      sprintf(buf,"%s tells you: %s",op->name,msg);
    for(pl=first_player;pl!=NULL;pl=pl->next)
      if(strncasecmp(pl->ob->name,name,MAX_NAME)==0)
      {
        draw_info(pl->ob,buf);
        return 1;
      }
#ifdef SERVER
    for(s = first_socket; s != (sockets *) NULL; s = s->next)
      if(strncasecmp(s->name,name,MAX_NAME)==0)
      {
        draw_socket(s->fd,buf);
        return 1;
      }
#endif /* SERVER */
    draw_info(op,"No such player or socket.");
    return 1;
  }
  if(!strncmp(str,"bell",buf_len)) {
    char buf[MAX_BUF];
    player *pl;
#ifdef SERVER
    sockets *s;
#endif /* SERVER */
    if (p == NULL) {
      draw_info(op,"Bell whom?");
      return 1;
    }
    p++;
    for(pl=first_player;pl!=NULL;pl=pl->next)
      if(strncasecmp(pl->ob->name,p,MAX_NAME)==0)
      {
        if (op == NULL)
          sprintf(buf,"%s bells you.",active_socket->name);
        else
          sprintf(buf,"%s bells you.",op->name);
        draw_info(pl->ob,buf);
        XBell(pl->ob->contr->gdisp,100);
        return 1;
      }
#ifdef SERVER
    for(s = first_socket; s != (sockets *) NULL; s = s->next)
      if(strncasecmp(s->name,p,MAX_NAME)==0)
      {
        if (op == NULL)
          sprintf(buf,"%s bells you.%c",active_socket->name,7);
        else
          sprintf(buf,"%s bells you.%c",op->name,7);
        draw_socket(s->fd,buf);
        return 1;
      }
#endif /* SERVER */
  }
  if(!strncmp(str,"who",buf_len)) {
    player *pl;
#ifdef SERVER
    sockets *s;
#endif /* SERVER */
    if (first_player != (player *) NULL)
      draw_info(op,"Players:");
    for(pl=first_player;pl!=NULL;pl=pl->next) {
      if(pl->ob->map == NULL)
        continue;
      if(op == NULL || IS_WIZ(op))
        (void) sprintf(buf,"%s the %s (%s) [%s]%s%s%s (%d)",pl->ob->name,
                       (pl->own_title[0]=='\0'?pl->title:pl->own_title),
		       pl->name,pl->ob->map->map_object->name,
                       IS_WIZ(pl->ob)?" [WIZ]":"",pl->idle?" I":"",
                       pl->peaceful?"P":"W",pl->ob->count);
      else
        (void) sprintf(buf,"%s the %s (%s) [%s]%s%s%s",pl->ob->name,
                       (pl->own_title[0]=='\0'?pl->title:pl->own_title),
		       pl->name,pl->ob->map->map_object->name,
                       IS_WIZ(pl->ob)?" [WIZ]":"",pl->idle?" I":"",
                       pl->peaceful?"P":"W");
      draw_info(op,buf);
    }
#ifdef SERVER
    if(first_socket == (sockets *) NULL)
      return 1;
    draw_info(op,"Sockets:");
    for(s = first_socket; s != (sockets *) NULL; s = s->next) {
      (void) sprintf(buf, "%s (%s)%s", s->name,s->host,s->wiz?" [Wiz]":"");
      draw_info(op,buf);
    }
#endif
    return 1;
  }
  if(!strncmp(str,"malloc",buf_len)) {
    malloc_info(op);
    return 1;
  }
  if(!strncmp(str,"mapinfo",buf_len)) {
    current_map_info(op);
    return 1;
  }
  if(!strncmp(str,"maps",buf_len)) {
    map_info(op);
    return 1;
  }
  if(!strncmp(str,"strings",buf_len)) {
    ss_dump_statistics();
    draw_info(op,errmsg);
    draw_info(op,ss_dump_table(2));
    return 1;
  }
#ifdef DEBUG
  if(!strncmp(str,"sstable",buf_len)) {
    ss_dump_table(1);
    return 1;
  }
#endif
  if(!strncmp(str,"time",buf_len)) {
    time_info(op);
    return 1;
  }
  if(!strncmp(str,"archs",buf_len)) {
    arch_info(op);
    return 1;
  }
  if(!strncmp(str,"hiscore",buf_len)) {
    display_high_score(op,op==NULL?9999:(INFOLINES)-1);
    return 1;
  }
  if(!strncmp(str,"debug",buf_len)) {
    int i;
    char buf[MAX_BUF];
    if(p==NULL||!sscanf(++p,"%d",&i)) {
      sprintf(buf,"Global debug level is %d.",debug);
      draw_info(op,buf);
      if(op == NULL) {
        sprintf(buf,"Socket debug level is %d.",active_socket->debug);
        draw_info(op,buf);
      }
      return 1;
    }
    if((op != NULL && !IS_WIZ(op)) || (*p == '-' && !active_socket->wiz)) {
      draw_info(op,"Privileged command.");
      return 1;
    }
    if (*p == '-' || op != NULL)
      debug = FABS(i);
    else
      active_socket->debug = i;
    sprintf(buf,"Set debug level to %d.", i);
    draw_info(op,buf);
    return 1;
  }
  if((op == NULL) ? !active_socket->wiz : !IS_WIZ(op)) {
    if(op != NULL)
      op->contr->no_echo = 0;
    draw_info(op,"Unknown command.  Try help.");
    return 1;
  }

/*
 * End of non-DM commands.  DM-only commands below.
 * (This includes commands directly from socket)
 */

  if(op != NULL) { /* Some commands not accepted from socket */
    if(!strncmp(str,"goto",buf_len)) {
      mapstruct *m, *prev;
      char *name;
      object *dummy;
      if(p==NULL) {
        draw_info(op,"Go to what level?");
        return 1;
      }
      name = ++p;      
      m = has_been_loaded(name);
      prev = op->map;
      dummy=get_object();
      dummy->map = op->map;
      EXIT_PATH(dummy) = add_string (name);
      enter_exit(op,dummy);
      free_object(dummy);
      if(op->contr->loading == NULL) {
        sprintf(buf,"Difficulty: %d.",op->map->difficulty);
        draw_info(op,buf);
        /*
         * Now, if we entered a new, unloaded map, set the cheat-flag in
         * all objects here.
         */
#ifdef SET_WIZCHEAT
        if(op->map != prev && !m) {
          object *tmp;
          for(tmp = objects; tmp != NULL; tmp = tmp->next)
            if(tmp->map == op->map)
              SET_WAS_WIZ(tmp);
        }
#endif
      }
      return 1;
    }
    if(!strncmp(str,"summon",buf_len)) {
      int i;
      object *dummy;
      if(p==NULL||++p=='\0') {
         draw_info(op,"Usage: summon <player>.");
         return 1;
      }
      for(pl=first_player;pl!=NULL;pl=pl->next) 
        if(!strncmp(pl->ob->name,p,MAX_NAME)) 
          break;
      if(pl==NULL) {
        draw_info(op,"No such player.");
        return 1;
      }
      if(pl->state != ST_PLAYING) {
        draw_info(op,"That player can't be summoned right now.");
        return 1;
      }
      i=find_free_spot(op->arch,op->map,op->x,op->y,1,8);
      dummy=get_object();
      EXIT_PATH(dummy)=add_string(op->map->path);
      EXIT_X(dummy)=op->x+freearr_x[i];
      EXIT_Y(dummy)=op->y+freearr_y[i];
      enter_exit(pl->ob,dummy);
      free_object(dummy);
      draw_info(pl->ob,"You are summoned.");
      draw_info(op,"OK.");
      return 1;
    }
    if(!strncmp(str,"create",buf_len)) {
      object *tmp;
      int nrof,i;
      char buf[MAX_BUF];
      archetype *at;
      if(p==NULL||sscanf(++p,"%d %s",&nrof,buf)!=2) {
        draw_info(op,"Create what?");
        return 1;
      }
      if((at=find_archetype(buf))==NULL) {
        draw_info(op,"No such archetype.");
        return 1;
      }
      if(at->clone.nrof) {
        tmp=arch_to_object(at);
        tmp->x=op->x,tmp->y=op->y;
        tmp->nrof=nrof;
        tmp->map=op->map;
        SET_WAS_WIZ(tmp);
        insert_ob_in_ob(tmp,op);
        return 1;
      } 
      D_LOCK(op);
      for(i=0;i<nrof;i++) {
        archetype *atmp;
        object *prev=NULL,*head=NULL;
        for(atmp=at;atmp!=NULL;atmp=atmp->more) {
          tmp=arch_to_object(atmp);
          SET_WAS_WIZ(tmp);
          if(head==NULL)
            head=tmp;
          tmp->x=op->x+tmp->arch->clone.x;
          tmp->y=op->y+tmp->arch->clone.y;
          tmp->map=op->map;
          if(head!=tmp)
            tmp->head=head,prev->more=tmp;
          prev=tmp;
        }
        if(IS_ALIVE(head))
          insert_ob_in_map(head,op->map);
        else
          insert_ob_in_ob(head,op);
        if(at->randomitems!=NULL)
          create_treasure(at->randomitems,head,GT_INVENTORY,
                          op->map->difficulty);
      }
      D_UNLOCK(op);
      draw_all_inventory(op);
      draw_all_look(op);
      return 1;
    }
  } /* if(<not socket>) */

/*
 * Now follows dm-commands which are also acceptable from sockets
 */

  if(!strncmp(str,"synchronize",buf_len)) {
    if((synchronize = !synchronize))
      draw_info(op,"Turned on synchronizing.");
    else
      draw_info(op,"Turned off synchronizing.");
    return 1;
  }
  if(!strncmp(str,"inventory",buf_len)) {
    object *tmp;
    int i;
    if(p==NULL||!sscanf(p,"%d",&i)||(tmp=find_object(i))==NULL) {
      draw_info(op,"Inventory of what object (nr)?");
      return 1;
    }
    inventory(op,tmp);
    return 1;
  }
  if(!strncmp(str,"dump",buf_len)) {
    int i;
    if(p!=NULL&&!strcmp(++p,"me"))
      tmp=op;
    else if(p==NULL||!sscanf(p,"%d",&i)||(tmp=find_object(i))==NULL) {
      draw_info(op,"Dump what object (nr)?");
      return 1;
    }
    dump_object(tmp);
    draw_info(op,errmsg);
    return 1;
  }
  if(!strncmp(str,"patch",buf_len)) {
    int i;
    char *arg,*arg2;
    char buf[MAX_BUF];

    tmp=NULL;
    if(p!=NULL) {
      if(!strncmp(++p,"me",2))
        tmp=op;
      else if(sscanf(p,"%d",&i))
        tmp=find_object(i);
      else if(sscanf(p,"%s",buf))
        tmp=find_object_name(buf);
    }
    if(tmp==NULL) {
      draw_info(op,"Patch what object (nr)?");
      return 1;
    }
    arg=strchr(p,' ');
    if(arg==NULL) {
      draw_info(op,"Patch what values?");
      return 1;
    }
    if((arg2=strchr(++arg,' ')))
      arg2++;
    SET_WAS_WIZ(tmp); /* To avoid cheating */
    if(set_variable(tmp,arg) == -1)
      draw_info(op,errmsg);
    else {
      sprintf(buf,"(%s#%d)->%s=%s",tmp->name,tmp->count,arg,arg2);
      draw_info(op,buf);
    }
    return 1;
  }
  if(!strncmp(str,"remove",buf_len)) {
    int i;
    if(p==NULL||!sscanf(++p,"%d",&i)||(tmp=find_object(i))==NULL) {
      draw_info(op,"Remove what object (nr)?");
      return 1;
    }
    remove_ob(tmp);
    return 1;
  }
  if(!strncmp(str,"free",buf_len)) {
    int i;
    if(p==NULL||!sscanf(++p,"%d",&i)||(tmp=find_object(i))==NULL) {
      draw_info(op,"Free what object (nr)?");
      return 1;
    }
    free_object(tmp);
    return 1;
  }
  if(!strncmp(str,"addexp",buf_len)) {
    char buf[MAX_BUF];
    int i;
    if(p==NULL||sscanf(++p,"%s %d",buf,&i)!=2) {
       draw_info(op,"Usage: addexp [who] [how much].");
       return 1;
    }
    for(pl=first_player;pl!=NULL;pl=pl->next) 
      if(!strncmp(pl->ob->name,buf,MAX_NAME)) 
        break;
    if(pl==NULL) {
      draw_info(op,"No such player.");
      return 1;
    }
    add_exp(pl->ob,i);
    SET_WAS_WIZ(pl->ob);
    draw_stats(pl->ob);
    return 1;
  }
  if(!strncmp(str,"speed",buf_len)) {
    int i;
    if(p==NULL||!sscanf(++p,"%d", &i)) {
      sprintf(errmsg,"Current speed is %d",max_time);
      draw_info(op,errmsg);
      return 1;
    }
    set_max_time(i);
    reset_sleep();
    draw_info(op,"The speed is changed.");
    return 1;
  }
/**************************************************************************/
/* Mods made by Tyler Van Gorder, May 10-13, 1992.                        */
/* CSUChico : tvangod@cscihp.ecst.csuchico.edu                            */
/**************************************************************************/

  if((!strncmp(str,"stats",buf_len))){
    thing[0] = '\0';
    if(p==NULL||!sscanf(++p,"%s",thing) || thing == NULL) {
       draw_info(op,"Who?");
       return 1;
    }
    for(pl=first_player;pl!=NULL;pl=pl->next) 
       if(!strcmp(pl->ob->name,thing)) {
         sprintf(buf,"Str : %-2d      H.P. : %-4d  MAX : %d",
                 pl->ob->stats.Str,pl->ob->stats.hp,pl->ob->stats.maxhp);
         draw_info(op,buf);
         sprintf(buf,"Dex : %-2d      S.P. : %-4d  MAX : %d",
                 pl->ob->stats.Dex,pl->ob->stats.sp,pl->ob->stats.maxsp) ;
         draw_info(op,buf);
         sprintf(buf,"Con : %-2d        AC : %-4d  WC  : %d",
                 pl->ob->stats.Con,pl->ob->stats.ac,pl->ob->stats.wc) ;
         draw_info(op,buf);
         sprintf(buf,"Wis : %-2d       EXP : %d",
                 pl->ob->stats.Wis,pl->ob->stats.exp);
         draw_info(op,buf);
         sprintf(buf,"Cha : %-2d      Food : %d",
                 pl->ob->stats.Cha,pl->ob->stats.food) ;
         draw_info(op,buf);
         sprintf(buf,"Int : %-2d    Damage : %d",
                 pl->ob->stats.Int,pl->ob->stats.dam) ;
         draw_info(op,buf);
         break;
       }
    if(pl==NULL)
       draw_info(op,"No such player.");
    return 1;
  }

  if((!strncmp(str,"abil",buf_len))) {

    iii = 0;
    thing[0] = '\0';
    thing2[0] = '\0';
    if(p==NULL||!sscanf(++p,"%s %s %d",thing,thing2,&iii) || thing==NULL) {
       draw_info(op,"Who?");
       return 1;
    }
    if (thing2==NULL){
       draw_info(op,"You can't change that.");
       return 1;
    }
    if (iii<1||iii>25) {
      draw_info(op,"Illegal range of stat.\n");
      return 1;
    }
    for(pl=first_player;pl!=NULL;pl=pl->next) 
       if(!strcmp(pl->ob->name,thing)){   
          SET_WAS_WIZ(pl->ob);
          if(!strcmp("str",thing2))
            pl->ob->stats.Str = iii,pl->orig_stats.Str = iii;
          if(!strcmp("dex",thing2))   
            pl->ob->stats.Dex = iii,pl->orig_stats.Dex = iii;
          if(!strcmp("con",thing2))
            pl->ob->stats.Con = iii,pl->orig_stats.Con = iii;
          if(!strcmp("wis",thing2))
            pl->ob->stats.Wis = iii,pl->orig_stats.Wis = iii;
          if(!strcmp("cha",thing2))
            pl->ob->stats.Cha = iii,pl->orig_stats.Cha = iii;
          if(!strcmp("int",thing2))
            pl->ob->stats.Int = iii,pl->orig_stats.Int = iii;
          sprintf(buf,"%s has been altered.",pl->ob->name);
          draw_info(op,buf);
          fix_player(pl->ob);
         return 1;
       } 
    draw_info(op,"No such player.");
    return 1;
  }
  if((!strncmp(str,"reset",buf_len))) {
    mapstruct *m;
    object *dummy = NULL, *tmp = NULL;

    if (p==NULL) {
      draw_info(op,"Reset what map [name]?");
      return 1;	
    }
    if (strcmp (++p, ".") == 0)
      p = op->map->path;
    m = has_been_loaded (p);
    if (m==NULL) {
      draw_info(op,"No such map.");
      return 1;	
    }

    if (m->in_memory != MAP_SWAPPED) {
	player *pl;

	if(m->in_memory != MAP_IN_MEMORY) {
	    LOG(llevError,"Tried to swap out map which was not in memory.\n");
	    return 0;
	}
	for(pl=first_player;pl!=NULL;pl=pl->next)
	    if(pl->ob == NULL || (!(IS_REMOVED(pl->ob)) && pl->ob->map == m))
		if (IS_WIZ (pl->ob)) {
		    /* does not work if there are several dms in same map */
		    tmp = pl->ob;
		    dummy=get_object();
		    dummy->map = m;
		    EXIT_X(dummy) = tmp->x;
		    EXIT_Y(dummy) = tmp->y;
		    EXIT_PATH(dummy) = add_string (p);
		    remove_ob (tmp);
		} else
		    break;
	swap_map(m);
    }

    if (m->in_memory == MAP_SWAPPED) {	
	LOG(llevDebug,"Resetting map %s.\n",m->path);
	clean_tmp_map(m);
	m->tmpname = NULL;
	m->reset_time = 0;
	
	if (tmp) {
	    enter_exit(tmp, dummy);
	    /* sigh - enter exit does not insert object 
	       if it is removed */
	    SET_NO_APPLY(tmp);
	    insert_ob_in_map(tmp,tmp->map);
	    UNSET_NO_APPLY(tmp);
	    free_object(dummy);
	}

      draw_info(op,"OK.");
      return 1;	      
    }
    draw_info(op,"Reset failed, couldn't swap map.\n");
    return 1;
  }
  if(!strncmp(str,"nowiz",buf_len)||
     !strncmp(str,"nodm",buf_len)) {
     if(op == NULL) {
       active_socket->wiz = 0;
       return 1;
     }
     UNSET_WIZ(op);
     UNSET_FLY(op);
     return 1;
  }
  if(op != NULL) {
    op->contr->no_echo = 0;
    draw_info(op,"Unknown command.  Try help.");
  }
  return 0;
}

int legal_range(object *op,int r) {
  int i;
  object *tmp;

  switch(r) {
  case 0: /* "Nothing" is always legal */
    return 1;
  case 1: /* bows */
    return (present_in_ob(BOW,op)!=NULL);
  case 2: /* cast spells */
    if(op->contr->nrofknownspells==0)
      return 0;
    for(i=0;i<op->contr->nrofknownspells;i++)
      if(op->contr->known_spells[i]==op->contr->chosen_spell)
        return 1;
    op->contr->chosen_spell=op->contr->known_spells[0];
    return 1;
  case 3: /* use wands */
    for(tmp=op->inv;tmp!=NULL;tmp=tmp->below)
      if(tmp->type==WAND&&IS_APPLIED(tmp)) {
        op->contr->chosen_spell=tmp->stats.sp;
        return 1;
      }
    return 0;
  case 4: /* use scrolls */
    return 0;
  }
  return 0;
}

void change_spell(object *op,char k) {
  char buf[MAX_BUF];
  if(op->contr->golem!=NULL) {
    remove_friendly_object(op->contr->golem);
    remove_ob(op->contr->golem);
    free_object(op->contr->golem);
    op->contr->golem=NULL;
  }
  do {
    op->contr->shoottype+= k=='+'?1:-1;
    if(op->contr->shoottype>3)
      op->contr->shoottype=0;
    else if(op->contr->shoottype== -1)
      op->contr->shoottype=3;
  } while (!legal_range(op,op->contr->shoottype));
  switch(op->contr->shoottype) {
  case 0:
    draw_info(op,"No ranged attack chosen.");
    break;
  case 1:
    draw_info(op,"Switched to bow/crossbow.");
    break;
  case 2:
    sprintf(buf,"Switched to spells (%s).",
            spells[op->contr->chosen_spell].name);
    draw_info(op,buf);
    break;
  case 3:
    sprintf(buf,"Switched to wands (%s).",
            spells[op->contr->chosen_spell].name);
    draw_info(op,buf);
    break;
  }
  draw_stats(op);
}

#ifdef SAVE_WINDOW_POSITIONS
void get_window_coord(object *op, Window win,
		 int *x,int *y,
		 int *wx,int *wy,
		 unsigned int *w,unsigned int *h)
{
  Window root,child;
  unsigned int tmp;
  XGetGeometry(op->contr->gdisp,win,
	       &root,
	       x,y,w,h,
	       &tmp,&tmp);
  XTranslateCoordinates(op->contr->gdisp,win,root,
			0,0,wx,wy,
			&child);
}
#endif /* SAVE_WINDOW_POSITIONS */

int parse_key(object *op,char k, KeyCode ks) {
  char buf[MAX_BUF];
  player *pl=op->contr;
  char last_cmd=pl->last_cmd;
  int i;

  if(pl->viewmap) {
    pl->viewmap=0;
    refresh(op);
  }
  pl->last_cmd=0;
  if(ks==pl->keys[K_MOVE_1])
    move_player(op,1);
  else if(ks==pl->keys[K_MOVE_2])
    move_player(op,2);
  else if(ks==pl->keys[K_MOVE_3])
    move_player(op,3);
  else if(ks==pl->keys[K_MOVE_4])
    move_player(op,4);
  else if(ks==pl->keys[K_MOVE_5])
    move_player(op,5);
  else if(ks==pl->keys[K_MOVE_6])
    move_player(op,6);
  else if(ks==pl->keys[K_MOVE_7])
    move_player(op,7);
  else if(ks==pl->keys[K_MOVE_8])
    move_player(op,8);
  else if(ks==pl->keys[K_FIRE]||ks==pl->keys[K_FIRE2])
    return pl->fire_on=1;
  else if(ks==pl->keys[K_RUN]||ks==pl->keys[K_RUN2])
    return pl->run_on=1;
  else if(pl->writing)
    return parse_writing(op,k);
  else {
    switch(k) {
    case '.': fire(op,0); break;
    case 'l': move_player(op,3);break;
    case 'h': move_player(op,7);break;
    case 'j': move_player(op,5);break;
    case 'k': move_player(op,1);break;
    case 'y': move_player(op,8);break;
    case 'u': move_player(op,2);break;
    case 'b': move_player(op,6);break;
    case 'n': move_player(op,4);break;
    case 'L': move_player(op,3);break;
    case 'H': move_player(op,7);break;
    case 'J': move_player(op,5);break;
    case 'K': move_player(op,1);break;
    case 'Y': move_player(op,8);break;
    case 'U': move_player(op,2);break;
    case 'B': move_player(op,6);break;
    case 'N': move_player(op,4);break;
    case 12 : move_player(op,3);break;
    case  8 : move_player(op,7);break;
    case 10 : move_player(op,5);break;
    case 11 : move_player(op,1);break;
    case 25 : move_player(op,8);break;
    case 21 : move_player(op,2);break;
    case 2  : move_player(op,6);break;
    case 14 : move_player(op,4);break;
    case 'C':
      op->contr->configure=K_MOVE_1;
      op->contr->state = ST_CONFIGURE;
      configure_keys(op,0);
      op->contr->count=0;
      break;
    case '@':
      op->contr->count_left=0;
      set_pickup_mode(op,op->contr->mode>4?0:op->contr->mode+1);
      return 1;
    case 'I':
      if(!IS_WIZ(op)) break;
      op->invisible+=100;
      update_object(op);
      draw_info(op,"You turn invisible.");
      break;
    case '"':
      write_ch(op,'"');
      op->contr->count=0;
      return 1;
    case '\'':
      write_ch(op,'>');
      op->contr->count=0;
      return 1;
    case ':':
      look_at(op,0,0);
      pl->last_cmd=2;
      break;
    case 'Q': 
      draw_info(op,"Type 'quit to quit.");
      break;
    case '>':
      rotate_right(op);
      op->contr->count_left=0;
      break;
    case '<':
      rotate_left(op);
      op->contr->count_left=0;
      break;
    case 'a':
      apply_inventory(op);
      break;
    case 'A':
      apply_below(op);
      break;
    case 'e':
      examine(op,op->inv);
      break;
    case 'E':
      examine(op,op->below);
      break;
    case '\?':
      info_keys(op);
      break;
    case '-':
      change_spell(op,'-');
      break;
    case '+':
      change_spell(op,'+');
      break;
    case 't':
      draw_info(op,"Throw is disabled (it was too buggy).");
      break;
#if 0
      op->contr->shoottype=10;
      op->contr->count_left=0;
      draw_info(op,"You will now throw things.");
      break;
#endif
    case 'd':
      drop_inventory(op);
      break;
    case ',':
      pick_up(op,NULL); /* NULL is default (below) */
      break;
    case 'i':
      inventory(op,NULL);
      pl->last_cmd=1;
      break;
    case 'D':
      if (IS_WIZ(op) && op->below) {
	  dump_object(op->below);
	  draw_info(op,errmsg);
      }
      break;
    case 'W':
      if (IS_WIZ(op))
        if (WIZPASS(op))
          UNSET_WIZPASS(op);
        else
          SET_WIZPASS(op);
      break;
    case 'P':
      if (IS_WIZ(op))
        dump_all_objects();
      break;
    case 'G':
      if (IS_WIZ(op))
        dump_friendly_objects();
      break;
    case 'O':
      if (IS_WIZ(op))
        dump_all_archetypes();
      break;
    case 's':
      if (op->contr->braced) {
        op->contr->braced = 0;
        draw_info(op, "You are no longer braced.");
      }
      else {
        op->contr->braced = 1;
        draw_info(op, "You are now braced.");
      }
      fix_player(op);
      break;
    case 'S': if(IS_WIZ(op))
      (void) ss_dump_table(1);
      break;
    case 'm':
      if(IS_WIZ(op))
        dump_map(op->map);
      break;
    case 'M':
      if(IS_WIZ(op))
        dump_all_maps();
      break;
    case 'z':
      if(IS_WIZ(op))
        print_los(op);
      break;
    case 3: clear_win_info(op); break;
    case 18:
      if(!op->contr->split_window)
        XClearWindow(op->contr->gdisp,op->contr->win_root);
      refresh(op);
      op->contr->last_value= -1;
      draw_stats(op);
      draw_all_info(op);
      draw_all_inventory(op);
      draw_all_look(op);
      draw_all_message(op);
      break;
    case 'v':
      version(op);
      break;
    case '\t':			/* browse through spells */
      {
      int i;
      if(op->contr->shoottype!=2) {
        if(op->contr->nrofknownspells>0)
          op->contr->shoottype=2;
        else
          draw_info(op,"You know no spells.");
        break;
      }
      for(i=0;i<op->contr->nrofknownspells;i++)
	  if(op->contr->known_spells[i]==op->contr->chosen_spell)
	    {
	      if(pl->fire_on || pl->run_on)
		i--;
	      else
		i++;
	      if(i<0)
		i=op->contr->nrofknownspells-1;
	      if(i>=op->contr->nrofknownspells)
		i=0;
              op->contr->chosen_spell=op->contr->known_spells[i];
	      break;
	    }
	draw_stats(op);
	break;
      }
#ifdef SAVE_WINDOW_POSITIONS
    case 'X':			/* save window positions */
      {
	int i,eq=1;
	if(!(op->contr->split_window)) {
	  draw_info(op,"You can't save window positions in this mode.");
	  break;
	}
	if(op->contr->valid_save_positions) {
	  op->contr->valid_save_positions=0;
	  draw_info(op,"Window positions will no longer be saved.");
	  break;
	}
	get_window_coord(op,op->contr->win_game,
			 &op->contr->win_pos[0].x,&op->contr->win_pos[0].y,
			 &op->contr->win_pos[0].wx,&op->contr->win_pos[0].wy,
			 &op->contr->win_pos[0].w,&op->contr->win_pos[0].h);
	get_window_coord(op,op->contr->win_stats,
			 &op->contr->win_pos[1].x,&op->contr->win_pos[1].y,
			 &op->contr->win_pos[1].wx,&op->contr->win_pos[1].wy,
			 &op->contr->win_pos[1].w,&op->contr->win_pos[1].h);
	get_window_coord(op,op->contr->win_info,
			 &op->contr->win_pos[2].x,&op->contr->win_pos[2].y,
			 &op->contr->win_pos[2].wx,&op->contr->win_pos[2].wy,
			 &op->contr->win_pos[2].w,&op->contr->win_pos[2].h);
	get_window_coord(op,op->contr->win_inv,
			 &op->contr->win_pos[3].x,&op->contr->win_pos[3].y,
			 &op->contr->win_pos[3].wx,&op->contr->win_pos[3].wy,
			 &op->contr->win_pos[3].w,&op->contr->win_pos[3].h);
	get_window_coord(op,op->contr->win_look,
			 &op->contr->win_pos[4].x,&op->contr->win_pos[4].y,
			 &op->contr->win_pos[4].wx,&op->contr->win_pos[4].wy,
			 &op->contr->win_pos[4].w,&op->contr->win_pos[4].h);
	get_window_coord(op,op->contr->win_message,
			 &op->contr->win_pos[5].x,&op->contr->win_pos[5].y,
			 &op->contr->win_pos[5].wx,&op->contr->win_pos[5].wy,
			 &op->contr->win_pos[5].w,&op->contr->win_pos[5].h);
	for(i=0;i<5;i++)	/* try to figure out the window coords */
	  if(op->contr->win_pos[i].x!=op->contr->win_pos[i+1].x ||
	     op->contr->win_pos[i].y!=op->contr->win_pos[i+1].y)
	    {
	      eq=0;			/* window positions were different */
	      break;
	    }
	if(eq)			/* need to shift window positions (wm frame) */
	  for(i=0;i<6;i++)
	    {
#ifdef FUNNY_WINDOW_MANAGER /* try defining this if the other doesn't work */
	      op->contr->win_pos[i].x=op->contr->win_pos[i].wx-
		op->contr->win_pos[i].x;
	      op->contr->win_pos[i].y=op->contr->win_pos[i].wy-
		op->contr->win_pos[i].y;
#else /* FUNNY_WINDOW_MANAGER */
	      op->contr->win_pos[i].x=op->contr->win_pos[i].wx;
	      op->contr->win_pos[i].y=op->contr->win_pos[i].wy;
#endif /* FUNNY_WINDOW_MANAGER */
	    }
	op->contr->valid_save_positions=1;
	draw_info(op,"Current window positions will be saved.");
      }
      break;
#endif /* SAVE_WINDOW_POSITIONS */
    default:
      if(ks==pl->keys[K_MOVE_0]) /* Don't want it to override anything */
        move_player(op,0);
      if(pl->key_state) {
        fix_push_key(pl,ks);
        return 0;
      }
      {
        KeySym j;
        for(i=0;i<NROFPUSHKEYS;i++) {
          if(!(j=op->contr->pushkeys[i]))
            continue;
          if(j==ks) {
            (void) parse_string(op,op->contr->pushstring[i]);
            return 0;
          }
        }
      }
      if(k>='0'&&k<='9') break;
      op->contr->count_left=0;
    }
    if(k>='0'&&k<='9') {
      if(op->contr->count<1000)
        op->contr->count=(k-'0')+op->contr->count*10;
      sprintf(buf,"Count: %d.",op->contr->count);
      draw_info(op,buf);
      pl->last_cmd=last_cmd;
      return 1;
    }
  }
  if(op->contr->count)
    op->contr->count_left=op->contr->count-1,
    op->contr->prev_cmd=k,
    op->contr->prev_fire_on=op->contr->fire_on;
    op->contr->prev_keycode=ks,
    op->contr->count=0;
  return 0;
}

int check_dmpasswd(char *str)
{
  FILE *fp;
  char buf[MAX_BUF], *cp;

  sprintf(buf, "%s/adm/passwd", LIBDIR);
  if ((fp = fopen(buf, "r")) == NULL) {
    if ((fp = fopen(buf, "w")) == NULL) {
      /* Unable to create a new password, check with default password */
      return (!strcmp(str,DM_PASSWD) && strcmp("nopw", DM_PASSWD));
    }
    /* No previous password file.  Since we have privs, create a new */
    fprintf(fp, "%s", crypt_string(str, NULL));
    fclose(fp);
    chmod(buf, 0644);
    return 1;
  }
  if (fgets(buf, MAX_BUF, fp) == NULL)
  {
    fclose(fp);
    return (!strcmp(str,DM_PASSWD) && strcmp("nopw", DM_PASSWD));
  }
  if ((cp = strchr(buf, '\n')))
    *cp = '\0';
  fclose(fp);
  LOG(llevDebug, "Pw: %s\n", buf);
  return check_password(str, buf);
}
