require "util.pl";

$root = $ARGV[0];
$archetypes = "archetypes";
$bmaps = "bmaps";
$paths = $bmaps."."."paths";
$faceExt = "\\.[A-Z0-9][A-Z0-9][A-Z0-9]";

### main
&info("looking ...");
&traverse($root);
&info("writing ...");
open(ARCH,">".$archetypes) || &die("cannot open ".$archetypes);
&archsOut;
close(ARCH);
open(BMAPS,">".$bmaps) || &die("cannot open ".$bmaps);
&bmapsOut;
close(BMAPS);
open(BMAPS,">".$paths) || &die("cannot open ".$paths);
&pathsOut;
close(BMAPS);
&stats;
exit 0;

sub traverse {
    local($dir) = shift;
    local($file,$name);
    foreach $file (<$dir/*>) {
	$name = &basename($file,""); # DIR
        if( -d $file && $name ne "dev" && $name ne "trashbin") {
	    &traverse($file);
	} elsif( $file =~ /.*\.arc$/) {	# ARCHETYPE
	    $archsNum++;
	    push(@archs,$file);
	} elsif( $file =~ /.*$faceExt$/) { # FACE
	    $facesNum++;
	    &warn("dublicate face ".$name." in ".$dir)
		if $faces{$name};
	    $faces{$name} = $file;
	    # &warn($file." has no archetype") 
	    #	if ! -r $dir."/".&basename($file,$faceExt).".arc";
	} else {
	    $trashNum++;
	    &msg($file." no match");
	}
	&warn($file." is over 14 charactes")
	    if length($name) > 14;
    }
}

sub archsOut {
    foreach $arch (@archs) {
	open(ARC,$arch) || &die("cannot open ".$arch);
	while(<ARC>) {
	    chop;
	    ($var,@values) = split;
	    $anim = 0 if $var eq "mina";
	    &warn($arch." is missing face ".$var)
		if $anim && ! $faces{$var};
	    &warn($arch." is missing face ".$values[0])
		if $var eq "face" && ! $faces{$values[0]};
	    $anim = 1 if $var eq "anim";
	    print ARCH $_,"\n";
	}
	close(ARC);
    }
}

sub pline {
    local($face) = shift;
    print BMAPS sprintf("%05d",$idx++)," ",$face,"\n";
}

sub opline {
    local($face) = shift;
    print BMAPS sprintf("\\%05d",$idx++),"\t",$face,"\n";
}

sub pheader {
    print BMAPS "# This file is generated by $0, do not edit\n";
}

sub bmapsOut {
    &pheader;
    $idx = 0;
    &pline("bug.111");
    foreach $face (sort(keys %faces)) {
	&pline($face) if $face !~ /bug\.111/;
    }
}

sub pathsOut {
    &pheader;
    $idx = 0;
    &opline($root."/system/bug.111");
    foreach $face (sort(keys %faces)) {
	&opline($faces{$face}) if $faces{$face} !~ /bug\.111/;
    }
}

### print out statical information
sub stats {
    &info(Archs.":\t".$archsNum);
    &info(Images.":\t".$facesNum);
    &info(Trash.":\t".$trashNum);
}
