.\"$Id: crossfire.man,v 1.5 1993/04/22 06:01:11 frankj Exp $
.TH crossfire 0.89.3 "Mar 7 1993"
.SH NAME
CrossFire - multiplayer adventure and arcade game for X-windows
.SH SYNOPSIS
.B crossfire
[-<options>][display]...
.SH DESCRIPTION
.PP
.I CrossFire
is a multiplayer graphical arcade and adventure game made for the X-Window
environment.
It has certain flavours from other games, especially Gauntlet (TM) and
Nethack/Moria.
Any number of players can move around in their own window, picking up / using
items and battle monsters.  The players all do battle in the same world,
and can communicate with eachothers (even fight with eachothers).
The goal of the game is to survive and to have FUN.
.SH OPTIONS
.TP
.B -b
Use black & white colors even if you have a color display
.TP
.B -d
When playing, prints out some debugging.
.TP
.TP
.B -f
Crossfire will only flush, and not attempt to synchronize all windows.
This means that the game will crash if someone kills their window, but
the game will not lock if someone freezes their window.
This option is recommended if the game seems to be slow due to many
participating players.
.TP
.B -h
Prints out usage of flags.
.TP
.B -l
Removes the local player (whatever the DISPLAY environment variable is set to)
from the list of players
.TP
.B -m
Lists out information about all monsters and tries to calculate an
alternative experience rating for them (will not be used in game though).
.TP
.B -mon
Turns on monster-debugging.  This means that all messages that the game
gives to the monsters is written to standard error.
.TP
.B -o
Prints out info on what was defined at compile time.
.TP
.B -p
Crossfire won't try to fix the fontpath if it can't find the fonts it needs.
.TP
.B -pix
Crossfire will use only pixmaps instead of fonts.
Note that if this switch is not given, and crossfire fails to set the
font, it will try using pixmaps anyway.
.TP
.B -s
Displays the highscore list.
.TP
.B -v
Prints out version, authors and contributors.
.TP
.B -w
Makes splitwindow default (see the resource for information).
.SH RESOURCES
.TP
.B name
Specifies which name your character will start with in Crossfire.
You have to choose a name, either this way or with the "name" command, if
you want to enter the highscore list.
.TP
.B peaceful
You can turn this mode on or off with the strings "on"/"off".  Default
is on.  If the mode is turned on, you will push other players instead of
attacking them when you run into them.  The mode can also be toggled
inside the game with the "'peaceful" command.
.TP
.B berzerk
If this mode is on, the player won't stop in front of a monster if you
hit CTRL + direction.  Instead s/he will continue fighting the monsters
until a wall is met.  Default is ON.
.TP
.B scroll
Default is off.  If scroll is turned on, the text window will scroll
instead of wrapping.  The mode can also be toggled inside the game
with the "'scroll" command.
Please note that the scroll-option is buggy.
.TP
.B splitwindow
Default is off (unless switch -w is given).  If this is turned on, all
windows will be under the control of the window manager.  That is, they
can be placed in any order, and some can be resized.
.TP
.B pixmap
Default is off (unless switch -pix is given).  If this is turned on,
crossfire will not try to set your fontpath, but instead use pixmaps.
Note that crossfire will try pixmaps if it fails to set the fontpath.
.SH PLAYING
When you have rolled your stats and chosen a profession, you can
type `?' at any time to get information about the different keys.
.PP
The apply command (bound to key `a') is used for several things, like
wearing, removing, wielding, unwielding, drinking, eating, etc.
If you hold down Shift while pressing `A', you will apply the
object below you.  This is the only way to enter a house.
.PP
In addition to the direct commands which are bound to different keys, you
can also type more complex commands by pressing the '-key first.
To get more information about these, try typing "'help".
.PP
Your goal is to gain experience, find treasure, explore and have fun.
You do this by figuring out puzzles in maps, killing monsters and
destroying generators.  You loose by dying.
.PP
There are two ways of dying, one is to loose all hit-points
(usually fighting monsters), the other is to starve to death.
Remember to eat when hungry.
.SH MOUSE CONTROL
You can do several things by using only the mouse.  In the inventory-window,
you can examine, apply and drop things by clicking the different mouse-buttons.
In the look-window you can do mostly the same, except you pick up items instead
of dropping them when you click the right mouse button.  In both windows
you can move the scrollbar in different ways by clicking the different
mouse-button on it (but only if there are more items than can be displayed
in the window).  In the graphical window, you can click at places with
the left button to find out what is there, or with the right button
to move in that general direction.
.SH FILES
.TP
.B LIBDIR/archetypes
Global objects which can be inherited are stored here.
.TP
.B LIBDIR/treasures
Linked lists of random treasure (& abilities!) which can be given to different
monsters are kept here.
.TP
.B LIBDIR/motd
Message of the day, is written to players when theey start the game.
.TP
.B LIBDIR/forbid
If the game is closed due to working hours, information is in this file.
.TP
.B LIBDIR/mapindex
A list of all maps, and their corresponding number is kept here.
.TP
.B LIBDIR/maps/*.om
The files which contains the background of the maps.
.TP
.B LIBDIR/maps/*.oo
The files which contains the objects of the maps.
.TP
.B LIBDIR/players/*.pl
Players can store their characters and equipment in these files.
.TP
.SH MAILING LIST
There are two mailing-lists dedicated to the developement and
bug-testing of crossfire.  The first is for discussing bugs and
features, the second is for announcing new versions.
.PP
If you want to join or leave any of the lists, send mail to
crossfire-request@ifi.uio.no with the subject "subscribe",
"unsubscribe","subscribe announce" or "unsubscribe announce".
If you use the subject "subscribe" or "unsubscribe" you will
(un)subscribe to *both* lists.
To send messages directly to the list, mail crossfire@ifi.uio.no.
An archive of old messages can be found at the ftp-sites (see below).
in the file crossfire.mail.Z
.SH FTP
The official ftp-sites where you can look for the latest versions are:
.PP
    ftp.ifi.uio.no:/pub/crossfire (129.240.64.2)
    yoyo.cc.monash.edu.au:/pub/crossfire (130.194.9.1)
    ftp.world.net:/pub/crossfire (192.243.32.18)
.PP
Please use the one nearest to you.  ".no" from Europe, ".au" from Australia
and ".net" from USA.
If anyone sets up other sites, please notify me.
.SH SEE ALSO
xledit
.SH BUGS
If the game looks very chaotic, it is probably because you are using
a font belonging to a previous version instead of the one supplied
with this version.
.PP
Please let me know about any bugs you find in the game.  I know there are
plenty of them, and some are mentioned on the TODO file which is supplied
with the game.
.SH AUTHOR
Copyright (C) 1992 Frank Tore Johansen (frankj@ifi.uio.no)
.PP
Authors and contributors to this program (source):
.LP
.RS
.ft B
.nf
frankj@ifi.uio.no (Frank Tore Johansen)
kjetilho@ifi.uio.no (Kjetil Torgrim Homme)
tvangod@ecst.csuchico.edu (Tyler)
elmroth@cd.chalmers.se (Tony Elmroth)
dougal.scott@fcit.monasu.edu.au (Dougal Scott)
wchuang@athena.mit.edu (William)
ftww@cs.su.oz.au (Geoff Bailey)
jorgens@flipper.pvv.unit.no (Kjetil Wiekhorst Jorgensen)
c.blackwood@rdt.monash.edu.au (Cameron Blackwood)
jtraub+@cmu.edu (Joseph L. Traub)
rgg@aaii.oz.au (Rupert G. Goldie)
eanders+@cmu.edu (Eric A. Anderson)
eneq@Prag.DoCS.UU.SE (Rickard Eneqvist)
Jarkko.Sonninen@lut.fi (Jarkko Sonninen)
kholland@sunlab.cit.cornell.du (Karl Holland)
vick@bern.docs.uu.se (Mikael Lundgren)
mol@meryl.csd.uu.se (Mikael Olsson)
haatanen@cc.lut.fi (Tero Haatanen)
ylitalo@student.docs.uu.se (Lasse Ylitalo)
anipa@pulmunen.cs.tut.fi (Niilo Neuvo)
mta@modeemi.cs.tut.fi (Markku J{rvinen)
master@cats.UCSC.EDU (Mark Wedel)
meunier@inf.enst.fr (Sylvain Meunier)
jfosback@darmok.uoregon.edu (Jason Fosback)
cedman@capitalist.princeton.edu (Carl Edman)
henrich@crh.cl.msu.edu (Charles Henrich)
.fi
.ft R
.RE
.LP
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.

.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.

.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

.\" The author can be reached via e-mail to frankj@ifi.uio.no.
