/*
 * static char *rcsid_player_c =
 *   "$Id: player.c,v 1.3 1993/04/22 06:00:07 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <graphics.h>

/*
 * Returns a newly allocated and initialised and correctly
 * linked player structure.
 */

player *get_player_ob() {
  int i;
  player *new,*tmp;

  new = (player *) calloc(1,sizeof(player));
  if(new==NULL)
    fatal(OUT_OF_MEMORY);
  if(!editor) {
    tmp=first_player;
    while(tmp!=NULL&&tmp->next!=NULL)
      tmp=tmp->next;
    if(tmp!=NULL)
      tmp->next=new;
    else
      first_player=new;
  }
  new->next=NULL;
#ifdef SHOP_LISTINGS
  new->menu=NULL;
#endif
  new->infoline=0;
  new->infopos=0;
  new->infofull=0;
  new->infolines=INFOLINES;
  new->infochars=INFOCHARS;
  new->info=(char **) malloc(sizeof(char *) * new->infolines);
  for(i=0;i<new->infolines;i++) {
    new->info[i]=(char *) malloc(sizeof(char) * (new->infochars + 1));
    strcpy(new->info[i]," ");
  }
  for(i=0;i<LOOK_SIZE;i++)
    new->look_name[i][0]='\0',new->look_face[i]=blank_face.number;
  for(i=0;i<INV_SIZE;i++)
    new->inv_name[i][0]='\0',new->inv_face[i]=blank_face.number;
  for(i=0;i<NROFPUSHKEYS;i++)
    new->pushkeys[i]=0,new->pushstring[i][0]='\0';
  new->key_state=0;

  new->use_pixmaps = 0;
  new->pixmaps = NULL;
  new->ob = get_object();
  new->ob->name = add_string("logon");
  new->ob->type = PLAYER;
  return new;
}

void free_player(player *pl) {
  if(first_player!=pl) {
    player *prev=first_player;
    while(prev!=NULL&&prev->next!=NULL&&prev->next!=pl)
      prev=prev->next;
    if(prev->next!=pl) {
      LOG(llevError,"Free_player: Can't find previous player.\n");
      exit(1);
    }
    prev->next=pl->next;
  } else first_player=pl->next;
  if(pl->ob != NULL)
    free_object(pl->ob);
  if(pl->name!=NULL)
    free_string(pl->name);
  if(pl->pixmaps != NULL) {
    free(pl->pixmaps);
  }
#ifdef SHOP_LISTINGS
/* From my understanding of the code, this will remove the pl->menu->inv
 (and all objects ->below) as well as the pl->menu object itself.  If this
  isn't true, then this will need to be altered - Mark Wedel 
  (master@cats.ucsc.ed)
*/
  if (pl->menu)
	free_object(pl->menu);
#endif
  CFREE(pl);
}
