/*
 * static char *rcsid_init_c =
 *   "$Id: init.c,v 1.6 1993/04/22 05:59:52 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <object.h>

/*
 * It is vital that init_library() is called by any functions
 * using this library.
 * If you want to lessen the size of the program using the library,
 * you can replase the call to init_library() with init_globals(),
 * init_function_pointers() and init_defaults().
 * (This is done in the client)
 */

void init_library() {
  init_globals();
  init_function_pointers();
  init_hash_table();
  init_objects();
  init_defaults();
  init_vars();
  init_block();
  ReadBmapNames ();
  init_archetypes();	/* Reads all archetypes from file */
  init_dynamic ();
}

/*
 * Initialises all global variables.
 * Might use environment-variables as default for some of them.
 */

void init_globals() {
  logfile = stderr;
  exiting = 0;
#ifndef SECURE
  LibDir=getenv("CROSSFIRE_LIBDIR");
  if (!LibDir)
#endif
    LibDir=LIBDIR;
#ifndef SECURE
  FontDir=getenv("CROSSFIRE_FONTDIR");
  if (!FontDir)
#endif
    FontDir=FONTDIR;
#ifndef SECURE
  PlayerDir=getenv("CROSSFIRE_PLAYERDIR");
  if (!PlayerDir)
#endif
    PlayerDir=PLAYERDIR;
#ifndef SECURE
  MapDir=getenv("CROSSFIRE_MAPDIR");
  if (!MapDir)
#endif
    MapDir=MAPDIR;
#ifndef SECURE
  ArcheTypes=getenv("CROSSFIRE_ARCHETYPES");
  if (!ArcheTypes)
#endif
    ArcheTypes=ARCHETYPES;
#ifndef SECURE
  Treasures=getenv("CROSSFIRE_TREASURES");
  if (!Treasures)
#endif
    Treasures=TREASURES;
  delete_last_file=0;
  first_player=NULL;
  first_friendly_object=NULL;
  first_map=NULL;
  first_treasurelist=NULL;
  chrfont=NULL;
  first_archetype=NULL;
  warn_archetypes=0;
  first_map=NULL;
  write_state=0;
  write_pos=0;
  write_d=0;
  button_flag=0;
  last_bard=0;
  fix_walls=0;
  default_split_window=0;
  dump_monsters=0;
  monsters = 1;
  generators = 1;
  hidden = 0;
  others = 1;
  last_micro = 0;
  nroftreasures = 0;
  ring_arch = NULL;
  amulet_arch = NULL;
  staff_arch = NULL;
  undead_name = add_string("undead");
  nrofpixmaps = 0;
  use_pixmaps = 0;
  name = strdup_local("crossfire");
  server_mode = SERVER_OFF;
  active_socket = (sockets *) NULL;
  first_socket = (sockets *) NULL;
  font_graphic = FONTNAME;
  trying_emergency_save = 0;
}

/*
 * Sets up and initialises the linked list of free and used objects.
 * Allocates a certain chunk of objects and puts them on the free list.
 * Called by init_library();
 */

void init_objects() {
  int i;
/* Initialize all objects: */
  free_objects=objarray;
  objects=NULL;
  objarray[0].prev=NULL,
  objarray[0].next= &objarray[1],
  objarray[0].flags|=(F_REMOVED|F_FREED);
  for(i=1;i<STARTMAX-1;i++)
    objarray[i].next= &objarray[i+1],
    objarray[i].prev= &objarray[i-1],
    objarray[i].flags|=(F_REMOVED|F_FREED);
  objarray[STARTMAX-1].next=NULL;
  objarray[STARTMAX-1].prev= &objarray[STARTMAX-2];
  objarray[STARTMAX-1].flags|=(F_REMOVED|F_FREED);
}

/*
 * Initialises global variables which can be changed by options.
 * Called by init_library().
 */

void init_defaults() {
  fix_fontpath=1;
  synchronize=1;
#ifdef DEBUG
  debug= llevDebug;
#else
  debug= llevError;
#endif
  no_color=0;
  editor=0;
  maplevel=0; /* What level the map we're editing has */
  nroferrors=0;
}

void init_dynamic () {
    archetype *at = first_archetype;
    while (at) {
	if (at->clone.type == MAP && EXIT_PATH (&at->clone)) {
	    strcpy (first_map_path, EXIT_PATH (&at->clone));
	    return;
	}
	at = at->next;
    }
    LOG(llevDebug,"You Need a archetype called 'map' and it have to contain start map\n");
    exit (-1);
}
