
#include <global.h>
#include <stdio.h>
#include <unistd.h>

struct bmappair {
    char *name;
    unsigned int number;
};

static struct bmappair *xbm;
int *xbm_values;
char **xbm_names;

MapLook blank_look;
Face blank_face;
Face blocked_face;
Face stipple1_face;
Face stipple2_face;


int nroffiles = 0;

static int compar (struct bmappair *a, struct bmappair *b) {
    return strcmp (a->name, b->name);
}

int ReadBmapNames () {
    char buf[MAX_BUF], *p, *q;
    FILE *fp;
    int value, nrofbmaps = 0, i;

    sprintf (buf,"%s/bmaps", LibDir);
    if ((fp=fopen(buf,"r"))==NULL) {
	perror("Can't open bmaps file");
	exit(-1);
    }
    LOG(llevDebug,"Reading bmaps...");
    
    /* First count how many bitmaps we have, so we can allocate correctly */
    while (fgets (buf, MAX_BUF, fp)!=NULL)
	if(buf[0] != '#' && buf[0] != '\n' )
	    nrofbmaps++;
    rewind(fp);
    
    xbm = (struct bmappair *) malloc(sizeof(struct bmappair) * (nrofbmaps + 10));
    xbm_values = (int *) malloc (sizeof(int) * (nrofbmaps + 10));
    memset (xbm, 0, sizeof (struct bmappair) * (nrofbmaps + 1));
    
    while(fgets (buf, MAX_BUF, fp)!=NULL) {
	if (*buf == '#')
	    continue;
	
	p = (*buf == '\\') ? (buf + 1): buf;
	if (!(p = strtok (p , " \t")) || !(q = strtok (NULL , " \t\n"))) {
	    LOG(llevDebug,"Warning, syntax error: %s\n", buf);
	    continue;
	}
	value = atoi (p);
	xbm[nroffiles].name = strdup_local(q);
	xbm[nroffiles].number = value;
	nroffiles++;
	if(value > nrofpixmaps)
	    nrofpixmaps = value;
    }
    fclose(fp);

    LOG(llevDebug,"done (got %d/%d/%d)\n",nrofpixmaps,nrofbmaps,nroffiles);

    xbm_names = (char **) malloc (sizeof (char *) * nrofpixmaps);
    for (i = 0; i < nrofpixmaps; i++)
	xbm_names[i] = "";

    for (i = 0; i < nroffiles; i++) {
	xbm_names[xbm[i].number] = xbm[i].name;
	xbm_values[i] = xbm[i].number;
    }

#if 1
    qsort (xbm, nrofbmaps, sizeof(struct bmappair), (int (*)())compar);
#endif

    blank_face.number = FindFace (BLANK_FACE_NAME);
    blank_face.fg = find_color ("black");
    blank_face.bg = find_color ("khaki");

    blank_look.face = blank_face;
    blank_look.flags = 0;

    blocked_face.number = FindFace (BLOCKED_FACE_NAME);
    blocked_face.fg = find_color ("black");
    blocked_face.bg = find_color ("black");

    stipple1_face.number = FindFace (STIPPLE1_FACE_NAME);
    stipple1_face.fg = find_color ("black");
    stipple1_face.bg = find_color ("black");

    stipple2_face.number = FindFace (STIPPLE2_FACE_NAME);
    stipple2_face.fg = find_color ("black");
    stipple2_face.bg = find_color ("black");

    nrofpixmaps++;
    return nrofpixmaps;
}


int FindFace (char *name) {
    int i;
    struct bmappair *bp, tmp;
    char *p;

    if ((i = atoi(name)))
	return i;

    if ((p = strchr (name, '\n')))
	*p = '\0';

#if 1
    tmp.name = name;
    bp = (struct bmappair *)bsearch 
	(&tmp, xbm, nroffiles, sizeof(struct bmappair), (int (*)())compar);

    return bp ? bp->number : 0;
#else
    {
	int i;
	for (i = 0; i < nroffiles; i++)
	    if (!strcmp (name, xbm[i].name))
		return xbm[i].number;
    }
    return 0;
#endif
}

